/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.i18n;

import com.huawei.lego.cbb.i18n.sdk.I18nMrg;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.springframework.beans.factory.InitializingBean;

public class I18nMrgImpl
implements I18nMrg,
InitializingBean {
    private static final long serialVersionUID = 4885017051868053189L;
    private Log log = LogFactory.getInstance(I18nMrgImpl.class);
    private Map<Locale, List<ResourceBundle>> resMap = new HashMap<Locale, List<ResourceBundle>>();

    public String getString(String key, Locale local) {
        if (null == key) {
            return "";
        }
        String value = key;
        if (null == this.resMap || this.resMap.isEmpty()) {
            return value;
        }
        List<ResourceBundle> list = this.resMap.get(local);
        if (this.checkListNull(list)) {
            return value;
        }
        for (ResourceBundle resourceBundle : list) {
            try {
                if (!resourceBundle.containsKey(key)) continue;
                value = resourceBundle.getString(key.trim());
                return value;
            }
            catch (Exception e) {
                this.log.debug((Object)("not value: " + ExceptionUtil.getErrorMessage((Throwable)e)), 0L);
            }
        }
        return value;
    }

    private boolean checkListNull(List<ResourceBundle> list) {
        return null == list || list.isEmpty();
    }

    public String getString(String key) {
        Locale local = new Locale("en");
        return this.getString(key, local);
    }

    public String getString(String key, Locale local, String[] agrs) {
        String oldValue = this.getString(key, local);
        return this.judgeString(key, agrs, oldValue);
    }

    public String getString(String key, String[] agrs) {
        String oldValue = this.getString(key);
        return this.judgeString(key, agrs, oldValue);
    }

    private String judgeString(String key, String[] agrs, String oldValue) {
        if (!oldValue.equalsIgnoreCase(key)) {
            try {
                oldValue = MessageFormatUtil.format((String)oldValue, (Object[])agrs);
            }
            catch (Exception e) {
                this.log.error((Object)("not value" + ExceptionUtil.getErrorMessage((Throwable)e)), 0L);
            }
        }
        return oldValue;
    }

    public void afterPropertiesSet() {
        this.loadReportConf();
        List urls = AdapterUtils.getAllClassPathEntries((String)"legoi18n/*.properties");
        Iterator iterator = urls.iterator();
        while (iterator.hasNext()) {
            Locale locale = null;
            URL url = (URL)iterator.next();
            String fileName = url.getFile();
            int c = fileName.lastIndexOf("_");
            if (c <= 0) continue;
            if (fileName.contains("_en")) {
                locale = new Locale("en");
                this.processRes(url, locale);
                continue;
            }
            if (!fileName.contains("_zh")) continue;
            locale = new Locale("zh", "CN");
            this.processRes(url, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRes(URL url, Locale locale) {
        PropertyResourceBundle resourceBundle = null;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(url.openStream());
            resourceBundle = new PropertyResourceBundle(inputStream);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
        }
        catch (IOException e) {
            this.log.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
        }
        finally {
            try {
                if (null != inputStream) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            }
        }
        this.addToBundleLst(locale, resourceBundle);
    }

    private void addToBundleLst(Locale locale, ResourceBundle resourceBundle) {
        List<ResourceBundle> bundleLst = this.resMap.get(locale);
        if (null == bundleLst) {
            bundleLst = new ArrayList<ResourceBundle>();
            bundleLst.add(resourceBundle);
            this.resMap.put(locale, bundleLst);
        } else {
            bundleLst.add(resourceBundle);
            this.resMap.put(locale, bundleLst);
        }
    }

    private boolean loadReportConf() {
        String location = "reporti18n.conf";
        boolean isReportConfEnabled = false;
        try {
            ClassLoader classLoader = I18nMrgImpl.class.getClassLoader();
            if (classLoader == null) {
                this.log.warn((Object)"not found classLoader", 0L);
                return isReportConfEnabled;
            }
            Enumeration<URL> url = classLoader.getResources(location);
            if (url.hasMoreElements()) {
                URL path = url.nextElement();
                Properties prop = new Properties();
                prop.load(path.openStream());
                String i18n = prop.getProperty("i18n");
                if (i18n == null) {
                    this.log.warn((Object)"not found i18n conf.", 0L);
                    return isReportConfEnabled;
                }
                isReportConfEnabled = true;
                String[] res = i18n.split(",");
                Locale localeZh = new Locale("zh", "CN");
                Locale localeEn = new Locale("en");
                this.dealLsts(res, localeZh, localeEn);
            }
        }
        catch (IOException e) {
            this.log.warn((Object)("i18n readConfig:" + e), 0L);
        }
        return isReportConfEnabled;
    }

    private void dealLsts(String[] res, Locale localeZh, Locale localeEn) {
        for (String re : res) {
            try {
                this.dealLst(re, localeZh, localeEn);
                this.log.info((Object)("res:" + re + " files loaded."), 0L);
            }
            catch (Exception e) {
                this.log.error((Object)("Error when load i18n file." + re + ExceptionUtil.getErrorMessage((Throwable)e)), 0L);
            }
        }
    }

    private void dealLst(String re, Locale localeZh, Locale localeEn) {
        ResourceBundle resourceBundleCN = ResourceBundle.getBundle(re, localeZh);
        this.addToBundleLst(localeZh, resourceBundleCN);
        ResourceBundle resourceBundleEN = ResourceBundle.getBundle(re, localeEn);
        this.addToBundleLst(localeEn, resourceBundleEN);
    }

    public String[] getParseParamForContainErrorID(LegoAlarm legoAlarm, Locale local) {
        String[] afterParseParam = new String[legoAlarm.getAlarmParam().length];
        int i = 0;
        for (String param : legoAlarm.getAlarmParam()) {
            afterParseParam[i++] = param.startsWith("lego.err.") ? this.getString(param, local) : param;
        }
        return afterParseParam;
    }
}

