/*
 * Decompiled with CFR 0.152.
 */
package com.huawei;

import com.huawei.FileSigner;
import com.huawei.FileUtil;
import com.huawei.KmcUtil;
import com.huawei.ProperUtil;
import com.huawei.kmc.common.AppException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class FileSignHandler {
    private static final String SIGNFILE = "signFile";

    public FileSignHandler(String kmcConfPath, String installPath) {
        InputStream is = null;
        try {
            ClassLoader clazzLoader = ProperUtil.class.getClassLoader();
            if (null != clazzLoader) {
                is = clazzLoader.getResourceAsStream(SIGNFILE);
            }
            if (null != is) {
                String text;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                ProperUtil properUtil = new ProperUtil();
                properUtil.getEncryptedProperties(SIGNFILE);
                KmcUtil.initKmc(kmcConfPath, properUtil);
                while ((text = reader.readLine()) != null) {
                    if (FileUtil.isEmpty((String)text)) continue;
                    if (text.startsWith(File.separator)) {
                        this.signFile(text);
                        continue;
                    }
                    this.signFile(installPath + text);
                }
            } else {
                System.out.println("get resource failed.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void signFile(String file) {
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            byte[] bytes = new byte[((InputStream)input).available()];
            ((InputStream)input).read(bytes);
            String str = new String(bytes);
            String hash = KmcUtil.sign(str);
            FileSigner signTool = new FileSigner();
            signTool.writeHashToSign(file, hash);
        }
        catch (FileNotFoundException e) {
            System.out.println("sigen file [" + file + "] failed, can't find the file.");
            FileSignHandler.closeInputStream(input);
            return;
        }
        catch (Exception e2) {
            System.out.println("sign file [" + file + "] failed, errMsg: " + e2);
            {
                catch (Throwable throwable) {
                    FileSignHandler.closeInputStream(input);
                    throw throwable;
                }
            }
            FileSignHandler.closeInputStream(input);
            return;
        }
        FileSignHandler.closeInputStream(input);
    }

    public boolean signVerify(String file, String signFile) {
        try {
            String plain = new String(Files.readAllBytes(Paths.get(file, new String[0])), StandardCharsets.UTF_8);
            String hashCode = new String(Files.readAllBytes(Paths.get(signFile, new String[0])), StandardCharsets.UTF_8);
            return KmcUtil.signVerify(plain, hashCode);
        }
        catch (AppException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static void closeInputStream(InputStream input) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                System.out.println("close BufferedReader failed.");
            }
        }
    }
}

