/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.ecs.constants;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import java.util.Arrays;

public enum InstanceInfoStatus {
    BUILD("BUILD", ServiceInstanceStatus.CREATING.getValue(), false),
    REBUILD("REBUILD", ServiceInstanceStatus.CREATING.getValue(), false),
    ACTIVE("ACTIVE", ServiceInstanceStatus.NORMAL.getValue(), true),
    ERROR("ERROR", ServiceInstanceStatus.ERROR.getValue(), false),
    MIGRATING("MIGRATING", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    REBOOT("REBOOT", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    HARD_REBOOT("HARD_REBOOT", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    RESIZE("RESIZE", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    REVERT_RESIZE("REVERT_RESIZE", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    SHUTOFF("SHUTOFF", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    VERIFY_RESIZE("VERIFY_RESIZE", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    DELETED("DELETED", ServiceInstanceStatus.MAINTAIN.getValue(), false);

    private final String status;
    private final String csrStatus;
    private final boolean isProtectable;

    private InstanceInfoStatus(String status, String csrStatus, boolean isProtectable) {
        this.status = status;
        this.csrStatus = csrStatus;
        this.isProtectable = isProtectable;
    }

    public String getCsrStatus() {
        return this.csrStatus;
    }

    @JsonValue
    public String getStatus() {
        return this.status;
    }

    public boolean getProtectable() {
        return this.isProtectable;
    }

    @JsonCreator
    public static InstanceInfoStatus from(String value) {
        return Arrays.stream(InstanceInfoStatus.values()).filter(em -> em.status.equalsIgnoreCase(value)).findFirst().orElse(null);
    }
}

