/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.ecs.executor;

import com.huawei.csr.app.ecs.constants.EcsPluginConsts;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.utils.EndpointUtil;
import com.huawei.csr.framework.core.executor.AbstractStepExecutor;
import com.huawei.csr.framework.core.executor.PollingStrategy;
import com.huawei.csr.framework.core.executor.StepExecuteContext;
import com.huawei.csr.framework.core.identifier.StepIdentifier;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.ecs.EcsClient;
import com.huawei.sdk.ecs.model.response.InstanceResponse;
import java.io.IOException;

public class StartEcsExecutor
extends AbstractStepExecutor {
    private static final Log LOG = LogFactory.getInstance(StartEcsExecutor.class);
    private EcsClient ecsClient;
    private PollingStrategy ecsPoller;

    public StartEcsExecutor() {
        this.setStepIdentifier(new StepIdentifier(ServiceType.ECS.getValue(), RecoverStepAction.POWER_ON.getValue()));
    }

    public void work(RecoverStep step, StepExecuteContext executeContext) throws ResponseException, ClientException, IOException {
        AppServiceInstance serviceInstance = ((ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class)).getServiceInstanceById(step.getServiceInstanceId());
        Credential credential = new Credential(executeContext.getRequestContext().getProjectId(), executeContext.getRequestContext().getAuthToken(), EndpointUtil.getEndpoint((String)step.getServiceType(), (String)serviceInstance.getPdRegionId()));
        InstanceResponse response = this.ecsClient.queryInstance(credential, serviceInstance.getInstanceId());
        if (VerifyUtil.isEmpty((Object)response)) {
            LOG.error((Object)"ECS: %s not exist", new Object[]{serviceInstance.getInstanceId()});
            throw new LegoCheckedException(1073953300L);
        }
        if (EcsPluginConsts.EcsStatusEnum.ACTIVE.getStatus().equals(response.getServer().getStatus())) {
            return;
        }
        this.ecsClient.startEcs(credential, serviceInstance.getInstanceId());
        this.ecsPoller.executePoller(executeContext, context -> {
            InstanceResponse result = this.ecsClient.queryInstance(credential, serviceInstance.getInstanceId());
            return !VerifyUtil.isEmpty((Object)result) && EcsPluginConsts.EcsStatusEnum.ACTIVE.getStatus().equals(result.getServer().getStatus());
        });
    }

    public EcsClient getEcsClient() {
        return this.ecsClient;
    }

    public void setEcsClient(EcsClient ecsClient) {
        this.ecsClient = ecsClient;
    }

    public PollingStrategy getEcsPoller() {
        return this.ecsPoller;
    }

    public void setEcsPoller(PollingStrategy ecsPoller) {
        this.ecsPoller = ecsPoller;
    }
}

