/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.ecs.service;

import com.huawei.csr.app.ecs.constants.EcsHostStatus;
import com.huawei.csr.app.ecs.constants.InstanceInfoStatus;
import com.huawei.csr.app.ecs.service.EcsService;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.plugin.ServiceInstanceFilter;
import com.huawei.csr.framework.common.statusopt.status.ReplicaStatus;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.ecs.EcsClient;
import com.huawei.sdk.ecs.model.AddressInfo;
import com.huawei.sdk.ecs.model.EcsInstanceInfo;
import com.huawei.sdk.ecs.model.request.ListInstanceRequest;
import com.huawei.sdk.ecs.model.response.InstanceResponse;
import com.huawei.sdk.ecs.model.response.ListInstancesResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.utils.Lists;

public class EcsServiceImpl
implements EcsService {
    private static final Log LOG = LogFactory.getInstance(EcsServiceImpl.class);
    private EcsClient ecsClient;

    public EcsClient getEcsClient() {
        return this.ecsClient;
    }

    public void setEcsClient(EcsClient ecsClient) {
        this.ecsClient = ecsClient;
    }

    @Override
    public AppServiceInstance queryServiceInstance(Credential credential, String serverId) throws ResponseException, ClientException, IOException {
        LOG.debug((Object)"Start queryServiceInstance, serverId: %s, projectId: %s, endpoint: %s", new Object[]{serverId, credential.getProjectId(), credential.getEndpoint()});
        if (VerifyUtil.isEmpty((Object)credential) || VerifyUtil.isEmpty((String)serverId)) {
            LOG.error((Object)"Credential or serverId is empty.");
            throw new LegoCheckedException(1073953302L);
        }
        InstanceResponse response = this.ecsClient.queryInstance(credential, serverId);
        return this.convert2ServiceInstance(response.getServer());
    }

    private AppServiceInstance convert2ServiceInstance(EcsInstanceInfo instanceInfo) {
        AppServiceInstance instance = new AppServiceInstance();
        instance.setInstanceId(instanceInfo.getId());
        instance.setInstanceName(instanceInfo.getName());
        instance.setInstanceObjectCount(Integer.valueOf(1));
        instance.setStatus(InstanceInfoStatus.from(instanceInfo.getStatus()).getCsrStatus());
        if (InstanceInfoStatus.from(instanceInfo.getStatus()) == InstanceInfoStatus.ACTIVE && EcsHostStatus.from(instanceInfo.getHostStatus()) != EcsHostStatus.UP) {
            instance.setStatus(ServiceInstanceStatus.MAINTAIN.getValue());
        }
        instance.setInstanceAddress(this.getAddress(instanceInfo.getAddresses()));
        instance.setPdAzId(instanceInfo.getAzName());
        instance.setReplicaStatus(ReplicaStatus.NORMAL.getValue());
        instance.setServiceType(ServiceType.ECS.getValue());
        return instance;
    }

    private String getAddress(Map<String, List<AddressInfo>> addressMap) {
        if (VerifyUtil.isEmpty(addressMap) || VerifyUtil.isEmpty(addressMap.values().stream())) {
            return "";
        }
        List<AddressInfo> addressInfos = addressMap.values().stream().findFirst().orElse(Lists.newArrayList());
        boolean[] bools = new boolean[2];
        String addressInfoV4 = "";
        String addressInfoV6 = "";
        for (AddressInfo addressInfo : addressInfos) {
            if (addressInfo.getVersion() == 4) {
                if (bools[0]) continue;
                bools[0] = true;
                addressInfoV4 = addressInfo.getAddr();
                continue;
            }
            if (bools[1]) continue;
            bools[1] = true;
            addressInfoV6 = addressInfo.getAddr();
        }
        if (!VerifyUtil.isEmpty((String)addressInfoV4)) {
            if (!VerifyUtil.isEmpty((String)addressInfoV6)) {
                return String.join((CharSequence)",", addressInfoV4, addressInfoV6);
            }
            return addressInfoV4;
        }
        if (!VerifyUtil.isEmpty((String)addressInfoV6)) {
            return addressInfoV6;
        }
        return "";
    }

    @Override
    public List<AppServiceInstance> queryServiceInstanceList(ServiceInstanceFilter filter, Credential credential) throws ResponseException, ClientException, IOException {
        LOG.debug((Object)"Start queryServiceInstanceList, pdRegionId: %s, drRegionId: %s, pdAzId: %s, drAzId:%s, projectId: %s, endpoint: %s", new Object[]{filter.getPdRegionId(), filter.getDrRegionId(), filter.getPdAzId(), filter.getDrAzId(), credential.getProjectId(), credential.getEndpoint()});
        if (!this.checkRegionAz(filter)) {
            LOG.error((Object)"CheckRegionAz error,pdRegionId: %s, drRegionId: %s, pdAzId: %s, drAzId:%s", new Object[]{filter.getPdRegionId(), filter.getDrRegionId(), filter.getPdAzId(), filter.getDrAzId()});
            return Collections.emptyList();
        }
        if (VerifyUtil.isEmpty((Object)credential)) {
            LOG.error((Object)"credential is empty.");
            throw new LegoCheckedException(1073953302L);
        }
        ListInstanceRequest requestParam = new ListInstanceRequest();
        requestParam.setName(filter.getInstanceName());
        ListInstancesResponse responseList = this.ecsClient.queryInstanceList(credential, requestParam);
        Stream<Object> stream = responseList.getServers().stream();
        if (!VerifyUtil.isEmpty((String)filter.getInstanceId())) {
            stream = stream.filter(server -> server.getId().contains(filter.getInstanceId()));
        }
        return stream.filter(server -> InstanceInfoStatus.ACTIVE.getStatus().equals(server.getStatus())).filter(server -> EcsHostStatus.UP.getValue().equals(server.getHostStatus())).map(this::convert2ServiceInstance).filter(server -> server.getPdAzId().equals(filter.getPdAzId())).peek(serviceInstance -> {
            serviceInstance.setPdRegionId(filter.getPdRegionId());
            serviceInstance.setDrType(filter.getDrType().getValue());
        }).collect(Collectors.toList());
    }

    @Override
    public boolean isProtectableServiceInstance(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        if (VerifyUtil.isEmpty((Object)credential) || VerifyUtil.isEmpty((String)serviceInstanceId)) {
            LOG.error((Object)"Credential or serverId is empty.");
            throw new LegoCheckedException(1073953302L);
        }
        LOG.debug((Object)"Start isProtectableServiceInstance check, serviceInstanceId: %s, projectId: %s, endpoint: %s", new Object[]{serviceInstanceId, credential.getProjectId(), credential.getEndpoint()});
        InstanceResponse response = this.ecsClient.queryInstance(credential, serviceInstanceId);
        return Optional.ofNullable(response).map(InstanceResponse::getServer).filter(instance -> InstanceInfoStatus.from(instance.getStatus()).getProtectable()).filter(instance -> EcsHostStatus.from(instance.getHostStatus()) == EcsHostStatus.UP).isPresent();
    }

    private boolean checkRegionAz(ServiceInstanceFilter filter) {
        return !VerifyUtil.isEmpty((String)filter.getPdRegionId()) && !VerifyUtil.isEmpty((String)filter.getPdAzId());
    }
}

