#!/bin/sh

stopAPM()
{
   echo "Before restore system, it will be check and stop the system, do you want to continue? Please input y/n."
   read options

   echo $options  | grep ^[yYnN]$ >> /dev/null

   if [ $? != 0 ]
   then
      echo "The value you input is invalid, please input y/n."
      stopAPM
      return 1
   fi;
    
   echo $options  | grep -i ^n$ >> /dev/null

   if [ $? = 0 ]
   then
       echo "The user canceled."
       return 2
   fi

   /home/apm/Runtime/bin/shutdownSystem.sh
   return 0;
}

importData()
{
    echo "Please input the restore file:"
    read restorefile

    echo $restorefile | grep ^[yYnN]$ >> /dev/null
    
    if [ -f $restorefile ]
    then
        /home/jdk1.6.0_14/bin/java -jar /root/backup/backup.jar $restorefile
    else
        echo "the file $restorefile is not exsist."
    fi
}

start()
{
    stopAPM
   

    if [ $? -eq 0 ]; then
        importData
    fi
    
    exit 0 
}

start