define([], function() {
/////////////////////////////////////模块申明开始/////////////////////////////////////
var platformModuleConstants = {};

/**
 * post/put/remove rest请求的超时时间，单位：毫秒
 */
platformModuleConstants.operateTimeout = 50000;

platformModuleConstants.token = "rd_randomStr_HW";

/**
 * 服务模块，定义平台中的所有服务
 */
var serviceModule = angular.module("ui.platform.service", []);

/**
 * 指令模块，定义平台中的所有指令
 */
var directiveModule = angular.module("ui.platform.directive",
    ["ui.platform.service", "wcc"]);

/**
 * 筛选器模块，定义平台中的所有筛选器
 */
var filterModule = angular.module("ui.platform.filter",
    ["ui.platform.service"]);

/////////////////////////////////////模块申明结束/////////////////////////////////////

/////////////////////////////////////平台模块定义开始/////////////////////////////////////

/**
 * 平台模块,定义配置和模块级别的服务
 *
 * @dependence directive
 * @dependence service
 * @dependence filter
 */
var platformModule = angular.module("ui.platform",
    ["ui.platform.directive", "ui.platform.service", "ui.platform.filter"]);

/**
 * 配置HTTP请求拦截器
 *
 * @dependence $routeProvider
 */
platformModule.config(function ($httpProvider) {
    //HTTP请求前do something
    var callBeforeFunction = function (data, headersGetter) {
        return data;
    };

    $httpProvider.defaults.transformRequest.push(callBeforeFunction);
});

/////////////////////////////////////平台模块定义结束/////////////////////////////////////

/////////////////////////////////////服务模块定义开始/////////////////////////////////////

/**
 * 异步通信服务，封装异步通信处理操作
 *
 * @dependence utilService cookieService
 */
serviceModule.service("communicationService", ["utilService", "cookieService",
function (utilService, cookieService) {
    var serviceObj = {};
    var token = cookieService.getToken();

    serviceObj.doCompositedRequest = function (url ,requestArray, callback) {
        var paraObj = {};
        for (var i = 0; i < requestArray.length; i++) {
            var eachRequest = requestArray[i];
            paraObj[eachRequest.id] = {
                method: eachRequest.body.method,
                url: eachRequest.body.url,
                para: eachRequest.body.para
            };
        }

        serviceObj.post(url, paraObj, function (result) {
            for (var i = 0; i < requestArray.length; i++) {
                var eachRequest = requestArray[i];
                var eachResult = result.data[eachRequest.id];
                if (eachRequest.body.successFn) {
                    eachRequest.body.successFn(eachResult);
                }
            }

            if (callback) {
                callback(result.data);
            }

        }, function (error) {
        });
    };

    /**
     * 执行查询操作。URL格式类似"/XXX/rest/device001/sessions"或
     * "/deviceManager/rest/device001/sessions/sess001"
     *
     * @param url              资源地址
     * @param successFn        操作成功后的回调操作
     * @param errorFn          操作失败后的回调操作
     * @param timeout          超时时间（ms）
     */
    serviceObj.get = function (url, successFn, errorFn, timeout) {
        if (!timeout) {
        	timeout = platformModuleConstants.operateTimeout;
        }

        var jqxhr = $.ajax({
            type: "GET",
            timeout: timeout,
            url: url,
            headers: {"If-Modified-Since": "0", "Accept-Language": cookieService.get("language"), "rd_randomStr_HW": token, "user.login.mode": cookieService.get("user.login.mode")}
        });

        jqxhr.pipe(function (result) {
            //如果有定义错误码的行为，就去执行该行为。
            if (typeof(ErrorCodeOperate) !== 'undefined' && angular.isDefined(result) &&
                angular.isDefined(result.errorCode) && angular.isDefined(ErrorCodeOperate[result.errorCode])) {
                ErrorCodeOperate[result.errorCode](result);
                return;
            }

            if (successFn) {
                successFn(result);
            }
        }, function (result) {
            if (errorFn) {
                errorFn(result);
            }
        });

        return jqxhr;
    };


    /**
     * 执行创建操作。URL格式类似"/XXX/rest/device001/sessions"
     *
     * @param url              资源地址
     * @param paraObject       JSON对象
     * @param successFn        操作成功后的回调操作
     * @param errorFn          操作失败后的回调操作
     * @param timeout          超时时间（ms）
     */
    serviceObj.post = function (url, paraObject, successFn, errorFn, timeout) {
        if (!timeout) {
            timeout = platformModuleConstants.operateTimeout;
        }

        var jqxhr = $.ajax({
            type: "POST",
            data: JSON.stringify(paraObject),
            timeout: timeout,
            url: url,
            contentType: "application/json;charset=utf-8",
            headers: { "If-Modified-Since": "0", "Accept-Language": cookieService.get("language"), "rd_randomStr_HW": token, "user.login.mode": cookieService.get("user.login.mode")}
        });

        jqxhr.pipe(function (result) {
            //如果有定义错误码的行为，就去执行该行为。
            if (typeof(ErrorCodeOperate) !== 'undefined' && angular.isDefined(result) &&
                angular.isDefined(result.errorCode) && angular.isDefined(ErrorCodeOperate[result.errorCode])) {
                ErrorCodeOperate[result.errorCode](result);
                return;
            }

            if (successFn) {
                successFn(result);
            }
        }, function (result) {
            if (errorFn) {
                errorFn(result);
            }
        });

        return jqxhr;
    };

    /**
     * 执行修改操作。URL格式类似"/XXX/rest/device001/sessions/sess1"
     *
     * @param url              资源地址
     * @param paraObject       JSON对象
     * @param successFn        操作成功后的回调操作
     * @param errorFn          操作失败后的回调操作
     * @param timeout          超时时间（ms）
     */
    serviceObj.put = function (url, paraObject, successFn, errorFn, timeout) {
        if (!timeout) {
        	timeout = platformModuleConstants.operateTimeout;
        }

        var jqxhr = $.ajax({
            type: "PUT",
            data: JSON.stringify(paraObject),
            timeout: timeout,
            url: url,
            contentType: "application/json;charset=utf-8",
            headers: { "If-Modified-Since": "0", "Accept-Language": cookieService.get("language"), "rd_randomStr_HW": token, "user.login.mode": cookieService.get("user.login.mode")}
        });

        jqxhr.pipe(function (result) {
            //如果有定义错误码的行为，就去执行该行为。
            if (typeof(ErrorCodeOperate) !== 'undefined' && angular.isDefined(result) &&
                angular.isDefined(result.errorCode) && angular.isDefined(ErrorCodeOperate[result.errorCode])) {
                ErrorCodeOperate[result.errorCode](result);
                return;
            }
            if (successFn) {
                successFn(result);
            }
        }, function (result) {
            if (errorFn) {
                errorFn(result);
            }
        });

        return jqxhr;
    };

    /**
     * 执行删除操作。URL格式类似"/XXX/rest/device001/sessions/sess1"
     *
     * @param url              资源地址
     * @param successFn        操作成功后的回调操作
     * @param errorFn          操作失败后的回调操作
     */
    serviceObj.remove = function (url, paraObject, successFn, errorFn, timeout) {
        if (!timeout) {
        	timeout = platformModuleConstants.operateTimeout;
        }

        var jqxhr = $.ajax({
            type: "DELETE",
            data: JSON.stringify(paraObject),
            timeout: timeout,
            url: url,
            contentType: "application/json;charset=utf-8",
            headers: { "If-Modified-Since": "0", "Accept-Language": cookieService.get("language"), "rd_randomStr_HW": token, "user.login.mode": cookieService.get("user.login.mode")}
        });

        jqxhr.pipe(function (result) {
            //如果有定义错误码的行为，就去执行该行为。
            if (typeof(ErrorCodeOperate) !== 'undefined' && angular.isDefined(result) &&
                angular.isDefined(result.errorCode) && angular.isDefined(ErrorCodeOperate[result.errorCode])) {
                ErrorCodeOperate[result.errorCode](result);
                return;
            }
            if (successFn) {
                successFn(result);
            }
        }, function (result) {
            if (errorFn) {
                errorFn(result);
            }
        });

        return jqxhr;
    };
    return serviceObj;
}]);

/**
 * 数据传递服务，封装父子页面数据交换操作
 *
 * @dependence $window
 */
serviceModule.service("infoTransferredService", [function () {
    var serviceObj = {};
    if (window == top) {
        top.temporaryElementWrappers = [];
    }

    /**
     * 保存操作。
     *
     * @param module 模块名称，可以是任何字符串。
     * @param key 数据的标示，数据的唯一标示为module + key
     * @param value 数据的值
     */
    serviceObj.put = function (module, key, value, isTemporary) {

        top[module + key] = value;

        if (isTemporary) {
            top.temporaryElementWrappers.push({module: module, key: key});
        }
    };

    /**
     * 获取操作。
     *
     * @param module 模块名称，可以是任何字符串。
     * @param key 数据的标示，数据的唯一标示为module + key
     * @return 数据的值
     */
    serviceObj.get = function (module, key) {
        return top[module + key];
    };

    /**
     * 删除操作。不再使用的数据务必删除，以减少内存开销。
     *
     * @param module 模块名称，可以是任何字符串。
     * @param key 数据的标示，数据的唯一标示为module + key
     */
    serviceObj.remove = function (module, key) {
        try {
            delete top[module + key];
        } catch (e) {
            // 规避IE8下delete操作的Bug
            top[module + key] = undefined;
        }

        for (var i = 0; i < top.temporaryElementWrappers.length; i++) {
            var item = top.temporaryElementWrappers[i];
            if (item.module == module && item.key == key) {
                top.temporaryElementWrappers.splice(i, 1);
                break;
            }
        }
    };

    serviceObj.removeTemporaryElement = function () {
        while (top.temporaryElementWrappers.length > 0) {
            var item = top.temporaryElementWrappers[0];
            serviceObj.remove(item.module, item.key);
        }
        top.temporaryElementWrappers = [];
    };
    return serviceObj;
}]);

/**
 * 公共方法服务
 *
 * getResouceUrl
 */
serviceModule.service("utilService", ['$window', 'cookieService',
function ($window, cookieService) {
    var serviceInstance = {

        /**
         * 获取服务的地址
         * @param url
         * @returns {String}
         */
        getResouceUrl: function (url) {
    		var root = this.getRootPath() + "/ws";
    		if(-1 !== url.indexOf(root))
    		{
    			return url;
    		}
    	    return this.getRootPath() + "/ws" + url;
        },

        /**
         * 获取js文件地址
         */
        getJsPath: function () {
            var js = document.getElementsByTagName('script');
            var jsPath = null;
            for (var j = 0; j < js.length; j++) {
                var jsSrc = js[j].src;
                if (typeof jsSrc != "undefined" && jsSrc.indexOf("components.min.js") > -1) {
                    jsPath = jsSrc.substring(0, jsSrc.lastIndexOf("/") + 1);
                    break;
                }
            }
            return jsPath;
        },

        appendToken : function(url) {
            if(!url) {
                return '';
            }
            var token = cookieService.getToken();
            var index = url.search(/\?.+\=.?/);
            if(index >= 0) {
                var prefix = url.slice(0, index + 1);
                var suffix = url.slice(index + 1);
                url = prefix + "rd_randomStr_HW=" + token + "&" + suffix;
            } else if(url.match(/\?$/)) {
                url = url + "rd_randomStr_HW=" + token;
            } else {
                url = url + "?rd_randomStr_HW=" + token;
            }
            return url;
        },

        decodeHTML : function(content) {
            if(content && typeof content === "string") {
                content = content.replace(/&lt;/g, "<");
                content = content.replace(/&gt;/g, ">");
                content = content.replace(/&#40;/g, "(");
                content = content.replace(/&#41;/g, ")");
                content = content.replace(/&amp;/g, "&");
            }
            return content;
        },

        /**
         * 获取js文件地址
         */
        getIbaseRootPath: function () {
            var js = document.getElementsByTagName('script');
            var jsPath = null;
            for (var j = 0; j < js.length; j++) {
                var jsSrc = js[j].src;
                if (typeof jsSrc != "undefined" && jsSrc.indexOf("components.min.js") > -1) {
                    jsPath = jsSrc.substring(0, jsSrc.lastIndexOf("/ibase/") + 7);
                    break;
                }
            }
            return jsPath;
        },

        /**
        * 获取项目根路径  http://xxx.xx.xx.xx:xx/xxx
        */
        getRootPath: function () {
            var rootPath = location.protocol + "//" + location.host;
            var ibaseRootPathTmp = this.getIbaseRootPath();
            if (angular.isDefined(ibaseRootPathTmp)
                && ibaseRootPathTmp) {
                if (ibaseRootPathTmp.substr(ibaseRootPathTmp.length - 1) === '/') {
                    ibaseRootPathTmp = ibaseRootPathTmp.substr(0, ibaseRootPathTmp.length - 1);
                }
                var removedProtocolSlice = ibaseRootPathTmp.substr(ibaseRootPathTmp.indexOf("//") + 2);
                rootPath = ibaseRootPathTmp.substr(0, ibaseRootPathTmp.lastIndexOf(ibaseRootPathTmp.substr(removedProtocolSlice.lastIndexOf('/') + location.protocol.length + 2)));
            } else {
                var strPath = location.pathname;
                if (this.isNotEmpty(strPath)) {
                	rootPath = "";
                }
            }

            return rootPath;
        },

        //函数：获取尺寸
        retrieveDimensions: function () {

            var winWidth = 0;
            var winHeight = 0;

            //获取窗口宽度
            if (window.innerWidth) {
                winWidth = window.innerWidth;
            } else if ((document.body) && (document.body.clientWidth)) {
                winWidth = document.body.clientWidth;
            }

            //获取窗口高度
            if (window.innerHeight) {
                winHeight = window.innerHeight;
            } else if ((document.body) && (document.body.clientHeight)) {
                winHeight = document.body.clientHeight;
            }

            //通过深入document内部对body进行检测，获取窗口大小
            if (document.documentElement && document.documentElement.clientHeight &&
                document.documentElement.clientWidth) {
                winHeight = document.documentElement.clientHeight;
                winWidth = document.documentElement.clientWidth;
            }

            return {
                'width': winWidth,
                'height': winHeight
            };
        },

        /**
         * 如果传入对象是undefined或者null, 返回false;
         * 如果传入的对象是String，当字符串是空或者只有空格字符串，返回false, 反之返回true;
         * 如果传入的对象是Array， 当数组的长度是0返回false, 反之返回true;
         * 如果传入的对象是Object,当对象没有自己的属性与方法时返回false, 反之返回true.
         * @param obj需要判断的对象
         */

        isValid: function (obj) {
            var valid = false;
            if (angular.isUndefined(obj)) {
                valid = false;
            } else if (obj === null) {
                valid = false;
            } else if (angular.isString(obj)) {
                if (angular.element.trim(obj) === "") {
                    valid = false;
                } else {
                    valid = true;
                }
            } else if (angular.isArray(obj)) {
                if (obj.length === 0) {
                    valid = false;
                } else {
                    valid = true;
                }
            } else if (angular.isObject(obj)) {
                if (angular.element.isEmptyObject(obj)) {
                    valid = false;
                } else {
                    valid = true;
                }
            } else {
                valid = true;
            }
            return valid;
        },

        /**
         * 根据参数名获取当前 URL 的附带参数值
         * @param name 参数名
         * @returns 返回参数值
         */
        getUrlParam: function (name) {
            var searchString = location.search;
            if (this.isEmpty(searchString)) {
                return null;
            }

            searchString = searchString.substring(1);
            var hasMoreParam = searchString.indexOf("?");
            var paramArr;

            if (hasMoreParam === -1) {// 单个参数
                paramArr = searchString.split("=");
                return paramArr[0] == name ? paramArr[1] : null;
            } else {// 多个参数
                paramArr = searchString.split("?");
                for (var i = 0; i < paramArr.length; i++) {
                    var temp = paramArr[i].split("=");
                    if (temp[0] == name) {
                        return temp[1];
                    }
                }
            }
            return null;
        },

        /**
         * 判断浏览器
         */
        isIE: function () {
            return !!window.ActiveXObject;
        },

        isOpera: function () {
            return navigator.userAgent.indexOf("Opera") !== -1;
        },

        isChrome: function () {
            return navigator.userAgent.indexOf("Chrome") !== -1;
        },

        isSafari: function () {
            var userAgent = navigator.userAgent;
            return userAgent.indexOf("Safari") !== -1 && userAgent.indexOf("Chrome") === -1;
        },

        isFirefox: function () {
            return navigator.userAgent.indexOf("Firefox") !== -1;
        },

        /**
         * 判空
         * @param val
         * @returns {Boolean}
         */
        isEmpty: function (val) {
            if (angular.isUndefined(val) || null === val) {
                return true;
            } else {
                if (angular.isString(val)) {
                    return angular.element.trim(val) === "";
                } else if (angular.isArray(val)) {
                    return val.length === 0;
                }
            }

        },

        /**
         * 判断非空
         */
        isNotEmpty: function (val) {
            return !this.isEmpty(val);
        },

        // ipv4验证 验证通过返回ture
        checkIPV4: function (ipv4) {
            var reg = /^(?!\s+)(22[0-3]|2[0-1]\d|1([0-13-9]\d)|12[0-68-9]|[1-9][0-9]|[1-9])((\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})(?!\s+)$/;
            if (reg.test(ipv4)) {
                return true;
            } else {
                return false;
            }
        },


        //子网掩码验证
        isSubnetMaskV4: function (mask) {
            var reg = /^\d{1,3}$/;
            var ipArray = mask.split('.');
            var str = '';
            if (ipArray.length != 4) {
                return false;
            }
            for (var i = 0; i < ipArray.length; i++) {
                if (!reg.test(ipArray[i])) {
                    return false;
                }
                if (parseInt(ipArray, 10) > 255) {
                    return false;
                }

                str += this.int2Binary(ipArray[i]);
            }
            if (str.indexOf('01') > -1) {
                return false;
            }
            return true;
        },

        int2Binary: function (data) {
            return (parseInt(data) + 256).toString(2).substring(1);
        },

        //ipv6验证
        checkIPV6: function (ipv6) {
            var reg = /^(?!\s+)((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?(?!\s+)$/;
            var reg1 = /^(?!\s+)((([0]{1,4}:){7}([0]{1,4}|1|01|001|0001|:))|(([0]{1,4}:){6}(:([0]{1,4}|1|01|001|0001)|((0\.0\.0\.1|0\.0\.0\.0))|:))|(([0]{1,4}:){5}(((:[0]{1,4}){1,2})|(:([0]{1,4}):(1|01|001|0001))|:0\.0\.0\.1|:0\.0\.0\.0|:))|(([0]{1,4}:){4}(((:([0]{1,4})){1,3})|((:([0]{1,4}))?:((0\.0\.0\.1|0\.0\.0\.0)))|((:([0]{1,4})){0,2}:(1|01|001|0001))|:))|(([0]{1,4}:){3}(((:([0]{1,4})){1,4})|((:([0]{1,4})){0,2}:((0\.0\.0\.1|0\.0\.0\.0)))|((:([0]{1,4})){0,3}:(1|01|001|0001))|:))|(([0]{1,4}:){2}((:([0]{1,4})){1,5}|((:([0]{1,4})){0,3}:((0\.0\.0\.1|0\.0\.0\.0)))|((:([0]{1,4})){0,4}:(1|01|001|0001))|:))|(([0]{1,4}:){1}(((:([0]{1,4})){1,6})|((:([0]{1,4})){0,4}:((0\.0\.0\.1|0\.0\.0\.0)))|((:([0]{1,4})){0,5}:(1|01|001|0001))|:))|(:(((:[0]{1,4}){1,7})|((:[0]{1,4}){0,5}:((0\.0\.0\.1|0\.0\.0\.0)))|((:([0]{1,4})){0,6}:(1|01|001|0001))|:)))(%.+)?(?!\s+)$/;
            if (reg.test(ipv6) && !reg1.test(ipv6)) {
                return true;
            } else {
                return false;
            }
        },
        //ipv6验证无00
        checkIPV6_normal: function (ipv6) {
            var reg = /^(?!\s+)((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?(?!\s+)$/;
            if (reg.test(ipv6)) {
                return true;
            } else {
                return false;
            }
        },

        isIPv6Prefix: function (prefix) {
            var reg = /^[1-9]\d{0,2}$/;
            if (!reg.test(prefix) ||
                parseInt(prefix) > 128) {
                return false;
            } else {
                return true;
            }
        },

        /**
         * 根据文件名获取文件后缀名
         * @param fileName 文件名
         */
        getFileSuffix: function (fileName) {

            //假如文件名不是字符串，返回undefined.
            if (!angular.isString(fileName)) {
                return;
            }

            //假如文件名是空，返回undefined.
            if (!this.isValid(fileName)) {
                return;
            }

            var start = fileName.lastIndexOf('\.') + 1;
            var end = fileName.length;
            var suffix = fileName.substring(start, end);
            return angular.element.trim(suffix);
        },
        //动态加载JS文件
        dynLoadJSFiles: function (path) {
            if (path) {
                for (var i = 0; i < path.length; i++) {
                    var script = document.createElement("script");
                    script.src = path[i];
                    script.type = "text/javascript";
                    document.getElementsByTagName("head")[0].appendChild(script);
                }
            }
        },

        /**
         * <将特殊字符转义>
         */
        escapeSpecialStr: function (str) {
            if (!str) {
                return '';
            }
            return str.replace(/&/g, '&amp;').replace(/\'/g, '&#39;').replace(/"/g, '&quot;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
        },

        /**
         *
         * <将转义的特殊字符还原>
         *
         * @param str
         */
        restoreSpecialStr: function (str) {
            if (!str) {
                return '';
            }
            return str.replace(/&#39;/g, '\'').replace(/&quot;/g, '"').replace(/&lt;/g, '<').replace(/&gt;/g, '>').replace(/&amp;/g, '&');
        }

    };
    return serviceInstance;
}]);

/**
 * 定时服务
 * doTask
 */
serviceModule.service("timerService", ["infoTransferredService", function (infoTransferredService) {
    if (window == top) {
        top.temporaryTasks = [];
        top.platformTasks = [];
        top.allTasks = [];
    }

    var serviceInstance = {
        /**
         * 定时刷新
         * @param fn|object :       任务
         * @param time|string :     时间间隔(秒)
         * @param isTemporary|boolean ：离开页面后是否清除当前定时任务，true:清除
         */
        doTask: function (fn, time, isTemporary, isPlatform) {

            if (!fn) {
                return null;
            }

            //定时任务
            var timeTask = top.setInterval(function () {
                fn.apply(this, arguments);
            }, time * 1000);

            if (isTemporary) {
                top.temporaryTasks.push(timeTask);
            }

            if (isPlatform) {
                top.platformTasks.push(timeTask);
            }

            top.allTasks.push(timeTask);
            return timeTask;
        },

        clearTimer: function (timeTask) {
            top.clearInterval(timeTask);
        },

        stopPlatformTask: function () {
            angular.forEach(top.platformTasks, function (platformTask) {
                top.clearInterval(platformTask);
            });

            //清除数组中的所有对象，释放资源
            top.platformTasks = [];
        },

        stopTemporaryTask: function () {
            angular.forEach(top.temporaryTasks, function (temporaryTask) {
                top.clearInterval(temporaryTask);
            });

            //清除数组中的所有对象，释放资源
            top.temporaryTasks = [];
        },

        stopAllTask: function () {
            angular.forEach(top.allTasks, function (eachTask) {
                top.clearInterval(eachTask);
            });

            //清除数组中的所有对象，释放资源
            top.allTasks = [];
        }
    };
    return serviceInstance;
}]);


/**
 * cookie服务
 * $cookies
 */
serviceModule.service("cookieService", [function () {

    var serviceInstance = {

        /**
         * 获取cookie信息
         * @param key     cookie 名
         * @param path    cookie 路径【可选】
         * @returns  value
         */
        get: function (key, path) {
            "language" == key && (key = "rd_" + key);
            var arrStr = document.cookie.split("; ");
            var arrLength = arrStr.length;
            for (var i = 0; i < arrLength; i++) {
                var tempArr = arrStr[i].split("=");
                if (tempArr[0] == key) {
                    return unescape(tempArr[1]);
                }
            }
        },

        /**
         * 添加cookie信息
         *
         * @param key       cookie 名
         * @param value     cookie 值
         * @param hours     cookie 过期时间【可选】
         */
        put: function (key, value) {
            "language" == key && (key = "rd_" + key);
            var cookieString = key + "=" + escape(value);

            //不设定过期时间，浏览器关闭时cookie自动消失
            //安全红线，不允许使用持久性cookie，即不允许设置cookie过期日期。
            document.cookie = cookieString + ";path=/src/;secure=true";
        },

        putToken: function (token) {
            this.put('rd_randomStr_HW', token);
        },

        getToken: function () {
            return this.get("rd_randomStr_HW");
        },

        removeToken: function () {
            this.remove('rd_randomStr_HW');
        },

        /**
         * 删除cookie信息
         * @param key cookie 名称
         */
        remove: function (key) {
            var removeString = key + "=;expires=" + (new Date(0)).toGMTString() + ";path=/";
            document.cookie = removeString;
        }
    };
    return serviceInstance;
}]);


/////////////////////////////////////服务模块定义结束/////////////////////////////////////
});