define([], function() {
    /**
     * 权限指令（一个scope只允许有一个这样的指令，新版本需要修改这个方案）
     * modify version :
     * 1 : 不支持双向，直接清空dom。
     * ！！！：为了达到双向绑定，scope是extend的。__permissions__避免在scope中使用。
     * 不双向绑定，就可以clear dom，达到和if不加载的效果。但是如果权限key动态变更，就不能实现更新了。
     * @param  {[type]} $compile        [description]
     * @param  {[type]} securityService [description]
     * @return {[type]}                 [description]
     */
    var auth = ["$compile","securityService",function($compile,securityService){
        return {
            template : "<span ng-if='__permissions__' ng-transclude></span>",
            transclude: true,
            "link" : function(scope, element, attrs) {
                scope.__permissions__ = securityService.checkRight(scope.$eval(attrs.auth));

                scope.$watch(attrs.auth,function(newVal,oldValue,newScope){

                    if(newVal === oldValue)
                    {
                        return;
                    }

                    scope.__permissions__ = securityService.checkRight(newVal);
                })
            }
        }
    }];

    /**
     * 权限指令（常用）
     */
    var authKey = ["$compile","securityService",function($compile,securityService){
        return {
            "link" : function(scope, element, attrs) {
                var authKey = scope.$eval(attrs.auth);
                _.isEmpty(authKey) && (authKey = attrs.auth);
                var isAuth = securityService.checkRight(authKey);

                if (!isAuth) {
                    $(element).remove();
                }
            }
        }
    }];

    var hideCloak = [function(){
        return {
            restrict: "AC",
            compile: function(element, attr){
                setTimeout(function(){
                    attr.$set('hideCloak', undefined);
                })
            }
        }
    }];

    /**
     * 局部mask
     *
     * mask="promise" 必选
     * mask-style="top:0px;left:0px;height:0px;width:0px"  可选 重写style样式
     *
     * example :
     *  <div mask="promise|boolean"/>
     *  <div mask="promise|boolean" mask-style="css style"/>
     *
     * !!!:
            1.新加的dom在指令dom的parent后添加
            2.在单独使用指令时，指令没有包含需要hide的dom时，注意遮挡层是透明的。opacity:0，需要自己将opacity:1，在设置和背景相同的background-color，请参考添加保护组时，选择os。
            3.指令内包含dom时，dom是隐藏的。
     */
    var mask = ["mask", "i18nService", function(mask, i18nService) {
        return {
            restrict: "A",
            scope: false,
            "link": function(scope, element, attrs) {

                var watchObj = scope.$eval(attrs.mask),
                    maskStyle = attrs.maskStyle,
                    maskDom = $(element),
                    offset = maskDom.offset(),
                    width = maskDom.width(),
                    height = maskDom.height(),
                    mheight = height < 50 ? 50 : height,
                    loadingText = i18nService.get("common_term_loading_label", "Loading"),
                    html = '<div class="loading loadingBlock"> <div class="circle"> <div class="backgrdClass"> <div class="waitingBoxTextClass">' + loadingText + '</div><span class="block"></span> </div> </div> </div>',
                    backgroundTmp = $('<div unselectable="on"></div>').css({
                        "-moz-user-select": "none",
                        "-webkit-user-select": "none",
                        "z-index": 999,
                        "filter": "Alpha(Opacity=0)",
                        "position": "absolute",
                        "top": offset.top,
                        "left": offset.left,
                        "width": width,
                        "height": mheight,
                        "background": "50% 50% repeat-x rgb(0, 0, 0)",
                        "opacity": "0",
                        "border-radius": "5px"
                    }),
                    background = backgroundTmp.attr("style", backgroundTmp.attr("style") + ";" + maskStyle),
                    loading = $(html).css({
                        "z-index": +background.css("z-index") + 1,
                        "position": "absolute",
                        "top": parseInt(background.css("top"), 10) + background.height() / 2 - 40 / 2,
                        "left": parseInt(background.css("left"), 10) + background.width() / 2 - 140 / 2,
                        "display": "inline-block",
                        "text-align": "center",
                        "overflow": "hidden",
                        "margin-left": "inherit",
                        "margin-top": "inherit"
                    }),
                    id = _.uniqueId("mask_"),
                    addDom = $("<div></div>").attr("id", id).append(background).append(loading),
                    thisFn = arguments.callee,
                    maskWatchHandle = scope.$watch(attrs.mask, function(newVal, oldValue, newScope) {

                        //promise情况下，判断对象状态
                        if (_.isObject(newVal) && _.isObject(oldValue)) {
                            if (newVal.state() === oldValue.state()) {
                                if (!(oldValue.id && oldValue.id != newVal.id)) {
                                    return;
                                }

                                //promise情况下，频繁切换或更改promise对象地址的情况。例如消息频繁通知
                                //需要强制处理上次请求。
                                //然后重新执行一次
                                clearTimeout(deleteMask);
                                maskDom.show();
                                $("#" + id).remove();
                            };
                            //true/false情况下，相等情况处理
                        } else if (newVal === oldValue) {
                            return;
                        }


                        //false情况下处理show处理
                        if (newVal == false) {
                            clearTimeout(deleteMask);
                            maskDom.show();
                            $("#" + id).remove();
                            return;
                        }

                        //删除当前监听
                        maskWatchHandle();

                        //对象已经变化了，重新执行本方法
                        thisFn(scope, maskDom, attrs);
                    });

                //防止scope没有定义变量时的情况。
                if (undefined == watchObj) {
                    return;
                }

                maskDom.hide();
                $("body").append(addDom);

                //防止请求时间过长，用户界面切换太多，生成的遮挡层太多无法自动删除。
                var deleteMask = setTimeout(function() {
                    (function(maskDom, id) {
                        maskDom.show();
                        $("#" + id).remove();
                    })(maskDom, id)
                }, 60000);

                //promise情况下，频繁切换或更改promise对象地址的情况。例如消息频繁通知
                if (_.isObject(watchObj)) {
                    watchObj.id = id;

                    //promise异步完成时的处理。
                    $.when(watchObj).then(function() {
                        clearTimeout(deleteMask);
                        maskDom.show();
                        $("#" + id).remove();
                    });
                }

                //请求没有返回，用户updateview
                var destroy = scope.$on('$destroy', function() {
                    clearTimeout(deleteMask);
                    $("#" + id).remove();
                    destroy();
                });

            }
        }
    }];
    return {
        auth: auth,
        authKey : authKey,
        hideCloak: hideCloak,
        mask: mask
    };
});
