define(["tiny-directives/Directive", "tiny-extra-widgets/DualSelectBox"], function(Directive, DualSelectBoxWidget) {

    var DualSelectBox;
    var DEFAULT_CONFIG = {
        "directiveName" : "tinyDualselectbox",
        "widgetClass" :DualSelectBoxWidget,
        "constantProperties" : ["id","left-values","right-values","setting","load"],
        "template" : "<div></div>",
        "replace" : "true"
    };

    DualSelectBox = Directive.extend({
        "init": function (options) {
            var directiveThis = this;
            directiveThis._super(_.extend({}, DEFAULT_CONFIG, options));
        },
        "compile": function () {
            var directiveThis = this;
            return directiveThis.link;
        },
        "link": function (scope, element, attrMap) {
            var directiveThis = this;
            var configOptions = scope.$eval(attrMap.options) || {};
            var constants = _.pick(configOptions, directiveThis.constantProperties);
            //filter undefined scope
            var validProperName = [];
            _.filter(constants, function (value, key) {
                if (value !== undefined) {
                    validProperName.push(key);
                }
                return value !== undefined;
            });
            var _option = _.pick(constants,validProperName);
            _option.isDirective = true;
            directiveThis = new directiveThis.widgetClass(_option);
            directiveThis.$compile = this.$compile;
            element.append(directiveThis._element);

            directiveThis.on("loadEvt", function(templateDom) {
                directiveThis.$compile($(templateDom))(scope);
                if (configOptions.load) {
                    configOptions.load();
                }
                scope.$apply();
            });

        },
        toAngularDirective : function(){
            var directiveThis = this;
            var module = angular.module( directiveThis.moduleName );
            module.directive( directiveThis.directiveName, function($compile){
                var directiveConfig = directiveThis;
                delete directiveConfig.scope;
                directiveConfig.$compile = $compile;
                return directiveConfig;
            } );
        }
    });
    new DualSelectBox().toAngularDirective();
    return DualSelectBox;
});
