define(["tiny-directives/Directive"], function(Directive) {
    var DEFAULT_CONFIG = {
        "directiveName": "tinyFloatingpanel",
        "restrict" : "E",
        "scope": {
            "id" : "=",
            "text": "="
        },
        "replace": true,
        "transclude":true,
        "template":
            '<div class="FLPanel_mian">' +
                '<div class="FLPanel_content">'+
                '<div class="FLPanel_title" ng-bind="text"></div>' +
                '<div class="FLPanel_user_content" ng-transclude></div>' +
                '</div>'+
                '<div class="FLPanel_triangle"></div>' +
            '</div>'
    };

    var FLPanel = Directive.extend({
        "init": function(options) {
            var directiveThis = this;
            directiveThis._super(_.extend({}, DEFAULT_CONFIG, options));
        },

        "compile" : function(element, attrMap, transcludeFn) {
            var directiveThis = this;
            return directiveThis.link;
        },

        "link" : function(scope, element, attrMap) {
            var sID = scope.id;
            if(scope.id){
                element.attr('id',scope.id);
            }
            $("body").on("mousedown", {
               id:sID
            }, function(event){

               _onBodyMouseDown(event);
            });

            function _onBodyMouseDown(event) {
                var nSrc = $(event.target);
                var sID = event.data.id;
                if(nSrc.parents("#"+sID).length > 0 || nSrc.is("#"+sID) || nSrc.parents('.even').length > 0
                    || nSrc.parents('.odd').length > 0 ){
                }else{
                   _show(false);
                }
            }

            function _show(isshow) {
                if(isshow){
                    element.show();
                }else{
                    element.hide();
                }
            }
        }

    });

    new FLPanel().toAngularDirective();

    return FLPanel;
});
