define(["tiny-directives/Directive", "tiny-extra-widgets/IconTip"], function(Directive, IconTipWidget) {
    var DEFAULT_CONFIG = {
        "directiveName" : "tinyIcontip",
        "widgetClass" : IconTipWidget,
        "scope" : {
            "tip" : "=",
            "class": "="
        },
        "constantProperties" : ["tip", "class"],
        "replace" : true,
        "template" : "<span></span>"
    };

    var IconTip = Directive.extend({
        "init" : function(options) {
            var directiveThis = this;
            directiveThis._super(_.extend({}, DEFAULT_CONFIG, options));
        },
        "compile" : function(element, attrMap, transclude) {
    	   var directiveThis = this;
           return directiveThis.link;
        },
        "link" : function(scope, element, attrMap) {
            var directiveThis = this;
            
            var options = _.pick(scope, _.keys(attrMap));
            var widgetInstance = new directiveThis.widgetClass(options);
            
            var dom = widgetInstance.getDom();
            element.replaceWith( dom );
            
            dom.on('$destroy', function(){
                scope.$destroy();
                widgetInstance.destroy();
            });
         }
    });

    new IconTip().toAngularDirective();

    return IconTip;
});