define(["tiny-directives/Directive","tiny-extra-widgets/Pop"], function (Directive,PopWidget) {
    var DEFAULT_CONFIG = {
        "directiveName": "tinyPop",
        "widgetClass": PopWidget,
        "constantProperties" : ["id","elementId"],
        "scope": {
            "id": "=",
            "template": "=",
            "elementId": "=",
            "popStyle" : "="
        },
        "replace": true,
        "transclude":true,
        "template": '<div class="pop_mian" >' +
            '</div>'
    };

    var Pop = Directive.extend({

        "init": function (options) {
            var directiveThis = this;
            directiveThis._super(_.extend({}, DEFAULT_CONFIG, options));
        },

        "compile": function (element, attrMap, transclude) {
            var directiveThis = this;
            return directiveThis.link;
        },

        "link": function (scope, element, attrMap) {
             var directiveThis = this;
            //根据用户设置的属性，构造控件实例
            var widgetInstance = new directiveThis.widgetClass(_.pick(scope,directiveThis.constantProperties));

            var $pop = widgetInstance._element;
            element.replaceWith($pop);

            var sID = scope.id;
            var widgetObj = $pop.widget();

            if(scope.popStyle){
                widgetInstance.setStyle(scope.popStyle);
            }

            if(scope.template){
                scope.$watch('template', function(newValue, oldValue){
                    $pop.html(newValue) ;

                    //todo complie
                });
            }

            scope.$watch('elementId',function(newValue, oldValue){
                widgetObj.option('elementId',newValue);
            })

            $("body").on("mousedown", {
                id:sID
            }, function(event){
                _onBodyMouseDown(event);
            });

            function _onBodyMouseDown(event) {
                var directiveThis = this;
                var nSrc = $(event.target);
                var sID = event.data.id;
                if (nSrc.attr("id") == "taskButton" || nSrc.attr("id") == "taskCountDiv" || nSrc.attr("id") == "taskFailedDiv") {
                    return;
                }
                if(nSrc.parents("#"+sID).length > 0 || nSrc.is("#"+sID) || nSrc.hasClass("tiny-combobox-popup-container")){

                }else{
                    widgetInstance.setPopShow(false);
                }
            }
        }


    });
    new Pop().toAngularDirective();
    return Pop;
})