define(["tiny-directives/Directive", "tiny-extra-widgets/Rainbowbar"], function (Directive, RainbowbarWidget) {

    var DEFAULT_CONFIG = {
        "directiveName": "tinyRainbowbar",
        "widgetClass": RainbowbarWidget,
        "constantProperties": ["id"],
        "scope": {
            "id": "=",
            "config": "=",
            "width": '=',
            "barwidth": '=',
            "position":"=",
            "percentages":"="
        },
        "replace": true,
        "template": "<span></span>"
    };

    var Rainbowbar = Directive.extend({

        "init": function (options) {
            var directiveThis = this;
            directiveThis._super(_.extend({}, DEFAULT_CONFIG, options));
        },

        "compile": function (element, attrMap, transclude) {
            var directiveThis = this;
            return directiveThis.link;
        },

        "link": function (scope, element, attrMap) {
            var directiveThis = this, constants = _.pick(scope, directiveThis.constantProperties);
            //filter undefined scope
            var validProperName = [];
            _.filter(constants, function (value, key) {
                if (value !== undefined) {
                    validProperName.push(key);
                }
                return value !== undefined;
            });
            var widgetInstance = new directiveThis.widgetClass(_.pick(constants, validProperName));
            $rainbowbar = widgetInstance._element;
            element.append($rainbowbar);
            var widgetObj = $rainbowbar.widget();

            scope.$watchCollection("config", function (newValue, oldValue) {
                widgetObj.option("config", newValue);
            });

            scope.$watch("width", function (newValue, oldValue) {
                widgetObj.option("width", newValue);
            });

            scope.$watch("barwidth", function (newValue, oldValue) {
                widgetObj.option("barwidth", newValue);
            });
            scope.$watch("position", function (newValue, oldValue) {
                widgetObj.option("position", newValue);
            });

            scope.$watch("percentages", function (newValue, oldValue) {
                widgetObj.option("percentages", newValue);
            });
        }

    });
    new Rainbowbar().toAngularDirective();

    return Rainbowbar;

});