define(["tiny-lib/angular", "tiny-lib/jquery", "tiny-widgets/Widget","app/services/msgService","app/services/i18nService"],
    function(angular, $, Widget,msgService,i18nService){
    var message = new msgService();
    var i18nService = new i18nService();
    var DEFAULT_CONFIG  = {

    	/*id*/
        containerId : "",
        id : "",
        template: "<div style='height:100%;'></div>",

        /*选择类型
         *单选: single
         *多选: multi
         * */
        "type" : "single",

        /*数据,对象数组,每一个对象的格式为
         *{
         *  value   : 该项的值
         *  content : 则为自定义显示的内容
         *}
         * */
        "data" : [],

        /*选中项的值*/
        "checkedValue" : [],
        /*默认选中*/
        "defaultCheck" : "",

    	/*事件*/
    	onCheck : "",
    	onCancelCheck : "",
        isChange:""
    };

    /*tool fn*/

    /**
     * 从数组中通过key和vaule获取特定项
     * @param array 数组
     * @param key 对象属性
     * @param value 对应属性的值
     */
    var getItemFromArray = function(array,key,value){
    	if( !(array instanceof Array) ) return;

    	for(var i = 0 , len = array.length ; i < len ; i++){
			if(value){
	    		if(array[i][key] == value){
					return array[i];
				}
    		}else{
    			if(array[i] == key){
					return array[i];
				}
    		}
		}
	};

	/**
     * 判断数组中是否存在项满足指定的key和value
     * @param array 数组
     * @param key 对象属性
     * @param value 对应属性的值
     */
	var isInArray = function(array,key,value){
		return getItemFromArray(array, key, value);
	};


    //记录当前显示的面板index(data的下标)
    var crtPanelIndex = 0;
    var moveUnit = "112";
    var cantainCount;

    var CheckPanel = Widget.extend({
        "init":function(options){
            var widgetThis = this;
            //这里需要深拷贝
            options = _.extend({}, angular.copy(DEFAULT_CONFIG), options);
            widgetThis._super(options);

            $("#" + options["containerId"]).append(widgetThis._element);
            if( options.defaultCheck ){
          	  $("li.tiny-checkpanel-td[value='"+options.defaultCheck+"']").click();
            }

            //内容高度大于容器,出现下拉按钮
            if( $("#contentTable").height() > $("#elementContent").height() ){
                $(".tiny-checkpanel-arrow-container").show();
                var emHeight = $("#" + options["containerId"]).height() - 54;
                $("#elementContent").height(emHeight);
                //初始时禁用向上按钮
                $(".tiny-arrow-up-icon").removeClass("tiny-arrow-up-icon").addClass("tiny-arrow-up-icon-disabled");
            }

            cantainCount = Math.floor($("#elementContent").height()/moveUnit);

            crtPanelIndex = 0;
        },
        "_generateElement": function(){
            var widgetThis = this;
            widgetThis._super();

            var options = widgetThis.options;
            var id = options.id;
            var elementContent = "<div id='" + id + "' style='height:100%;background:#f2f2f2;width:325px;box-sizing: border-box;padding:0 10px 10px 10px;'> <div class='tiny-checkpanel-arrow-container'><div class='tiny-checkpanel-arrow tiny-arrow-up-icon' up></div></div>";

            elementContent += "<div id='elementContent' style='height:100%;position:relative;'><ul id='contentTable' style='position:absolute;'>"
            angular.forEach(options.data , function(item){
            	elementContent += "<li class='tiny-checkpanel-td' value="+item.value+" style='width: 280px;height:100%;'><img src='"+item.imgSrc+"' style='width:280px;'></img><div class='tiny-checkpanel-label'><span title='"+item.content+"'>"+item.content+"</span></div><div class='tiny-checkpanel-checkicon' style='display: none'></div></li>";
            });
             elementContent += "</ul></div>"

            elementContent += "<div class='tiny-checkpanel-arrow-container'><div class='tiny-checkpanel-arrow tiny-arrow-down-icon' down></div></div></div>";
            widgetThis._element.html(elementContent);
        },
        "_addBehavior" : function() {
            var widgetThis = this;
            var element = widgetThis._element;
            var options = widgetThis.options;

            element.find(".tiny-checkpanel-arrow").click(function(evt){
                var ul = element.find("ul");
                //down
                if( angular.isUndefined($(this).attr("up")) ){
                    if( crtPanelIndex < options.data.length - cantainCount ){
                        crtPanelIndex ++;
                        ul.animate({top:"-=112"},'fast');
                        //激活向上按钮
                        $(".tiny-arrow-up-icon-disabled").removeClass("tiny-arrow-up-icon-disabled").addClass("tiny-arrow-up-icon");
                        if(options.data.length - crtPanelIndex == cantainCount ){
                            $(".tiny-arrow-down-icon").removeClass("tiny-arrow-down-icon").addClass("tiny-arrow-down-icon-disabled");
                        }
                    }
                }
                //up
                else{
                    if( crtPanelIndex > 0 ){
                        crtPanelIndex --;
                        ul.animate({top:"+=112"},'fast')
                        //激活向下按钮
                        $(".tiny-arrow-down-icon-disabled").removeClass("tiny-arrow-down-icon-disabled").addClass("tiny-arrow-down-icon");
                        if(crtPanelIndex == 0){
                             $(".tiny-arrow-up-icon").removeClass("tiny-arrow-up-icon").addClass("tiny-arrow-up-icon-disabled");
                        }
                    }
                }

            });


            element.find("li")
            .on("mouseover", function(evt) {

            })
            .on("mouseout",function(evt){
            	var value = $(evt.target).attr("value");

            })
            .on("click",function(evt){
            	var jqTd = $(evt.target);
            	if( evt.target.nodeName.toUpperCase() == "DIV" || evt.target.nodeName.toUpperCase() == "IMG") {
            		jqTd = jqTd.parent();
            	}

                if (evt.target.nodeName.toUpperCase() == "SPAN") {
                    jqTd = jqTd.parent().parent();
                }

            	var value = jqTd.attr("value"),
            		checkedValue = options.checkedValue;

            	if( !isInArray(checkedValue,value) ){
            		if( options.type == "single" ){
                        if(options.isChange){
                            message.confirm({
                                content:i18nService.get("change_schedules_msg_label"),
                                ok: function(){
                                    options.isChange = false;
                                    checkedValue.splice(0,1,value);
                                    element.find("li.tiny-checkpanel-td").not(jqTd).removeClass("checked")
                                    .find("div.tiny-checkpanel-checkicon").css("visibility","hidden");

                                    !jqTd.hasClass("checked") && jqTd.addClass("checked");
                                    jqTd.find("div.tiny-checkpanel-checkicon").css("visibility","visible");
                                    "function" == ( typeof options["onCheck"]) && options["onCheck"](value,evt);
                                }
                            })
                        }else{
                            checkedValue.splice(0,1,value);
                            element.find("li.tiny-checkpanel-td").not(jqTd).removeClass("checked")
                            .find("div.tiny-checkpanel-checkicon").css("visibility","hidden");

                            !jqTd.hasClass("checked") && jqTd.addClass("checked");
                            jqTd.find("div.tiny-checkpanel-checkicon").css("visibility","visible");
                            "function" == ( typeof options["onCheck"]) && options["onCheck"](value,evt);
                        }
            		}
            		else{
            			checkedValue.push(value);
                        "function" == ( typeof options["onCheck"]) && options["onCheck"](value,evt);
            		}

            	}
            	else{
            		"function" == ( typeof options["onCancelCheck"]) && options["onCancelCheck"](value,evt);
            	}
              });
        },
        "getCheckedValue" : function(){
        	 var widgetThis = this;
        	 var options = widgetThis.options;

        	 return options.type == "single" ? options.checkedValue[0] : options.checkedValue;
        }
    });
    return CheckPanel;
});
