define(["tiny-lib/angular", "tiny-lib/jquery", "tiny-widgets-CirqueChart", "tiny-lib/raphael"],
    function(angular, $, Cirquechart, Raphael) {
        var CirquechartExt = Cirquechart.extend({
            /**
             * 返回容量单位对应权值
             *
             * @param unit 指定容量单位
             * @returns {Number}
             */
            "getScale": function(unit) {
                switch (unit) {
                    case "BIT":
                        return 1;
                    case "BYTE":
                        return 8;
                    case "KB":
                        return 8 * 1024;
                    case "MB":
                        return 8 * 1024 * 1024;
                    case "GB":
                        return 8 * 1024 * 1024 * 1024;
                    case "TB":
                        return 8 * 1024 * 1024 * 1024 * 1024;
                    case "PB":
                        return 8 * 1024 * 1024 * 1024 * 1024 * 1024;
                }
            },
            /**
             * 容量转换(返回转换后的值, 保留3位小数)
             *
             * @param capacity 容量
             * @param srcUnit 原容量单位
             * @param targetUnit 目标容量单位
             * @returns 转化后的容量
             */
            "convertCapacity": function(capacity, srcUnit, targetUnit) {
                var returnValue = capacity;

                // 若不传目标容量，则默认为GB
                if (angular.isUndefined(targetUnit)) {
                    targetUnit = "GB";
                }

                if (this.getScale(srcUnit) > this.getScale(targetUnit)) {
                    returnValue = (this.getScale(srcUnit) / this.getScale(targetUnit)) * capacity;
                }
                if (this.getScale(srcUnit) < this.getScale(targetUnit)) {
                    returnValue = capacity / (this.getScale(targetUnit) / this.getScale(srcUnit));
                }

                if (isNaN(returnValue)) {
                    returnValue = 0;
                }
                return (targetUnit == "KB") ? Math.ceil(returnValue) : this.numberFormat(returnValue, 1);
            },
            /**-----------数字与容量转换相关的工具方法定义 begin---------------*/

            /**
             * 将数据格式化，保留三位小数（截取方式）
             * 如123456.78901 显示为123,456.789
             *
             * @param number 原数字
             * @param decimals 保留小数个数 [默认3位]
             * @param dec_point 小数分隔副
             * @param thousands_sep 千分位分隔符
             * @returns 转化后的数字
             */
            "numberFormat": function(number, decimals, dec_point, thousands_sep, isCeil) {
                if (angular.isUndefined(decimals)) {
                    decimals = 3;
                }
                number = (String(number)).replace(/[^0-9+-Ee.]/g, '');
                let n = isFinite(+number) ? +number : 0;
                let prec = isFinite(+decimals) ? Math.abs(decimals) : 0;
                let sep = (angular.isUndefined(thousands_sep)) ? ',' : thousands_sep;
                let dec = (angular.isUndefined(dec_point)) ? '.' : dec_point;
                let toFixedFix = function(n, prec, isCeil) {
                    let k = Math.pow(10, prec);
                    return isCeil ? String(Math.ceil(n * k) / k) : String(Math.floor(n * k) / k);
                };

                let s = (!prec ? String(Math.floor(n)) : toFixedFix(n, prec, isCeil)).split('.');
                if (s[0].length >= 4) {
                    s[0] = s[0].replace(/\B(?=(?:d{3})+(?!d))/g, sep);
                }

                if (s[1] && s[1].length > prec) {
                    s[1] += new Array(prec - s[1].length + 1).join('0');
                }
                if (angular.isUndefined(s[1])) {
                    s[1] = '0';
                }
                while ((s[1] || '').length < prec) {
                    s[1] += '0';
                }
                return s.join(dec);
            },
            /**
             * 容量转换(返回转换后的值+对应单位的字符串)
             *
             * @param capacity 容量
             * @param srcUnit 原容量单位
             * @param targetUnit 目标容量单位
             * @returns  "xxx GB"
             */
            "convertCapacityWithUnit": function(capacity, srcUnit, targetUnit) {
                var unit = targetUnit ? targetUnit : "AUTO_SIZE";
                if (unit != "AUTO_SIZE") {
                    return this.convertCapacity(capacity, srcUnit, targetUnit) + " " + unit;
                } else {
                    //自动容量转换
                    var units = ["PB", "TB", "GB", "MB", "KB"];
                    var tunit;
                    var tresult;

                    for (var i = 0; i < units.length; i++) {
                        tunit = units[i];
                        tresult = this.convertCapacity(capacity, srcUnit, tunit);
                        if (Math.floor(tresult) > 0) {
                            //取指定小数位数,保留1位小数
                            var num = this.numberFormat(tresult, 1);

                            return num + " " + tunit;
                        }
                    }
                    //都不符合时，以KB为单位
                    return this.convertCapacity(capacity, srcUnit, "KB") + " " + "KB";
                }
            },
            "getCapacityNumAndUnit": function(valueWithUnit) {
                var tmp = valueWithUnit.split(/\s+/);
                var obj = {
                    value: tmp[0],
                    unit: tmp[1]
                };
                return obj;
            },
            "createLegend": function() {
                var widgetThis = this;
                widgetThis._calcBPoint();
                widgetThis._calcAPoint();
                widgetThis._calcProperAPointY();
                setTimeout(function() {
                    widgetThis._polyLegendBulid();
                }, 0)
            },
            //根据A框大小，得出可以作为A点的坐标集合，再根据计算出的结果，选取最接近的，没有被占用的坐标作为A点的坐标
            "_calcProperAPointY": function() {
                var widgetThis = this;
                var left_Y = [];
                var right_Y = [];
                var perLengendHeight = 49.5;
                var topExtend = -3;
                var bottomExtend = 10;
                var maxIndex = 0;
                var i = 0;
                var totalBackupPointsCount = parseInt(((widgetThis.C + widgetThis.r) * 2) / perLengendHeight) + 1;
                for (i = 0; i < totalBackupPointsCount; i++) {
                    left_Y[i] = i * perLengendHeight + widgetThis.center[1] - widgetThis.C - widgetThis.r;
                    right_Y[i] = i * perLengendHeight + widgetThis.center[1] - widgetThis.C - widgetThis.r;
                }
                maxIndex = i - 1;
                for (var i = 0; i < widgetThis.A.length; i++) {
                    if (widgetThis.A[i].Directive == "left") {
                        var j = widgetThis._getMostCloseY(left_Y, widgetThis.A[i].Y);
                        if (j == 0) {
                            widgetThis.A[i].Y = left_Y[j] + topExtend;
                        } else if (j == maxIndex) {
                            widgetThis.A[i].Y = left_Y[j] + bottomExtend;
                        } else {
                            widgetThis.A[i].Y = left_Y[j];
                        }
                        left_Y[j] = -1;
                    } else {
                        var j = widgetThis._getMostCloseY(right_Y, widgetThis.A[i].Y);
                        if (j == 0) {
                            widgetThis.A[i].Y = right_Y[j] + topExtend;
                        } else if (j == maxIndex) {
                            widgetThis.A[i].Y = right_Y[j] + bottomExtend;
                        } else {
                            widgetThis.A[i].Y = right_Y[j];
                        }
                        right_Y[j] = -1;
                    }
                }
                widgetThis.left_Y = left_Y;
                widgetThis.right_Y = right_Y;
                widgetThis._calcLeftMidPoint();
            },
            //3段，最大一段居左且中心位置在0.75pi到1.25pi之间，连接线为水平
            "_calcLeftMidPoint": function() {

                var widgetThis = this;
                if (widgetThis.A.length != 3) {
                    return;
                }
                var count = 0;
                var index = 0;
                var j = 0;
                for (var i = 0; i < widgetThis.left_Y.length; i++) {
                    if (widgetThis.left_Y[i] == -1) {
                        count++;
                        index = i;
                    }
                }
                for (j = 0; j < widgetThis.A.length; j++) {
                    if (widgetThis.A[j].Directive == "left") {
                        break;
                    }
                }
                if (count == 1 && widgetThis.B[j].Align >= (widgetThis.pi - 0.0001) * 0.75 && widgetThis.B[j].Align <= (widgetThis.pi - 0.0001) * 1.25) {
                    widgetThis.B[j].X = widgetThis.center[0] + Math.cos(widgetThis.pi) * widgetThis.r;
                    widgetThis.B[j].Y = widgetThis.center[1] + Math.sin(widgetThis.pi) * widgetThis.r;

                    widgetThis.A[j].X = widgetThis.center[0] + Math.cos(widgetThis.pi) * (widgetThis.r + widgetThis.C);
                    widgetThis.A[j].Y = widgetThis.center[1] + Math.sin(widgetThis.pi) * (widgetThis.r + widgetThis.C);
                }
            },

            "_getMostCloseY": function(array, Y) {
                var s = Number.MAX_VALUE;
                var j = -1;
                for (var i = 0; i < array.length; i++) {
                    var test = Math.abs(array[i] - Y);

                    if (array[i] == -1) {
                        continue;
                    } else if (test < s) {
                        s = test;
                        j = i;
                    }
                }
                return j;
            },


            "_calcBPoint": function() {
                var widgetThis = this;
                if (!widgetThis.B) {
                    widgetThis.B = [];
                }
                //只有两段弧
                if (widgetThis.angles.length == 3) {
                    //选左右，谁在左边宽，谁的图例就在左边，剩下的在右边固定位置
                    if (widgetThis.angles[1] > widgetThis.pi) {
                        var _ang = 0.875 * widgetThis.pi;
                        var _X = widgetThis.center[0] + Math.cos(_ang) * widgetThis.r;
                        var _Y = widgetThis.center[1] + Math.sin(_ang) * widgetThis.r;
                        widgetThis.B.push({
                            Align: _ang,
                            X: _X,
                            Y: _Y
                        });
                        var _ang1 = 1.875 * widgetThis.pi;
                        if (widgetThis.angles[1] > 1.775 * widgetThis.pi) {
                            _ang1 = ((widgetThis.angles[2] - widgetThis.angles[1]) / 2 + widgetThis.angles[1]) % (2 * widgetThis.pi);
                        }
                        var _X1 = widgetThis.center[0] + Math.cos(_ang1) * widgetThis.r;
                        var _Y1 = widgetThis.center[1] + Math.sin(_ang1) * widgetThis.r;
                        widgetThis.B.push({
                            Align: _ang1,
                            X: _X1,
                            Y: _Y1
                        });
                    } else {
                        var _ang = 0.125 * widgetThis.pi;
                        if (widgetThis.angles[1] < 0.225 * widgetThis.pi) {
                            _ang = ((widgetThis.angles[1] - widgetThis.angles[0]) / 2 + widgetThis.angles[0]) % (2 * widgetThis.pi);
                        }
                        var _X = widgetThis.center[0] + Math.cos(_ang) * widgetThis.r;
                        var _Y = widgetThis.center[1] + Math.sin(_ang) * widgetThis.r;
                        widgetThis.B.push({
                            Align: _ang,
                            X: _X,
                            Y: _Y
                        });
                        var _ang1 = 1.125 * widgetThis.pi;
                        var _X1 = widgetThis.center[0] + Math.cos(_ang1) * widgetThis.r;
                        var _Y1 = widgetThis.center[1] + Math.sin(_ang1) * widgetThis.r;
                        widgetThis.B.push({
                            Align: _ang1,
                            X: _X1,
                            Y: _Y1
                        });
                    }
                    //3段弧
                } else {
                    for (var i = 1; i < widgetThis.angles.length; i++) {
                        var _ang = ((widgetThis.angles[i] - widgetThis.angles[i - 1]) / 2 + widgetThis.angles[i - 1]) % (2 * widgetThis.pi);
                        var _X = widgetThis.center[0] + Math.cos(_ang) * widgetThis.r;
                        var _Y = widgetThis.center[1] + Math.sin(_ang) * widgetThis.r;
                        widgetThis.B.push({
                            Align: _ang,
                            X: _X,
                            Y: _Y
                        });
                    }
                }

            },

            "_calcAPoint": function() {
                var widgetThis = this;
                var pi = widgetThis.pi;
                var x0 = widgetThis.center[0];
                var y0 = widgetThis.center[1];
                var r = widgetThis.r;
                var C = 10;
                var R = C + r;
                var _X = 0;
                var _Y = 0;
                var vBlank = 0.05;
                var hRect = 0.25;
                var rectToCenter = R * Math.cos(hRect);
                widgetThis.C = C;

                if (!widgetThis.A) {
                    widgetThis.A = [];
                }
                for (var i = 0; i < widgetThis.B.length; i++) {
                    var tB = (widgetThis.B[i].Align / pi) % 2;

                    if (tB > 0.5 && tB <= 1.5) { //在左侧
                        _dir = "left";
                    } else { //在右侧
                        _dir = "right";
                    }
                    if (tB >= (0.5 - vBlank) && tB <= (0.5 + vBlank)) { //下
                        if (tB < 0.5) {
                            _X = x0 - R * Math.tan((0 - vBlank) * pi);
                        } else {
                            _X = x0 - R * Math.tan(vBlank * pi);
                        }
                        _Y = y0 + R;
                    } else if (tB > (0.5 + vBlank) && tB < (1.5 - vBlank)) { //左
                        if (tB > (1 - hRect) && tB < (1 + hRect)) {
                            _X = x0 - rectToCenter;
                            _Y = y0 - rectToCenter * Math.tan(widgetThis.B[i].Align - pi);
                        } else {
                            _X = x0 + R * Math.cos(widgetThis.B[i].Align);
                            _Y = y0 + R * Math.sin(widgetThis.B[i].Align);
                        }
                    } else if (tB >= (1.5 - vBlank) && tB <= (1.5 + vBlank)) { //上
                        if (tB < 1.5) {
                            _X = x0 + R * Math.tan((0 - vBlank) * pi);
                        } else {
                            _X = x0 + R * Math.tan((vBlank) * pi);
                        }
                        _Y = y0 - R;
                    } else { //右
                        if (tB > (2 - hRect) || tB < hRect) {
                            _X = x0 + R;
                            _Y = y0 + R * Math.tan(widgetThis.B[i].Align);
                        } else {
                            _X = x0 + R * Math.cos(widgetThis.B[i].Align);
                            _Y = y0 + R * Math.sin(widgetThis.B[i].Align);
                        }
                    }
                    widgetThis.A.push({
                        Directive: _dir,
                        X: _X,
                        Y: _Y
                    });
                }

            },
            "_polyLegendBulid": function() {
                var detailFontColor = "#666666";
                var widgetThis = this;
                var r = widgetThis.r;
                var separateLineLength = 106;
                var ENDPOINT = {
                    LEFT: widgetThis.center[0] - r - separateLineLength,
                    RIGHT: widgetThis.center[0] + r + separateLineLength
                }
                for (var i = 0; i < widgetThis.B.length; i++) {
                    var path = "";
                    var percentFontColor = widgetThis.options.data[i].color;
                    if (percentFontColor == "#cccccc") {
                        percentFontColor = "#666666";
                    }

                    if (percentFontColor == "#e5e5e5") {
                        percentFontColor = "#ccc";
                    }
                    var percent = Math.floor((100 * (widgetThis.angles[i + 1] - widgetThis.angles[i]) / (2 * widgetThis.pi)) * 10) / 10;
                    if (percent < 0.1) {
                        percent = 0.0;
                    }
                    var capacityStr = percent + "%|" + widgetThis.convertCapacityWithUnit(widgetThis.options.data[i].value, "KB");
                    capacityStr = widgetThis.options.data[i].capacityView;

                    var capacityStrShort = capacityStr;
                    if (capacityStr.length > 14) {
                        capacityStrShort = capacityStr.slice(0, 12 - 1) + "...";
                    }
                    var nameStr = widgetThis.options.data[i].name;
                    var nameStrShort = nameStr;
                    if (nameStrShort.length > 14) {
                        nameStrShort = nameStrShort.slice(0, 12 - 1) + "...";
                    }
                    if (widgetThis.A[i].Directive == "left") {

                        separateLineLength = 106;

                        path = "M" + widgetThis.B[i].X + "," + widgetThis.B[i].Y + "L" + widgetThis.A[i].X + "," + widgetThis.A[i].Y + "L" + (widgetThis.A[i].X - separateLineLength) + "," + widgetThis.A[i].Y;
                        widgetThis.paper.text(widgetThis.A[i].X - separateLineLength, widgetThis.A[i].Y - 13, capacityStrShort).attr({
                            fill: detailFontColor,
                            "font-size": 14,
                            strokeWidth: "1",
                            "href": "javascript:void(0)",
                            "cursor": "text",
                            "text-anchor": "start",
                            "title": capacityStr
                        });
                        widgetThis.paper.text(widgetThis.A[i].X - separateLineLength, widgetThis.A[i].Y + 13, nameStrShort).attr({
                            fill: detailFontColor,
                            "font-size": 13,
                            strokeWidth: "1",
                            "href": "javascript:void(0)",
                            "cursor": "text",
                            "text-anchor": "start",
                            "font": "12px",
                            "title": nameStr,
                            "height": "14px"
                        });
                    } else {
                        separateLineLength = 362 - widgetThis.A[i].X;
                        path = "M" + widgetThis.B[i].X + "," + widgetThis.B[i].Y + "L" + widgetThis.A[i].X + "," + widgetThis.A[i].Y + "L" + (widgetThis.A[i].X + separateLineLength) + "," + widgetThis.A[i].Y;
                        widgetThis.paper.text(widgetThis.A[i].X + separateLineLength, widgetThis.A[i].Y - 13, capacityStrShort).attr({
                            fill: detailFontColor,
                            "font-size": 14,
                            strokeWidth: "1",
                            "href": "javascript:void(0)",
                            "cursor": "text",
                            "text-anchor": "end",
                            "title": capacityStr
                        });
                        widgetThis.paper.text(widgetThis.A[i].X + separateLineLength, widgetThis.A[i].Y + 13, nameStrShort).attr({
                            fill: detailFontColor,
                            "font-size": 13,
                            strokeWidth: "1",
                            "href": "javascript:void(0)",
                            "cursor": "text",
                            "text-anchor": "end",
                            "font": "12px",
                            "title": nameStr,
                            "height": "14px"
                        });
                    }

                    widgetThis.paper.path(path).attr({
                        stroke: percentFontColor,
                        strokeWidth: "5"
                    });
                }
            }
        });

        return CirquechartExt;

    });
