/**
 * 双向选择器。该组件用于支持双向选择操作。分左右两部分，左侧为源数据操作面板（唯一），右侧为目标操作面板（可以有多个目标面板）
 */
define(["tiny-lib/angular", "tiny-lib/jquery", "tiny-lib/Class", "tiny-widgets/Widget","tiny-common/util",
    "tiny-widgets/Tip","tiny-lib/encoder"], function(angular, $, Class, Widget,util,Tip,encoder) {
    var DEFAULT_CONFIG = {
        "template" : '<div class="tiny-dualSelectBox">'
    +    '<div class="tiny-dualSelectBox-left">'
    +    '</div>'
    +    '<div class="tiny-dualSelectBox-right" >'
    +    '</div>'
    +'</div>',
        "left-values" : [],//title,title-type,content,content-type
        "right-values":[],//height,title-type,content,content-type
        "setting":{"left-width":"400px","height":"400px","right-width":"440px"}//leftWidth,rightWidth,height
        /**
         * left-values数据结构：[{title:"test",title-type:"url",content:"test.html",content-type:"url",}]
         */
    };
    var dualSelectBox = Widget.extend({
        "init" : function(options) {
            var dualSelectBoxThis = this;
            var options = _.extend({}, DEFAULT_CONFIG, options);
            dualSelectBoxThis._super(options);
            dualSelectBoxThis._setOptions(options);
            $("#" + options["id"]).append(dualSelectBoxThis._element);
        },
        //处理配置参数
        "_valuesDispose" : function(value,type) {
            var dualSelectBoxThis = this;
            var options = dualSelectBoxThis.options;
            //左布局参数解析
            if(type=='left'){
                var setting=options["setting"];
                var width=setting["left-width"]?setting["left-width"]:"400";
                var height=setting["height"]?setting["height"]:"400px";

                //修正整体高度
                width=$.encoder.encodeForCSS("width", width, true);
                height=$.encoder.encodeForCSS("height", height, true);
                height=height.replace("px","");
                height-=32;
                width=width.replace("px","");
                width-=2;

                //左布局dom
                var leftcontent=dualSelectBoxThis._element.find('.tiny-dualSelectBox-left');
                leftcontent.empty();
                if(value["title"]){
                    if(value["title-type"]=='url'){
                        var title=$("<div/>").appendTo(leftcontent);
                        title.load(value["title"],function() {
                            //加载后处理
                            if (options.isDirective) {
                                dualSelectBoxThis.trigger("loadEvt", [this]);
                            } else {
                                if (options.load) {
                                    options.load(this);
                                }
                            }
                        });
                    }else{
                        var title=$('<span class="tiny-dualSelectBox-title-span" >'+$.encoder.encodeForHTML(value["title"])+'</span>').appendTo(leftcontent);
                    }
                }
                var contentDom=$('<div class="tiny-dualSelectBox-left-content" style="width:'+width+'px;height:'+height+'px;">'
                   + '</div>').appendTo(leftcontent);
                //自定义样式
                if(value["content-cls"]){
                    contentDom.addClass(value["content-cls"]);
                }
                //加载内容
                if(value["content-type"] === 'url'){
                    contentDom.load(value["content"],function() {
                        //加载后处理
                        if (options.isDirective) {
                            dualSelectBoxThis.trigger("loadEvt", [this]);
                        } else {
                            if (options.load) {
                                options.load(this);
                            }
                        }
                    });
                }else{
                    contentDom.html(value["content"]);
                    //加载后处理
                    if (options.isDirective) {
                        dualSelectBoxThis.trigger("loadEvt", [contentDom]);
                    } else {
                        if (options.load) {
                            options.load(contentDom);
                        }
                    }
                }

            }else if(type=='right'){//右布局参数解析
                var rightcontent=dualSelectBoxThis._element.find('.tiny-dualSelectBox-right');
                var height=value["height"]?$.encoder.encodeForCSS("height", value["height"], true):"200px";
                //修正高度
                height=height.replace("px","");
                height-=52;
                //右布局dom

                var html=$('<div class="tiny-dualSelectBox-right-item" >'
                    +'<div class="tiny-dualSelectBox-right-buttons">'
                    +'</div>'
                    +'    <div class="tiny-dualSelectBox-right-content">'
                    +'<div class="tiny-dualSelectBox-right-title">'
                    +'</div>'
                    +'        <div class="tiny-dualSelectBox-content-div"  style="height:'+height+'px;">'
                    +'        </div>'
                    +'    </div>'
                    +'</div>').appendTo(rightcontent);
                var title=html.find(".tiny-dualSelectBox-right-title");
                if(value["title"]){
                    if(value["title-type"]=='url'){
                        title.load(value["title"],function() {
                            //加载后处理
                            if (options.isDirective) {
                                dualSelectBoxThis.trigger("loadEvt", [this]);
                            } else {
                                if (options.load) {
                                    options.load(this);
                                }
                            }
                        });
                    }else{
                        $('<span class="tiny-dualSelectBox-title-span" >'+$.encoder.encodeForHTML(value["title"])+'</span>').appendTo(title);
                    }
                }
                //操作按钮定义add,remove,addall,removeall:click事件，class
                if(value["add"]){
                    var addbtndiv=$('<div></div>').appendTo(html.find(".tiny-dualSelectBox-right-buttons"));
                    if(value["add"].cls){
                        addbtndiv.addClass(value["add"].cls);
                    }else{
                        addbtndiv.addClass("add");
                    }
                    var addbtn=$('<a class="arrow-btn arrow-span right-arrow" href="javascript:void(0)"></a>').appendTo(addbtndiv);
                    if(value["add"].disabled){
                        addbtn.addClass("tiny-img-disabled buttons-disabled");
                    }else{
                        addbtn.addClass("buttons-default")
                    }
                    if("function" == ( typeof value["add"].click) ){
                        addbtn.on("click", function(event) {
                            if(addbtn.hasClass("tiny-img-disabled")){
                                return;
                            }
                            value["add"].click(event);
                        });
                    }
                    if(value["add"].id){
                        addbtn.attr("id",value["add"].id);
                    }
                }
                if(value["remove"]){
                    var removebtndiv=$('<div></div>').appendTo(html.find(".tiny-dualSelectBox-right-buttons"));
                    if(value["remove"].cls){
                        removebtndiv.addClass(value["remove"].cls);
                    }else{
                        removebtndiv.addClass("remove");
                    }
                    var removebtn=$('<a class="arrow-btn arrow-span left-arrow" href="javascript:void(0)"></a>').appendTo(removebtndiv);
                    if(value["remove"].disabled){
                        removebtn.addClass("tiny-img-disabled buttons-disabled")
                    }else{
                        removebtn.addClass("buttons-default");
                    }

                    if("function" == ( typeof value["remove"].click) ){
                        removebtn.on("click",function(event){
                            if(removebtn.hasClass("tiny-img-disabled")){
                                return;
                            }
                            value["remove"].click(event);
                        }  );
                    }

                    if(value["remove"].id){
                        removebtn.attr("id",value["remove"].id);
                    }
                }
                if(value["addall"]){
                    var addallbtndiv=$('<div></div>').appendTo(html.find(".tiny-dualSelectBox-right-buttons"));
                    if(value["addall"].cls){
                        addallbtndiv.addClass(value["addall"].cls);
                    }else{
                        addallbtndiv.addClass("addall");
                    }
                    var addallbtn=$('<span></span>').appendTo(addallbtndiv);
                    if(value["addall"].disabled){
                        addallbtn.addClass("tiny-img-disabled buttons-disabled")
                    }else{
                        addallbtn.addClass("buttons-default");
                        if(value["addall"].cls){
                            addallbtn.addClass(value["addall"].cls);
                        }
                    }
                    if("function" == ( typeof value["addall"].click) ){
                        addallbtn.on("click",function(event){
                            if(addallbtn.hasClass("tiny-img-disabled")){
                                return;
                            }
                            value["addall"].click(event);
                        }  );
                    }

                    if(value["addall"].id){
                        addbtn.attr("id",value["addall"].id);
                    }
                }
                if(value["removeall"]){
                    var removeallbtndiv=$('<div></div>').appendTo(html.find(".tiny-dualSelectBox-right-buttons"));
                    if(value["removeall"].cls){
                        removeallbtndiv.addClass(value["removeall"].cls);
                    }else{
                        removeallbtndiv.addClass("removeall");
                    }
                    var removeallbtn=$('<span></span>').appendTo(removeallbtndiv);
                    if(value["removeall"].cls){
                        removeallbtn.addClass(value["removeall"].cls);
                    }
                    if(value["removeall"].disabled){
                        removeallbtn.addClass("tiny-img-disabled buttons-disabled")
                    }else{
                        removeallbtn.addClass("buttons-default");
                    }

                    if("function" == ( typeof value["removeall"].click) ){
                        removeallbtn.bind("click",function(event){
                            if(removeallbtn.hasClass("tiny-img-disabled")){
                                return;
                            }
                            value["removeall"].click(event);
                        }  );
                    }

                    if(value["removeall"].id){
                        addbtn.attr("id",value["removeall"].id);
                    }

                }
                //加载内容
                var contentDom=html.find(".tiny-dualSelectBox-content-div");
                //自定义样式
                if(value["content-cls"]){
                    contentDom.addClass(value["content-cls"]);
                }
                if(value["content-type"] === 'url'){
                    contentDom.load(value["content"],function() {
                        //加载后处理
                        if (options.isDirective) {
                            dualSelectBoxThis.trigger("loadEvt", [this]);
                        } else {
                            if (options.load) {
                                options.load(this);
                            }
                        }
                    });
                }else{
                    contentDom.html(value["content"]);
                    //加载后处理
                    if (options.isDirective) {
                        dualSelectBoxThis.trigger("loadEvt", [contentDom]);
                    } else {
                        if (options.load) {
                            options.load(contentDom);
                        }
                    }
                }
            }
        },
        "_setOption" : function(key, value) {
            var dualSelectBoxThis = this;
            dualSelectBoxThis._super(key, value);
            var options = dualSelectBoxThis.options;
            switch (key) {
                case 'id':
                    dualSelectBoxThis._updateId(value);
                    break;
                case 'left-values':
                    dualSelectBoxThis._updateValues(value,"left");
                    break;
                case 'right-values':
                    dualSelectBoxThis._updateValues(value,"right");
                    break;
                case "setting":
                    dualSelectBoxThis._updateSetting(value,"right");
                    break;
                default:break;
            }
        },
        "_updateValues":function(values,type){
            var dualSelectBoxThis=this;
            for (var i = 0; i < values.length; i++) {
                var elementLength = values[i].length || 1;
                for (var j = 0; j < elementLength; j++) {
                    var value = values[i][j] || values[i];
                    dualSelectBoxThis._valuesDispose(value,type);
                };
            };
        },
        "_updateSetting":function(values,type){
            var dualSelectBoxThis=this;
            //宽度
            var leftWidth=values["left-width"];
            var rightWidth=values["right-width"];
            var width=parseInt(leftWidth.replace("px",""))+parseInt(rightWidth.replace("px",""));
            //left布局高宽设置
            var leftcontent=dualSelectBoxThis._element.find('.tiny-dualSelectBox-left');
            leftcontent.attr("style","width:"+values["left-width"]+";height:"+values["height"]);
            //right布局宽设置，高度
            var rightcontent=dualSelectBoxThis._element.find('.tiny-dualSelectBox-right');
            rightcontent.attr("style","width:"+values["right-width"]+";");
            var box=dualSelectBoxThis._element;
            box.addClass(values["cls"]);
            box.attr("style","width:"+width+"px");
        },
        "opDisabled":function(disabledNew,id){
            var dualSelectBoxThis=this;
            var btn=dualSelectBoxThis._element.find("[id="+id+"]");
            if(!id){
                btn=dualSelectBoxThis._element.find(".tiny-dualSelectBox-right-buttons > span");
            }
            if("true"==String(disabledNew)){
                btn.addClass("tiny-img-disabled buttons-disabled").removeClass("buttons-default");
            }else{
                btn.removeClass("tiny-img-disabled buttons-disabled").addClass("buttons-default");
            }
            ;
        }
});
return dualSelectBox;
});
