define(["tiny-lib/angular", "tiny-lib/jquery", "tiny-widgets/Widget", "tiny-lib/underscore"],
    function(angular, $, Widget, _){    
    var DEFAULT_CONFIG  = {        
    	tip : "", //提示信息
    	"class" : "tiny-icontip-help", //图标样式,默认为帮助
    	template : "<div class='tiny-icontip-help'></div>"
    };
    
    var IconTip = Widget.extend({
        "init":function(options){            
            var widgetThis = this; 
            widgetThis._super(_.extend({}, DEFAULT_CONFIG, options));
        },
        "_generateElement": function(){
            var widgetThis = this;
            widgetThis._super();
            
            var options = widgetThis.options;

            options.id = _.uniqueId("icontip_");
            widgetThis._element.attr("id",options.id);
            
            var class_ = options["class"];
            if( class_ && class_!="tiny-icontip-help" ){
            	widgetThis._element.attr("class",class_);
            }
        },
        "_addBehavior" : function() {
            var widgetThis = this;
            var element = widgetThis._element;
            var options = widgetThis.options;
            
            var id = options.id + "_tipDiv";
        	var tipDiv = $("#"+id);
        	
            element.on("mouseover", function(evt) {
				if( tipDiv.length > 0 ){
					tipDiv.css("display","block");
				} else {
					$("body").append($("<div id='" + id + "' class='tiny-icontip-content'></div>").append(options.tip));
					tipDiv = $("#"+id);
				}
				
				var offsetX = 0 , offsetY = 0;
				if( evt.offsetX ){
					offsetX = evt.offsetX;
					offsetY = evt.offsetY;
				}else if( evt.originalEvent && evt.originalEvent.layerX ){
					offsetX = evt.originalEvent.layerX;
					offsetY = evt.originalEvent.layerY;
				}
				
                var x = evt.pageX - offsetX + 10 + 16 + 5, y = evt.pageY - offsetY;
				
				if( x + tipDiv.width() > $("body").width() ){
					x =  x - tipDiv.width() - 10;
				}
				
				if( y + tipDiv.height() > $("body").height() ){
					y = y - tipDiv.height() + 16;
				}
				
				tipDiv.css("left", x).css("top", y);
				
            })
            .on("mouseout",function(evt){
            	tipDiv.css("display","none");
            });
        },
        "destroy" : function() {
        	var widgetThis = this;
        	
        	widgetThis._element.unbind();
        	$("#"+widgetThis.options.id + "_tipDiv").remove();
        }
    });
    return IconTip;
});
