define(["tiny-lib/angular", "tiny-lib/jquery", "tiny-lib/Class", "tiny-widgets/Widget", "tiny-lib/underscore"],
    function (angular, $, Class, Widget, _) {
        var DEFAULT_CONFIG = {
            "elementId":"",
            "id":"",
            "template": '<div class="pop_mian" >' +
                '</div>'
        };
        var Pop = Widget.extend({
            "init": function (options) {
                var widgetThis = this;
                widgetThis._super(_.extend({}, DEFAULT_CONFIG, options));
                widgetThis._setOptions(widgetThis.options);
            },

            "_setOption": function (key, value) {
                var widgetThis = this;

                widgetThis._super(key, value);

                switch (key) {
                    case 'elementId':
                        widgetThis._setElementId(value);
                        break;
                    case  'id':
                        widgetThis._updateId(value);
                }
            },

            "_setElementId": function(value) {
                var widgetThis = this;
                widgetThis.elementId = value;
            },

            "setPopShow": function(isshow,elementId){
                var widgetThis = this;
                if(elementId){
                    widgetThis.elementId = elementId;
                }
                var nTarget = $("#"+widgetThis.elementId);
                var nElement = widgetThis._element;
                var position = nTarget.offset();
                var targetwidth = nTarget.width();
                var targetheight = nTarget.height();
                var elementwidth = nElement.width();

                if(isshow){
                    nElement.show();
                    if(nTarget){
                        position = _.extend(position,{
                            "left": position.left + targetwidth - elementwidth,
                            "top": position.top + targetheight+5
                        });
                        nElement.offset(position);
                    }
                }else{
                    nElement.hide();
                }
            },

            "setStyle": function(styleobj) {
                var widgetThis = this;
                widgetThis._element.css(styleobj)
            }
        });
        return Pop;
    });
