define(["tiny-lib/angular", "tiny-lib/jquery", "tiny-lib/Class", "tiny-widgets/Widget", "tiny-lib/underscore"],
    function (angular, $, Class, Widget, _) {
        var DEFAULT_CONFIG = {
            "id": "",
            "config": [],
            "width": '100px',
            "barwidth": '100px',
            "position":"outside",
            "percentages":true,
            "template": '<div class="rainbowbar_panel"><div class="rainbowbar_textpanel"></div><div class="rainbowbar_mian" ></div><div class="rainbowbar_text" ></div>' +
            	'</div>'
        };
        var Rianbowbar = Widget.extend({
            "init": function (options) {
                var widgetThis = this;
                widgetThis._super(_.extend({}, DEFAULT_CONFIG, options));
                widgetThis._setOptions(widgetThis.options);
            },

            "_setOption": function (key, value) {
                var widgetThis = this;

                widgetThis._super(key, value);

                switch (key) {
                    case  'id':
                        widgetThis._updateId(value);
                        break;
                    case 'config':
                        widgetThis._setConfig(value);
                        break;
                    case 'width':
                        widgetThis._setWidth(value);
                        break;
                    case 'barwidth':
                        widgetThis._setBarwidth(value);
                        break;
                }
            },

            "_creatDataDom": function (dataObj) {
                var color = dataObj.color;
                var nDom = $('<div class="rainrowbar_content"></div>');
                return nDom;
            },

            "_creatDataText": function (element) {
                element.color = !element.text ? "#999" : element.color ;
            	var nDom = $('<span class="rainrowbar_text" style="color:'+ element.color +'">' +element.text + '</span>');
                return nDom;
            },

            "_gettotal": function (config) {
                var total = 0;
                _.each(config, function (element, index) {
                    total += parseInt(element.data, 10);
                })
                return total;
            },

            "_setDomWidth": function (element, total, nDom ,insideFlag) {
                var color = element.color;
                var data = parseInt(element.data, 10);
                var percentages;
                if (total !== 0) {
                    percentages = data / total * 100;
                } else {
                    percentages = 0;
                }
                percentages = Math.round(percentages);
                element.per = percentages + '%';

                nDom.css({
                    "background-color": color,
                    "width": percentages + '%'
                });
                return nDom;
            },

            "_setConfig": function (config) {
                var widgetThis = this;
                var nParent = widgetThis._element;
                var $mian = nParent.find(".rainbowbar_mian");
                var $text = nParent.find(".rainbowbar_text");
                var $textpanel = nParent.find(".rainbowbar_textpanel");

                $mian.empty();
                $text.empty();
                $textpanel.empty();
                var total = widgetThis._gettotal(config);
                var size = config.length;
                var per = parseInt(100 / size, 10) + "%";
                var text = "";
                _.each(config, function (element, index) {

                    var nDom = widgetThis._creatDataDom(element);
                    var position = config[index].position;
                    if(position == "right"){
                    	nDom = widgetThis._setDomWidth(element, total, nDom,true);
                        $mian.append(nDom);
                        if(index == 0) {
                        	var tDom = widgetThis._creatDataText(element);
                        	$text.append(tDom);
                        }else {
                        		$text.append($('<span class="rainrowbar_text" style="color: #666;padding: 0px 4px 0px 4px;">/</span>'));
                        	var tDom = widgetThis._creatDataText(element);
                        	$text.append(tDom);
                        }
                    	widgetThis._setText(element, $textpanel, per ,true);
                    	return;
                    }
                    nDom = widgetThis._setDomWidth(element, total, nDom);
                    $mian.append(nDom);
                    widgetThis._setText(element, $textpanel, per);
                })
            },

            "_setWidth": function (width) {
                var widgetThis = this;
                widgetThis._element.width(width);
            },

            "_setBarwidth": function (barwidth) {
                var widgetThis = this;
                widgetThis._element.find(".rainbowbar_mian").width(barwidth);
            },

            "_setText": function (obj, $dom, per, insideFlag) {
                var text = obj.text;
                var textper = obj.per;
                var color = obj.color;
                var widgetThis = this;

                var $nDom = $("<div class='rainbowbar_textcontent'></div>");
                var $perdiv = $("<div class='rainbowbar_textpanel_per'></div>");
                var $textdiv = $("<div class='rainbowbar_textpanel_text'></div>");

                $perdiv.text(textper);
                $perdiv.css("color", color);
                $nDom.css("width", per);
            }
        });
        return Rianbowbar;
    });
