/**
 * 搜索框。扩展自select，搜索框由三部分构成：类型（select控件）区域、输入区域（用于输入查询的内容）和查询按钮。
 * 根据类型的不同，输入框可以有两种形态：下拉选择框和文本输入框。
 *
 */
define(["tiny-lib/angular", "tiny-lib/jquery","tiny-widgets/Select", "tiny-widgets/Searchbox", "tiny-lib/encoder"],
    function(angular, $,Select,Searchbox, encoder) {
        var textBox="";
        var button="";
        var domTemplate = '<div class="tiny-select">'
            + '  <div class="tiny-select-input-field">'
            + '    <input type="text" readonly="readonly" class="tiny-select-text">'
            + '  </div>'
            + '</div>'
            +"<div class='tiny-searchbox-textbox'>" +
            "</div>";

        var DEFAULT_CONFIG = {
            "template" : domTemplate,
            "width" : 100,
            "textWidth":160
        };
        var SearchboxExt = Select.extend({
            "init" : function(options) {
                var selectThis = this;
                var options = _.extend({}, DEFAULT_CONFIG, options);
                selectThis._super(options);
                selectThis.extPanel();
            },
            "_locateElement" : function() {
                var selectThis = this;

                selectThis.$element = selectThis._element;
                selectThis.$inputField = selectThis._element.find(".tiny-select-input-field").first();//避免在输入区为下拉框的时候事件造成的样式冲突。
                selectThis.$inputText = selectThis._element.find(".tiny-select-text");
            },
            "extPanel":function(){
                var widgetThis=this;
                var options=widgetThis.options;
                widgetThis.$combobx=$(widgetThis._element[0]);
                if(!widgetThis.$textBox){
                    widgetThis.$textBox=$(widgetThis._element[1]);
                }
                //初始化显示文本框
                widgetThis.changeTextBox(true);
                widgetThis.$flag=true;
                //调整样式
                widgetThis.$containner=widgetThis.$combobx.find(".tiny-select-input-field");
                widgetThis.$containner.addClass("tiny-searchbox-combobox-container");
            },
            "changeTextBox":function(flag,op){
                var widgetThis=this;
                var options=op||{};
                var textWidth=widgetThis.options.textWidth
                if(!textWidth){
                    textWidth=160;
                }
                options.width=textWidth;
                widgetThis.$textBox.empty();
                //flag如果是true则显示文本框，否则显示下拉框
                if(flag){
                    widgetThis.$flag=true;
                    //如果没有配置参数，从控件options中获取默认值
                    if(!op){
                        var tempOp= _.pick(widgetThis.options,"disable","suggest","click");
                        options= _.extend(tempOp,options);
                    }
                    options.search=options.click;
                    var searchBox=new Searchbox(options);
                    //修正宽度以显示分割线
                    var inputWidth=searchBox.$inputArea.width()-4;
                    searchBox.$inputArea.width(inputWidth);
                    //【事件】：当输入框有搜索内容时，显示删除图标
                    searchBox.$inputArea.on('keyup', function(evt) {
                        var newContent = searchBox.$inputArea.val();
                        var clear=searchBox.$searchBox.find(".clear");
                        //若输入框中内容为空，则清除删除按钮
                        if ('' == $.trim(newContent)) {
                            searchBox.$searchBox.find(".clear").remove();
                            return;
                        }

                        //添加删除按钮
                        if(!clear||clear.length==0){
                            var div=$("<div/>").insertAfter(searchBox.$inputArea);
                            div.addClass("clear");
                            var span=$("<span/>").appendTo(div);
                            span.addClass("clear_span");
                            span.mousedown(function(){
                                searchBox.setValue("");
                                searchBox.$searchBox.find(".clear").remove();
                                searchBox.$inputArea.focus();
                                return false;
                            });
                        }
                    });
                    widgetThis.$searchBox=searchBox;
                    searchBox.rendTo(widgetThis.$textBox);

                }else{
                    widgetThis.$flag=false;
                    if(!options.change){
                        options.change=widgetThis.options.click;
                    }
                    var select= new Select(options);
                    widgetThis.$inputSelect=select;
                    var containner=$(select._element[0]).find(".tiny-select-input-field");

                    containner.addClass("tiny-searchbox-combobox-container-left");
                    select.rendTo(widgetThis.$textBox);
                }

            },
            "getSearchboxValue":function(){
                var widgetThis=this;
                var value={};
                value.type=widgetThis.getSelectedId();
                if(widgetThis.$flag){
                    value.inputValue=widgetThis.$searchBox.getValue();
                }else{
                    value.inputValue=widgetThis.$inputSelect.getSelectedId();
                }
                return value;
            },
            "setSearchboxValue":function(value){
                var widgetThis=this;
                if(widgetThis.$flag){
                    widgetThis.$searchBox.setValue(value);
                }else{
                    widgetThis.$inputSelect.opChecked(value);
                }
            }
        });

        return SearchboxExt;
    });
