﻿/**
 * Tiny SelectPanel widget. 版本日期  2014-7-31 15:21:23
 *
 * 扩展下拉面板组件用于显示days of month
 **/

define(["tiny-lib/angular", "tiny-lib/jquery", "tiny-widgets/Select", "tiny-common/util", "tiny-common/UnifyValid", "tiny-lib/encoder"],
function(angular, $, Widget, util, UnifyValid,encod) {
    var language = tinyLanguage.language;
    var Select = Widget.extend({
        // 生成一个下拉选项的dom
        "_optionHtmlFactory" : function(selectId, image, label, checked,isDisabled) {
            var selectThis = this, options = this.options;
            var width="";
            if(selectId=="lastday"){
                width='style="width: 77px"';
            }
            var html = '<li class="tiny-select-option ';
            if(isDisabled){
                html+="tiny-select-option-disabled"
            }
            html+=' "'+width+'>';


            html += '<span class="tiny-select-checkbox';
            if (checked) {
                html += ' tiny-select-checkbox-checked';
            }
            if(isDisabled){
                html+=" tiny-select-checkbox-disabled"
            }
            html += '"  '+width+'>' + label + '</span>';

            // 图标是可选项目
            image = false;
            if (image) {
                image = $.trim(image);
                image = $.encoder.encodeForURL(image);
                html += '<img src="' + image + '" />';
            }

            label = $.encoder.encodeForHTML(label);
            html += '</li>';
            return html;
        },
        "_updateValues" : function() {
            var selectThis = this;
            var options = selectThis.options;
            var optionHtml = "";
            var selectId,img,labelText,checked;
            var checkedArray = [];
            var idIndex = 1;
            var values=[];
            if(!options.values||options.values.length<=0){
                for(var i=1;i<=31;i++){
                    values.push({label : i,selectId : i});
                }
                values.push({label : language.lastDay,selectId : "lastday"});

                options.values = values;
            }
            // 更新下拉菜单内容
            selectThis.$popup.empty();
                var values = options["values"];
                _.each(values, function(val) {
                if (val["selectId"] || val["selectId"] == "") {
                    selectId = val["selectId"];
                }
                else {
                    selectId = "tinydefaultid" + idIndex;
                    val["selectId"] = selectId;
                }
                img = val["image"] || "";
                labelText = val["label"] || "";
                checked = val["checked"] || selectThis._isDefaultSelected(selectId);
                    optionHtml += selectThis._optionHtmlFactory(selectId, false, labelText, checked);
                if (checked) {
                    checkedArray.push(selectId + "");
                }
                idIndex++;
            });
            // 针对Firefox32以下版本中滚轮事件引起的下拉选项延迟显示问题，需要将DOM结构改为无序列表
            var $ulWrapper = $('<ul class="tiny-select-panel">').append(optionHtml);
            selectThis.$popup.append($ulWrapper);
                // 缓存每一个option对应的selectId
                var $optionList = selectThis.$popup.find(".tiny-select-option");
                $optionList.each(function(index, optionItem) {
                    $(optionItem).data("selectId", values[index].selectId + "");
                });

            selectThis._recordToSelected(checkedArray);// 记录并规范化已选择内容
            selectThis._setInput();// 根据selectThis.selected更新文本框
        }
    });

    return Select;
});
