define(["tiny-lib/angular", "tiny-lib/jquery", "tiny-lib/Class", "tiny-lib/underscore", "tiny-widgets-Table"], function(angular, jquery, Class, _, Widget)
{
    var Table = Widget.extend({

        "init" : function(options) {
            var widgetThis = this;
            var menuNum = !_.isNumber(options.displayLength) ? 10 : parseInt(options.displayLength,10);
            options= _.extend({"tips":true,"columnsDraggable":true,"length-menu":[menuNum]},options);//默认增加提示
            widgetThis._super(options);
            //隐藏表格未出现前的一行字
            $('.dataTables_empty',this._element).css('display','none');
            //初始化时强制刷新一次表格
            function fresh () {
               var dom = widgetThis.getOSettings().nTableWrapper;
               var id = $(dom).parent('div').attr('id');
               if( id ){
                    if(_.isEmpty( $('#'+id).widget().option('data') )){
                        $('#'+id).widget().option('data',[]);
                    }
               }else{
                   setTimeout(fresh,20);
               }
            }
	        setTimeout(fresh,300);
            //拖拽时不显示oparea
            var optDiv = this._element.find('div.OpButton_main');
            if(optDiv.length){
                this._element.on('mousedown','thead',function(){
                    var _this = this;
                    var timer = setInterval(function(){
                        var op = $(_this).parents('div.tinyTablediv:first').find('div.OpButton_main');
                        op.css('display') !== 'none' && op.css('display','none');
                    },50);
                    $(document.body).one('mouseup',function(){
                        clearInterval(timer);
                    });
                });
            }
        },
        "_getSelectedNumsOld": function () {
            var widgetThis = this;
            var oSetting = widgetThis.getOSettings();
            var nTable = oSetting.nTable;
            return $(nTable).find("td .table_checkbox_select").length;
        },
        "_getSelectedNums": function () {//排除不可选项
            var widgetThis = this;
            var oSetting = widgetThis.getOSettings();
            var nTable = oSetting.nTable;
            return $(nTable).find("td .table_checkbox_select:not(.dataTables_checkboxs_disabled)").length;
        },
        "_getCurrentNums": function () {//排除不可选项
            var widgetThis = this;
            var oSetting = widgetThis.getOSettings();
            var nTable = oSetting.nTable;
            return $(nTable).find(".dataTables_checkboxs:not(.dataTables_checkboxs_disabled)").length;
        },
        "getTableCheckedItems": function () {//排除不可选项
            var widgetThis = this;
            var oSetting = widgetThis.getOSettings();
            var nTable = oSetting.nTable;
            var aaData = [];
            $(nTable).find("tr.clickTrColor:not(:has(.dataTables_checkboxs_disabled))").each(function () {
                var aData = oSetting.oInstance.fnGetData(this);
                aaData.push(aData);
            })
            return aaData;
        },
        "_doFLPanelHandle": {
            "click": function (widgetThis, nNode) {
                var ID = widgetThis.options.floatingPanelId;
                var iNums;
                var nTr;
                if (widgetThis.options.checkbox) {
                    iNums = widgetThis._getSelectedNumsOld();
                    if (iNums === 1) {
                        nTr = widgetThis._element.find(".clickTrColor");
                        widgetThis._doFLPanelshow(nTr);
                    } else {
                        $("#" + ID).hide();
                    }
                } else {
                    widgetThis._doFLPanelshow(nNode);
                }
            }
        },

        "_doFLPanelshow": function (nTr) {
            var widgetThis = this;
            var ID = widgetThis.options.floatingPanelId;

            if (ID === undefined) {
                return;
            }
            var nTarget = nTr;
            var oPosition = nTarget.offset();
            var ntriangle = $("#" + ID).find('.FLPanel_triangle');
            var obj = {
                top: oPosition.top
            };
            if (nTr.hasClass('clickTrColor')) {
                var _width = window.screen.width*0.24;
                $("#" + ID).css("position","absolute");
                $("#" + ID).css("width",_width);
                $("#" + ID).css("top","0");
                $("#" + ID).show();
                ntriangle.offset(obj);
            }
        },

        "_toggleCss": function() {
            var widgetThis = this;
            widgetThis._super();
            widgetThis._element.on("mouseover", "th:has(span.sorting_disabled)", function(event) {
                $(this).css("cursor", "default");
            });
        }
    });

    return Table;

});
