define(["tiny-widgets-Window", "tiny-widgets/Widget", "app/services/constsService"],
    function(Window, Widget, constsService) {
        constsService = new constsService();
        var WindowExt = Window.extend({
            "init": function(options) {
                Window.prototype.init.call(this, options);

                var helpUrl = constsService.WIN_HELP_MAP[options.helpId]
                !helpUrl && (helpUrl = constsService.WIN_HELP_MAP[options.winId]);

                if (helpUrl && !window.isPrivateConsole) {
                    this._element.find(".ui-dialog-titlebar-buttonpane").append('<a href="javascript:void(0)" role="button" style="position: relative; float: right; top: auto; right: auto; margin: 0px;"><span class="ui-icon-hcp-help"></span></a>').on("click", function() {
                        helpLink(helpUrl);
                    });
                }

            }
        });

        var helpWin = null;
        function helpLink(helpUrl) {
            openHelpLink(helpUrl);
        }

        function openHelpLink(helpUrl) {
            var injector = angular.element(document).injector();
            var restService = injector.get("restService");
            restService.getSoftwareInfo([], {
                mask: false,
                success: function(result) {
                    var url = window.isEn ? "/help/en/en-us_bookmap_0229729142.htm" : "/help/zh/zh-cn_bookmap_0229728260.htm";
                    if (window.isUltraVR) {
                        url = window.isEn ? "/help_fs/en/en-us_bookmap_0229730378.htm" : "/help_fs/zh/zh-cn_bookmap_0229730378.htm";
                    }

                    url = url + "#" + helpUrl;
                    if (helpWin && !helpWin.closed) {
                        var curUrl = helpWin.location.href;
                        if (curUrl.indexOf(url) > 0) {
                            return;
                        }

                        helpWin.location.replace(url);
                    } else {
                        helpWin = window.open(url, "online_help");
                    }

                }
            })
        }

        return WindowExt;
    });
