var __bind = function(fn, me) { return function() { return fn.apply(me, arguments); }; },
    __slice = [].slice;

(function($, window) {
    var TableColDrag, parseWidth, pointerX, setWidth;
    parseWidth = function(node) {
        return parseFloat(node.style.width.replace('%', ''));
    };
    setWidth = function(node, width) {
        width = width.toFixed(2);
        return node.style.width = "" + width + "%";
    };
    pointerX = function(e) {
        if (e.type.indexOf('touch') === 0) {
            return (e.originalEvent.touches[0] || e.originalEvent.changedTouches[0]).pageX;
        }
        return e.pageX;
    };
    TableColDrag = (function() {
        TableColDrag.prototype.defaults = {
            selector: 'tr th',
            store: window.store,
            syncHandlers: true,
            resizeFromBody: true,
            maxWidth: null,
            minWidth: null
        };

        function TableColDrag($table, options) {
            this.pointerdown = __bind(this.pointerdown, this);
            this.constrainWidth = __bind(this.constrainWidth, this);
            this.options = $.extend({}, this.defaults, options);
            this.$table = $table;
            this.setHeaders();
            this.restoreColumnWidths();
            this.syncHandleWidths();
            $(window).on('resize.rc', ((function(_this) {
                return function() {
                    return _this.syncHandleWidths();
                };
            })(this)));
            if (this.options.start) {
                this.$table.bind('column:resize:start.rc', this.options.start);
            }
            if (this.options.resize) {
                this.$table.bind('column:resize.rc', this.options.resize);
            }
            if (this.options.stop) {
                this.$table.bind('column:resize:stop.rc', this.options.stop);
            }
        }

        TableColDrag.prototype.triggerEvent = function(type, args, original) {
            var event;
            event = $.Event(type);
            event.originalEvent = $.extend({}, original);
            return this.$table.trigger(event, [this].concat(args || []));
        };

        TableColDrag.prototype.getColumnId = function($el) {
            return this.$table.data('resizable-columns-id') + '-' + $el.data('resizable-column-id');
        };

        TableColDrag.prototype.setHeaders = function() {
            this.$tableHeaders = this.$table.find(this.options.selector);
            this.assignPercentageWidths();
            return this.createHandles();
        };

        TableColDrag.prototype.destroy = function() {
            this.$handleContainer.remove();
            this.$table.removeData('resizableColumns');
            return this.$table.add(window).off('.rc');
        };

        TableColDrag.prototype.assignPercentageWidths = function() {
            return this.$tableHeaders.each((function(_this) {
                return function(_, el) {
                    var $el;
                    $el = $(el);
                    return setWidth($el[0], $el.outerWidth() / _this.$table.width() * 100);
                };
            })(this));
        };

        TableColDrag.prototype.createHandles = function() {
            var _ref;
            if ((_ref = this.$handleContainer) != null) {
                _ref.remove();
            }
            this.$table.before((this.$handleContainer = $("<div class='rc-handle-container' />")));
            this.$tableHeaders.each((function(_this) {
                return function(i, el) {
                    var $handle;
                    if (_this.$tableHeaders.eq(i + 1).length === 0 || (_this.$tableHeaders.eq(i).attr('data-noresize') != null) || (_this.$tableHeaders.eq(i + 1).attr('data-noresize') != null)) {
                        return;
                    }
                    $handle = $("<div class='rc-handle' />");
                    $handle.data('th', $(el));
                    return $handle.appendTo(_this.$handleContainer);
                };
            })(this));
            return this.$handleContainer.on('mousedown touchstart', '.rc-handle', this.pointerdown);
        };

        TableColDrag.prototype.syncHandleWidths = function() {
            return this.$handleContainer.width(this.$table.width()).find('.rc-handle').each((function(_this) {
                return function(_, el) {
                    var $el;
                    $el = $(el);
                    return $el.data('th') && $el.css({
                        left: $el.data('th').outerWidth() + ($el.data('th').offset().left - _this.$handleContainer.offset().left),
                        height: _this.options.resizeFromBody ? _this.$table.height() : _this.$table.find('thead').height()
                    });
                };
            })(this));
        };

        TableColDrag.prototype.saveColumnWidths = function() {
            return this.$tableHeaders.each((function(_this) {
                return function(_, el) {
                    var $el;
                    $el = $(el);
                    if ($el.attr('data-noresize') == null) {
                        if (_this.options.store != null) {
                            return _this.options.store.set(_this.getColumnId($el), parseWidth($el[0]));
                        }
                    }
                };
            })(this));
        };

        TableColDrag.prototype.restoreColumnWidths = function() {
            return this.$tableHeaders.each((function(_this) {
                return function(_, el) {
                    var $el, width;
                    $el = $(el);
                    if ((_this.options.store != null) && (width = _this.options.store.get(_this.getColumnId($el)))) {
                        return setWidth($el[0], width);
                    }
                };
            })(this));
        };

        TableColDrag.prototype.totalColumnWidths = function() {
            var total;
            total = 0;
            this.$tableHeaders.each((function(_this) {
                return function(_, el) {
                    return total += parseFloat($(el)[0].style.width.replace('%', ''));
                };
            })(this));
            return total;
        };

        TableColDrag.prototype.constrainWidth = function(width) {
            if (this.options.minWidth != null) {
                width = Math.max(this.options.minWidth, width);
            }
            if (this.options.maxWidth != null) {
                width = Math.min(this.options.maxWidth, width);
            }
            return width;
        };

        TableColDrag.prototype.pointerdown = function(e) {
            var $currentGrip, $leftColumn, $ownerDocument, $rightColumn, newWidths, startPosition, widths;
            e.preventDefault();
            $ownerDocument = $(e.currentTarget.ownerDocument);
            startPosition = pointerX(e);
            $currentGrip = $(e.currentTarget);
            $leftColumn = $currentGrip.data('th');
            $rightColumn = this.$tableHeaders.eq(this.$tableHeaders.index($leftColumn) + 1);
            widths = {
                left: parseWidth($leftColumn[0]),
                right: parseWidth($rightColumn[0])
            };
            newWidths = {
                left: widths.left,
                right: widths.right
            };
            this.$handleContainer.add(this.$table).addClass('rc-table-resizing');
            $leftColumn.add($rightColumn).add($currentGrip).addClass('rc-column-resizing');
            this.triggerEvent('column:resize:start', [$leftColumn, $rightColumn, newWidths.left, newWidths.right], e);
            $ownerDocument.on('mousemove.rc touchmove.rc', (function(_this) {
                return function(e) {
                    var difference;
                    difference = (pointerX(e) - startPosition) / _this.$table.width() * 100;
                    setWidth($leftColumn[0], newWidths.left = _this.constrainWidth(widths.left + difference));
                    setWidth($rightColumn[0], newWidths.right = _this.constrainWidth(widths.right - difference));
                    if (_this.options.syncHandlers != null) {
                        _this.syncHandleWidths();
                    }
                    return _this.triggerEvent('column:resize', [$leftColumn, $rightColumn, newWidths.left, newWidths.right], e);
                };
            })(this));
            return $ownerDocument.one('mouseup touchend', (function(_this) {
                return function() {
                    $ownerDocument.off('mousemove.rc touchmove.rc');
                    _this.$handleContainer.add(_this.$table).removeClass('rc-table-resizing');
                    $leftColumn.add($rightColumn).add($currentGrip).removeClass('rc-column-resizing');
                    _this.syncHandleWidths();
                    _this.saveColumnWidths();
                    return _this.triggerEvent('column:resize:stop', [$leftColumn, $rightColumn, newWidths.left, newWidths.right], e);
                };
            })(this));
        };

        return TableColDrag;

    })();

    return $.fn.extend({
        resizableColumns: function() {
            var args, option;
            option = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
            return this.each(function() {
                var $table, data;
                $table = $(this);
                data = $table.data('resizableColumns');
                if (!data) {
                    $table.data('resizableColumns', (data = new TableColDrag($table, option)));
                }
                if (typeof option === 'string') {
                    return data[option].apply(data, args);
                }
            });
        }
    });
})(window.jQuery, window);