define(["lazy-load/lazyLoad", "ui-router/angular-ui-router.min", "tiny-extra-directives/FloatingPanel"], function(lazyLoadModule, router) {
    "use strict";

    var routerConfig = [{
        name: "home",
        url: "/home",
        breadcrumbs: { name: "home_title" },
        templateUrl: "app/business/recoverydirector/home/views/main.html",
        controller: "home.ctrl",
        scripts: {
            'controllers': ['app/business/recoverydirector/home/controllers/homeCtrl']
        }
    }, {
        name: "home.staticView",
        url: "/staticView",
        templateUrl: function() {
            if (window.isUltraVR) {
                return "app/business/ultraVR/views/home/staticView.html";
            }
            return "app/business/recoverydirector/home/views/home/staticView.html";
        }(),
        controller: "home.staticView.ctrl",
        scripts: {
            'controllers': function() {
                if (window.isUltraVR) {
                    return ["app/business/ultraVR/controllers/home/staticViewCtrl"];
                }
                return ["app/business/recoverydirector/home/controllers/staticViewCtrl"];
            }()
        }
    }, {
        name: "home.topoVew",
        url: "/topoVew",
        templateUrl: "app/business/recoverydirector/monitor/views/topo/topoView.html",
        controller: "home.ctrl",
        scripts: {
            'controllers': ['app/business/recoverydirector/home/controllers/homeCtrl']
        },
        onExit: function(infoTransferredService) {
            localStorage.removeItem('viewSwitch_selectedId');
        },
    }];

    var module = angular.module("home.config", ["ui.router"]);
    module = lazyLoadModule.makeLazy(module);
    module.tinyStateConfig({stateConfig: routerConfig});
    return module;

});