define(["tiny-widgets/Window"], function(Window) {
	var ctrl = ["$rootScope","$scope","$state","$compile","cookieService","exception", "message", "communicationService", "utilService" ,"constsService","mask","appUtils","infoTransferredService","statusEnumService",
            function ($rootScope,$scope,$state,$compile,cookieService,exception,message,communicationService,utilService,constsService,mask,appUtils,infoTransferredService,statusEnumService) {

    	$scope.$on(constsService.TOPIC_HOME_SWITCH, function(ev,id) {

			 if(id == "1"){
				 $state.transitionTo("home.topoVew");
			 }
			 if(id == "0"){
				 $state.transitionTo("home.staticView");
			 }
		 });

    	var flashStatu = flashChecker();
    	if (flashStatu.f == 0){
            message.notice({content: appUtils.getString("system_info_term_flash_label", "<a href='javascript:downloadInterpose()'>"+ appUtils.getString("system_info_term_flash_link") +"</a>")});
    	}

    	function flashChecker() {
			let hasFlash = 0;
			let flashVersion = 0;

			if (document.all) {
				let swf = null;
				try {
					swf = new ActiveXObject('ShockwaveFlash.ShockwaveFlash');
				} catch (e) {
					swf = null;
				}
				if (swf) {
					hasFlash = 1;
					VSwf = swf.GetVariable("$version");
					middleString = VSwf.split(" ")[1].split(",", 2);
					flashVersion = middleString[0] + "." + middleString[1];
				}
			} else {
				if (navigator.plugins && navigator.plugins.length) {
					let swf = navigator.plugins["Shockwave Flash"];
					if (swf) {
						hasFlash = 1;
						swf.description.split(" ").forEach(item => {
							if (!isNaN(parseInt(item))) {
								flashVersion = item;
								return;
							}
						})
					}
				}
    		}
    		return {f:hasFlash,v:flashVersion};
    	}


    	window["downloadInterpose"] = function()
    	{
	    	 var WEB_ROOT_ABS_PATH = utilService.getRootPath();
	    	 var Msie = /(msie\s|trident.*rv:)([\w.]+)/;
	    	 var sUserAgent = navigator.userAgent;
    		 var isWin = (navigator.platform == "Win32") || (navigator.platform == "Windows");
    		 var isLinux = (String(navigator.platform).indexOf("Linux") > -1);
    		 var agent = sUserAgent.toLowerCase();
     		 var match = Msie.exec(agent);
             var lan = cookieService.get("language"), flashDownloadLink = 'https://get.adobe.com/flashplayer/?loc=en';
    		if(isWin) {
                (lan === "zh" || lan === "zh_CN") && (flashDownloadLink = 'https://get.adobe.com/flashplayer/?loc=cn');
    			if(null != match){
    				window.open(flashDownloadLink)
    			}else{
    				window.open(flashDownloadLink)
    			}
    		}
    	};
    	var routerStatusUrl = $state.$current;
		if(routerStatusUrl == "home.topoVew"){
			$rootScope.model.viewSwitch.selected = 1;
		}
		if(routerStatusUrl == "home.staticView"){
			$rootScope.model.viewSwitch.selected = 0;
		}

		$scope.getLocalLang = function(){
			return cookieService.get("language");
		};

		$scope.getIsmToken = function(){
			return cookieService.getToken();
		};


		$scope.getRemouteAddress = function(){
			return location.protocol+"//"+location.host;
		};

		$scope.loadPageWait = function(){
			mask.show();
		};

		$scope.loadPageClose = function(){
			mask.hide();
		};

		$scope.getUserAuthority = function(){
			return appUtils.checkRight("9328");
		};

		$scope.getConfigAuthority = function(){
			return appUtils.checkRight("ism.drm.monitor.gloable.topo.auth.set.operateID");
		};

		$scope.getTopoAuthority = function(){
			return appUtils.checkRight("ism.drm.monitor.gloable.topo.auth.scan");
		};

		$scope.setTitle = function(){
            document.title="OceanStor BCManager eReplication";
		};

		$scope.getStorageLinkDetail = function(devSN, trgSN){
				var data = {};
				data.srcDeviceSn = devSN;
				data.tgtDeviceSn = trgSN;
				var options = {
	            "winId": "storageLinkDetail",
	            "data": data,
	            "title": appUtils.getString("topo_term_storagelinkdetail_title"),
	            "width" : constsService.WIN_SIZE.S5[0],
	            "height" : constsService.WIN_SIZE.S2[1],
	            "content-type": "url",
	            "content":constsService.REPLICATION_LINK_URL,
	            "minimizable": false,
	            "maximizable": false,
	            "buttons": [
	              {
	              	key : "cancel",
	              	label : appUtils.getString('common_term_close_button'),
	              	focused : true,
	              	handler : function(event) {
	            	   $("#storageLinkDetail").widget().destroy();
	                  }
	               }
	            ],
	            "close":function(){

	            }
	        };
	        var win = new Window(options);
	        win.show();
	    };

	    $scope.getQuorumLinkDetail = function(devSN, trgSN) {
            var data = {};
            data.srcDeviceSn = devSN;
            data.tgtDeviceSn = trgSN;
            var options = {
                "winId": "quorumLinkDetail",
                "data": data,
                "title": appUtils.getString("topo_term_storagelinkdetail_title"),
                "width": constsService.WIN_SIZE.S5[0],
                "height": constsService.WIN_SIZE.S2[1],
                "content-type": "url",
                "content": constsService.QUORUM_LINK_URL,
                "minimizable": false,
                "maximizable": false,
                "buttons": [{
                    key: "cancel",
                    label: appUtils.getString('common_term_close_button'),
                    focused: true,
                    handler: function(event) {
                        $("#quorumLinkDetail").widget().destroy();
                    }
                }],
                "close": function() {

                }
            };
            var win = new Window(options);
            win.show();
        };

	    $scope.getHostLinkDetail = function(devSN, trgSN) {
            var data = {};
            data.srcDeviceSn = devSN;
            data.tgtDeviceSn = trgSN;
            var options = {
                "winId": "hostLinkDetail",
                "data": data,
                "title": appUtils.getString("topo_term_initiatordetail_title"),
                "width": constsService.WIN_SIZE.S5[0],
                "height": constsService.WIN_SIZE.S2[1],
                "content-type": "url",
                "content": constsService.INITIATOR_LINK_URL,
                "minimizable": false,
                "maximizable": false,
                "buttons": [{
                    key: "cancel",
                    label: appUtils.getString('common_term_close_button'),
                    focused: true,
                    handler: function(event) {
                        $("#hostLinkDetail").widget().destroy();
                    }
                }],
                "close": function() {

                }
            };
            var win = new Window(options);
            win.show();
        };

		$scope.viewStorageInfo = function(storageSN, siteID){
			var url  = utilService.getResouceUrl("/storages/"+storageSN+"/action/getStorageUnitInfo");
			  communicationService.get(url).promise().always(function(result){
				  if(exception.check(result)){
					var ip = result.linkIp;
                    if (appUtils.validIPv6Address(ip)) {
                        //如果是IPv6需要加方括号
                        ip = "[" + ip + "]";
                    }
					if(result.linkPort){
						var port = result.linkPort;
					    window.open(utilService.appendToken("https://"+ $.encoder.encodeForURL(ip)+":"+ $.encoder.encodeForURL(port)));
					    return;
					}
					  window.open(utilService.appendToken("https://"+ $.encoder.encodeForURL(ip)));
				  }
			  });
		};

		$scope.setDrResourceSite = function(selectId, devSN, siteID, devName, siteName, srcSiteName, callback) {
        	var confirmConfig = {
    			label : appUtils.getString("common_term_confirm_button"),
                handler : function() {
                	var url = utilService.getResouceUrl("/resources/action/modifyResourceSite?resourceId=" + devSN);
            		var map = {
                    		"siteId" : siteID
                    	};
            		mask.show();
            		communicationService.put(url, map).promise().always(function(result) {
                        mask.hide();
                        if (exception.check(result)) {
                            message.prompt({
                                content: appUtils.getString("common_term_operation_success_label"),
                                ok: function() {
                                	if (typeof callback === "function")
                                	{
                                        (callback)();
                                    }
                                	msg.destroy();
                                }
                            });
                        }
                    });
            	}
        	};

        	var cancelConfig = {
        			label : appUtils.getString("common_term_cancel_button"),
        			handler : function() {
        				msg.destroy();
            	    }
            	};

            var buttons = [confirmConfig, cancelConfig];

            var msg = new tinyWidget.Message({
                "type": "confirm",
                "content": appUtils.getString("topo_term_sethostsite_msg", $.encoder.encodeForHTML(srcSiteName),
                		$.encoder.encodeForHTML(devName),
                		$.encoder.encodeForHTML(siteName),
                		$.encoder.encodeForHTML(devName)),
                "height": "220px",
                "width": "350px",
                "buttons": buttons
            });
            msg.show();
            $("#"+msg.dialogId).find(".ti-info-circle").removeClass('tiny-img-confirm').addClass('message_win_picture');
            $("#"+msg.dialogId).css("min-height","40px").css("height","auto");
            $("#"+msg.dialogId).parent().find(".ui-dialog-title").html(appUtils.getString("common_message_win_question_title"));
            $("#"+msg.dialogId).find(".tinyMessageBox_msgBoxContent").css("font-size","14px").css("color","#333");
        };

		var ngdom = $("<div></div>");

        $scope.model.topoAppPop =
        {
           "id" : "topoAppPop",
           "elementId" : "topoSearchPopIdPopEleId",
           "template" : ngdom,
           "popStyle": {
                "width":'750px',
                "height":'480px'
            }
        };

		$scope.viewAppInfo = function(hostSN, hostName, locationX, locationY){
			ngdom.load(constsService.TOPO_HOST_APP_URL, function()
	        {
				var tabs = new tinyWidget.Tabs({
		              "id": "hostTopoAppTabs"
				});

	            $compile($("#topoHostAppContainer"))($scope);
	            $scope.$apply();
	            _init();

	            $("#topoAppPop").css({"left":($(window).width() - $("#topoAppPop").width())/2+"px","top": ($(window).height() - $("#topoAppPop").height())/2+"px"});
	            $("#topoAppPop").show();
			     //写入事件
                 bindEvent();
	        });

			  $scope.hostPlugins = [];



			  var _assemblePlungins = function(arrays){
				  if(arrays.length == 0){
					  $scope.hostPlugins = [];
					  $("#data1").hide();
					  $("#hostAppTabs").html("<span class='configform-tips'>" +appUtils.getString("site_term_hostapp_message") +"</span>");
					  return;
				  }
				  for(var i = 0; i < arrays.length ; i++){

					  if(arrays[i]["appType"]  == "1"){
						  $scope.hostPlugins.push({
					            "id":"Oracle",
					            "openState": "1",
					            "name":"Oracle"
					        })
					  }
					  if(arrays[i]["appType"]  == "2"){
						  $scope.hostPlugins.push({
					            "id":"SQLServer",
					            "openState": "2",
					            "name":"SQL Server"
					        })
					  }
					  if(arrays[i]["appType"]  == "3"){
						  $scope.hostPlugins.push({
					            "id":"DB2",
					            "openState": "3",
					            "name":"DB2"
					        })
					  }
					  if(arrays[i]["appType"]  == "8"){
						  $scope.hostPlugins.push({
							    "id":"Exchange",
					            "openState": "8",
					            "name":"Exchange"
						  })
					  }
					  if(arrays[i]["appType"]  == "9"){
						  $scope.hostPlugins.push({
					            "id":"NTFS",
					            "openState": "9",
					            "name": appUtils.getString("protection.term.localFS.label")
					        })
					  }
                      if (arrays[i]["appType"] == "15") {
                            $scope.hostPlugins.push({
                                "id": appUtils.getString("host_app_type_15_da_meng"),
                                "openState": "15",
                                "name": appUtils.getString("host_app_type_15_da_meng")
                            })
                      }
                      //HANA
                      if(arrays[i]["appType"] == "16"){
                          $scope.hostPlugins.push({
                              "id": "HANA",
                              "openState": "16",
                              "name": "HANA"
                          })
                      }
				  }
				  $scope.$apply();
			  }


            var dbClumn = [{
					"sTitle" : appUtils.getString("site_term_dbname_label"),
					"mData" : "name"
				},{
					"sTitle" : appUtils.getString("ism.drm.drp.local.pg.name.label"),
					"mData" : "protectGroupName"
				},
				{
					"sTitle" : appUtils.getString("site_term_instance_label"),
					"mData" : "instanceName"
				},
				{
					"sTitle" : appUtils.getString("common_term_version_label"),
					"mData" : "dbVersion"
				},{
					"sTitle" : "dbType",
					"mData" : "dbType",
					"bVisible":false
				},{
					"sTitle" : appUtils.getString("common_term_link_topo_label"),
					"mData" : "link",
					"sWidth" : "120px"
				}];

			  var  ntfsColum = [{
					"sTitle" : appUtils.getString("site_term_name_label"),
					"mData" : "name"
				},{
					"sTitle" : appUtils.getString("ism.drm.drp.local.pg.name.label"),
					"mData" : "protectGroupName"
				},
				{
					"sTitle" : appUtils.getString("common_term_type_label"),
					"mData" : "fsType",
					"bSortable":false
				},
				{
					"sTitle" : appUtils.getString("site_term_loap_label"),
					"mData" : "mount"
				},
				{
					"sTitle" : appUtils.getString("site_term_capacity_label"),
					"mData" : "capacity",
					"bSortable":false
				},{
					"sTitle" : appUtils.getString("common_term_link_topo_label"),
					"mData" : "link",
					"sWidth" : "120px"
				}];


			  var exChangeColum = [{
					"sTitle" : appUtils.getString("site_term_dbname_label"),
					"mData" : "name"
				},
				{
					"sTitle" : appUtils.getString("ism.drm.drp.local.pg.name.label"),
					"mData" : "protectGroupName"
				},
				{
					"sTitle" : appUtils.getString("site_term_storagegroup_label"),
					"mData" : "instanceName"
				},
				{
					"sTitle" : appUtils.getString("common_term_version_label"),
					"mData" : "dbVersion"
				},{
					"sTitle" : "dbType",
					"mData" : "dbType",
					"bVisible":false
				},{
					"sTitle" : appUtils.getString("common_term_link_topo_label"),
					"mData" : "link",
					"sWidth" : "120px"
				}]
            //oracle 12c 这里oracle单独处理
            var orcaleClumn = [{
                "sTitle": "",
                "mData": "detail",
                "bSearchable": false, // childResources
                "bSortable": false,
                "sWidth": "30px"
            }, {
                "sTitle": appUtils.getString("site_term_dbname_label"),
                "mData": "name"
            }, {
                "sTitle": appUtils.getString("ism.drm.drp.local.pg.name.label"),
                "mData": "protectGroupName"
            }, {
                "sTitle": appUtils.getString("site_term_instance_label"),
                "mData": "instanceName"
            }, {
                "sTitle": appUtils.getString("common_term_pdb_type_label"),
                "mData": "IS_CDB"
            }, {
                "sTitle": appUtils.getString("common_term_version_label"),
                "mData": "dbVersion"
            }, {
                "sTitle": "dbType",
                "mData": "dbType",
                "bVisible": false
            }, {
                "sTitle": appUtils.getString("common_term_link_topo_label"),
                "mData": "link",
                "sWidth": "120px"
            }];
            //HANA
            var hanaColum = [{
                "sTitle": appUtils.getString("site_term_system_id_label"),
                "mData": "name",
                "bSortable": false
            },{
                "sTitle": appUtils.getString("ism.drm.drp.local.pg.name.label"),
                "mData": "protectGroupName"
            },{
                "sTitle": appUtils.getString("site_term_instance_number_label"),
                "mData": "instanceName",
                "bSortable": false
            },{
                "sTitle": appUtils.getString("common_term_version_label"),
                "mData": "dbVersion",
                "bSortable": false
            },{
                "sTitle": "dbType",
                "mData": "dbType",
                "bVisible": false
            },{
                "sTitle": appUtils.getString("common_term_link_topo_label"),
                "mData": "link",
                "sWidth": "120px"
            }];
            //oracle展示详情绑定事件
            function bindEvent(){
                $("#datasHostAppTable").on("click", ".show-detail", function(){
                    var thisTr = $(this).parent().parent();
                    var trObj = $("#datasHostAppTable").widget().getTableData(thisTr[0]);
                    var PDBData = _.filter(trObj.PDB,function(val){
                        return val.type == "PDB"
                    });
                    thisTr.toggleClass("tr-open");
                    if(thisTr.hasClass("tr-open")){
                        var pdbHtml = "<td colspan='7' style='border-bottom:1px solid #dddddd;'><div class='showPdbListDiv' style='width:85%;margin:auto;max-height:158px;margin-top:16px;margin-bottom:16px;overflow-y:auto'><tiny-table id='model.id' columns-draggable='false' data='data' columns='columns' enable-pagination='false'></tiny-table></div></td>"
                        var pdbLink = $compile($(pdbHtml));
                        var pdbScope = $scope.$new();
                        pdbScope.id = "pdbListTable";
                        pdbScope.data = appUtils.encodeForHTML(PDBData);
                        pdbScope.columns = [{
                            "sTitle" : appUtils.getString("common_term_pdb_id_label"),
                            "mData":"conID"
                        },{
                            "sTitle" : appUtils.getString("common_term_name_label"),
                            "mData":"pdbName",
                            "sWidth":"65%"
                        }];
                        var optNode = pdbLink(pdbScope);
                        var Tr = $("<tr></tr>").html(optNode);
                        thisTr.after(Tr);
                    }else{
                        var nextTr = thisTr.nextAll("tr")[0];
                        $(nextTr).remove();
                    }
                });
            }
            //处理点击排序时出现的bug(如果展开详情点击排序会有问题)
            function theadClick(){
                $('th:has(span.sorting,span.sorting_asc,span.sorting_desc)').on("click", function(){
                    //点击详情里的排序问题规避
                    if($(this).parents(".showPdbListDiv").length > 0){
                        return;
                    }
                    ($("tr").hasClass("tr-open") && $("tr").next().has(".showPdbListDiv").length == 0) && $("tr").removeClass('tr-open');
                })
            }

			 $scope.changeTab = function(obj){
            	  if(obj == "9" ){
            		  _doFs();
            	  }else{
            		  _doDataBase(obj,theadClick);
            	  }
				  return false;
			  };

			  $scope.datasHostAppTable = {
						id : "datasHostAppTable",
						columns : dbClumn,
						enablePagination : false,
						displayLength:constsService.TABLE_COUNT_PER_PAGE,
			            callback :function(evtObj) {

			            },
                        drawCallBack: function(){
                           ($("tr").hasClass("tr-open") && $("tr").next().has(".showPdbListDiv").length == 0) && $("tr").removeClass('tr-open');
                        },
						renderRow : function(nRow, aData, iDataIndex) {

			            	var dbType =  aData["dbType"];
			            	if(dbType == "8"){
			            		var version = aData["dbVersion"];
			            		if(version == "1"){
			            			$('td:eq(3)', nRow).text("Exchange 2007");
			            		}else if(version == "2"){
			            			$('td:eq(3)', nRow).text("Exchange 2010");
			            		}else if (version == "3"){
			            			$('td:eq(3)', nRow).text("Exchange 2013");
			            		}else if (version == "4"){
			            			$('td:eq(3)', nRow).text("Exchange 2016");
			            		}else{
			            			$('td:eq(3)', nRow).text("Exchange 2019");
			            		}

			            	}

                            //如果是容器数据库展示相关信息
                            if(dbType == "1"){
                                if(aData.IS_CDB == "1" && _.filter(aData.PDB,function(val){return val.type == "PDB"}).length != 0){
                                    $("td:eq(0)", nRow).html("<div class='show-detail' style='width:16px;height:16px;'></div>");
                                }
                                $("td:eq(4)", nRow).html(statusEnumService.getValueByKey("DATABASE_TYPE",aData['IS_CDB']));
                            }

			            	if("--" == aData.protectGroupName)
			            	{
			            		var linkIndex = 4;
			            		if(9 === +dbType)
								{
			            			linkIndex = 5;
								}
                                if (1 === +dbType) {
                                    linkIndex = 6;
                                }
			            		$("td:eq("+linkIndex+")", nRow).html("<div class='icon-no-link'></div>");
			            		return;
			            	}
			            	var optColumn = "<div class='icon-link' ng-click='toTopoDetail()'></div>";
		                    var optLink = $compile($(optColumn));
		                    var optScope = $scope.$new();
		                    optScope.data = aData;
		                    optScope.hostName = hostName;
		                    optScope.hostSN = $.encoder.encodeForHTML(hostSN);
		                    optScope.toTopoDetail = function () {
		                    	var params =
		                    	{
		                    			hostName:encodeURIComponent(optScope.hostName),
		                    			pgInfo : []
		                    	};
		                    	angular.forEach(optScope.data.protectGroupList,function(pg){
		                    		this.push(pg.protectGroupName + ":" + pg.protectGroupId);
		                    	},params.pgInfo);
		                    	params.pgInfo = encodeURIComponent(params.pgInfo.join(";"));

		                    	$state.go("monitor.protectGroupTopo.topogoly",params);
		                    };
		                    var optNode = optLink(optScope),linkIndex = 4;;
		                    if(9 === +dbType)
		                    {
		                    	linkIndex = 5;
		                    }
                            if (1 === +dbType) {
                                linkIndex = 6;
                            }
		                    $("td:eq("+linkIndex+")", nRow).html(optNode);

						},

						data : [],
						cellClickActive : function(e, param) {
							$scope.current = param;

					     }

					};


			   var _init = function(){
				  var hostSn = hostSN;
				  var typeUrl = utilService.getResouceUrl("/hosts/"+hostSn+"/apptypes");
				  communicationService.get(typeUrl).promise().always(function(result){
						 if(exception.check(result)){
							    _assemblePlungins(result);
				                if($scope.hostPlugins.length != 0){
				                	  $("#hostTopoAppTabs li a").eq(0).click();
				                	  if($scope.hostPlugins[0].openState == "9" ){
				                		  _doFs();
				                	  }else{
				                		  _doDataBase($scope.hostPlugins[0].openState,theadClick);
				                	  }

				                }
				                $scope.$apply();
						   }
				  });


			  };

			 var _doDataBase = function(type,callback){
				 var hostSn = hostSN;
				 var url = utilService.getResouceUrl("/hosts/"+hostSn+"/databases?dbType="+type);
				  communicationService.get(url).promise().always(function(result){
					 if(exception.check(result)){


						 	appUtils.encodeForHTML(result);

			                var arr = [];
			                _.each(result, function(d) {
			                	d.name = d.name;
			                	d.instanceName = d.parentMo.instanceName;
			                	d.instanceStatus = d.dbStatus;
			                	d.dbType = d.parentMo.dbType;
			                	d.dbVersion = d.parentMo.dbVersion;
			                	d.protectGroupName = getProtectGroupNames(d.protectGroupList);
			                	var tmo;
                                if(type == "1" && !_.isUndefined(d.IS_CDB)){
                                    tmo = _.pick(d, "name", "protectGroupName", "instanceName", "instanceStatus", "dbVersion", "dbType", "protectGroupList","IS_CDB","PDB");
                                }else{
                                    tmo = _.pick(d, "name", "protectGroupName", "instanceName", "instanceStatus", "dbVersion", "dbType", "protectGroupList");
                                };
                                arr.push(tmo);
			                });
			                $scope.datasHostAppTable.data = arr;
			                if(type == "8"){
			                	$scope.datasHostAppTable.columns = exChangeColum;
			                }else if(type == "1"){
                                $scope.datasHostAppTable.columns = orcaleClumn;
                            }else if (type == "16") {
                                $scope.datasHostAppTable.columns = hanaColum;
                            }else{
			                	$scope.datasHostAppTable.columns = dbClumn;
			                }

			                $scope.datasHostAppTable.totalRecords = result.length;
			                $scope.datasHostAppTable.enablePagination = result.length > constsService.TABLE_COUNT_PER_PAGE;
			                $scope.$apply();
                            _.isFunction(callback) && callback();
					   }
				  });
			 };


			 var _doFs = function(){
				 var hostSn = hostSN;
				 var url = utilService.getResouceUrl("/hosts/"+hostSn+"/filesystems");
				  communicationService.get(url).promise().always(function(result){
					 if(exception.check(result)){


						 	appUtils.encodeForHTML(result);

			                var arr = [];
			                _.each(result, function(d) {
			                    d.protectGroupName = getProtectGroupNames(d.protectGroupList);
					            var tmo =_.pick(d, "name","protectGroupName","fsType","mount","capacity","protectGroupList");
  					            tmo.dbType = 9;
			                    arr.push(tmo);
			                });
			                $scope.datasHostAppTable.data = arr;
			                $scope.datasHostAppTable.columns = ntfsColum;
			                $scope.datasHostAppTable.totalRecords = result.length;
			                $scope.datasHostAppTable.enablePagination = result.length > constsService.TABLE_COUNT_PER_PAGE;
			                $scope.$apply();

					   }
				  });
			 };

			 var getProtectGroupNames = function(lists)
			 {
				 var names = [];
				 angular.forEach(lists,function(pg){
					 this.push(pg.protectGroupName);
				 },names);

				 if(0 == names.length)
				 {
					 return "--";
				 }
				 return names.join(";");
			 }
		}

	}];

    var applyInstanceConfigModule = angular.module('home.config');
    applyInstanceConfigModule.tinyController('home.ctrl', ctrl);
    return applyInstanceConfigModule;
});
