define(["tiny-widgets/Window"], function(Window) {
    "use strict";

    var ctrl = ["$scope", "$timeout", "$sce", "$state", "$compile", "exception", "message", "communicationService", "utilService", "constsService", "appUtils", "mask", "infoTransferredService", "cookieService", "statusEnumService", "topoService", "restService",
        function($scope, $timeout, $sce, $state, $compile, exception, message, communicationService, utilService, constsService, appUtils, mask, infoTransferredService, cookieService, statusEnumService, topoService, restService) {
            $scope.TEST_STATUS_IN_LAST_THREEMONTH = appUtils.getString("home.term.testStatusInLastThreeMonth.tab");
            $scope.LOADING = appUtils.getString("home.term.loadding.label");
            $scope.TOP5_TEST_TIME = appUtils.getString("home.term.RPOmet.tab");
            $scope.BOTTOM_TEST_TIME = appUtils.getString("home.term.planTestTimeStatic.tab");
            $scope.PROTECTION_COUNT_LBAEL = appUtils.getString("home.term.protectedCount_label");
            $scope.TOP5_ALARM_VIEWALL = appUtils.getString("home.term.top5alarm.viewall");
            $scope.ALARM_STATISTICS = appUtils.getString("home_alarm_statistics_label");
            $scope.PROTECTED_STATICS = appUtils.getString("common.term.protectedStatistics.tab");
            $scope.TEST_SUCCEED_LABEL = appUtils.getString("home.term.testStatusInLastThreeMonth.value.success.label");
            $scope.TEST_FAILED_LABEL = appUtils.getString("home.term.testStatusInLastThreeMonth.value.fail.label");
            $scope.TEST_NOTESTED_LABEL = appUtils.getString("home.term.testStatusInLastThreeMonth.value.notTested.label");
            $scope.NO_LABEL = appUtils.getString("home_term_RPOmet_no_tab");
            $scope.YES_LABEL = appUtils.getString("home_term_RPOmet_yes_tab");
            $scope.UNKNOWN_LABEL = appUtils.getString("home_term_RPOmet_unknown_tab");
            $scope.LEVEL_1 = appUtils.getString("home_term_planStatic_lv1_tab");
            $scope.LEVEL_2 = appUtils.getString("home_term_planStatic_lv2_tab");
            $scope.LEVEL_3 = appUtils.getString("home_term_planStatic_lv3_tab");
            $scope.LEVEL_4 = appUtils.getString("home_term_planStatic_lv4_tab");
            $scope.LEVEL_5 = appUtils.getString("home_term_planStatic_lv5_tab");
            $scope.NO_DATA = appUtils.getString("common_term_nodata_label");
            $scope.alarm_critical = appUtils.getString("alarm_term_critical_label");
            $scope.alarm_major = appUtils.getString("alarm_term_major_label");
            $scope.alarm_minor = appUtils.getString("alarm_term_send_label");
            $scope.alarm_warning = appUtils.getString("alarm_term_info_label");
            $scope.NO_RIGHT_TEXT = appUtils.getString("lego.err.1073947400");
            $scope.NO_SITE_TIP = $sce.trustAsHtml(appUtils.getString("site_nosite_tip_label"));

            //权限定义
            $scope.alarmRight = appUtils.checkRight("lego.evtMgr.curtAlarm.scan");
            $scope.serverRight = appUtils.checkRight("ism.drm.servers.auth.scan");
            $scope.siteViewRight = appUtils.checkRight("ism.drm.site.auth.scan");
            $scope.siteAddRight = appUtils.checkRight("ism.drm.site.auth.add");
            $scope.pgReportRight = appUtils.checkRight("ism.drm.report.protection.auth.scan");
            $scope.recoveryReportRight = appUtils.checkRight("ism.drm.report.rp.auth.scan");

            var EMPTY_ERS = [{
                value: 100,
                name: appUtils.getString("common_term_nodata_label"),
                tooltip: appUtils.getString("common_term_nodata_label"),
                linearGradient: {
                    startColor: constsService.COLOR_THIN_GREY,
                    endColor: constsService.COLOR_THIN_GREY,
                    angle: 100
                }
            }];
            var chartWidth = 0;
            if ($("body").width() > 1500) {
                chartWidth = 400;
            } else {
                chartWidth = $("body").width() / 6;
            }
            var testStatusPromise = false;
            $scope.createTestStatusChart = function(siteId) {
                var url = "/reports/action/testStatusStatistic";
                if (!_.isEmpty(siteId)) {
                    url += "?siteId=" + siteId;
                };
                testStatusPromise = false;
                communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result) {
                    testStatusPromise = true;
                    if (exception.check(result)) {
                        $("#testStatusContainer").empty();
                        var chartDatas = [];
                        if (result[0].successCount == "0" && result[1].failCount == "0" && result[2].unTestCount == "0") {
                            $scope.createDonutChart("testStatusContainer", EMPTY_ERS, chartWidth, 180);
                            $("#donaChartDiv .succeed").eq(0).text(0);
                            $("#donaChartDiv .failed").eq(0).text(0);
                            $("#donaChartDiv .untested").eq(0).text(0);
                            return;
                        }
                        var s = parseInt(result[0].successCount, 10);
                        var f = parseInt(result[1].failCount, 10);
                        var u = parseInt(result[2].unTestCount, 10);
                        var total = s + f + u;
                        var s_tooltip = appUtils.getString("common_term_succeed_label") + ":" + s + appUtils.getString("common_label_single_label"),
                            f_tooltip = appUtils.getString("common_term_failed_label") + ":" + f + appUtils.getString("common_label_single_label"),
                            u_tooltip = appUtils.getString("common_term_untest_label") + ":" + u + appUtils.getString("common_label_single_label");

                        if (appUtils.isEn()) {
                            s_tooltip = appUtils.getString("common_term_succeed_label") + ":" + s + " " + appUtils.getString("common_label_single_label");
                            f_tooltip = appUtils.getString("common_term_failed_label") + ":" + f + " " + appUtils.getString("common_label_single_label");
                            u_tooltip = appUtils.getString("common_term_untest_label") + ":" + u + " " + appUtils.getString("common_label_single_label");
                        }

                        chartDatas.push({
                            value: s * 100 / total,
                            name: appUtils.getString("common_term_succeed_label"),
                            tooltip: s_tooltip,
                            linearGradient: {
                                startColor: constsService.COLOR_GREEN,
                                endColor: constsService.COLOR_GREEN,
                                angle: 100
                            }
                        });
                        chartDatas.push({
                            value: f * 100 / total,
                            name: appUtils.getString("common_term_failed_label"),
                            tooltip: f_tooltip,
                            linearGradient: {
                                startColor: constsService.COLOR_RED,
                                endColor: constsService.COLOR_RED,
                                angle: 100
                            }
                        });
                        chartDatas.push({
                            value: u * 100 / total,
                            name: appUtils.getString("common_term_untest_label"),
                            tooltip: u_tooltip,
                            linearGradient: {
                                startColor: constsService.COLOR_GREY,
                                endColor: constsService.COLOR_GREY,
                                angle: 100
                            }
                        });
                        $scope.createDonutChart("testStatusContainer", chartDatas, chartWidth, 180);
                        $("#donaChartDiv .succeed").eq(0).text(s);
                        $("#donaChartDiv .failed").eq(0).text(f);
                        $("#donaChartDiv .untested").eq(0).text(u);
                        $("#donaChartDiv").show();
                    }
                })
            }

            $scope.refreshTestStatus = function(siteId) {
                if (!$scope.recoveryReportRight) {
                    return;
                }
                $scope.createTestStatusChart(siteId);
            }
            var rPOMeetPromise = false;
            $scope.createRPOMeetChart = function(siteId) {
                var url = "/reports/action/getRpoMetStatisticInfo";
                if (!_.isEmpty(siteId)) {
                    url += "?siteId=" + siteId;
                };
                rPOMeetPromise = false;
                communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result) {
                    rPOMeetPromise = true;
                    if (exception.check(result)) {
                        $("#rpoContainer").empty();
                        var chartDatas = [];
                        if (result.meetCount == "0" && result.notmeetCount == "0" && result.unknownCount == "0") {
                            $scope.createDonutChart("rpoContainer", EMPTY_ERS, chartWidth, 180);
                            $("#rpoChartDiv .succeed").eq(0).text("0");
                            $("#rpoChartDiv .failed").eq(0).text("0");
                            $("#rpoChartDiv .untested").eq(0).text("0");
                            return;
                        }
                        var s = result.meetCount;
                        var f = result.notmeetCount;
                        var d = result.unknownCount;
                        var total = s + f + d;
                        var s_tooltip = appUtils.getString("home_term_RPOmet_yes_tab") + ":" + s + appUtils.getString("common_label_single_label"),
                            f_tooltip = appUtils.getString("home_term_RPOmet_no_tab") + ":" + f + appUtils.getString("common_label_single_label"),
                            d_tooltip = appUtils.getString("home_term_RPOmet_unknown_tab") + ":" + d + appUtils.getString("common_label_single_label");

                        if (appUtils.isEn()) {
                            s_tooltip = appUtils.getString("home_term_RPOmet_yes_tab") + ":" + s + " " + appUtils.getString("common_label_single_label");
                            f_tooltip = appUtils.getString("home_term_RPOmet_no_tab") + ":" + f + " " + appUtils.getString("common_label_single_label");
                            d_tooltip = appUtils.getString("home_term_RPOmet_unknown_tab") + ":" + d + " " + appUtils.getString("common_label_single_label");
                        }
                        chartDatas.push({
                            value: s * 100 / total,
                            name: appUtils.getString("home_term_RPOmet_yes_tab"),
                            tooltip: s_tooltip,
                            linearGradient: {
                                startColor: constsService.COLOR_GREEN,
                                endColor: constsService.COLOR_GREEN,
                                angle: 100
                            }
                        });
                        chartDatas.push({
                            value: f * 100 / total,
                            name: appUtils.getString("home_term_RPOmet_no_tab"),
                            tooltip: f_tooltip,
                            linearGradient: {
                                startColor: constsService.COLOR_RED,
                                endColor: constsService.COLOR_RED,
                                angle: 100
                            }
                        });
                        chartDatas.push({
                            value: d * 100 / total,
                            name: appUtils.getString("home_term_RPOmet_unknow_tab"),
                            tooltip: d_tooltip,
                            linearGradient: {
                                startColor: constsService.COLOR_GREY,
                                endColor: constsService.COLOR_GREY,
                                angle: 100
                            }
                        });
                        $scope.createDonutChart("rpoContainer", chartDatas, chartWidth, 180);
                        $("#rpoChartDiv .succeed").eq(0).text(s);
                        $("#rpoChartDiv .failed").eq(0).text(f);
                        $("#rpoChartDiv .untested").eq(0).text(d);
                    }
                })
            }


            $scope.refreshTestTimeTop5 = function(siteId) {
                if (!$scope.pgReportRight) {
                    return;
                }
                $scope.createRPOMeetChart(siteId);
            }
            var planStaticPromiese = false;
            $scope.createPlanStaticChart = function(siteId) {
                var url = "/reports/action/getRpTestTimeStatisticInfo";
                if (!_.isEmpty(siteId)) {
                    url += "?siteId=" + siteId;
                };
                planStaticPromiese = false;
                communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result) {
                    planStaticPromiese = true;
                    if (exception.check(result)) {
                        $("#planStaticContainer").empty();
                        var chartDatas = result;
                        var chartDatas = [];
                        if (result.level1 == "0" && result.level2 == "0" && result.level3 == "0" && result.level4 == "0") {
                            $scope.createDonutChart("planStaticContainer", EMPTY_ERS, chartWidth, 180);
                            $("#planStatictDiv .succeed").eq(0).text("0");
                            $("#planStatictDiv .snormal").eq(0).text("0");
                            $("#planStatictDiv .failed").eq(0).text("0");
                            $("#planStatictDiv .untested").eq(0).text("0");
                            $("#planStatictDiv").show();
                            return;
                        }
                        var s = result.level1;
                        var f = result.level2;
                        var d = result.level3;
                        var k = result.level4;
                        var total = s + f + d + k;
                        var s_tooltip = appUtils.getString("home_term_planStatic_lv1_tab") + ":" + s + appUtils.getString("common_label_single_label"),
                            f_tooltip = appUtils.getString("home_term_planStatic_lv2_tab") + ":" + f + appUtils.getString("common_label_single_label"),
                            d_tooltip = appUtils.getString("home_term_planStatic_lv3_tab") + ":" + d + appUtils.getString("common_label_single_label"),
                            k_tooltip = appUtils.getString("home_term_planStatic_lv4_tab") + ":" + k + appUtils.getString("common_label_single_label");

                        if (appUtils.isEn()) {
                            s_tooltip = appUtils.getString("home_term_planStatic_lv1_tab") + ":" + s + " " + appUtils.getString("common_label_single_label");
                            f_tooltip = appUtils.getString("home_term_planStatic_lv2_tab") + ":" + f + " " + appUtils.getString("common_label_single_label");
                            d_tooltip = appUtils.getString("home_term_planStatic_lv3_tab") + ":" + d + " " + appUtils.getString("common_label_single_label");
                            k_tooltip = appUtils.getString("home_term_planStatic_lv4_tab") + ":" + k + " " + appUtils.getString("common_label_single_label");
                        }

                        chartDatas.push({
                            value: s * 100 / total,
                            name: appUtils.getString("home_term_planStatic_lv1_tab"),
                            tooltip: s_tooltip,
                            linearGradient: {
                                startColor: constsService.COLOR_GREEN,
                                endColor: constsService.COLOR_GREEN,
                                angle: 100
                            }
                        });
                        chartDatas.push({
                            value: f * 100 / total,
                            name: appUtils.getString("home_term_planStatic_lv2_tab"),
                            tooltip: f_tooltip,
                            linearGradient: {
                                startColor: constsService.CLOLOR_ORANGE,
                                endColor: constsService.CLOLOR_ORANGE,
                                angle: 100
                            }
                        });
                        chartDatas.push({
                            value: d * 100 / total,
                            name: appUtils.getString("home_term_planStatic_lv3_tab"),
                            tooltip: d_tooltip,
                            linearGradient: {
                                startColor: constsService.COLOR_RED,
                                endColor: constsService.COLOR_RED,
                                angle: 100
                            }
                        });
                        chartDatas.push({
                            value: k * 100 / total,
                            name: appUtils.getString("home_term_planStatic_lv4_tab"),
                            tooltip: k_tooltip,
                            linearGradient: {
                                startColor: constsService.COLOR_GREY,
                                endColor: constsService.COLOR_GREY,
                                angle: 100
                            }
                        });
                        $scope.createDonutChart("planStaticContainer", chartDatas, chartWidth, 180);
                        $("#planStatictDiv .succeed").eq(0).text(s);
                        $("#planStatictDiv .snormal").eq(0).text(f);
                        $("#planStatictDiv .failed").eq(0).text(d);
                        $("#planStatictDiv .untested").eq(0).text(k);
                    }
                })
            };

            $scope.refreshTestTimeBottom5 = function(siteId) {
                if (!$scope.recoveryReportRight) {
                    return;
                }
                $scope.createPlanStaticChart(siteId);
            };

            var protectedStatistcsPromise = false;
            $scope.queryProtectedStatistcs = function(siteId) {
                var url = "/reports/action/protectStatistic";
                !_.isEmpty(siteId) && (url += "?siteId=" + siteId);
                protectedStatistcsPromise = false;
                communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result) {
                    protectedStatistcsPromise = true;
                    var protectedDatas = [];
                    var protectedDatas = []
                    var chartDatas = result.details;
                    var width = $(".d-po-container #protectedStatisticsDiv").width() - 70;
                    if (exception.check(result)) {
                        _.each(chartDatas, function(charData) {
                            protectedDatas.push({
                                appType: appUtils.getString("protect_object")[charData.appType],
                                value: +charData.protectedAppCount + "/" + (+charData.noProtectedAppCount + (+charData.protectedAppCount)),
                                progress: {
                                    display: true,
                                    width: width > 400 ? 290 : width,
                                    labelPosition: "none",
                                    color: "#009ae7",
                                    height: 3,
                                    value: +charData.protectedAppCount / (+charData.noProtectedAppCount + (+charData.protectedAppCount)) * 100
                                }
                            });
                        });
                        $scope.protectedDatas = protectedDatas;
                        $scope.$apply();
                    }
                })
            };
            $scope.protectedDatas = {};
            $scope.createDonutChart = function(container, chartDatas, width, height) {
                var options = {
                    id: container,
                    r: 65,
                    height: height,
                    width: width,
                    strokeWidth: 12,
                    showShadow: true,
                    showLegend: false,
                    showClickEvent: true,
                    data: chartDatas

                };
                var testStatusChart = new tinyWidget.Cirquechart(options);
                return testStatusChart;
            };

            $scope.alarm = {
                criticalClick: function() {
                    $state.go("monitor.currentalarmjump", {
                        alarmType: '4'
                    });
                },
                majorClick: function() {
                    $state.go("monitor.currentalarmjump", {
                        alarmType: '3'
                    });
                },
                minorClick: function() {
                    $state.go("monitor.currentalarmjump", {
                        alarmType: '2'
                    });
                },
                warningClick: function() {
                    $state.go("monitor.currentalarmjump", {
                        alarmType: '1'
                    });
                },
            };

            $scope.refreshAlarmStatistcs = function() {
                if (!$scope.alarmRight) {
                    return;
                }
                communicationService.get(utilService.getResouceUrl("/alarms/statistic")).promise().always(function(result) {
                    if (exception.check(result)) {
                        result = angular.fromJson(result);
                        $scope.alarm.critical = +result.critical > 99 ? "99+" : +result.critical;
                        $scope.alarm.major = +result.major > 99 ? "99+" : +result.major;
                        $scope.alarm.minor = +result.minor > 99 ? "99+" : +result.minor;
                        $scope.alarm.warning = +result.warning > 99 ? "99+" : +result.warning;
                        $scope.$apply();
                    }
                })
            };


            function init() {
                $scope.createRPOMeetChart();
                $scope.createTestStatusChart();
                $scope.createPlanStaticChart();
                $scope.queryProtectedStatistcs();
                $scope.refreshAlarmStatistcs();
                $scope.refreshTopo = function() {
                    if (!$scope.serverRight) {
                        return;
                    }
                    if (!!_.size($("#dashboard"))) {
                        $(".topo-root").empty();
                        var containerX = parseInt($("#dashboard").css("width").replace("px", ""), 10) * 0.78;
                        var containerY = 535;
                        restService.queryLocalServer([], {
                            mask: false,
                            isShowMsgBox: false,
                            success: function(data) {
                                if (_.isEmpty(data) || !$scope.siteViewRight) {
                                    return;
                                }
                                restService.querySites([data.uuid], {
                                    isShowMsgBox: false,
                                    success: function(sites) {
                                        if (!_.isEmpty(sites)) {
                                            topoService.initTopo(containerX, containerY, sites, function(siteId, changePic) {
                                                var clickFlag = protectedStatistcsPromise && testStatusPromise && rPOMeetPromise && planStaticPromiese;
                                                _.isFunction(changePic) && changePic(clickFlag);
                                                protectedStatistcsPromise && $scope.queryProtectedStatistcs(siteId);
                                                testStatusPromise && $scope.refreshTestStatus(siteId);
                                                rPOMeetPromise && $scope.refreshTestTimeTop5(siteId);
                                                planStaticPromiese && $scope.refreshTestTimeBottom5(siteId);
                                            });
                                        }
                                        $scope.sites = sites || [];
                                        $scope.$evalAsync();
                                    }
                                })
                            }
                        })
                    };
                };
                $scope.refreshTopo();
            };
            $timeout(function() {
                init();
            }, 10)


            window['createSite'] = function() {
                if (!$scope.siteAddRight) {
                    message.error(appUtils.getString("lego.err.1073947400"));
                    return;
                }
                $state.go("site");
            }
        }
    ];
    var module = angular.module('home.config');
    module.tinyController('home.staticView.ctrl', ctrl);
    return module;
});