define(["lazy-load/lazyLoad", "ui-router/angular-ui-router.min", "tiny-extra-directives/Rainbowbar", "tiny-extra-directives/Pop"],
    function(lazyLoadModule, router) {
        "use strict";

        var routerConfig = [{
            name: "monitor",
            url: "/monitor",
            breadcrumbs: { name: "monitor_title" },
            templateUrl: "app/business/recoverydirector/monitor/views/main.html"
        }, {
            name: "monitor.currentalarmlist",
            url: "/currentalarmlist/{alarmType}",
            breadcrumbs: [{ name: "alarms_title" }, { name: "alarms_current_title" }],
            templateUrl: "app/business/recoverydirector/monitor/views/alarm/alarmList.html",
            controller: "monitor.currentalarmlist.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/monitor/controllers/alarm/alarmListCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "monitor.currentalarmjump",
            url: "/currentalarmlist/{alarmType}",
            breadcrumbs: [{ name: "alarms_title" }, { name: "alarms_current_title" }],
            templateUrl: "app/business/recoverydirector/monitor/views/alarm/alarmList.html",
            controller: "monitor.currentalarmlist.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/monitor/controllers/alarm/alarmListCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "monitor.historyalarmlist",
            url: "/historyalarmlist",
            breadcrumbs: [{ name: "alarms_title" }, { name: "alarms_history_title" }],
            templateUrl: "app/business/recoverydirector/monitor/views/alarm/alarmList.html",
            controller: "monitor.currentalarmlist.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/monitor/controllers/alarm/alarmListCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "monitor.audiosetting",
            url: "/audiosetting",
            breadcrumbs: [{ name: "alarms_title" }, { name: "audio_setting_title" }],
            templateUrl: "app/business/recoverydirector/monitor/views/alarm/audioSetting.html",
            controller: "monitor.audioSetting.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/monitor/controllers/alarm/audioSettingCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "monitor.topo",
            url: "/topo",
            breadcrumbs: { name: "topo_title" },
            templateUrl: "app/business/recoverydirector/monitor/views/topo/topoView.html",
            controller: "monitor.topo.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/monitor/controllers/topo/topoViewCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "monitor.report",
            url: "/report",
            breadcrumbs: { name: "report_title" },
            templateUrl: "app/business/recoverydirector/monitor/views/report/main.html"
        }, {
            name: "monitor.groupstatreport",
            url: "/groupstatreport",
            breadcrumbs: [{ name: "report_title" }, { name: "report_pg_title" }],
            templateUrl: "app/business/recoverydirector/monitor/views/report/groupcount/groupCount.html",
            controller: "monitor.groupstatreport.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/monitor/controllers/report/groupcount/groupCountCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "monitor.recoverytestreport",
            url: "/recoverytestreport",
            breadcrumbs: [{ name: "report_title" }, { name: "report_recovery_title" }],
            templateUrl: "app/business/recoverydirector/monitor/views/report/recoverytest/recoveryTest.html",
            controller: "monitor.recoverytestreport.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/monitor/controllers/report/recoverytest/recoveryTestCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "monitor.linkToRecoveryReport",
            url: "/recoverytestreport/{timeSeg}",
            stateParamsKey:"timeSeg",
            breadcrumbs: [{name: "report_title"},{name: "report_recovery_title"}],
            templateUrl: "app/business/recoverydirector/monitor/views/report/recoverytest/recoveryTest.html",
            controller: "monitor.recoverytestreport.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/monitor/controllers/report/recoverytest/recoveryTestCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "monitor.protectGroupTopo",
            url: "/protectGroupTopo/{hostName}/{pgInfo}",
            breadcrumbs: [{ name: "topo_title" }, { name: "--" }],
            templateUrl: "app/business/recoverydirector/monitor/views/topo/protectGroupTopo.html",
            controller: "monitor.protectGroupTopo.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/monitor/controllers/topo/protectGroupTopoCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "monitor.protectGroupTopo.topogoly",
            url: "/groupstatreport",
            templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/common/topology.html",
            controller: "protection.pg.abstract.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/protection/controllers/protectiongroup/common/topologyCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }];


        var module = angular.module("recoverydirector.monitor.config", ["ui.router"]);
        module = lazyLoadModule.makeLazy(module);
        module.tinyStateConfig({ stateConfig: routerConfig });
        return module;
    });