define(["tiny-common/UnifyValid", "tiny-widgets/Window"],
    function (UnifyValid, Window) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "$compile",
            "exception",
            "message",
            "communicationService", "utilService", "mask", "appUtils", "constsService", "statusEnumService", "cookieService", "infoTransferredService",
            function ($scope, $state, $stateParams, $compile, exception, message, communicationService, utilService, mask, appUtils, constsService, statusEnumService, cookieService, infoTransferredService) {
                $scope.FROM = appUtils.getString("common_term_from_label");
                $scope.TO = appUtils.getString("common_term_to_label");
                $scope.ADVANCED_LABEL = appUtils.getString("common_term_adgsearch_button");
                $scope.refreshTitle = appUtils.getString("common_term_refresh_button");

                $scope.condition = null;
                $scope.callbackSearchCondition = 0;
                $scope.orderBy = "severity";
                $scope.orderType = "desc";
                $scope.startPage = constsService.start;
                $scope.pageSize = constsService.TABLE_COUNT_PER_PAGE_BIG;
                $scope.isCurrentAlarm = !_.isUndefined($stateParams.alarmType) ? true : false;
                $scope.refreshRateDiv = $scope.isCurrentAlarm ? true : false;

                Array.prototype.remove = function (val) {
                    var index = this.indexOf(val);
                    if (index > -1) {
                        this.splice(index, 1);
                    }
                };

                var timeOutHander;
                var clickedIds = [];
                var rateRefreshTable = function (time) {
                    if ("-1" != time) {
                        timeOutHander = setInterval(function () {
                            if ("monitor.currentalarmlist" == $.trim($state.current.name)
                                || "monitor.currentalarmjump" == $.trim($state.current.name)) {
                                $scope.autoRef = true;
                                _initTable();
                                var selectAlarmNum = $("#alarmTable").widget().getTableCheckedNums();
                                if (selectAlarmNum > 0) {
                                    _.extend($scope.batchButton[0], {
                                        label: appUtils.getString("common_term_selected_label", selectAlarmNum)
                                    });
                                }
                            }
                        }, time);
                    }
                };


                $scope.$on("$destroy", function () {
                    if (timeOutHander) {
                        clearInterval(timeOutHander);
                    }
                });

                var _updateUI = function (result) {
                    mask.hide();
                    if (exception.check(result)) {
                        var arr = [];
                        _.each(result.records, function (d) {
                            d.alarmName = $.encoder.encodeForHTML(d.alarmName);
                            d.moName = $.encoder.encodeForHTML(d.moName);
                            d.firstTimeStr = $.encoder.encodeForHTML(d.firstTimeStr);
                            d.clearTimeStr = $.encoder.encodeForHTML(d.clearTimeStr);
                            d.alarmTimeStr = $.encoder.encodeForHTML(d.alarmTimeStr);
                            d.confirmUser  = $.encoder.encodeForHTML(d.confirmUser);
                            var tmo = _.pick(d, "alarmId", "entity", "severity", "confirmStatus", "alarmName", "alarmType", "count", "moName", "firstTimeStr", "alarmTimeStr", "clearTimeStr", "params","confirmUser");
                            arr.push(tmo);
                        });
                        $scope.currentAlarmTable.data = arr;
                        $scope.currentAlarmTable.totalRecords = result["totalCount"];
                        $scope.currentAlarmTable.enablePagination = result["totalCount"] > constsService.TABLE_COUNT_PER_PAGE_BIG ? true : false;
                        $scope.exportAll.disable = result["totalCount"] > 0 ? false : true;
                        $scope.isShow = $("#alarmTable").widget().getTableCheckedNums() === 0 ? false : true;
                        $scope.$apply();
                    }
                };

                var _initRight = function () {
                    var batchButtonSet = [];
                    $scope.userRight = {};
                    $scope.isCurrentAlarm = !_.isUndefined($stateParams.alarmType) ? true : false;
                    if ($scope.isCurrentAlarm) {
                        var confirmRight = appUtils.checkRight("lego.evtMgr.curtAlarm.confirm");
                        var unconfirmRight = appUtils.checkRight("lego.evtMgr.curtAlarm.confirm");
                        var clearRight = appUtils.checkRight("lego.evtMgr.curtAlarm.clear");
                        var exportRight = appUtils.checkRight("lego.evtMgr.curtAlarm.export");

                        if (confirmRight || unconfirmRight || clearRight || exportRight) {
                            batchButtonSet.push({
                                id: 0,
                                label: appUtils.getString("common_term_selected_label", 0),
                                display: true,
                                lastLine: false
                            });
                        }
                        if (confirmRight) {
                            batchButtonSet.push({
                                id: 1,
                                label: appUtils.getString("alarm_term_confirm_label"),
                                display: $scope.isCurrentAlarm,
                                lastLine: false,
                                click: function () {
                                    $scope.batchDealAction(constsService.ALARM_BATCH_DEAL.confirm,
                                        appUtils.getString("current_alarm_term_confirm_messge_lable"),
                                        appUtils.getString("current_alarm_term_confirm_success_lable"));
                                }
                            });
                        }
                        if (unconfirmRight) {
                            batchButtonSet.push({
                                id: 2,
                                label: appUtils.getString("alarm_term_unconfirm_label"),
                                display: $scope.isCurrentAlarm,
                                lastLine: false,
                                click: function () {
                                    $scope.batchDealAction(constsService.ALARM_BATCH_DEAL.cancelConfirm,
                                        appUtils.getString("current_alarm_term_cancleConfirm_messge_lable"),
                                        appUtils.getString("current_alarm_term_cancleConfirm_success_lable"));
                                }
                            });
                        }

                        if (clearRight) {
                            batchButtonSet.push({
                                id: 3,
                                label: appUtils.getString("common_term_dump_button"),
                                display: $scope.isCurrentAlarm,
                                lastLine: false,
                                click: function () {
                                    $scope.batchDealAction(constsService.ALARM_BATCH_DEAL.clear,
                                        appUtils.getString("current_alarm_term_clear_messge_lable"),
                                        appUtils.getString("current_alarm_term_clear_success_lable"),
                                        "clear");
                                }
                            });
                        }

                        if (exportRight) {
                            batchButtonSet.push({
                                id: 4,
                                label: appUtils.getString("common_term_export_button"),
                                display: true,
                                lastLine: true,
                                click: function () {
                                    var tableData = $("#alarmTable").widget().getTableCheckedItems();
                                    if (!utilService.isNotEmpty(tableData)) {
                                        message.error(appUtils.getString("common_term_select_data_least_label"));
                                        return false;
                                    }
                                    var params = "";
                                    angular.forEach(tableData, function (obj, i) {
                                        params =params + "&alarmIdSet=" + obj.entity;
                                    });
                                        params = params.substr(1);
                                    if ($scope.isCurrentAlarm) {
                                        appUtils.export("/alarms/action/exportSelectedAlarms?sortField=alarmName&sortType=desc", params, "get");
                                    } else {
                                        appUtils.export("/alarms/action/exportSelectedHistoryAlarms?sortField=alarmName&sortType=desc", params, "get");
                                    }
                                }
                            })

                            $scope.userRight.exportAllRight = true;
                        } else {
                            $scope.userRight.exportAllRight = false;
                        }
                    } else {

                        var exportRight = appUtils.checkRight("lego.evtMgr.hisAlarm.export");
                        if (exportRight) {
                            batchButtonSet.push({
                                id: 0,
                                label: appUtils.getString("common_term_selected_label", 0),
                                display: true,
                                lastLine: false
                            }, {
                                id: 4,
                                label: appUtils.getString("common_term_export_button"),
                                display: true,
                                lastLine: true,
                                click: function () {
                                    var tableData = $("#alarmTable").widget().getTableCheckedItems();
                                    if (!utilService.isNotEmpty(tableData)) {
                                        message.error(appUtils.getString("common_term_select_data_least_label"));
                                        return false;
                                    }
                                    var params = "";
                                    angular.forEach(tableData, function (obj, i) {
                                        params =params + "&alarmIdSet=" + obj.entity;
                                    });
                                    params = params.substr(1);
                                    if ($scope.isCurrentAlarm) {
                                        appUtils.export("/alarms/action/exportSelectedAlarms?sortField=alarmName&sortType=desc", params, "get");
                                    } else {
                                        appUtils.export("/alarms/action/exportSelectedHistoryAlarms?sortField=alarmName&sortType=desc", params, "get");
                                    }
                                }
                            });
                            $scope.userRight.exportAllRight = true;
                        } else {
                            $scope.userRight.exportAllRight = false;
                        }
                    }
                    $scope.batchButton = batchButtonSet;
                }


                var _initTable = function () {
                    $scope.isCurrentAlarm = !_.isUndefined($stateParams.alarmType) ? true : false;
                    $scope.refreshRateDiv = $scope.isCurrentAlarm ? true : false;
                    var url = constsService.AlARM_TYPE_URL.history;
                    if ($scope.isCurrentAlarm) {
                        url = constsService.AlARM_TYPE_URL.current;
                    }
                    url = url + "?startPage=" + $scope.startPage + "&pageSize=" + $scope.pageSize + "&orderBy=" + $scope.orderBy + "&orderType=" + $scope.orderType;
                    if (!_.isEmpty($scope.condition) && !_.isUndefined($scope.condition)) {
                        url = url + $scope.condition;
                    } else if (!_.isEmpty($stateParams.alarmType) && !_.isUndefined($stateParams.alarmType)) {
                        url = url + "&severity=" + parseInt($stateParams.alarmType, 10);
                    }

                    if (!$scope.autoRef) {
                        mask.show();
                    }
                    communicationService.get(utilService.getResouceUrl(url)).promise().always(_updateUI);
                    _initRight();
                };

                rateRefreshTable("15000");

                $scope.advance = {
                    labels: {
                        cls: "alarmAdvance a_td_label",
                        source: appUtils.getStringWithColon("current_alarm_term_source_column"),
                        type: appUtils.getStringWithColon("current_alarm_term_type_column"),
                        confirmStatus: appUtils.getStringWithColon("current_alarm_term_confirm_status_column"),
                        occurredTime: appUtils.getStringWithColon("current_alarm_term_occurred_time_label")
                    },
                    alarmLevel: {
                        labelcls: "alarmAdvance a_td_level_label",
                        level: appUtils.getStringWithColon("current_alarm_term_level_column"),
                        id : "alarmLevel",
                        layout: "horizon",
                        contentcls: "#generalDiv sendContentCls",
                        values : [
                            {"key" : "4", "text" : appUtils.getString(constsService.ALARM_LEVEL.critical.label), "checked" : false, "disable" : false},
                            {"key" : "3", "text" : appUtils.getString(constsService.ALARM_LEVEL.major.label), "checked" : false, "disable" : false},
                            {"key" : "2", "text" : appUtils.getString(constsService.ALARM_LEVEL.warn.label), "checked" : false, "disable" : false},
                            {"key" : "1", "text" : appUtils.getString(constsService.ALARM_LEVEL.info.label), "checked" : false, "disable" : false}],
                        spacing : {"width" : "5px", "height": "25px"}
                    },
                    type: {
                        id: "alarmType",
                        values: [
                            {"selectId": "0", "label": appUtils.getString("common_term_all_label"), "checked": true},
                            {"selectId": "1", "label": appUtils.getString("alarm_term_type_comm")},
                            {"selectId": "2", "label": appUtils.getString("alarm_term_type_env")},
                            {"selectId": "3", "label": appUtils.getString("alarm_term_type_dev")},
                            {"selectId": "4", "label": appUtils.getString("alarm_term_type_business")},
                            {"selectId": "5", "label": appUtils.getString("alarm_term_type_operation")},
                            {"selectId": "6", "label": appUtils.getString("alarm_term_type_security")}
                        ],
                        width: constsService.W3
                    },
                    confirmStatus: {
                        id: "confirmStatus",
                        values: [
                            {"selectId": "0", "label": appUtils.getString("common_term_all_label"), "checked": true},
                            {"selectId": "2", "label": appUtils.getString("alarm_term_confirm_label")},
                            {"selectId": "1", "label": appUtils.getString("alarm_term_unconfirm_label")}
                        ],
                        width: constsService.W3
                    },
                    source: {
                        id: "source",
                        value: "",
                        width: constsService.W3,
                        validate: constsService.VALID.AUTH_ALARM_SOURCE
                    },
                    startDate: {
                        id: "startDate",
                        type: "datetime",
                        dateFormat: 'yy-mm-dd',
                        timeFormat: "h:mm:ss",
                        "ampm": true
                    },
                    endDate: {
                        id: "endDate",
                        type: "datetime",
                        dateFormat: 'yy-mm-dd',
                        timeFormat: "h:mm:ss",
                        disable: false,
                        "ampm": true
                    },
                    btnOK: {
                        id: "btnOK",
                        text: appUtils.getString("common_term_search_button"),
                        click: function () {
                            if (!UnifyValid.FormValid($("#advanceSearchDiv"), {focusInvalid: true})) {
                                return;
                            }

                            var startTime = $("#startDate").widget().getDateTime();
                            var endTime = $("#endDate").widget().getDateTime();

                            var severity = "";
                            var advanceCondition = "";
                            $scope.callbackSearchCondition = 1;

                            var levelIds = $("#alarmLevel").widget().opChecked("checked");
                            _.each(levelIds, function(value) {
                                clickedIds.push(value);
                                severity = severity + "&severity=" + parseInt(value, 10);
                            });

                            if (utilService.isNotEmpty(severity)) {
                                advanceCondition = advanceCondition + severity;
                            }

                            var type = $("#alarmType").widget().getSelectedId();
                            if (utilService.isNotEmpty(type)) {
                                advanceCondition = advanceCondition + "&alarmType=" + type;
                            }

                            var status = $("#confirmStatus").widget().getSelectedId();
                            if (utilService.isNotEmpty(status)) {
                                advanceCondition = advanceCondition + "&confirmStatus=" + status;
                            }

                            var alarmSource = $("#source").widget().getValue();
                            if (utilService.isNotEmpty(alarmSource)) {
                                advanceCondition = advanceCondition + "&alarmSource=" + $.encoder.encodeForURL(alarmSource);
                            }

                            if (utilService.isNotEmpty(startTime)) {
                                startTime = appUtils.newDate(startTime).getTime();
                                advanceCondition = advanceCondition + "&createTimeStart=" + startTime;
                            }

                            if (utilService.isNotEmpty(endTime)) {
                                endTime = appUtils.newDate(endTime).getTime();
                                advanceCondition = advanceCondition + "&createTimeEnd=" + endTime;
                            }
                            if ((utilService.isNotEmpty(startTime) && utilService.isNotEmpty(endTime)) && startTime >= endTime){
                                message.error(appUtils.getString("notify_alarm_term_endTime_start_error_msg"));
                                return;
                            }
                            $scope.condition = advanceCondition;

                            $scope.startPage = 0;
                            $scope.currentAlarmTable.curPage = {
                                "pageIndex": 1
                            };
                            mask.show();
                            _initTable();
                        }
                    }

                };

                var _clearAdvanceParams = function () {
                    $scope.callbackSearchCondition = 1;
                    clickedIds = [];
                    !_.isEmpty($("#alarmLevel").widget()) && $("#alarmLevel").widget().checkedAll(false);
                    !_.isEmpty($("#alarmType").widget()) && $("#alarmType").widget().opChecked(0);
                    !_.isEmpty($("#confirmStatus").widget()) && $("#confirmStatus").widget().opChecked(0);
                    !_.isEmpty($("#source").widget()) && $("#source").widget().option("value", "");
                    !_.isEmpty($("#startDate").widget()) && $("#startDate").find("input").val("");
                    !_.isEmpty($("#endDate").widget()) && $("#endDate").find("input").val("");
                };

                var getExportAllParam = function () {
                    var alarmType = $("#alarmType").widget();
                    var alarmTypeValue;
                    if (!utilService.isNotEmpty(alarmType)) {
                        alarmTypeValue = 0;
                    } else {
                        alarmTypeValue = alarmType.getSelectedId();
                    }
                    var confirmStatus = $("#confirmStatus").widget();
                    var confirmStatusValue;
                    if (!utilService.isNotEmpty(confirmStatus)) {
                        confirmStatusValue = 0;
                    } else {
                        confirmStatusValue = confirmStatus.getSelectedId();
                    }
                    var alarmSource = $("#source").widget();
                    var alarmSourceValue;
                    if (!utilService.isNotEmpty(alarmSource)) {
                        alarmSourceValue = "";
                    } else {
                        alarmSourceValue = alarmSource.getValue();
                    }
                    var createTimeStart = $("#startDate").widget();
                    var createTimeStartValue;
                    if (!utilService.isNotEmpty(createTimeStart)) {
                        createTimeStartValue = 0;
                    } else {
                        createTimeStartValue = createTimeStart.getDateTime();
                        if (!utilService.isNotEmpty(createTimeStartValue)) {
                            createTimeStartValue = 0;
                        } else {
                            createTimeStartValue = appUtils.newDate(createTimeStartValue).getTime();
                        }
                    }
                    var createTimeEnd = $("#endDate").widget();
                    var createTimeEndValue;
                    if (!utilService.isNotEmpty(createTimeEnd)) {
                        createTimeEndValue = 0;
                    } else {
                        createTimeEndValue = createTimeEnd.getDateTime();
                        if (!utilService.isNotEmpty(createTimeEndValue)) {
                            createTimeEndValue = 0;
                        } else {
                            createTimeEndValue = appUtils.newDate(createTimeEndValue).getTime();
                        }
                    }
                    if (!utilService.isNotEmpty(clickedIds) && $scope.callbackSearchCondition == 1) {
                        clickedIds.push(0);
                    }

                    if ($scope.callbackSearchCondition == 2) {
                        var value = $("#severity").widget().getSelectedId();
                        if (utilService.isNotEmpty(value)) {
                            clickedIds.push(value);
                        }
                    }
                    var severityParam = {
                        severity: clickedIds
                    }
                    if ($scope.isCurrentAlarm) {
                        appUtils.export("/alarms/action/exportAllAlarms?sortField=alarmName&sortType=desc&alarmType=" + alarmTypeValue
                            + '&confirmStatus=' + confirmStatusValue + '&alarmSource=' + alarmSourceValue + '&createTimeStart=' + createTimeStartValue
                            + '&createTimeEnd=' + createTimeEndValue, severityParam, "get");
                    } else {
                        appUtils.export("/alarms/action/exportAllHistoryAlarms?sortField=alarmName&sortType=desc&alarmType=" + alarmTypeValue
                            + '&confirmStatus=' + confirmStatusValue + '&alarmSource=' + alarmSourceValue + '&createTimeStart=' + createTimeStartValue
                            + '&createTimeEnd=' + createTimeEndValue, severityParam, "get");
                    }
                }
                $scope.exportAll = {
                    id: "exportAll",
                    disable: false,
                    text: appUtils.getString("common_term_exportall_button"),
                    click: function () {
                        getExportAllParam();
                        clickedIds = [];
                    }
                };

                $scope.refreshData = function () {
                    var url = constsService.AlARM_TYPE_URL.history;
                    if ($scope.isCurrentAlarm) {
                        url = constsService.AlARM_TYPE_URL.current;
                    }
                    $scope.condition = "&severity=0";
                    $scope.currentAlarmTable.curPage = {
                        "pageIndex": 1
                    };
                    $("#severity").widget().option("default-selectid", constsService.ALARM_LEVEL.all.id);

                    mask.show();
                    communicationService.get(utilService.getResouceUrl(url + "?startPage=0&pageSize=15&orderBy=severity&orderType=desc")).promise().always(_updateUI);
                    _initRight();
                    _clearAdvanceParams();
                };

                var ngdom = $("<div></div>");
                $scope.advanceSearchPop = {
                    "id": "advanceSearchPopId",
                    "elementId": "advanceSearchPopEleId",
                    "template": ngdom,
                    "popStyle": {
                        "width": "zh" === cookieService.get("language") || "zh_CN" === cookieService.get("language") ? '380px' : "435",
                        "height": "zh" === cookieService.get("language") || "zh_CN" === cookieService.get("language") ? '300px' : "302px"
                    }
                };
                $scope.showAdvanceSearch = function () {
                    ngdom.load("app/business/recoverydirector/monitor/views/alarm/current/advanceSearch.html", function () {
                        $compile($("#advanceSearchDiv"))($scope);
                        $scope.$apply();
                        $("#advanceSearchPopId").widget().setPopShow(true);
                    });
                };

                $scope.model = {
                    refreshRate: {
                        id: "refreshRate",
                        values: [
                            {
                                selectId: '15000',
                                label: appUtils.getString("common_term_refresh_15_second"),
                                checked: true
                            },
                            {
                                selectId: '30000',
                                label: appUtils.getString("common_term_refresh_30_second")
                            },
                            {
                                selectId: '60000',
                                label: appUtils.getString("common_term_refresh_60_second")
                            },
                            {
                                selectId: '-1',
                                label: appUtils.getString("common_term_refresh_stop")
                            }
                        ],
                        width: constsService.W2,
                        change: function () {
                            clearInterval(timeOutHander);
                            rateRefreshTable($("#refreshRate").widget().getSelectedId());
                        }
                    },
                    level: {
                        id: "level",
                        values: [
                            {
                                selectId: '1',
                                label: appUtils.getString("current_alarm_term_level_column"),
                                checked: true
                            }
                        ],
                        width: constsService.W2,
                        defaultSelectid:"1",
                        isSearchbox:false,
                        levelOptions:{
                            id:"severity",
                            values:[
                            { selectId: constsService.ALARM_LEVEL.all.id, label: appUtils.getString(constsService.ALARM_LEVEL.all.label), checked: !$stateParams.alarmType ? true : false },
                            { selectId: constsService.ALARM_LEVEL.critical.id, label: appUtils.getString(constsService.ALARM_LEVEL.critical.label), checked: $stateParams.alarmType == 4 ? true : false},
                            { selectId: constsService.ALARM_LEVEL.major.id, label: appUtils.getString(constsService.ALARM_LEVEL.major.label), checked: $stateParams.alarmType == 3 ? true : false},
                            { selectId: constsService.ALARM_LEVEL.warn.id, label: appUtils.getString(constsService.ALARM_LEVEL.warn.label), checked: $stateParams.alarmType == 2 ? true : false},
                            { selectId: constsService.ALARM_LEVEL.info.id, label: appUtils.getString(constsService.ALARM_LEVEL.info.label), checked: $stateParams.alarmType == 1 ? true : false}
                            ],
                            defaultSelectid:constsService.ALARM_LEVEL.all.id,
                            display:true
                        },
                        click : function(){
                            $scope.callbackSearchCondition = 2;
                            $scope.startPage = 0;
                            $scope.currentAlarmTable.curPage = {
                                "pageIndex": 1
                            };
                            var value = $("#severity").widget().getSelectedId();
                            if (!_.isEmpty(value) && !_.isUndefined(value)) {
                                $scope.condition = "&severity=" + parseInt(value, 10);
                            }
                            mask.show();
                            _initTable();
                        }
                    },
                };

                $scope.currentAlarmTable = {
                    "id": "alarmTable",
                    "paginationStyle":"full_numbers",
                    "displayLength": constsService.TABLE_COUNT_PER_PAGE_BIG,
                    "isDraggedRemember": true,
                    "totalRecords": 0,
                    "checkbox": true,
                    "curPage": {
                        "pageIndex": 1
                    },
                    "enablePagination": true,
                    "lengthMenu": constsService.TABLE_LENGTH_AUTO_MENU,
                    "columns": [
                        { "sTitle": appUtils.getString("current_alarm_term_level_column"), "mData": "severity" },
                        { "sTitle": appUtils.getString("current_alarm_term_confirm_status_column"), "mData": "confirmStatus"},
                        { "sTitle": appUtils.getString("current_alarm_term_name_column"), "mData": "alarmName" },
                        { "sTitle": appUtils.getString("current_alarm_term_type_column"), "mData": "alarmType"},
                        { "sTitle": appUtils.getString("current_alarm_term_count_column"), "mData": "count"},
                        { "sTitle": appUtils.getString("current_alarm_term_source_column"), "mData": "moName" },
                        { "sTitle": appUtils.getString("current_alarm_term_first_time_column"), "mData": "firstTimeStr"},
                        { "sTitle": appUtils.getString("current_alarm_term_last_time_column"), "mData": "alarmTimeStr" },
                        { "sTitle": appUtils.getString("current_alarm_term_clear_time_column"), "mData": "clearTimeStr", "bVisible": !$scope.isCurrentAlarm},
                        {"mData": "params", bVisible: false},
                        { "mData": "entity", "bVisible": false},
                        { "mData": "alarmId", "bVisible": false }
                    ],
                    "data": [],
                    "callback": function (evtObj) {
                        $scope.startPage = evtObj.currentPage - 1;
                        $scope.pageSize = evtObj.displayLength;
                        mask.show();
                        _initTable();
                    },
                    "cellClickActive": function (e, param) {
                        $scope.current = param;
                        $scope.dealBtnShow();
                    },
                    "tHeadCheckboxFn": function (param, evt) {
                        $scope.dealBtnShow();
                    },
                    sortCallback: function (nNode, sortArr) {
                        $scope.startPage = 0;
                        var orderByStr = $scope.currentAlarmTable.columns[sortArr[0][0] - 1].mData;
                        if (!_.isEmpty(orderByStr)) {
                            if (orderByStr == "firstTimeStr") {
                                $scope.orderBy = "createTime";
                            } else if (orderByStr == "alarmTimeStr") {
                                $scope.orderBy = "modTime";
                            } else if (orderByStr == "clearTimeStr") {
                                $scope.orderBy = "clearTime";
                            } else {
                                $scope.orderBy = orderByStr;
                            }
                        } else {
                            $scope.orderBy = "";
                        }
                        $scope.orderType = sortArr[0][1];
                        mask.show();
                        _initTable();
                    },
                    "renderRow": function (nRow, aData, iDataIndex) {
                        var params = [];
                        _.each(aData["params"], function (d) {
                            params.push($.encoder.encodeForHTML(d));
                        });
                        var theConfirmUser = aData["confirmStatus"] === "1" ? aData["confirmUser"] : "";
                        theConfirmUser = "<font style=color:#008000>" + theConfirmUser + "</font>";
                        var alarmName = appUtils.getString(aData['alarmName'], params);
                        $("td:eq(1)", nRow).html(statusEnumService.getStatus("ALARM_LEVEL", aData["severity"]), "");
                        $("td:eq(2)", nRow).html(statusEnumService.getStatus("ALARM_CONFIRMED_STATUS", aData["confirmStatus"]) + " " + theConfirmUser, "");
                        $("td:eq(4)", nRow).html(statusEnumService.getStatus("ALARM_TYPE", aData["alarmType"]), "");
                        var optColumn = "<span class='btn-link' ng-click='toAlarmDetail()'>" + alarmName + "</span> ";
                        var optLink = $compile($(optColumn));
                        var optScope = $scope.$new();
                        optScope.data = aData;
                        optScope.toAlarmDetail = function () {
                            $scope.openWin("currentAlarmDetailWin",
                                appUtils.getString(constsService.COURRENT_ALARM_DETAIL_TITLE),
                                {entity: aData['entity'], isFirstViewGo: false}, "850px", "600px",
                                constsService.COURRENT_ALARM_DETAIL_URL);
                        };
                        var optNode = optLink(optScope);
                        $("td:eq(3)", nRow).html(optNode);
                        var optColumn = "<a href='javascript:void(0)' class='btn-link' ng-click='toCountDetail()'>" + aData['count'] + "</a> ";
                        var optLink = $compile($(optColumn));
                        var optScope = $scope.$new();
                        optScope.data = aData;
                        optScope.toCountDetail = function () {
                            $scope.openWin("currentCountDetailWin",
                                appUtils.getString(constsService.COURRENT_ALARM_COUNT_TITLE),
                                {"alarmId": aData['entity'], "name": alarmName}, "1000px", "600px",
                                constsService.COURRENT_ALARM_COUNT_URL);
                        };
                        var optNode = optLink(optScope);
                        $("td:eq(5)", nRow).html(optNode);
                    }
                };

                $scope.dealBtnShow = function () {
                    if ($scope.batchButton.length > 0) {
                        var num = $("#alarmTable").widget().getTableCheckedNums();
                        $scope.isShow = 0 < num;
                        $scope.batchButton[0].label = appUtils.getString("common_term_selected_label", num);
                        $scope.$apply();
                    }
                };

                $scope.openWin = function (winId, winTitle, paramObj, winWidth, winHeight, url, callback) {
                    var options = {
                        "winId": winId,
                        "title": winTitle,
                        "data": paramObj,
                        "height": winHeight,
                        "width": winWidth,
                        "modal": true,
                        "content-type": "url",
                        "draggable": true,
                        "content": url,
                        "minimizable": false,
                        "maximizable": false,
                        "buttons": [
                            {
                                key: "close",
                                label: appUtils.getString("common_term_close_button"),
                                focused: true,
                                handler: function (event) {
                                    $("#" + winId).widget().destroy();
                                    _.isFunction(callback) && callback();
                                }
                            }
                        ],
                        "close": function() {
                            !_.isEmpty(infoTransferredService.get("openstackRollbackTask", "taskId")) && infoTransferredService.remove("openstackRollbackTask", "taskId");
                        }
                    }
                    var win = new Window(options);
                    win.show();
                };

                $scope.batchDealAction = function (url, confirmMsg, resultMsg, dealType) {
                    var tableData = $("#alarmTable").widget().getTableCheckedItems();
                    var selectAlarmNum = $("#alarmTable").widget().getTableCheckedNums();
                    if (!utilService.isNotEmpty(tableData)) {
                        message.error(appUtils.getString("common_term_select_data_least_label"));
                        return false;
                    }
                    var params = [];
                    angular.forEach(tableData, function (obj, i) {
                        params.push({extTargetId: obj.entity, targetName: obj.alarmName});
                    });

                    if (url == constsService.ALARM_BATCH_DEAL.confirm) {
                        mask.show();
                        communicationService.put(utilService.getResouceUrl(url), params).promise().always(function(response) {
                            mask.hide();
                            if (exception.check(response)) {
                                if (utilService.isNotEmpty(response) && utilService.isNotEmpty(response.failCount)) {
                                    if (0 == response.failCount) {
                                        message.success({content: resultMsg, ok: function() {
                                                _initTable();
                                            }
                                        });
                                    } else {
                                        $scope.openWin("alarmClearFailWin", appUtils.getString(constsService.ALARM_CLEAR_ERROR_TITLE),
                                            response, "500px", "550px", constsService.COURRENT_BATCH_RESULT_URL, _initTable);
                                    }
                                }
                            } else {
                                selectAlarmNum > 0 && _.extend($scope.batchButton[0], {label: appUtils.getString("common_term_selected_label", selectAlarmNum)});
                                _initTable();
                                $scope.$evalAsync();
                            }
                        })
                        return;
                    }

                    message.warn({
                        content: confirmMsg,
                        ok: function() {
                            mask.show();
                            communicationService.put(utilService.getResouceUrl(url), params).promise().always(function(response) {
                                mask.hide();
                                if (exception.check(response)) {
                                    if (utilService.isNotEmpty(response) && utilService.isNotEmpty(response.failCount)) {
                                        if (0 == response.failCount) {
                                            message.success({
                                                content: resultMsg,
                                                ok: function() {
                                                    if ("clear" == dealType) {
                                                        _initTable();
                                                    }
                                                    _initTable();
                                                }
                                            });
                                        } else {
                                            $scope.openWin("alarmClearFailWin", appUtils.getString(constsService.ALARM_CLEAR_ERROR_TITLE),
                                                response, "500px", "550px", constsService.COURRENT_BATCH_RESULT_URL, _initTable);
                                        }
                                    }
                                } else {
                                    _initTable();
                                    if (selectAlarmNum > 0) {
                                        _.extend($scope.batchButton[0], {
                                            label: appUtils.getString("common_term_selected_label", selectAlarmNum)
                                        });
                                    }
                                }
                            })
                        }
                    });
                };

                _initTable();
            }]

        var module = angular.module('recoverydirector.monitor.config');
        module.tinyController('monitor.currentalarmlist.ctrl', ctrler);
        return module;
    })
