define(["tiny-common/UnifyValid"], function(UnifyValid) {
	"use strict";
	var ctrler = [
		"$scope",
		"$state",
		"$stateParams",
		"exception",
		"message",
		"communicationService",
		"utilService",
		"mask",
		"constsService",
		"appUtils",
		function($scope, $state, $stateParams ,exception, message,communicationService, utilService, mask,constsService,appUtils) {
			$scope.CRITICAL = appUtils.getString("alarm_term_critical_label");
			$scope.MAJOR = appUtils.getString("alarm_term_major_label");
			$scope.WARNING = appUtils.getString("alarm_term_warning_label");
			$scope.INFO = appUtils.getString("alarm_term_info_label");
			$scope.CHECKBOX = appUtils.getString("alarm_term_info_label");
			$scope.TYPE = appUtils.getString("common_term_type_label");
			$scope.ENABLE = appUtils.getString("alarm_term_enable_label");
			$scope.LEVEL = appUtils.getString("alarm_term_severity_label");
			$scope.LISTEN = appUtils.getString("alarm_term_voicetype_label");
			$scope.checkRight = appUtils.checkRight;

			$scope.configformTitle = appUtils.getString("alarm_term_setting_titlle");

			  $scope.model = {
	                enableCriticalSelect: {
	                    id: "enableCriticalSelect",
	                    width:constsService.W3,
	                    values : [{selectId : "-1", label :appUtils.getString("common_term_pleaseSelect_listbox")},{selectId : "1", label : appUtils.getString("alarm_term_traditional_label")}, {selectId : "2", label : appUtils.getString("alarm_term_loop_label")}],
	                    disabled:false,
	                    validate:"required"
	                },
	                enableCritical:{
	                	id: "enableCritical",
	                	text:"",
	                	checked:true,
	                	change:function(){
	                	    var c = $("#enableCritical").widget().option("checked");
	                	    if(c){
	                	    	$scope.model.enableCriticalSelect.disabled = false;
	                	    	$(".cls").eq(0).removeClass("iconbutton-listen-disabled").addClass("iconbutton-listen");
	                	    	$scope.enableCritical = true;
	                	    }else{
	                	    	$scope.model.enableCriticalSelect.disabled = true;
	                	    	$("#enableCriticalSelect").widget().opChecked("-1");
	                	    	$(".cls").eq(0).removeClass("iconbutton-listen").addClass("iconbutton-listen-disabled");
	                	    	$scope.enableCritical = false;
	                	    }
	                    }

	                },
	                enableMajorSelect: {
	                    id: "enableMajorSelect",
	                    width:constsService.W3,
	                    values : [{selectId : "-1", label :appUtils.getString("common_term_pleaseSelect_listbox")},{selectId : "1", label : appUtils.getString("alarm_term_traditional_label")}, {selectId : "2", label : appUtils.getString("alarm_term_loop_label")}],
	                    disabled:false,
	                    validate:"required"
	                },
	                enableMajor:{
	                	id: "enableMajor",
	                	text:"",
	                	checked:false,
	                	change:function(){
	                	var c = $("#enableMajor").widget().option("checked");
                	    if(c){
                	    	$scope.model.enableMajorSelect.disabled = false;
                	    	$(".cls").eq(1).removeClass("iconbutton-listen-disabled").addClass("iconbutton-listen");
                	    	$scope.enableMajor = true;
                	    }else{
                	    	$scope.model.enableMajorSelect.disabled = true;
                	    	$("#enableMajorSelect").widget().opChecked("-1");
                	    	$(".cls").eq(1).removeClass("iconbutton-listen").addClass("iconbutton-listen-disabled");
                	    	$scope.enableMajor = false;
                	    }
                    }
	                },
	                enableWarningSelect: {
	                    id: "enableWarningSelect",
	                    width:constsService.W3,
	                    disabled:false,
	                    values : [{selectId : "-1", label :appUtils.getString("common_term_pleaseSelect_listbox")},{selectId : "1", label : appUtils.getString("alarm_term_traditional_label")}, {selectId : "2", label : appUtils.getString("alarm_term_loop_label")}],
	                    validate:"required"
	                },
	                enableWarning:{
	                	id: "enableWarning",
	                	text:"",
	                	checked:false,
	                	change:function(){
	                	var c = $("#enableWarning").widget().option("checked");
                	    if(c){
                	    	$scope.model.enableWarningSelect.disabled = false;
                	    	$(".cls").eq(2).removeClass("iconbutton-listen-disabled").addClass("iconbutton-listen");
                	    	$scope.enableWarning  = true;
                	    }else{
                	    	$scope.model.enableWarningSelect.disabled = true;
                	    	$("#enableWarningSelect").widget().opChecked("-1");
                	    	$(".cls").eq(2).removeClass("iconbutton-listen").addClass("iconbutton-listen-disabled");
                	    	$scope.enableWarning = false;
                	    }
                      }
	                },
	                enableInfoSelect: {
	                    id: "enableInfoSelect",
	                    width:constsService.W3,
	                    disabled:false,
	                    values : [{selectId : "-1", label :appUtils.getString("common_term_pleaseSelect_listbox")},{selectId : "1", label : appUtils.getString("alarm_term_traditional_label")}, {selectId : "2", label : appUtils.getString("alarm_term_loop_label")}],
	                    validate:"required"
	                },
	                enableInfo:{
	                	id: "enableInfo",
	                	text:"",
	                	checked:false,
	                	change:function(){
	                	var c = $("#enableInfo").widget().option("checked");
                	    if(c){
                	    	$scope.model.enableInfoSelect.disabled = false;
                	    	$(".cls").eq(3).removeClass("iconbutton-listen-disabled").addClass("iconbutton-listen");
                	    	$scope.enableInfo = true;
                	    }else{
                	    	$scope.model.enableInfoSelect.disabled = true;
                	    	$("#enableInfoSelect").widget().opChecked("-1");
                	    	$(".cls").eq(3).removeClass("iconbutton-listen").addClass("iconbutton-listen-disabled");
                	    	$scope.enableInfo = false;
                	    }

                      }
	                }
			   };

			  $scope.btnOk = {
			            id: "btnCreateOk",
			            text: appUtils.getString("common_term_confirm_button"),
			            click: function() {
					    var validateResult = UnifyValid.FormValid($("#voiceSetting"), {focusInvalid: true})

		                if(!validateResult){
		                	return;
		                };
			        	 var audioArray = [];

			        	 var url = utilService.getResouceUrl("/audio")
			        	 var param = {};
			        	 param.isEnabledInfo = $("#enableInfo").widget().option("checked")
			        	 param.isEnabledWarn = $("#enableWarning").widget().option("checked")
			        	 param.isEnabledMajor = $("#enableMajor").widget().option("checked")
			        	 param.isEnabledCritical = $("#enableCritical").widget().option("checked");
			        	 param.audioInfo = $("#enableInfoSelect").widget().getSelectedId();
			        	 param.audioWarn = $("#enableWarningSelect").widget().getSelectedId();
			        	 param.audioMajor = $("#enableMajorSelect").widget().getSelectedId();
			             param.audioCritical = $("#enableCriticalSelect").widget().getSelectedId();
                         if (param.isEnabledInfo && param.audioInfo === "-1") {
                             message.error(appUtils.getString("common_term_required_message"));
                             return;
                         }
                         if (param.isEnabledWarn && param.audioWarn === "-1") {
                             message.error(appUtils.getString("common_term_required_message"));
                             return;
                         }
                         if (param.isEnabledMajor && param.audioMajor === "-1") {
                             message.error(appUtils.getString("common_term_required_message"));
                             return;
                         }
                         if (param.isEnabledCritical && param.audioCritical === "-1") {
                             message.error(appUtils.getString("common_term_required_message"));
                             return;
                         }

			        	 communicationService.put(url, param).promise().always(function(result){
			        		 if(exception.check(result)){
			        			 message.success({content:appUtils.getString("common_term_operation_success_label"),ok:function(){
			        				 _init();
			        			 }
			        	       })
			        		 }
			        	 });
			          }
			    };

	          $scope.btnCancel = {
	                id: "btnCreateCancel",
	                text: appUtils.getString("common_term_cancel_button"),
	                click: function() {
	        	       _init();
	                }
	           };

	          $scope.listen = function(_this, level) {
	        		var url,src ;
	        		var obj = document.getElementById("voicePlayer");
	        		var time = 3000;
	        		if (level) {
	        			src = _getVocieName(level);
	        			if(!src || src =="-1"){
	        				return;
	        			}
        				url = "/src/app/business/recoverydirector/monitor/views/alarm/audio/"+src+".mp3";
	        			obj = document.getElementById("voicePlayer");
	        		}
	        		obj.innerHTML = "<audio src='" + url + "' autoplay='autoplay'></audio>";

	        		var c = window.setTimeout(function() {
	        			obj.innerHTML = "";
	        			window.clearTimeout(c);
	        		}, time);
	        	};

	        	var _getVocieName = function(level){
	        		var name = $.encoder.encodeForHTML($.trim($("#"+level).widget().getSelectedId()));
	        		if(level == "enableCriticalSelect"){
	        			if(!$scope.enableCritical){
	        				return "";
	        			}
	        			if(name == "1"){
	        				return "critical"
	        			}
	        			if(name == "2"){
	        				return "critical_loop";
	        			}
	        		}
	        		if(level == "enableMajorSelect"){
	        			if(!$scope.enableMajor){
	        				return "";
	        			}
	        			if(name == "1"){
	        				return "major"
	        			}
	        			if(name == "2"){
	        				return "major_loop";
	        			}
	        		}
	        		if(level == "enableWarningSelect"){
	        			if(!$scope.enableWarning){
	        				return "";
	        			}
	        			if(name == "1"){
	        				return "warn"
	        			}
	        			if(name == "2"){
	        				return "warn_loop";
	        			}
	        		}
	        		if(level == "enableInfoSelect"){
	        			if(!$scope.enableInfo){
	        				return "";
	        			}
	        			if(name == "1"){
	        				return "info"
	        			}
	        			if(name == "2"){
	        				return "info_loop";
	        			}
	        		}
	        		return name;

	        	};

	        	var _init = function(){
	        		mask.show();

	        		 communicationService.get(utilService.getResouceUrl("/audio")).promise().always(function(result){
	        			    result = JSON.parse(result);
					    	if(exception.check(result)){
					    		$scope.enableCritical = result["critical-switch"] == "0"?false:true;
								$scope.enableMajor    = result["major-switch"] == "0"?false:true;
								$scope.enableWarning  = result["warn-switch"] == "0"?false:true;
								$scope.enableInfo     = result["info-switch"] == "0"?false:true;

								if($scope.enableCritical){
									$scope.model.enableCriticalSelect.defaultSelectid = result["critical-audio"];
									$scope.model.enableCritical.checked = true;
									$scope.model.enableCriticalSelect.disabled = false;
		                	    	$(".cls").eq(0).removeClass("iconbutton-listen-disabled").addClass("iconbutton-listen");
								}else{
									$scope.model.enableCriticalSelect.defaultSelectid = "-1";
									$scope.model.enableCritical.checked = false;
									$scope.model.enableCriticalSelect.disabled = true;
		                	    	$(".cls").eq(0).addClass("iconbutton-listen-disabled").removeClass("iconbutton-listen");
								}
								if($scope.enableMajor){
									$scope.model.enableMajorSelect.defaultSelectid = result["major-audio"];
									$scope.model.enableMajor.checked = true;
									$scope.model.enableMajorSelect.disabled = false;
		                	    	$(".cls").eq(1).removeClass("iconbutton-listen-disabled").addClass("iconbutton-listen");
								}else{
									$scope.model.enableMajorSelect.defaultSelectid = "-1";
									$scope.model.enableMajor.checked = false;
									$scope.model.enableMajorSelect.disabled = true;
		                	    	$(".cls").eq(1).addClass("iconbutton-listen-disabled").removeClass("iconbutton-listen");
								}
								if($scope.enableWarning){
									$scope.model.enableWarningSelect.defaultSelectid = result["warn-audio"];
									$scope.model.enableWarning.checked = true;
									$scope.model.enableWarningSelect.disabled = false;
		                	    	$(".cls").eq(2).removeClass("iconbutton-listen-disabled").addClass("iconbutton-listen");
								}else{
									$scope.model.enableWarning.checked = false;
									$scope.model.enableWarningSelect.defaultSelectid = "-1";
									$scope.model.enableWarningSelect.disabled = true;
		                	    	$(".cls").eq(2).addClass("iconbutton-listen-disabled").removeClass("iconbutton-listen");
								}
								if($scope.enableInfo){
									$scope.model.enableInfoSelect.defaultSelectid = result["info-audio"];
									$scope.model.enableInfo.checked = true;
									$scope.model.enableInfoSelect.disabled = false;
		                	    	$(".cls").eq(3).removeClass("iconbutton-listen-disabled").addClass("iconbutton-listen");
								}else{
									$scope.model.enableInfo.checked = false;
									$scope.model.enableInfoSelect.defaultSelectid = "-1";
									$scope.model.enableInfoSelect.disabled = true;
		                	    	$(".cls").eq(3).addClass("iconbutton-listen-disabled").removeClass("iconbutton-listen");
								}
								mask.hide();
								$scope.$apply();
					    	}
					  });
	        	};

	        	_init();
			}]

	var module = angular.module('recoverydirector.monitor.config');
	module.tinyController('monitor.audioSetting.ctrl', ctrler);
	return module;
})
