define([],
    function () {
        "use strict";
        var countCtrl = [
            "$scope",
            "$state",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            function ($scope, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils) {
                $scope.FROM = appUtils.getString("common_term_from_label");
                $scope.TO = appUtils.getString("common_term_to_label");
                $scope.advance = {
                    labels: {
                        source: appUtils.getString("current_alarm_term_source_column") + ":",
                        type: appUtils.getString("current_alarm_term_type_column") + ":",
                        confirmStatus: appUtils.getString("current_alarm_term_confirm_status_column") + ":",
                        occurredTime: appUtils.getString("current_alarm_term_occurred_time_label") + ":"
                    },
                    alarmLevel: {
                        labels: {
                            level: appUtils.getString("current_alarm_term_level_column") + ":",
                            critical: appUtils.getString(constsService.ALARM_LEVEL.critical.label),
                            major: appUtils.getString(constsService.ALARM_LEVEL.major.label),
                            warn: appUtils.getString(constsService.ALARM_LEVEL.warn.label),
                            info: appUtils.getString(constsService.ALARM_LEVEL.info.label)
                        },
                        click: function (e, level) {
                            if (!constsService.isNotEmpty(level)) {
                                return false;
                            }
                            switch (level) {
                                case "critical":

                                    return;
                            }
                        }
                    },
                    type: {
                        id: "type",
                        values: [
                            {"selectId": "", "label": appUtils.getString("common_term_all_label"), "checked": true},
                            {"selectId": "1", "label": appUtils.getString("alarm_term_type_comm")},
                            {"selectId": "2", "label": appUtils.getString("alarm_term_type_env")},
                            {"selectId": "3", "label": appUtils.getString("alarm_term_type_dev")},
                            {"selectId": "4", "label": appUtils.getString("alarm_term_type_business")},
                            {"selectId": "5", "label": appUtils.getString("alarm_term_type_operation")},
                            {"selectId": "6", "label": appUtils.getString("alarm_term_type_security")}
                        ],
                        width: constsService.W3,
                        change: function () {

                        }
                    },
                    confirmStatus: {
                        id: "confirmStatus",
                        values: [
                            {"selectId": "", "label": appUtils.getString("common_term_all_label"), "checked": true},
                            {"selectId": "1", "label": appUtils.getString("alarm_term_confirm_label")},
                            {"selectId": "0", "label": appUtils.getString("alarm_term_unconfirm_label")}
                        ],
                        width: constsService.W3,
                        change: function () {

                        }
                    },
                    source: {
                        id: "source",
                        value: "",
                        validate: "",
                        width: constsService.W3
                    },
                    startDate: {
                        id: "startDate",
                        type: "datetime",
                        dateFormat: 'yy-mm-dd',
                        timeFormat: "h:mm:ss",
                        "ampm": true
                    },
                    endDate: {
                        id: "endDate",
                        type: "datetime",
                        dateFormat: 'yy-mm-dd',
                        timeFormat: "h:mm:ss",
                        disable: false,
                        "ampm": true
                    },
                    btnOK: {
                        id: "btnOK",
                        text: appUtils.getString("common_term_search_button"),
                        click: function () {

                        }
                    }

                }
            } ]
        var alarmCountApp = angular.module("app.current.alarm.advanceSearch", [ "framework" ]);
        alarmCountApp.controller("app.current.alarm.advanceSearch.ctrl", countCtrl);
        return alarmCountApp;
    })