define([],
    function () {
        "use strict";
        var batchResultCtrl = [
            "$scope",
            "$state",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            function ($scope, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils) {
                var param = $("#alarmClearFailWin").widget().option("data");

                function updateUI(param) {
                    if (utilService.isNotEmpty(param.result)) {
                        var arr = [];
                        _.each(param.result, function (response) {
                            var alarmName = appUtils.getString($.encoder.encodeForHTML(response.targetName));
                            var errorMsg = appUtils.getString($.encoder.encodeForHTML("lego.err." + response.errorCode));
                            if (param.isCheckResult) {
                                alarmName = $.encoder.encodeForHTML(response.targetName);
                                errorMsg = !response.errorObject ? appUtils.getString("common_term_operation_success_label") : exception.check(response.errorObject, false);
                            }
                            var temp = {
                                targetName: alarmName,
                                errorCode: errorMsg
                            }
                            arr.push(temp);
                        })
                        $scope.batchResultTable.data = arr;
                        $scope.obj = [
                            {
                                count: appUtils.getString("current_alarm_term_batch_result_total", param.totalCount)
                            },
                            {
                                count: appUtils.getString("current_alarm_term_batch_result_success", param.succeedCount)
                            },
                            {
                                count: appUtils.getString("current_alarm_term_batch_result_fail", param.failCount)
                            }
                        ];
                        $scope.$apply();
                    }
                };
                $scope.batchResultTable = {
                    id: "batchResultTable",
                    enablePagination: false,
                    "columns": [
                        {
                            "sTitle": appUtils.getString("current_alarm_term_name_column"),
                            "mData": "targetName"
                        },
                        { "sTitle": appUtils.getString("common_term_detail_label"),
                            "mData": "errorCode"
                        }
                    ],
                    data: [],
                    renderRow: function (nRow, aData, iDataIndex) {
                    }
                };
                updateUI(param);
            } ]
        var batchResultApp = angular.module("recoverydirector.monitor.config");
        batchResultApp.tinyController("app.batch.result.ctrl", batchResultCtrl);
        return batchResultApp;
    })
