define([],
    function () {
        "use strict";
        var countCtrl = [
            "$scope",
            "$state",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "statusEnumService",
            "mask",
            "constsService",
            "appUtils",
            function ($scope, $state, $stateParams, exception, message, communicationService, utilService, statusEnumService, mask, constsService, appUtils) {
                $scope.orderBy = "modTime";
                $scope.orderType = "desc";
                var startPage = constsService.start;
                var pageSize = constsService.pageSize;
                var widget = $("#currentCountDetailWin").widget().option("data");
                var name = _.isUndefined(widget.name) || _.isEmpty(widget.name) ? "--" : $.encoder.encodeForHTML(widget.name);
                $scope.NAME_LABEL = appUtils.getStringWithColon("current_alarm_term_name_column") + name;
                var _updateUI = function (result) {
                    mask.hide();
                    if (exception.check(result)) {
                        var arr = [];
                        _.each(result.records, function (d) {
                            d.clearUser = $.encoder.encodeForHTML(d.clearUser);
                            d.confirmTimeStr = $.encoder.encodeForHTML(d.confirmTimeStr);
                            d.timeStr = $.encoder.encodeForHTML(d.timeStr);
                            d.clearTimeStr = $.encoder.encodeForHTML(d.clearTimeStr);
                            d.confirmUser = $.encoder.encodeForHTML(d.confirmUser);
                            var tmo = _.pick(d, "id", "timeStr", "confirmStatus", "confirmTimeStr", "clearStatus", "clearTimeStr", "notifyType", "confirmUser", "clearUser");
                            arr.push(tmo);
                        });
                        $scope.alarmCountDetailTable.data = arr;
                        $scope.alarmCountDetailTable.totalRecords = result["totalCount"];
                        if ($scope.alarmCountDetailTable.totalRecords > constsService.TABLE_COUNT_PER_PAGE) {
                            $scope.alarmCountDetailTable.enablePagination = true;
                        } else {
                            $scope.alarmCountDetailTable.enablePagination = false;
                        }
                        $scope.$apply();
                    }
                };
                var _init = function () {
                    var alarmId = $.encoder.encodeForURL(widget.alarmId);
                    var url = "/alarms/" + alarmId + "/alarmCountDetail?startPage=" + startPage +"&pageSize=" + pageSize + "&orderBy=" + $scope.orderBy + "&orderType=" + $scope.orderType;
                    mask.show();
                    communicationService.get(utilService.getResouceUrl(url)).promise().always(_updateUI);
                }

                $scope.alarmCountDetailTable = {
                    "id": "alarmCountDetailTable",
                    "displayLength": constsService.TABLE_COUNT_PER_PAGE,
                    "enablePagination": false,
                    "totalRecords":0,
                    "currPage": {
                        "pageIndex": 1
                    },
                    "columns": [
                        {"mData": "id", "bVisible": false},
                        { "sTitle": appUtils.getString("current_alarm_term_occurred_time_label"), "mData": "timeStr" },
                        { "sTitle": appUtils.getString("current_alarm_term_confirm_status_column"), "mData": "confirmStatus", "sWidth": "10%"},
                        { "sTitle": appUtils.getString("current_alarm_term_confirm_time_column"), "mData": "confirmTimeStr" },
                        { "sTitle": appUtils.getString("current_alarm_term_clear_status_column"), "mData": "clearStatus", "sWidth": "10%"},
                        { "sTitle": appUtils.getString("current_alarm_term_clear_time_column"), "mData": "clearTimeStr"},
                        { "sTitle": appUtils.getString("current_alarm_term_notice_type_column"), "mData": "notifyType", "bSortable": false},
                        {"mData": "confirmUser", "bVisible": false},
                        {"mData": "clearUser", "bVisible": false}
                    ],
                    "data": [],
                    "renderRow": function (nRow, aData, iDataIndex) {
                        var confirmColor = "", clearColor = "";
                        if (0 == aData["confirmStatus"]) {
                            confirmColor = "#e83917";
                        } else if (1 == aData["confirmStatus"]) {
                            confirmColor ="#008000";
                        }

                        if (0 == aData["clearStatus"]) {
                            clearColor = "#e83917";
                        } else if (1 == aData["clearStatus"]) {
                            clearColor ="#008000";
                        }

                        $("td:eq(1)", nRow).html(statusEnumService.getStatus("ALARM_CONFIRMED_STATUS", aData["confirmStatus"]) + " " + "<font style=color:" + confirmColor + ">" + $.encoder.encodeForHTML(aData['confirmUser']) + "</font>", "");
                        $("td:eq(3)", nRow).html(statusEnumService.getStatus("ALARM_CLEAR_STATUS", aData["clearStatus"]) + " " + "<font style=color:" + clearColor + ">" + $.encoder.encodeForHTML(aData['clearUser']) + "</font>", "");
                        $("td:eq(5)", nRow).html(statusEnumService.getStatus("ALARM_NOTIF_YTYPE_STATUS", aData["notifyType"]), "");
                    },
                    sortCallback: function (nNode, sortArr) {
                        var orderBy = $scope.alarmCountDetailTable.columns[sortArr[0][0]].mData;
                        switch (orderBy) {
                            case "timeStr" :
                                $scope.orderBy = "modTime";
                                break;
                            case "confirmTimeStr":
                                $scope.orderBy = "confirmTime";
                                break;
                            case "clearTimeStr" :
                                $scope.orderBy = "clearTime";
                                break;
                            default :
                                $scope.orderBy = orderBy;
                        }
                        $scope.orderType = sortArr[0][1];
                        startPage = 0;
                        _init();
                    },
                    callback : function (evtObj){
                    	startPage = evtObj.currentPage - 1;
                    	pageSize = evtObj.displayLength;
                    	_init();
                    }
                };

                _init();

            } ]
        var alarmCountApp = angular.module("recoverydirector.monitor.config");
        alarmCountApp.tinyController("app.current.alarm.count.ctrl", countCtrl);
        return alarmCountApp;
    })