define(["tiny-common/UnifyValid"],
    function (UnifyValid) {
        "use strict";
        var detailCtrl = [
            "$scope",
            "$sce",
            "$state",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            "infoTransferredService",
            function ($scope, $sce, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils, statusEnumService, infoTransferredService) {
                var entity = $.encoder.encodeForURL($("#currentAlarmDetailWin").widget().option("data").entity);

                $scope.basicInfoTitle = appUtils.getString("current_alarm_term_win_abstract_label");
                $scope.recommendAdviceTitle = appUtils.getString("current_alarm_term_win_recommendAdvice_label");
                $scope.experiencesTitle = appUtils.getString("current_alarm_term_win_experiences_label");

                $scope.btnSave = {
                    id: "btnSave",
                    text: appUtils.getString("common_term_save_button"),
                    click: function () {
                        if (!UnifyValid.FormValid($("#alarmDetailDiv"), {focusInvalid: true})) {
                            return;
                        }
                        var text = $("#maintenance_experiences").widget().getValue();
                        var url = utilService.getResouceUrl("/alarms/" + entity + "/action/alarmExperiences");
                        communicationService.post(url, {experience: text}).promise().always(function (response) {
                            if (exception.check(response)) {
                                message.success({content: appUtils.getString("common_term_operation_success_label"), ok: function () {
                                    $("#maintenance_experiences").widget().option("value", "");
                                    _initTableAction();
                                }})
                            }
                        }, function (response) {
                            exception.check(response);
                        })
                    }
                }
                $scope.btnCancel = {
                    id: "btnCancel",
                    text: appUtils.getString("common_term_cancel_button"),
                    click: function () {
                        $("#maintenance_experiences").widget().option("value", "");
                    }
                }
                $scope.experiences = {
                    labels: appUtils.getString("current_alarm_term_win_addexperiences_label"),
                    id: "maintenance_experiences",
                    labelcls: "tiny_formfield_label_hide",
                    contentTdAttr: {colspan: "2"},
                    type: "multi",
                    require: true,
                    width: "780px",
                    height: constsService.DESCR_HEIGHT,
                    validate: "required;maxSize(128):" + appUtils.getString("validate_term_expr_length")
                }

                $scope.experiencesTable = {
                    "id": "experiencesTable",
                    "columns": [
                        {
                            "mData": "id",
                            "bVisible": false
                        },
                        {
                            "mData": "alertId",
                            "bVisible": false
                        },
                        {
                            "sTitle": appUtils.getString("current_alarm_term_win_description_column"),
                            "mData": "experience",
                            "bSortable": true
                        },
                        {
                            "sTitle": appUtils.getString("current_alarm_term_win_admin_column"),
                            "mData": "userName",
                            "bSortable": true
                        },
                        {
                            "sTitle": appUtils.getString("current_alarm_term_win_time_column"),
                            "mData": "timeStr",
                            "bSortable": true
                        }
                    ],
                    cellClickActive: function (e, param) {
                        $scope.current = param;
                    },
                    data: [],
                    opAreaConfig: [
                        {
                            id: "iconBtnDel",
                            authKey: "lego.evtMgr.curtAlarm.experiences",
                            template: "<div class='iconbutton-delete' title='" + appUtils.getString('common_term_delete_button') + "'></div>",
                            clickActive: function () {
                                $scope.id = $("#experiencesTable").widget().getHoverData()[0].id;
                                message.warn({content: appUtils.getString("current_alarm_term_delete_exper_lable"), ok: function () {
                                    var url = utilService.getResouceUrl("/alarms/action/alarmExperiences");
                                    var ids = [];
                                    ids.push($scope.id);
                                    mask.show();
                                    communicationService.remove(url, ids).promise().always(function (response) {
                                        mask.hide();
                                        if (exception.check(response)) {
                                            message.success({content: appUtils.getString("common_term_operation_success_label"), ok: function () {
                                                _initTableAction();
                                            }})
                                        }
                                    }, function (response) {
                                        exception.check((response));
                                    })
                                }})
                            }
                        }
                    ],
                    renderRow: function (nRow, aData, iDataIndex) {}
                };

                var _isEmpty = function (val) {
                    return _.isEmpty(val) || _.isUndefined(val);
                }

                var _formatHtmlText = function (msg) {
                    if (_isEmpty(msg)) {
                        return "--";
                    }

                    var ele = "<table width='100%' border='0'>";
                    var data = $.trim(msg).split("<br>"), trElement = "";
                    _.each(data, function (value, index) {
                        if(!_isEmpty($.trim(value))) {
                            trElement += "<tr><td style='padding:0px 4px;word-wrap:break-word;line-height:25px'>" + value + "</td></tr>";
                        }
                    });
                    return $(ele).append(trElement + "</table>");
                }

                var _initUI = function () {
                    _initRight();
                    communicationService.get(utilService.getResouceUrl("/alarms/" + entity)).promise().always(function (result) {
                        if (exception.check(result)) {
                        	var params = [];
                        	_.each(result.params, function (d) {
                        		params.push(d);
                        	});
                        	if ("0x3230019.alarm.desc" === result.alarmDesc){
                        		params[0] = params[0] != 4 ? constsService.CURRENT_ALARM_DETAIL_APP[params[0]] : appUtils.getString(constsService.CURRENT_ALARM_DETAIL_APP[params[0]]);
                        	}

                            if (_.contains(["0x3230028.alarm.advice"], result.advice)) {
                                !_.isEmpty(params[0]) && (infoTransferredService.put("openstackRollbackTask", "taskId", params[0]));
                            }
                            //操作日志上报
                            if ("0x3230042.alarm.desc" == result.alarmDesc){
                                params[0] == "administratorlog" && (params[0] = appUtils.getString("setting_syslog_report_role_admin_label"))
                            }

                            $scope.summery = [
                                {
                                    "key_1": appUtils.getStringWithColon("current_alarm_term_level_column"),
                                    "value_1": $sce.trustAsHtml(statusEnumService.getValueByKey("ALARM_LEVEL", result.severity)),
                                    "key_2": appUtils.getStringWithColon("current_alarm_term_confirm_status_column"),
                                    "value_2": $sce.trustAsHtml(statusEnumService.getValueByKey("ALARM_CONFIRMED_STATUS", result.confirmStatus))
                                },
                                {
                                    "key_1": appUtils.getStringWithColon("current_alarm_term_confirm_user_label"),
                                    "value_1": $sce.trustAsHtml(_isEmpty(result.confirmUser) ? "--" : result.confirmUser),
                                    "key_2": appUtils.getStringWithColon("current_alarm_term_confirm_time_label"),
                                    "value_2": $sce.trustAsHtml(_isEmpty(result.confirmTimeStr) ? "--" : result.confirmTimeStr)
                                },
                                {
                                    "key_1": appUtils.getStringWithColon("current_alarm_term_name_column"),
                                    "value_1": $sce.trustAsHtml(_isEmpty(result.alarmName) ? "--" : appUtils.getString(result.alarmName, params)),
                                    "key_2": appUtils.getStringWithColon("current_alarm_term_source_column"),
                                    "value_2": $sce.trustAsHtml(_isEmpty(result.moName) ? "--" : result.moName)
                                },
                                {
                                    "key_1": appUtils.getStringWithColon("current_alarm_term_first_time_column"),
                                    "value_1": $sce.trustAsHtml(_isEmpty(result.firstTimeStr) ? "--" : result.firstTimeStr),
                                    "key_2": appUtils.getStringWithColon("current_alarm_term_last_time_column"),
                                    "value_2": $sce.trustAsHtml(_isEmpty(result.alarmTimeStr) ? "--" : result.alarmTimeStr)
                                },
                                {
                                    "key_1": appUtils.getStringWithColon("current_alarm_term_clear_status_label"),
                                    "value_1": $sce.trustAsHtml(statusEnumService.getValueByKey("ALARM_CLEAR_STATUS", result.clearStatus)),
                                    "key_2": appUtils.getStringWithColon("current_alarm_term_clear_user_label"),
                                    "value_2": $sce.trustAsHtml(_isEmpty(result.clearUser) ? "--" : result.clearUser)
                                },
                                {
                                    "key_1": appUtils.getStringWithColon("current_alarm_term_clear_time_label"),
                                    "value_1": $sce.trustAsHtml(_isEmpty(result.clearTimeStr) ? "--" : result.clearTimeStr),
                                    "key_2": appUtils.getStringWithColon("current_alarm_term_type_column"),
                                    "value_2": $sce.trustAsHtml(statusEnumService.getValueByKey("ALARM_TYPE", result.alarmType))
                                },
                                {
                                    "key_1": appUtils.getStringWithColon("current_alarm_term_desc_label"),
                                    "value_1": $sce.trustAsHtml(_isEmpty(result.alarmDesc) ? "--" : appUtils.getString(result.alarmDesc, params)),
                                    "key_2": "",
                                    "value_2": ""
                                }
                            ];
                            var temp = {};
                            _.each($scope.summery, function(item, index) {
                                var firstKey = temp["last_key"];
                                var firstValue = temp["last_value"];
                                temp["last_key"] = item["key_2"];
                                temp["last_value"] = item["value_2"];
                                if (index == 0) {
                                    item["key_2"] = appUtils.getStringWithColon("common_term_id_label");
                                    item["value_2"] = $sce.trustAsHtml(_.isEmpty(result.alarmId) ? "--" : result.alarmId);
                                } else {
                                    item["key_2"] = item["key_1"];
                                    item["value_2"] = item["value_1"];
                                    item["key_1"] = firstKey;
                                    item["value_1"] = firstValue;
                                }
                            });
                            $scope.recommendMsg = appUtils.getString($.encoder.encodeForHTML(result.advice), params);
                            _initTableAction();
                        }

                    });
                }

                $scope.userRight = {};
                var _initRight = function () {
                    var addRight = appUtils.checkRight("lego.evtMgr.curtAlarm.experiences");
                    if (addRight) {
                        $scope.userRight.experiencesAdd = true;
                    } else {
                        $scope.userRight.experiencesAdd = false;
                    }
                    $scope.experiencesTable.opAreaConfig = appUtils.flilterOperRight($scope.experiencesTable.opAreaConfig);
                };

                var _initTableAction = function () {
                    communicationService.get(utilService.getResouceUrl("/alarms/" + entity + "/action/alarmExperiences")).promise().always(function (r) {
                        if (exception.check(r)) {
                            var arr = [];
                            _.each(r, function (d) {
                                d.experience = $.encoder.encodeForHTML(d.experience);
                                d.timeStr =  $.encoder.encodeForHTML(d.timeStr);
                                d.userName = $.encoder.encodeForHTML(d.userName);
                                var tmo = _.pick(d, "id", "alertId", "experience", "userName", "timeStr");
                                arr.push(tmo);
                            });
                            $scope.experiencesTable.data = arr;
                            $scope.$apply();
                        }
                    })
                }

                window['startOpenStackTask'] = function() {
                    mask.show();
                    communicationService.put(utilService.getResouceUrl("/rollbacktask/action/run"), {"taskId": infoTransferredService.get("openstackRollbackTask", "taskId")}).promise().always(function (r) {
                        mask.hide();
                        if (exception.check(r)) {
                            message.prompt({content: appUtils.getString("common_term_operationsyn_success_label"), ok: function(){
                                $("#currentAlarmDetailWin").widget().destroy();
                            }});
                        }
                    });

                }

                _initUI();
                setTimeout(function () {
                    $("#recommendMsg").html(_formatHtmlText($scope.recommendMsg));
                }, 500);
            } ]
        var alarmDetailApp = angular.module("recoverydirector.monitor.config");
        alarmDetailApp.tinyController("app.current.alarm.detail.ctrl", detailCtrl);
        return alarmDetailApp;
    })
