define([],
    function () {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "$compile",
            "exception",
            "message",
            "communicationService", "utilService", "mask", "appUtils", "constsService", "statusEnumService",
            function ($scope, $state, $stateParams, $compile, exception, message, communicationService, utilService, mask, appUtils, constsService, statusEnumService) {
                $scope.startPage = 0;
                $scope.pageSize = 15;
                $scope.orderBy = "pgName";
                $scope.orderType = "desc";
                $scope.queryTime = constsService.QUERY_TIME.all;
                $scope.checkRight = appUtils.checkRight;
                $scope.refreshTitle = appUtils.getString("common_term_refresh_button");

                var language = appUtils.resource().union();
                function _updateUI() {
                    var url = utilService.getResouceUrl("/reports/protectionreports/?orderBy=" + $scope.orderBy + "&orderType=" + $scope.orderType + "&startPage=" +
                        $scope.startPage + "&pageSize=" + $scope.pageSize + "&queryTime=" + $scope.queryTime);
                    mask.show();
                    communicationService.get(url).promise().always(function (result) {
                        mask.hide();
                        if (exception.check(result)) {
                            var arr = [];
                            _.each(result.records, function (d) {
                                var cfgRPO = "";
                                if(angular.isArray(d.RPO_ITEM_KEY) && d.RPO_ITEM_KEY.length != 0 ){
                                    if (d.RPO_ITEM_KEY.length > 1) {
                                        _.each(d.RPO_ITEM_KEY, function(obj){
                                            cfgRPO += appUtils.maxMsTimeUnit(obj.configuredRPO)+",";
                                        });
                                    }else {
                                        cfgRPO = appUtils.maxMsTimeUnit(d.RPO_ITEM_KEY[0].configuredRPO);
                                    }
                                }
                                if (cfgRPO.indexOf(",") != -1) {
                                    cfgRPO = cfgRPO.substr(0, cfgRPO.length -1);
                                }

                                var actualRPO = "";
                                if(angular.isArray(d.RPO_ITEM_KEY) && d.RPO_ITEM_KEY.length != 0 ){
                                    if (d.RPO_ITEM_KEY.length > 1) {
                                        _.each(d.RPO_ITEM_KEY, function(obj){
                                            actualRPO += appUtils.maxMsTimeUnit(obj.actualRPO)+",";
                                        });
                                    }else {
                                        actualRPO = appUtils.maxMsTimeUnit(d.RPO_ITEM_KEY[0].actualRPO);
                                    }
                                }
                                if (actualRPO.indexOf(",") != -1) {
                                    actualRPO = actualRPO.substr(0, actualRPO.length -1);
                                }

                                var estimateRTO = "";
                                if(angular.isArray(d.RTO_ITEM_KEY) && d.RTO_ITEM_KEY.length != 0 ){
                                    if (d.RTO_ITEM_KEY.length > 1) {
                                        _.each(d.RTO_ITEM_KEY, function(obj){
                                            estimateRTO += appUtils.maxMsTimeUnit(obj.estimateRTO)+",";
                                        });
                                    }else {
                                        estimateRTO = appUtils.maxMsTimeUnit(d.RTO_ITEM_KEY[0].estimateRTO);
                                    }

                                }
                                if (estimateRTO.indexOf(",") != -1) {
                                    estimateRTO = estimateRTO.substr(0, estimateRTO.length -1);
                                }


                                d.cfgRPO = "" == cfgRPO ? "--" : cfgRPO;
                                d.actualRPO  = "" == actualRPO ? "--" : actualRPO;
                                d.estimateRTO = "" == estimateRTO ? "--" : estimateRTO;
                                var tmo = _.pick(d, "uuid", "name", "replicationType", "productSite", "recoverySite", "poType", "cfgRPO", "actualRPO", "estimateRTO", "totalNum", "successNum");
                                arr.push(tmo);
                            });
                            var exportBtn = $("#btnExport").widget();
                            if(exportBtn){
                                if (arr.length < 1){
                                    exportBtn.option("disable",true);
                                }else{
                                    exportBtn.option("disable",false);
                                }
                            }
                            $scope.groupCountTable.data = appUtils.encodeForHTML(arr);
                            $scope.groupCountTable.totalRecords = result["totalCount"];
                            $scope.groupCountTable.enablePagination = $scope.groupCountTable.totalRecords > constsService.TABLE_COUNT_PER_PAGE_BIG ? true : false;
                            $scope.$apply();
                        }
                        else {
                            $scope.groupCountTable.enablePagination = false;
                            $scope.$apply();
                        }
                    });
                };

                $scope.refreshData = function() {

                 $("#queryTime").widget().option("default-selectid", constsService.QUERY_TIME.all);
                 $scope.groupCountTable.curPage = {
                        "pageIndex": 1
                 };
                 $scope.startPage = 0;
                 $scope.pageSize = 15;
                 $scope.queryTime = constsService.QUERY_TIME.all;
                 _updateUI();
               }

                $scope.model = {
                    exportBtn: {
                        id: "btnExport",
                        text: appUtils.getString("common_term_exportall_button"),
                        click: function () {
                            appUtils.export("/reports/action/exportProtectGroupReport");
                        }
                    },
                    timeRang: {
                        id: "timeRang",
                        values: [
                            {
                                selectId: '1',
                                label: appUtils.getString("common_term_time_rang_label"),
                                checked: true
                            }
                        ],
                        width: constsService.W2,
                        defaultSelectid: "1",
                        isSearchbox:false,
                        timeOptions:{
                            id:"queryTime",
                            values:[
                            {
                                selectId: constsService.QUERY_TIME.all,
                                label: appUtils.getString("common_term_all_label"),
                                checked: true
                            },
                            {
                                selectId: constsService.QUERY_TIME.Time_24Hours,
                                label: appUtils.getString("common_term_latest_one_day_value")
                            },
                            {
                                selectId: constsService.QUERY_TIME.threeDays,
                                label: appUtils.getString("common_term_latest_three_day_value")
                            },
                            {
                                selectId: constsService.QUERY_TIME.Time_7Day,
                                label: appUtils.getString("common_term_latest_one_week_value")
                            },
                            {
                                selectId: constsService.QUERY_TIME.Time_30Days,
                                label: appUtils.getString("common_term_latest_thirty_day_value")
                            }
                            ],
                            defaultSelectid:constsService.QUERY_TIME.all
                        },
                        click:function(){
                            $scope.queryTime = $("#queryTime").widget().getSelectedId();
                            $scope.startPage = 0;
                            $scope.groupCountTable.curPage = {
                                    "pageIndex": 1
                             };
                            _updateUI();
                        }
                    },
                };

                $scope.covertText = function(value) {
                    var str = value.substr(value.indexOf("("));
                    if (_.has(language, str.substr(1, str.length - 2))) {
                        return value.substr(0, value.indexOf("(")) + "(" + language[str.substr(1, str.length - 2)] + ")";
                    }
                    return value;
                }

                $scope.groupCountTable = {
                    "id": "groupCountTable",
                    "paginationStyle":"full_numbers",
                    "displayLength": 15,
                    "totalRecords": 0,
                    "checkbox": true,
                    "enablePagination": true,
                    "curPage": {
                        "pageIndex": 1
                    },
                    "columns": [
                        {"mData": "uuid", "bVisible": false},
                        { "sTitle": appUtils.getString("group_count_term_name_column"), "mData": "name" },
                        { "sTitle": appUtils.getString("group_count_term_poliy_templet_column"), "mData": "replicationType", "bSortable":false},
                        { "sTitle": appUtils.getString("group_count_term_product_site_column"), "mData": "productSite", "bSortable":false},
                        { "sTitle": appUtils.getString("group_count_term_disaster_site_column"), "mData": "recoverySite", "bSortable":false},
                        { "sTitle": appUtils.getString("group_count_term_protect_object_type_column"), "mData": "poType", "bSortable":false},
                        { "sTitle": appUtils.getString("group_count_term_configured_RPO_column"), "mData": "cfgRPO", "bSortable":false},
                        { "sTitle": appUtils.getString("group_count_term_current_RPO_column"), "mData": "actualRPO", "bSortable":false},
                        { "sTitle": appUtils.getString("group_count_term_evaluate_RPO_column"), "mData": "estimateRTO", "bSortable":false},
                        {
                            "sTitle": appUtils.getString("group_count_term_excute_result_column"),
                            "mData": "totalNum",
                            "bSortable":false,
                            "sWidth": "13%"
                        },
                        {
                            "mData": "successNum",
                            "bVisible": false
                        }
                    ],
                    "data": [],
                    "callback": function (evtObj) {
                        $scope.startPage = evtObj.currentPage - 1;
                        $scope.pageSize = evtObj.displayLength;
                        _updateUI();
                    },
                    sortCallback: function (nNode, sortArr) {
                        $scope.startPage = 0;
                        var sortField = $scope.groupCountTable.columns[sortArr[0][0]].mData;
                        if ("name" == sortField) {
                            sortField = "pgName";
                        }
                        $scope.orderBy = sortField;
                        $scope.orderType = sortArr[0][1];
                        _updateUI();
                    },
                    "renderRow": function (nRow, aData, iDataIndex) {
                        var successPer = aData["successNum"] * 100 / aData["totalNum"];
                        var failPer = (aData["totalNum"] - aData["successNum"]) * 100 / aData["totalNum"];
                        var excuteResultColumn = "<tiny-rainbowbar id='id' config='config' width='width' barwidth='barwidth'></tiny-rainbowbar>";
                        var excuteResultLink = $compile(excuteResultColumn);
                        var excuteResultScope = $scope.$new();
                        excuteResultScope.id = "excuteResult_" + iDataIndex;
                        excuteResultScope.config = [
                            {"color": constsService.COLOR_GREEN, "data": successPer, "text": aData["successNum"], "position": "right"},
                            {"color": constsService.COLOR_RED, "data": failPer, "text": aData["totalNum"] - aData["successNum"], "position": "right"}
                        ];
                        excuteResultScope.width = "130px";
                        excuteResultScope.barwidth = "80px";
                        var excuteResultNode = excuteResultLink(excuteResultScope);
                        $("td:eq(8)", nRow).html(excuteResultNode);
                        $("td:eq(4)", nRow).html(statusEnumService.getStatus("PROTECT_OBJECT_TYPE", aData['poType']));
                        $("td:eq(1)", nRow).html(statusEnumService.getStatus("POLICY_TEMPLET_STATUS", aData['replicationType']));

                        if((aData['productSite']).indexOf(",") != -1) {
                            var str = "";
                            _.each(aData['productSite'].split(","), function(d){
                                str += $scope.covertText(d) + ",";
                            });
                            $("td:eq(2)", nRow).html(str.substr(0, str.length -1));

                        } else if ((aData['productSite']).indexOf("(") != -1) {
                            $("td:eq(2)", nRow).html($scope.covertText(aData['productSite']));
                        } else {
                            $("td:eq(2)", nRow).html(aData['productSite']);
                        }

                        if (!_.isEmpty(aData['recoverySite'])) {
                            if ((aData['recoverySite']).indexOf(",") != -1) {
                                var str = "";
                                _.each(aData['recoverySite'].split(","), function(d) {
                                    str += $scope.covertText(d) + ",";
                                });
                                $("td:eq(3)", nRow).html(str.substr(0, str.length - 1));

                            } else if ((aData['recoverySite']).indexOf("(") != -1) {
                                $("td:eq(3)", nRow).html($scope.covertText(aData['recoverySite']));
                            } else {
                                $("td:eq(3)", nRow).html(aData['recoverySite']);
                            }
                        } else {
                            $("td:eq(3)", nRow).html("--");
                        }
                    }
                };

                _updateUI();

            }]


        var module = angular.module('recoverydirector.monitor.config');
        module.tinyController('monitor.groupstatreport.ctrl', ctrler);
        return module;
    })
