define([],
    function () {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "$compile",
            "exception",
            "message",
            "communicationService", "utilService", "mask", "appUtils", "constsService", "statusEnumService",
            function ($scope, $state, $stateParams, $compile, exception, message, communicationService, utilService, mask, appUtils, constsService, statusEnumService) {
                $scope.startPage = constsService.start;
                $scope.pageSize = 15;
                $scope.orderBy = "planName";
                $scope.orderType = "desc";
                $scope.queryTime = constsService.QUERY_TIME.all;
                $scope.checkRight = appUtils.checkRight;
                $scope.refreshTitle = appUtils.getString("common_term_refresh_button");

                var language = appUtils.resource().union();
                function _updateUI() {
                    var url = utilService.getResouceUrl("/reports/testreports?orderBy=" + $scope.orderBy + "&orderType=" + $scope.orderType + "&startPage=" +
                        $scope.startPage + "&pageSize=" + $scope.pageSize + "&queryTime=" + $scope.queryTime);
                    mask.show();
                    communicationService.get(url).promise().always(function (result) {
                        mask.hide();
                        if (exception.check(result)) {
                            var arr = [];
                            _.each(result.records, function (d) {
                                var tmo = _.pick(d, "id", "name", "productSite", "recoverySite", "poType", "averageTime", "maximumTime", "minimumTime", "totalNum", "successNum");
                                arr.push(tmo);
                            });

                            var exportBtn = $("#btnExport").widget();
                            if(exportBtn){
                                if (arr.length < 1){
                                    exportBtn.option("disable",true);
                                }else{
                                    exportBtn.option("disable",false);
                                }
                            }
                            $scope.recoveryTestTable.data = appUtils.encodeForHTML(arr);
                            $scope.recoveryTestTable.totalRecords = result["totalCount"];
                            $scope.recoveryTestTable.enablePagination = $scope.recoveryTestTable.totalRecords > constsService.TABLE_COUNT_PER_PAGE_BIG ? true : false;
                            $scope.$apply();
                        }
                        else {
                            $scope.recoveryTestTable.enablePagination = false;
                            $scope.$apply();
                        }
                    });
                };

                $scope.refreshData = function() {

                     $("#queryTime").widget().option("default-selectid", constsService.QUERY_TIME.all);
                     $scope.recoveryTestTable.curPage = {
                             "pageIndex": 1
                     };
                     $scope.startPage = 0;
                     $scope.pageSize = 15;
                     $scope.queryTime = constsService.QUERY_TIME.all;
                     _updateUI();
                }

                $scope.model = {
                    exportBtn: {
                        id: "btnExport",
                        text: appUtils.getString("common_term_exportall_button"),
                        click: function () {
                            appUtils.export("/reports/action/exportRecoveryPlanTestReport");
                        }
                    },
                    timeRang: {
                        id: "timeRang",
                        values: [
                            {
                                selectId: '1',
                                label: appUtils.getString("common_term_time_rang_label"),
                                checked: true
                            }
                        ],
                        width: constsService.W2,
                        defaultSelectid:"1",
                        isSearchbox:false,
                        timeOptions:{
                            id:"queryTime",
                            values: [
                                {
                                    selectId: constsService.QUERY_TIME.all,
                                    label: appUtils.getString("common_term_all_label")
                                },
                                {
                                    selectId: constsService.QUERY_TIME.oneMonth,
                                    label: appUtils.getString("common_term_latest_one_month_value")
                                },
                                {
                                    selectId: constsService.QUERY_TIME.threeMonth,
                                    label: appUtils.getString("common_term_latest_three_month_value")
                                },
                                {
                                    selectId: constsService.QUERY_TIME.sixMonth,
                                    label: appUtils.getString("common_term_latest_six_month_value")
                                },
                                {
                                    selectId: constsService.QUERY_TIME.oneYear,
                                    label: appUtils.getString("common_term_latest_one_year_value")
                                }
                            ],
                            defaultSelectid:($stateParams.timeSeg && parseInt($stateParams.timeSeg,10) === constsService.QUERY_TIME.threeMonth)?""+constsService.QUERY_TIME.threeMonth:""+constsService.QUERY_TIME.all
                        },
                        click:function(){
                            $scope.queryTime = $("#queryTime").widget().getSelectedId();
                            $scope.startPage = constsService.start;
                            $scope.recoveryTestTable.curPage = {
                                    "pageIndex": 1
                            };
                            _updateUI();
                        }
                    },
                };

                $scope.recoveryTestTable = {
                    "id": "recoveryTestTable",
                    "paginationStyle":"full_numbers",
                    "displayLength": 15,
                    "totalRecords": 0,
                    "checkbox": true,
                    "enablePagination": true,
                    "curPage": {
                        "pageIndex": 1
                    },
                    "columns": [
                        {
                            "mData": "id",
                            "bVisible": false
                        },
                        {
                            "sTitle": appUtils.getString("group_count_term_name_column"),
                            "mData": "name"
                        },
                        {
                            "sTitle": appUtils.getString("recovery_test_term_product_site_column"),
                            "mData": "productSite",
                            "bSortable":false
                        },
                        {
                            "sTitle": appUtils.getString("recovery_test_term_disaster_site_column"),
                            "mData": "recoverySite",
                            "bSortable":false
                        },
                        {
                            "sTitle": appUtils.getString("recovery_test_term_protect_object_type_column"),
                            "mData": "poType",
                            "bSortable":false
                        },
                        {
                            "sTitle": appUtils.getString("recovery_test_term_test_average_times_column"),
                            "mData": "averageTime",
                            "bSortable":false
                        },
                        {
                            "sTitle": appUtils.getString("recovery_test_term_test_long_times_column"),
                            "mData": "maximumTime",
                            "bSortable":false
                        },
                        {
                            "sTitle": appUtils.getString("recovery_test_term_test_short_times_column"),
                            "mData": "minimumTime",
                            "bSortable":false
                        },
                        {
                            "sTitle": appUtils.getString("group_count_term_excute_result_column"),
                            "mData": "totalNum",
                            "bSortable":false,
                            "sWidth": "13%"
                        },
                        {
                            "mData": "successNum",
                            "bVisible": false
                        }
                    ],
                    "data": [],
                    "callback": function (evtObj) {
                        $scope.startPage = evtObj.currentPage - 1;
                        $scope.pageSize = evtObj.displayLength;
                        _updateUI();
                    },
                    sortCallback: function (nNode, sortArr) {
                        $scope.startPage = 0;
                        var sortField = $scope.recoveryTestTable.columns[sortArr[0][0]].mData;
                        if ("name" == sortField) {
                            sortField = "planName";
                        }
                        $scope.orderBy = sortField;
                        $scope.orderType = sortArr[0][1];
                        _updateUI();
                    },
                    "renderRow": function (nRow, aData, iDataIndex) {
                        var successPer = aData["successNum"] * 100 / aData["totalNum"];
                        var failPer = (aData["totalNum"] - aData["successNum"]) * 100 / aData["totalNum"];
                        var excuteResultColumn = "<tiny-rainbowbar id='id' config='config' width='width' barwidth='barwidth'></tiny-rainbowbar>";
                        var excuteResultLink = $compile(excuteResultColumn);
                        var excuteResultScope = $scope.$new();
                        excuteResultScope.id = "excuteResult_" + iDataIndex;
                        excuteResultScope.config = [
                            {"color": constsService.COLOR_GREEN, "data": successPer, "text": aData["successNum"], "position": "right"},
                            {"color": constsService.COLOR_RED, "data": failPer, "text": aData["totalNum"] - aData["successNum"], "position": "right"}
                        ];
                        excuteResultScope.width = "130px";
                        excuteResultScope.barwidth = "80px";
                        var excuteResultNode = excuteResultLink(excuteResultScope);
                        $("td:eq(7)", nRow).html(excuteResultNode);
                        $("td:eq(3)", nRow).html(statusEnumService.getStatus("PROTECT_OBJECT_TYPE", aData['poType']));

                        if((aData['productSite']).indexOf("(") != -1) {
                            var str = aData['productSite'].substr(aData['productSite'].indexOf("("));
                            if (_.has(language, str.substr(1, str.length - 2))) {
                                $("td:eq(1)", nRow).html(aData['productSite'].substr(0, aData['productSite'].indexOf("(")) + "(" + language[str.substr(1, str.length - 2)] + ")");
                            }
                        } else {
                            $("td:eq(1)", nRow).html(aData['productSite']);
                        }

                        if((aData['recoverySite']).indexOf("(") != -1) {
                            var str = aData['recoverySite'].substr(aData['recoverySite'].indexOf("("));
                            if (_.has(language, str.substr(1, str.length - 2))) {
                                $("td:eq(2)", nRow).html(aData['recoverySite'].substr(0, aData['recoverySite'].indexOf("(")) + "(" + language[str.substr(1, str.length - 2)] + ")");
                            }
                        } else {
                            $("td:eq(2)", nRow).html(aData['recoverySite']);
                        }

                        $("td:eq(4)", nRow).html(appUtils.convertMilliSecondToTime(aData['averageTime']));
                        $("td:eq(5)", nRow).html(appUtils.convertMilliSecondToTime(aData['maximumTime']));
                        $("td:eq(6)", nRow).html(appUtils.convertMilliSecondToTime(aData['minimumTime']));

                    }
                };


                (function(){
                    if(!_.isUndefined($stateParams.timeSeg) && $stateParams.timeSeg == constsService.QUERY_TIME.threeMonth){
                       $scope.queryTime = constsService.QUERY_TIME.threeMonth;
                    }
                    _updateUI();
                })()


            }]

        var module = angular.module('recoverydirector.monitor.config');
        module.tinyController('monitor.recoverytestreport.ctrl', ctrler);
        return module;
    })
