define([],
    function() {
        "use strict";
        var ctrl = [
            "$scope",
            "$state",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            function ($scope, $state, exception, message, communicationService, utilService, mask, constsService, appUtils, statusEnumService) {

                var srcDeviceSn = $("#hostLinkDetail").widget().option("data").srcDeviceSn;
                var tgtDeviceSn = $("#hostLinkDetail").widget().option("data").tgtDeviceSn;
                $scope.linkTables = {
                    id: "linkTables",
                    columns: [ {
                    	"sTitle": appUtils.getString("topo_term_initiatordev_title"),
                        "mData": "dev",
                        "bSortable":false,
                        "sWidth":"25%"
                    }, {
                        "sTitle": appUtils.getString("common_term_type_label"),
                         "mData": "hbaType",
                         "bSortable":false,
                         "sWidth":"15%"
                    }, {
                        "sTitle": appUtils.getString("WWPN/IQN"),
                        "mData": "identity",
                        "bSortable":false,
                        "sWidth":"40%"
                    }, {
                        "sTitle": appUtils.getString("common_term_status_label"),
                            "mData": "runningStatus",
                            "bSortable":false
                    }],
                    renderRow: function (nRow, aData, iDataIndex) {
                    	var type = aData["hbaType"];
                        var type = type == "ISCSI" ? "iSCSI" : type;
                        $("td:eq(1)", nRow).text(type);

                        var linkStatus = aData["runningStatus"];
                        var statusText = "common_term_unknow_label";
                        if (linkStatus == "0")
                        {
                        	statusText = "common_term_status_online_label";
                        }
                        else if (linkStatus == "-1")
                        {
                        	statusText = "common_term_status_offline_label";
                        }
                        $("td:eq(3)", nRow).text(appUtils.getString(statusText));
                    },
                    paging: false,
                    data: []
                };
                var _init = function () {
                	var devArray = srcDeviceSn.split("---");
                	var hostArray = tgtDeviceSn.split("---");
                	devArray.forEach(function(dev){
                		hostArray.forEach(function(host){
                			communicationService.get(utilService.getResouceUrl("/storages/" + dev + "/hostinitiators?hostSn=" + host)).promise().always(function (result) {
                                if (exception.check(result)) {
                                    var arr = [];
                                    _.each(result, function (d) {
                                        var tmo = _.pick(d, "uuid", "name", "identity", "healthStatus", "runningStatus", "hbaType", "model");
                                        tmo.dev = dev;
                                        arr.push(tmo);
                                    });
                                    $scope.linkTables.data = $scope.linkTables.data.concat(arr);
                                    $scope.$apply();
                                }
                            })
                		});
                	});
                };

                _init();
            }]

        var module = angular.module("recoverydirector.monitor.config");
        module.tinyController("topo.topoInitiatorCtrl", ctrl);
        return module;
    })
