define([],
    function () {
        "use strict";
        var ctrl = [
            "$scope",
            "$state",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            function ($scope, $state, exception, message, communicationService, utilService, mask, constsService, appUtils, statusEnumService) {

                var srcDeviceSn = $("#storageLinkDetail").widget().option("data").srcDeviceSn;
                var tgtDeviceSn = $("#storageLinkDetail").widget().option("data").tgtDeviceSn;
                $scope.linkTables = {
                    id: "linkTables",
                    columns: [{
                        "sTitle": appUtils.getString("topo_term_linkId_label"),
                            "mData": "linkId",
                            "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("topo_term_src_label"),
                            "mData": "productArrayName",
                            "bSortable":false
                    }, {
                        "sTitle": appUtils.getString("topo_term_srcno_label"),
                            "mData": "deviceId",
                            "bSortable":false
                    }, {
                        "sTitle": appUtils.getString("topo_term_dest_label"),
                            "mData": "recoveryArrayName",
                            "bSortable":false
                    }, {
                        "sTitle": appUtils.getString("topo_term_destno_label"),
                            "mData": "remoteArrayId",
                            "bSortable":false
                    }, {
                        "sTitle": appUtils.getString("topo_term_linktype_label"),
                            "mData": "linkType",
                            "bSortable":false
                    }, {
                        "sTitle": appUtils.getString("topo_term_linkstatus_label"),
                            "mData": "linkStatus",
                            "bSortable":false
                    }],
                    renderRow: function (nRow, aData, iDataIndex) {
                    	var linkIds = aData["linkId"];
                        var linkStatus = aData["linkStatus"];
                        var linkType = aData["linkType"];
                        if (linkIds != null)
                        {
                        	if (linkIds.indexOf(";") > 0)
                            {
                        		var idArray = linkIds.split(";");
                                if (idArray != null && idArray.length == 2)
                                {
                                	$("td:eq(0)", nRow).html(idArray[1]);
                                }
                            }
                        	else if (linkIds.indexOf(":") > 0)
                        	{
                        		var idArray = linkIds.split(":");
                                if (idArray != null && idArray.length == 2)
                                {
                                	$("td:eq(0)", nRow).html(idArray[1]);
                                }
                        	}
                        }

                        if (linkType == "1") {
                            $("td:eq(5)", nRow).html("FC");
                        } else if (linkType == "3"){
                            $("td:eq(5)", nRow).html(aData["linkIp"]);
                        } else {
                            $("td:eq(5)", nRow).html("iSCSI");
                        }

                        if (linkStatus == "10")
                        {
                            $("td:eq(6)", nRow).text(appUtils.getString("common_term_status_link_label"));
                        }
                        else if (linkStatus == "11")
                        {
                            $("td:eq(6)", nRow).text(appUtils.getString("common_term_status_linkdown_label"));
                        }
                        else
                        {
                        	$("td:eq(6)", nRow).text(appUtils.getString("common_term_unknow_label"));
                        }
                    },
                    paging: false,
                    data: []
                };
                var _init = function () {
                    communicationService.get(utilService.getResouceUrl("/replications/" + srcDeviceSn + "/" + tgtDeviceSn + "/action/getReplicationLinks")).promise().always(function (result) {
                        if (exception.check(result)) {
                            var arr = [];
                            _.each(result, function (d) {
                                d.productArrayName = $.encoder.encodeForHTML(d.productArrayName);
                                d.recoveryArrayName = $.encoder.encodeForHTML(d.recoveryArrayName);
                                var tmo = _.pick(d, "linkId", "productArrayName", "deviceId", "recoveryArrayName", "remoteArrayId", "linkType", "linkStatus", "linkIp");
                                arr.push(tmo);
                            });
                            $scope.linkTables.data = arr;
                            $scope.$apply();
                        }
                    })
                };

                _init();
            }]

        var module = angular.module("recoverydirector.monitor.config");
        module.tinyController("topo.topoLinkCtrl", ctrl);
        return module;
    })
