define([],
    function () {
        "use strict";
        var ctrl = [
            "$scope",
            "$state",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            function ($scope, $state, exception, message, communicationService, utilService, mask, constsService, appUtils, statusEnumService) {

                var srcDeviceSn = $("#quorumLinkDetail").widget().option("data").srcDeviceSn;
                var tgtDeviceSn = $("#quorumLinkDetail").widget().option("data").tgtDeviceSn;
                $scope.linkTables = {
                    id: "linkTables",
                    columns: [ {
                        "sTitle": appUtils.getString("topo_term_localcontroller_label"),
                         "mData": "localControllerName",
                         "bSortable":false,
                         "sWidth":"20%"
                    }, {
                        "sTitle": appUtils.getString("topo_term_localport_label"),
                        "mData": "localPortName",
                        "bSortable":false,
                        "sWidth":"30%"
                    }, {
                        "sTitle": appUtils.getString("topo_term_quorumserverIp_label"),
                        "mData": "quorumServerIp",
                        "bSortable":false,
                        "sWidth":"30%"
                    }, {
                        "sTitle": appUtils.getString("topo_term_runningstate_label"),
                            "mData": "runningState",
                            "bSortable":false
                    }],
                    renderRow: function (nRow, aData, iDataIndex) {
                        var linkStatus = aData["runningState"];
                        var statusText = "common_term_unknow_label";
                        if (linkStatus == "10")
                        {
                        	statusText = "common_term_status_link_label";
                        }
                        else if (linkStatus == "11")
                        {
                        	statusText = "common_term_status_linkdown_label";
                        }
                        $("td:eq(3)", nRow).text(appUtils.getString(statusText));
                    },
                    paging: false,
                    data: []
                };
                var _init = function () {
                    communicationService.get(utilService.getResouceUrl("/storages/" + srcDeviceSn + "/quorumserverlinks?quorumServerId=" + tgtDeviceSn)).promise().always(function (result) {
                        if (exception.check(result)) {
                            var arr = [];
                            _.each(result, function (d) {
                                var tmo = _.pick(d, "id", "localControllerId", "localPortId", "localControllerName", "localPortName", "quorumServerId", "quorumServerIp", "runningState");
                                arr.push(tmo);
                            });
                            $scope.linkTables.data = arr;
                            $scope.$apply();
                        }
                    })
                };

                _init();
            }]

        var module = angular.module("recoverydirector.monitor.config");
        module.tinyController("topo.topoQuorumCtrl", ctrl);
        return module;
    })
