define([], function() {
    var config = {
        /** 自定义APP,以poType为值的数组
        *   若在此添加了应用的poType,则会加载该应用对应的实现
        **/
        EXTEND_APPS : [],

        POTYPE_MAPPER: {
            1: "oracle",
            2: "sqlserver",
            3: "db2",
            8: "exchange",
            9: "filesystem",
            10: "vmware",
            11: "lun",
            12: "fusionsphere",
            14: "nasfilesystem"
        },

        PG_CREATE_CONFIG: {
            //ORACLE
            1: [{
                    extend: "common.1"
                }, {
                    extend: "common.2"
                },
                "common.3"
            ],

            //SQLServer
            2: [{
                    extend: "common.1"
                }, {
                    extend: "common.2"
                },
                "common.3"
            ],

            //DB2
            3: [{
                    extend: "common.1",
                }, {
                    extend: "common.2"
                },
                "common.3"
            ],

            //Exchange
            8: [{
                    extend: "common.1"
                }, {
                    extend: "common.2"
                },
                "common.3"
            ],

            //FileSystem
            9: [{
                    extend: "common.1"
                }, {
                    extend: "common.2"
                },
                "common.3"
            ],

            //VMwareMachine
            10: [{
                    extend: "common.1"
                }, {
		    extend: "common.2"

                },
                "common.3"
            ],

            //LUN
            11: [{
                    extend: "common.1"
                }, {
                    extend: "common.2"
                },
                "common.3"
            ],

            //fusionsphere
            12: [{
                    extend: "common.1"
                }, {
                    extend: "common.2"
                },
                "common.3"
            ],

            //NAS文件系统
            14: [{
                    extend: "common.1"
                }, {
                    extend: "common.2"

                },
                "common.3"
            ],

            //Caché数据库
            15: [{
                    extend: "common.1"
                }, {
                    extend: "common.2"
                },
                "common.3"
            ],

            //HANA数据库
            16: [{
                    extend: "common.1"
                },{
                    extend: "common.2",
                },
                "common.3"
            ]
        },

        /**------保护组列表保护对象Tab页配置------*/
        /*提供独立或公共配置两种方式
         *
         *提供的公共配置:
         *  1. 列表框架,html+ctrl
         *  2. 应用公共逻辑
         *     a.增加保护对象: 应用只需在popWindowConfig配置项中配置  width,height,content;
         *                 默认数据传递     appUtils.getWinData()
         *     b.删除保护对象
         *     c.刷新列表
         *
         *配置项
         *  1. 表格column,
         *  2. renderRow 可注入,最后一个参数默认注入当前保护组对象
         *  3. overwrite : 提供任何粒度的重写 格式  attr1.attr2.attr3,作用在config对象下
         *  4. cancat: {key:[index,val]} 把配置项合并到指定索引的数组中去
         *     key -> 属性,支持任意粒度(该属性值必须为数组) index -> 合并到数组后的索引 val -> 配置项
         *
         * */
        PG_TAB_PROTECTOBJECTS : {

            //sqlserver
            2: {
                "extend": "common",
                "config": {
                    table: {
                        columns: [
                            {
                                "mData": "uuid",
                                "bVisible": false
                            },
                            {
                                "sTitle": "ism.drm.proetct.group.appdb.dbname.column",
                                "mData": "name"
                            },
                            {
                                "sTitle": "ism.drm.proetct.group.appdb.instance.column",
                                "mData": "props.INSTANCENAME",
                                "bSortable": false
                            },
                            {
                                "sTitle": "ism.drm.site.host",
                                "mData": "providerName",
                                "bSortable": false
                            },
                            {
                                "sTitle": "ism.drm.proetct.group.appdb.version.column",
                                "mData": "props.VERSION",
                                "bSortable": false
                            }
                        ],
                        opAreaConfig: [
                            {
                                id : "btnEditPo",
                                authKey     : "ism.drm.protectgroup.auth.modify",
                                template: "<div class='iconbutton-edit' title='res_term_modifyauth_label'></div>",
                                clickActive: ["appUtils","constsService", function (appUtils,Consts, pgArr, resource,$scope) {
                                    return function () {
                                        if( !$scope.btnEditPo ) return;

                                        var po = $("#poTable").widget().getHoverData()[0];
                                        var isOracle = po.poType == "1";

                                        var config = angular.copy(Consts.MODIFY_DB_TEST_WIN);
                                        config.title = resource.get(config.title);
                                        if( po.props.IS_ASM == "1" ){
                                            config.height = isOracle ? 480 : 450;
                                        }else{
                                            config.height = isOracle ? 300 : 265;
                                        }

                                        config.close = function(){
                                            appUtils.getWinData() === true && $scope.$emit(Consts.TOPIC.PG_LIST_UPDATE);
                                        };

                                        appUtils.openWin(config, {pgId: pgArr[0].pgId, po: po});
                                    };
                                }]
                            }
                        ],
                        renderRow: ["model","appUtils", function (Model,appUtils) {
                            return function (nRow, aData, iDataIndex) {
                                var instancename = aData.props && aData.props.INSTANCENAME;
                                $('td:eq("2")', nRow).text(Model.util.formatIstName(instancename));
                                //oracle归档日志是否保护
                                if(aData.poType == 1){
                                    var stringKey = aData.props.ARCHIVE_LOG == 1 ? "common_term_yes_label" : "common_term_no_label";
                                    $('td:eq("6")', nRow).text(appUtils.getString(stringKey));
                                    //是否为容器数据库
                                    var isCDBKey = aData.props.IS_CDB == "1" ? "common_term_is_pdb_label" : "common_term_isNot_pdb_label";
                                    $("td[tdtitle='" + appUtils.getString("common_term_pdb_type_label") + "']", nRow).text(appUtils.getString(isCDBKey));
                                }
                            };
                        }]
                    }
                }
            },


            //oralce
            1: {
                "extend": "2",
                "config": {
                    cancat: {
                        "table.columns" : [ 5 , {
                                    "sTitle": "protection_VM_task_setarchiveLogProtection_checkbox",
                                    "mData": "props.ARCHIVE_LOG",
                                    "bSortable": false
                                }
                        ],

                        "table.opAreaConfig": [ 0,
                            {
                                id : "btnSetArchiveLog",
                                authKey     : "ism.drm.protectgroup.auth.modify",
                                template: "<div class='iconbutton-panelSetting' title='protection_term_modifyProtectionSetting_button'></div>",
                                clickActive: ["appUtils","constsService", function (appUtils,Consts, pgArr, resource,$scope) {
                                    return function () {
                                        if( !$scope.btnSetArchiveLog ) return;

                                        var po = $("#poTable").widget().getHoverData()[0];

                                        var config = angular.copy(Consts.MODIFY_DB_PROTECT_WIN);
                                        config.title = resource.get(config.title);

                                        config.close = function(){
                                            appUtils.getWinData() === true && $scope.$emit(Consts.TOPIC.PG_LIST_UPDATE);
                                        };

                                        appUtils.openWin(config,{
                                            po: po,
                                            pg: pgArr[0]
                                        });
                                    };
                                }]
                            }
                        ]
                    }
                }
            },

            //db2
            3: {
                "extend": "2"
            },


            //exchange
            8: {
                "extend": "common",
                "config": {
                    table: {
                        columns: [
                            {
                                "mData": "uuid",
                                "bVisible": false
                            },
                            {
                                "sTitle": "ism.drm.proetct.group.appdb.dbname.column",
                                "mData": "name"
                            },
                            {
                                "sTitle": "ism.drm.site.host",
                                "mData": "providerName",
                                "bSortable": false
                            },
                            {
                                "sTitle": "system_about_term_version_label",
                                "mData": "props.APP_VERSION",
                                "bSortable": false
                            }
                        ],
                        renderRow: ["constsService", function (Consts, protectGroup) {
                            return function (nRow, aData, iDataIndex) {
                                var dbVersion = aData.props.APP_VERSION;
                                var map = {
                                    "1" : "Exchange2007",
                                    "2" : "Exchange2010",
                                    "3" : "Exchange2013",
                                    "4" : "Exchange2016",
                                    "5" : "Exchange2019"
                                };
                                $('td:eq(3)', nRow).text(map[dbVersion]);
                            };
                        }]
                    }
                }
            },

            //filesystem
            9: {
                "extend": "common",
                "config": {
                    table: {
                        columns: [
                            {
                                "mData": "uuid",
                                "bVisible": false
                            },
                            {
                                "mData": "moUuid",
                                "bVisible": false
                            },
                            {
                                "sTitle": "ism.drm.protect.group.appfs.fsname.column",
                                "mData": "name",
                                "bSortable": false
                            },
                            {
                                "sTitle": "ism.drm.site.host",
                                "mData": "providerName",
                                "bSortable": false
                            },
                            {
                                "sTitle": "ism.drm.protect.group.appfs.fstype.column",
                                "mData": "props.LOCAL_FS_TYPE",
                                "bSortable": false
                            }
                        ],
                        renderRow: ["constsService", function (Consts, protectGroup) {
                            return function (nRow, aData, iDataIndex) {
                            }
                        }]
                    }
                }
            },

            //VMwareMachine
            10: "protection.pg.list.protectobjects_vmware",

            //lun
            11: {
                "extend": "common",
                "config": {
                    overwrite: {
                        "addPo.popWindowConfig.content": "app/business/recoverydirector/protection/views/protectiongroup/lun/addProtectObjects.html"
                    },
                    table: {
                        columns: [
                            {
                                "mData": "uuid",
                                "bVisible": false
                            },
                            {
                                "sTitle": "common_term_name_label",
                                "mData": "name"
                            },{
                                "sTitle" : "ID",
                                "mData" : "props.lunId",
                                "bSortable" : false
                            }, {
                                "sTitle" : "WWN",
                                "mData" : "props.lunWwn",
                                "bSortable" : false
                            },
                            {
                                "sTitle": "ism.drm.drp.instance.storage",
                                "mData": "providerName",
                                "bSortable": false
                            },
                            {
                                "sTitle": "ism.drm.host.fs.capacity",
                                "mData": "props.totalCapacityAndUnit",
                                "bSortable": false
                            }
                        ]
                    }
                }
            },

            //fusionphere
            12 : "protection.pg.list.protectobjects_fusionsphere",

            //nas文件系统
            14: {
                "extend": "common",
                "config": {
                    overwrite: {
                        "addPo.popWindowConfig.content": "app/business/recoverydirector/protection/views/protectiongroup/lun/addProtectObjects.html"
                    },
                    table: {
                        columns: [
                            {
                                "mData": "uuid",
                                "bVisible": false
                            },{
                                "sTitle": "common_term_name_label",
                                "mData": "name"
                            },{
                                "sTitle" : "ID",
                                "mData" : "props.nasFsId",
                                "bSortable" : false
                            },{
                                "sTitle": "ism.drm.drp.instance.storage",
                                "mData": "providerName",
                                "bSortable": false
                            },{
                                "sTitle": "ism.drm.host.fs.capacity",
                                "mData": "props.totalCapacityAndUnit",
                                "bSortable": false
                            }
                        ]
                    }
                }
            },
            15: {
                "extend": "common",
                "config": {
                    table: {
                        columns: [
                            {
                                "mData": "uuid",
                                "bVisible": false
                            },
                            {
                                "sTitle": "ism.drm.proetct.group.appdb.instance.column",
                                "mData": "props.INSTANCENAME"
                            },
                            {
                                "sTitle": "ism.drm.site.host",
                                "mData": "providerName",
                                "bSortable": false
                            },
                            {
                                "sTitle": "ism.drm.proetct.group.appdb.version.column",
                                "mData": "props.VERSION",
                                "bSortable": false
                            }
                        ]
                    }
                }
            },
            16: {
                "extend": "common",
                "config": {
                    table: {
                        columns: [
                            {
                                "mData": "uuid",
                                "bVisible": false
                            },
                            {
                                "sTitle": "site_term_system_id_label",
                                "mData": "name"
                            },
                            {
                                "sTitle": "site_term_instance_number_label",
                                "mData": "props.INSTANCENAME",
                                "bSortable": false
                            },
                            {
                                "sTitle": "ism.drm.site.host",
                                "mData": "providerName",
                                "bSortable": false
                            },
                            {
                                "sTitle": "ism.drm.proetct.group.appdb.version.column",
                                "mData": "props.VERSION",
                                "bSortable": false
                            },
                        ],
                        opAreaConfig: [
                            {
                                id : "btnEditPo",
                                authKey     : "ism.drm.protectgroup.auth.modify",
                                template: "<div class='iconbutton-edit' title='res_term_modifyauth_label'></div>",
                                clickActive: ["appUtils","constsService", function (appUtils,Consts, pgArr, resource,$scope) {
                                    return function () {
                                        if( !$scope.btnEditPo ) return;

                                        var po = $("#poTable").widget().getHoverData()[0];
                                        var isOracle = po.poType == "1";

                                        var config = angular.copy(Consts.MODIFY_DB_TEST_WIN);
                                        config.title = resource.get(config.title);
                                        if( po.props.IS_ASM == "1" ){
                                            config.height = isOracle ? 480 : 450;
                                        }else{
                                            config.height = isOracle ? 300 : 265;
                                        }

                                        config.close = function(){
                                            appUtils.getWinData() === true && $scope.$emit(Consts.TOPIC.PG_LIST_UPDATE);
                                        };

                                        appUtils.openWin(config, {pgId: pgArr[0].pgId, po: po});
                                    };
                                }]
                            }
                        ]
                    }
                }
            },
            "common": {
                "extend": "",
                "config": {
                    addPo: {
                        popWindowConfig: {
                            //这里配置了数据库添加保护对象的公用模板 其他应用需要重写此配置
                            content: "app/business/recoverydirector/protection/views/protectiongroup/common/addProtectObjects.html"
                        }
                    }
                }
            }
        },

        /**------ 增加保护对象配置 ------*/
        /* 如果使用了公共的增加保护对象页面,则此配置有效(默认配置类型为数据库)
         * form表单配置
         * table配置
         * {
         *     desc  : 表格描述
         *     clickActionType : 选择单项的动作类型( 0=无动作 | 1=加载存储信息 | 2=测试数据库 )
         * }
         * */
        PO_ADD_CONFIG : {
            //exchange
            8: {
                table: {
                    desc: "ism.drm.protect.element.available",
                    clickActionType: 1,
                    columns: [
                        {
                            "mData": "uuid",
                            "bVisible": false
                        },
                        {
                            "sTitle": "ism.drm.proetct.group.appdb.dbname.column",
                            "mData": "name"
                        }
                    ]
                }
            },
            //filesystem
            9: {
                table: {
                    desc: "ism.drm.protect.element.available",
                    clickActionType: 1,
                    columns: [
                        {
                            "mData": "uuid",
                            "bVisible": false
                        },
                        {
                            "mData": "moUuid",
                            "bVisible": false
                        },
                        {
                            "sTitle": "ism.drm.protect.group.appfs.fsname.column",
                            "mData": "name",
                            "bSortable": false
                        },
                        {
                            "sTitle": "ism.drm.protect.group.appfs.fstype.column",
                            "mData": "props.LOCAL_FS_TYPE",
                            "bSortable": false
                        }
                    ],
                    renderRow: function (nRow, aData, iDataIndex) {

                    }
                }
            },
            //vmware
            10: {
                table: {
                    desc: "ism.drm.protect.element.available",
                    clickActionType: 1,
                    columns: [
                        {
                            "mData": "uuid",
                            "bVisible": false
                        },
                        {
                            "sTitle": "common_term_name_label",
                            "mData": "name"
                        },
                        {
                            "sTitle": "common_term_system_label",
                            "mData": "props.GUSTOS",
                            "bSortable": false
                        }
                    ]
                }
            }
        },

         /**------保护组规格配置------*/
        PO_NUM_SPECiFICATION: {
            1: 32
        }

    };
    return config;
});
