define(["tiny-lib/Class", "./appConfig"], function(Class, appConfig) {

	//默认应用
	var DefaultApp = Class.extend({
			init: function(poType) {
				this.poType = poType;
			},

			//保护对象Tab页state
			getPoTabState: function(){
				var tabConf = appConfig.PG_TAB_PROTECTOBJECTS[this.poType];
				return angular.isString(tabConf) ? tabConf : "protection.pg.list.protectobjects";
			},

			//解析保护对象Tab页面配置
			getPoTabConfig: function(){
				return _getConfig(angular.copy(appConfig.PG_TAB_PROTECTOBJECTS[this.poType]));

				function _getConfig(conf) {
					if (angular.isObject(conf)) {
						var extendConf = angular.copy(_getConfig(appConfig.PG_TAB_PROTECTOBJECTS[conf.extend]));
						var extend = angular.extend(extendConf, conf.config || {});

						//重写父配置,支持任何粒度
						var overwrite;
						if (overwrite = extend.overwrite) {
							angular.forEach(overwrite, function(v, k) {
								_traverObj(extend,k,v);
							});
						}

						//合并数组
						var cancat;
						if(cancat = extend.cancat){
							angular.forEach(cancat, function(v, k) {
								var srcArr = _traverObj(extend,k);
								if( angular.isArray(srcArr) ){
									srcArr.splice(v[0],0,v[1]);
								}
							});
						}

						return extend;
					}
					return {};
				}

				function _traverObj(obj,attrStr,v){
					var ls = attrStr.split(".") , lastObj = obj;

					for (var i = 0, len = ls.length; i < len - 1; i++) {
						lastObj = lastObj[ls[i]];
					}

					if(v){
						lastObj[ls[i]] = v;
					}
					return lastObj[ls[i]];
				}
			},

			//增加保护对象的配置
			getPoAddConfig: function(){
				return appConfig.PO_ADD_CONFIG[this.poType];
			},

			//保护组规格
			getPoNumSpecification: function(){
				return appConfig.PO_NUM_SPECiFICATION[this.poType];
			}
	});


//app管理
var AppMgr = {};

AppMgr.cache = {
	//标志应用是否已经注册(只注册一次)
	registerred: false,
	//注册了的应用类
	registerApp: {},
	//实例化了的应用
	appInstance: {},
	//默认应用
	defaultApp: null
};

/**
 * 增加应用(缓存在AppMgr.cache.registerApp)
 *
 * @param poType 应用的poType(参见appConfig.POTYPE_MAPPER)
 * @param proto 应用原型
 *
 * @return 应用构造函数
 */
AppMgr.add = function(poType, proto) {
	return ensure(AppMgr.cache.registerApp, poType, function() {
		return DefaultApp.extend(proto);
	});
}

/**
 * 实例化应用(缓存在AppMgr.cache.appInstance)
 *
 * @param poType
 *
 * @return 应用实例
 */
AppMgr.init = function(poType) {
	return ensure(AppMgr.cache.appInstance, poType, function() {
		var appClass = AppMgr.cache.registerApp[poType];
		return appClass ? new appClass(poType) : AppMgr.getDefaultApp(poType);
	});
}

/**
 * 实例化默认应用;没有继承的应用采用DefaultApp的配置
 *
 * @param poType
 *
 * @return 默认应用实例
 */
AppMgr.getDefaultApp = function(poType){
	var defaultApp = AppMgr.cache.defaultApp;
	if(defaultApp){
		defaultApp.poType = poType;
	}
	else{
		defaultApp = new DefaultApp(poType);
	}
	return defaultApp;
}


//工具方法
function ensure(obj, name, factory) {
	return obj[name] || (obj[name] = factory());
}

return AppMgr;

});