define(["tiny-common/UnifyValid"], function(UnifyValid) {

	//动态编译指令
	var dynamicCompile = ["$http", "$compile", "$controller", function($http, $compile, $controller) {
		function compileTmpl(view, ctrl, element, scope) {
			if (!(view && ctrl && element)) return;

			scope.compileInit = true;
			require([ctrl], function(ctrl) {
				$http.get(view).then(function(result){
					element.html(result.data);

					var oldScope = scope.$$childTail;
					if(oldScope && oldScope.$destroy){
						oldScope.$destroy();
					}
					var newScope = scope.$new();
					newScope.viewModel = scope.viewModel;
					newScope[ctrl] = ctrl;
					$controller(ctrl, {$scope: newScope});

					$compile(element.contents())(newScope);

				});
			});
		}

		return {
			restrict: "E",
			replace: true,
			scope: {view: "=view", ctrl: "=ctrl", viewModel: "=viewModel", listenObject: "=listenObject"},
			link: function(scope, element) {
				compileTmpl(scope.view, scope.ctrl, element, scope);

				scope.$watch("view", function(newView,oldView) {
					if( !scope.compileInit ){
						compileTmpl(newView, scope.ctrl, element, scope);
					}
					else{
						if(newView == oldView) return;
						compileTmpl(newView, scope.ctrl, element, scope);
					}
				});

				scope.$watch('listenObject', function(newValue, oldValue, scope) {
				    if (!scope.compileInit) {
				        compileTmpl(scope.view, scope.ctrl, element, scope);
				    } else {
				        if (newValue == oldValue) return;
				        compileTmpl(scope.view, scope.ctrl, element, scope);
				    }
				}, true);
			}
		}
	}];


	//应用策略设置
	var scheduleApp = ["appUtils",function(appUtils) {
		return {
			restrict: "E",
			template: '<div ng-bind="title" class="_title" ng-show="showTitle" style="margin:0 0 10px 0"></div><dynamic-compile view="view" ctrl="ctrl" view-model="viewModel"></dynamic-compile>',
			scope: {viewModel:"=viewModel"},
			link: function(scope) {
				if(!scope.viewModel) return;
				var vm = scope.viewModel;
				vm.showApp = true;
				var mapper = {
					1:"Oracle",2:"Common",3:"Common",8:"Common",9:"Common",10:"Common",12:"FusionSphere",11:"Lun", 99:"Lun", 16:"Common"
				}

				var htmlUrl = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/";
				var ctrlUrl = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/";

				scope.title = appUtils.getString("protection_term_concsistentProtectPolicy_tab");
				var appName = mapper[scope.viewModel.poType];

				scope.showTitle = true;

				//华为虚拟机不显示title
				if(scope.viewModel.poType == 12 || !appName){
					scope.showTitle = false;
				}
				if(!appName) {
					vm.showApp = false;
					return;
				}
				var marginMap = {
					"Oracle": "0 0 10px 0",
					"Common": "0 0 10px 0",
					"FusionSphere": "0 0 10px 0"
				};
				vm.margin = marginMap[appName];
				scope.view = htmlUrl + "scheduleApp" + appName + ".html";
				scope.ctrl = ctrlUrl + "scheduleApp" + appName + "Ctrl";
			}
		}
	}];

	//时间表设置
	var scheduleBase = ["appUtils",function(appUtils){
		return {
			restrict: "E",
			template: '<div ng-bind="title" class="{{cls}}"></div><dynamic-compile view="view" ctrl="ctrl" view-model="viewModel"></dynamic-compile>',
			scope: {viewModel:"=viewModel"},
			link: function(scope) {
				if(!scope.viewModel) return;

				scope.title = scope.viewModel.title || appUtils.getString("common_term_timePolicy_tab");
				scope.cls = scope.viewModel.titleFirst ? "first_title":"_title";
				scope.view = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/base.html";
				scope.ctrl = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/baseCtrl";
			}
		}
	}];

	//时间策略摘要面板
	var schedulePanel = ["constsService","appUtils",function(Consts,appUtils){
		return {
			restrict: "E",
			transclude: true,
			template:  '<div class="panel-wrap">' +
							'<div class="panel-top">' +
								'<div class="panel-title"   ng-bind="titleText"></div>' +
								'<div ng-class="{\'panel-setting\':settingEnable, \'panel-setting-disable\':!settingEnable}" ng-show="settingShow" ng-click="click()"><span ng-class="{\'iconbutton-edit\':settingEnable,\'iconbutton-edit-disabled\':!settingEnable}" style="display:inline-block;float:left;margin-right:5px;"></span><span ng-bind="settingText"></span></div>' +
								'<div style="clear:both;"></div>' +
							'</div>' +
							'<div class="panel-content">' +
								'<div ng-transclude></div>' +
							'</div>' +
					   '</div>',
			scope: {viewModel:"=viewModel"},
			link: function(scope){
				var viewModel = scope.viewModel;

				scope.titleText = viewModel.titleText || appUtils.getString("ism.drm.protect.group.template");
				scope.settingText = viewModel.settingText || appUtils.getString("ism.drm.settings.menuname");
				scope.settingShow = viewModel.settingShow;
				scope.settingEnable = true;

				if( viewModel.settingEnable === true || angular.isUndefined(viewModel.settingEnable) ){
					scope.settingEnable = true;
				}
				else{
					scope.settingEnable = false;
				}

				scope.click = function(){
					if(!scope.settingEnable) return;

					if( angular.isFunction(viewModel.click) ){
						viewModel.click();
					}
				}

				scope.$watch("viewModel.titleText",function(newVal,oldVal){
					if(!newVal) return;

					scope.titleText = newVal;
				})

				scope.$watch("viewModel.settingEnable",function(newVal,oldVal){
					if( angular.isUndefined(newVal) || newVal == oldVal ) return;

					scope.settingEnable = newVal;
				})
			}
		}
	}];

	//参数配置标题
	var scheduleTitle = ["appUtils", function(appUtils){
		return {
			restrict: "E",
			transclude: true,
			template: 	'<div>' +
							'<div>' +
								'<span class="{{policyIcon}}" style="display: inline-block;position: relative;top: 4px;" ></span>' +
								'<span style="margin: 0 0 10px 5px;display:inline-block;font-size: 14px;" ng-bind="policyTitle"></span>' +
							'</div>' +
							'<div style="border-top: 1px solid #e3e3e3;" ng-if="!!policyDesc">' +
								'<span style="display: inline-block;color:#666;margin: 10px 0 10px 0;font-size: 12px;" ng-bind="policyDesc"></span>' +
							'</div>' +
							'<div>' +
								'<div ng-transclude></div>' +
							'</div>' +
						'</div>',
			scope: {viewModel:"=viewModel"},
			link: function(scope){
				var viewModel = scope.viewModel || {};
				scope.policyTitle = viewModel.policyTitle || appUtils.getString("ism.drm.protect.group.template");
				scope.policyDesc = viewModel.policyDesc || "";
				scope.policyIcon = viewModel.policyIcon;
				scope.$watch("viewModel.policyTitle",function(newVal,oldVal){
					if(!newVal) return;

					scope.policyTitle = newVal;
				});
				scope.$watch("viewModel.policyDesc",function(newVal,oldVal){
					if(!newVal) return;

					scope.policyDesc = newVal;
				});
			}
		}

	}];

	//策略配置参数
	var scheduleConfig = ["appUtils", function(appUtils){
		return {
			restrict: "E",
			transclude: true,
			template: '<div class="panel-wrap">' +
							'<div>' +
								'<span ng-class="{true:\'advance-icon-open\',false:\'advance-icon-close\'}[iconOpen]" ng-click="openClick()" ng-show="!noSettingShow" class="btn-link"></span>' +
								'<span ng-show="noSettingShow" class="advance-icon-disable"></span>' +
								'<span style="margin-left:10px;font-size: 14px;" ng-bind="settingTitle" style="display:inline-block;"></span>' +
								'<span style="margin-left:20px;" ng-bind="btnTitle" ng-class="{true:\'btn-link\',false:\'btn-link-disable\'}[settingEnable]" ng-click="click()"></span>' +
								'<span ng-show="isEnableOffLineTransfer">' +
									'<span style="margin-left:20px;" ng-bind="enableBtnTitle" ng-class="{true:\'btn-link\',false:\'btn-link-disable\'}[enableSetting]" ng-click="enableClick()"></span>' +
									'<span style="margin-left:20px;" ng-bind="pauseBtnTitle" ng-class="{true:\'btn-link\',false:\'btn-link-disable\'}[pauseSetting]" ng-click="pauseClick()"></span>' +
									'<span style="margin-left:20px;" ng-bind="disableBtnTitle" ng-class="{true:\'btn-link\',false:\'btn-link-disable\'}[disableSetting]" ng-click="disableClick()"></span>' +
								'</span>' +
							'</div>' +
							'<div ng-show="iconOpen" style="margin-top:10px;padding-top: 15px;padding-left: 25px;overflow: auto;background-color:#f2f2f2">' +
								'<div ng-transclude style="overflow: hidden"></div>' +
							'</div>' +
						'</div>',
			scope: {viewModel:"=viewModel"},
			link: function(scope){
				var viewModel = scope.viewModel || {};
				scope.iconOpen = !viewModel.noSettingShow;
				scope.btnTitle = appUtils.getString("ism.drm.settings.menuname");
				//云备份的离线传输功能
				scope.enableBtnTitle = appUtils.getString("pg_cloudbackup_enable_offline_label");
				scope.pauseBtnTitle = appUtils.getString("pg_cloudbackup_pause_offline_label");
				scope.disableBtnTitle = appUtils.getString("pg_cloudbackup_disable_offline_label");
				if (viewModel.isEnableOffLineTransfer === true) {
				    scope.isEnableOffLineTransfer = true;
				} else {
				    scope.isEnableOffLineTransfer = false;
				};
				if (viewModel.enableSetting === true) {
				    scope.enableSetting = true;
				} else {
				    scope.enableSetting = false;
				};
				if (viewModel.pauseSetting === true) {
				    scope.pauseSetting = true;
				} else {
				    scope.pauseSetting = false;
				};
				if (viewModel.disableSetting === true) {
				    scope.disableSetting = true;
				} else {
				    scope.disableSetting = false;
				};
				//启用
				scope.enableClick = function(){
					if(!scope.enableSetting) return;

					if( angular.isFunction(viewModel.enableClick) ){
						viewModel.enableClick();
					}
				};
				//禁用
				scope.pauseClick = function(){
					if(!scope.pauseSetting) return;

					if( angular.isFunction(viewModel.pauseClick) ){
						viewModel.pauseClick();
					}
				};
				//暂停
				scope.disableClick = function(){
					if(!scope.disableSetting) return;

					if( angular.isFunction(viewModel.disableClick) ){
						viewModel.disableClick();
					}
				};
				scope.$watch("viewModel.isEnableOffLineTransfer",function(newVal,oldVal){
					if( angular.isUndefined(newVal) || newVal == oldVal ) return;

					scope.isEnableOffLineTransfer = newVal;
				});
				scope.$watch("viewModel.enableSetting",function(newVal,oldVal){
					if( angular.isUndefined(newVal) || newVal == oldVal ) return;

					scope.enableSetting = newVal;
				});
				scope.$watch("viewModel.pauseSetting",function(newVal,oldVal){
					if( angular.isUndefined(newVal) || newVal == oldVal ) return;

					scope.pauseSetting = newVal;
				});
				scope.$watch("viewModel.disableSetting",function(newVal,oldVal){
					if( angular.isUndefined(newVal) || newVal == oldVal ) return;

					scope.disableSetting = newVal;
				});
				if (viewModel.noSettingShow === true || angular.isUndefined(viewModel.noSettingShow)) {
				    scope.noSettingShow = true;
				} else {
				    scope.noSettingShow = false;
				};
				scope.settingTitle = viewModel.settingTitle || appUtils.getString("ism.drm.protect.group.template");
				if (viewModel.settingEnable === true || angular.isUndefined(viewModel.settingEnable)) {
				    scope.settingEnable = true;
				} else {
				    scope.settingEnable = false;
				};
				scope.openClick = function(){
					scope.iconOpen = !scope.iconOpen
				};
				//设置策略
				scope.click = function(){
					if(!scope.settingEnable) return;

					if( angular.isFunction(viewModel.click) ){
						viewModel.click();
					}
				};
				scope.$watch("viewModel.settingEnable",function(newVal,oldVal){
					if( angular.isUndefined(newVal) || newVal == oldVal ) return;

					scope.settingEnable = newVal;
				})
				scope.$watch("viewModel.noSettingShow",function(newVal,oldVal){
					if( angular.isUndefined(newVal) || newVal == oldVal ) return;

					scope.noSettingShow = newVal;
					scope.iconOpen = !newVal
				})
				scope.$watch("viewModel.settingTitle",function(newVal,oldVal){
					if( angular.isUndefined(newVal) || newVal == oldVal ) return;

					scope.settingTitle = newVal;
				})
				scope.$watch("viewModel.titleText",function(newVal,oldVal){
					if(!newVal) return;
					var pt = viewModel.data || {};
					if(!viewModel.createFlag && (_.contains([4,6],parseInt(pt.type)) || (pt.type == "3" && pt.sketch != "policy_template_3_cascaded_sa_dr_star.png") || (pt.type == "5" && pt.sketch != "policy_template_5_concurrent_sa_dr_star.png") )){
						return;
					};
					scope.settingTitle = newVal;
				})
			}
		}
	}];

	//策略设置
	var schedule = ["constsService", "infoTransferredService",function(Consts, infoTransferredService){
		return {
			restrict: "E",
			template: '<dynamic-compile view="view" ctrl="ctrl" view-model="viewModel"></dynamic-compile>',
			scope: {viewModel:"=viewModel"},
			link: function(scope) {
				//强制刷新
				scope.refreshFlag = 1;

				scope.$watch("viewModel.data",function(newData,oldData){
					if(newData === oldData) return;
					loadPtConfig(scope,newData);
				});

				if(!scope.viewModel || !scope.viewModel.data) return;
				var pt = scope.viewModel.data;

				loadPtConfig(scope,pt);

			}
		};

		function loadPtConfig(scope,pt){
			if (!_.isUndefined(infoTransferredService.get("hostOrGroupNameModuel", "hostOrGroupName"))) {
				infoTransferredService.remove("hostOrGroupNameModuel", "hostOrGroupName");
			}
			//SAN一体化备份清除hostname
			if (!_.isUndefined(infoTransferredService.get("hostOrGroupNameModuel", "hostOrGroupName0"))) {
				infoTransferredService.remove("hostOrGroupNameModuel", "hostOrGroupName0");
			};
			if (!_.isUndefined(infoTransferredService.get("hostOrGroupNameModuel", "hostOrGroupName4"))) {
				infoTransferredService.remove("hostOrGroupNameModuel", "hostOrGroupName4");
			};
			if ( _.isEmpty(pt) ) return;
			if( !pt.schedules ) {
				if(_.contains([3, 4, 5, 6, 17, 19, 28, 30, 31, 32, 35, 36] ,parseInt(pt.type, 10))){
					pt.schedules = [{protectLocation:1},{}];
					if (pt.type == 17) {
					    pt.schedules = [{protectLocation: 0}, {}];
					};
					//CDM重新处理
					if(_.contains([30, 31, 32] ,parseInt(pt.type, 10))){
						pt.schedules = [{protectLocation:0},{}];
					};
				}
				else if( pt.type == 0 ){
					delete pt.schedules;
				}
				else{
					pt.schedules = [{}];
				}
			}

			if (pt.type == 2 && _.size(pt.schedules) == 1 && $.isEmptyObject(_.first(pt.schedules))) {
				pt.schedules = [{protectLocation:0}, {protectLocation:0, protectedType: 101}];
			}

			//对应策略模版
			var url = pt.editTemplateUrl;
			var scheduleConf = Consts.TP_SCHEDULE_WIN.get(url,pt.type);
			if(!scheduleConf) return;

			//打开面板
			scope.view = scheduleConf.panelView + "?refresh=" + scope.refreshFlag++;
			scope.ctrl = scheduleConf.panelCtrl;
		}
	}];


	var directives = ["$compileProvider", function($CompileProvider) {
		$CompileProvider.directive({
			dynamicCompile: dynamicCompile,
			scheduleApp: scheduleApp,
			schedule: schedule,
			scheduleBase: scheduleBase,
			schedulePanel: schedulePanel,
			scheduleTitle: scheduleTitle,
			scheduleConfig: scheduleConfig
		})
	}];

	return directives;
});
