define(["lazy-load/lazyLoad", "ui-router/angular-ui-router.min", "./appMgr", "./appConfig", "./directive", "tiny-extra-directives/IconTip", "tiny-extra-directives/SelectPanel"],
    function(lazyLoadModule, router, App, appConfig, directive) {
        "use strict";

        var baseUrl = "app/business/recoverydirector/protection/";
        var routerConfig = [{
            name: "protection",
            url: "/protection",
            template: "<div ui-view></div>",
            breadcrumbs: { name: "protect_title" },
            scripts: {
                'controllers': [],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "protection.pg",
            url: "/protectionGroup?poType",
            template: "<link rel='stylesheet' type='text/css' href='../theme/recoverydirector/css/protect/protect.css'/><div ui-view></div>",
            scripts: {
                'controllers': [],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function($state, $rootScope) {
                if (window.G_APP && window.G_APP.poType == $state.params.poType) return;
                //初始化应用
                window.G_APP = App.init($state.params.poType);

                $rootScope.$on("$destroy", function() {
                    try {
                        delete window.G_APP;
                    } catch (e) {
                        window.G_APP = null;
                    }
                });
            }
        }, {
            name: "protection.pg.list",
            url: "/list",
            templateUrl: baseUrl + "views/protectiongroup/common/protectionGroupList.html",
            controller: "protection.pg.listCtrl",
            scripts: {
                'controllers': [baseUrl + "controllers/protectiongroup/common/protectionGroupListCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "protection.pg.list.abstract",
            templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/common/abstract.html",
            controller: "protection.pg.abstract.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/protection/controllers/protectiongroup/common/abstractCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "protection.pg.list.topogoly",
            templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/common/topology.html",
            controller: "protection.pg.topology.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/protection/controllers/protectiongroup/common/topologyCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "protection.pg.list.protectobjects",
            templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/common/protectionObjectList.html",
            controller: "protection.pg.protectobjects.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/protection/controllers/protectiongroup/common/protectionObjectListCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "protection.pg.list.protectobjects_vmware",
            templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/vmware/protectionObjectList.html",
            controller: "protection.pg.protectobjects_vmware.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/protection/controllers/protectiongroup/vmware/protectionObjectListCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "protection.pg.list.protectobjects_fusionsphere",
            templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/fusionsphere/protectionObjectList.html",
            controller: "protection.pg.protectobjects_fusionsphere.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/protection/controllers/protectiongroup/fusionsphere/protectionObjectListCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "protection.pg.list.policy",
            templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/common/policy.html",
            controller: "protection.pg.policy.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/protection/controllers/protectiongroup/common/policyCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "protection.pg.list.duplica",
            templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/common/duplica.html",
            controller: "protection.pg.duplica.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/protection/controllers/protectiongroup/common/duplicaCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "protection.pg.list.executionStep",
            templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/common/executionStep.html",
            controller: "protection.pg.executionStep.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/protection/controllers/protectiongroup/common/executionStepCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "protection.pg.list.executionhistory",
            templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/common/executionHistory.html",
            controller: "protection.pg.executionhistory.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/protection/controllers/protectiongroup/common/executionHistoryCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }]

        var module = angular.module("recoverydirector.protection.config", ["ui.router"]);
        module = lazyLoadModule.makeLazy(module).config(directive);
        module.tinyStateConfig({ stateConfig: routerConfig });
        return module;
    });