define([], function(){
    var ctrl = ["$scope","appUtils","constsService","restService",function($scope,appUtils,Consts,Rest){

        if(!$scope.$parent.tabShow) return;

        var resource = appUtils.resource();
        var pgId = $scope.protectGroup.pgId;

        $scope.basicInfoTitle = resource.get("current_alarm_term_win_abstract_label");
        $scope.successLabel = resource.get("common_term_succeed_label");
        $scope.failLabel =resource.get("common_term_failed_label");
        $scope.statisticsTitle = resource.get("protectionGroup.term.exeReportInOneDay.label");
        $scope.configuredRPO = resource.get("group_count_term_configured_RPO_column");
        $scope.currentRPO = resource.get("group_count_term_current_RPO_column");
        $scope.RPO = "RPO";
        $scope.basicLabels = [{
            label : resource.getWithColon("common_term_name_label"),
            value : ""
        },{
            label : resource.getWithColon("common_term_description_label"),
            value : ""
        },{
            label : resource.getWithColon("common_term_ower_label"),
            value : ""
        },{
            label : resource.getWithColon("group_count_term_protect_object_column"),
            value : ""
        },{
            label : resource.getWithColon("group_count_term_evaluate_RPO_column"),
            value : ""
        },{
            label : resource.getWithColon("protectionGroup.term.exeReportInOneDay.label"),
            value : ""
        }];

        function getRPOMeetStatus(val){
            var map = {
                    "0"  : resource.get("home_term_RPOmet_yes_tab"),
                    "-1" : resource.get("home_term_RPOmet_no_tab"),
                    "-2" : "--"
                };

            if(angular.isUndefined(map[val])){
                return resource.get("home_term_RPOmet_unknown_tab");
            }
            return map[val];
        };

        //初始化界面
        function init(pgId){
            var briefInfoDefer = $.Deferred();
            var statisticInfoDefer = $.Deferred();

            Rest.getGroupBriefInfo(pgId,{
                mask: false,
                callback : function(){
                    briefInfoDefer.resolve();
                },
                success: function(data){
                    var props = data.props || {};
                    $scope.basicLabels[0].value = data.name;
                    $scope.basicLabels[1].value = data.description == undefined ? "--" : $.trim(data.description);
                    $scope.basicLabels[2].value = props.providerName || ( (props.providerName === null) ? "null" : "--" );
                    $scope.basicLabels[3].value = data.poCount;
                    //RTO|RPO
                    var table = $("#basicInfoTable");

                    var rpo = _.contains([11, 15], +data.template.type) ? [] : appUtils.encodeForHTML(data["RPO_ITEM_KEY"]);
                    var rto = _.contains([11, 15], +data.template.type) ? [] : appUtils.encodeForHTML(data["RTO_ITEM_KEY"]);

                    var estimateRto = "--";
                    var RPOList = [];
                    $scope.RPOLists = [];
                    if( angular.isArray(rpo) && rpo.length != 0 ){
                        configRpo = "";
                        actualRpo = "";
                        var _getTIme = function(longTime) {
                            if (longTime < 0) {
                                var obj = "--"
                                return obj
                            }
                            var obj = {};
                            var day = Math.floor(longTime / (24 * 60 * 60 * 1000));
                            var h = Math.floor((longTime - day * 24 * 60 * 60 * 1000) / (60 * 60 * 1000));
                            var m = Math.floor((longTime % (60 * 60 * 1000)) / (60 * 1000));
                            var s = Math.floor((longTime % (60 * 1000)) / 1000);

                            obj.day = day == 0 ? "00" : day;
                            obj.h = h == 0 ? "00" : h;
                            obj.m = m == 0 ? "00" : m;
                            obj.s = s == 0 ? "00" : s;
                            return obj
                        };
                        var arr_copy = [];
                        var arr_fastcloudback = [];
                        var arr_cloudback = [];
                        var arr_noType = [];
                        rpo.forEach(function(rpoItem,index){
                            var configuredRPOString = _getTIme(rpoItem.configuredRPO);
                            var configuredRPOtime = {};
                            if(configuredRPOString == "--") {
                                configuredRPOtime._day = "--";
                                configuredRPOtime._h = "--";
                                configuredRPOtime._m = "--";
                                configuredRPOtime._s = "--";
                            } else {
                                configuredRPOtime._day = configuredRPOString.day;
                                configuredRPOtime._h = configuredRPOString.h;
                                configuredRPOtime._m = configuredRPOString.m;
                                configuredRPOtime._s = configuredRPOString.s;
                            }
                            rpoItem.configuredRPOtimes = [{
                                time:configuredRPOtime._day,
                                unit:appUtils.getString("pg_details_day_label")
                            },{
                                time:configuredRPOtime._h,
                                unit:appUtils.getString("pg_details_hours_label")
                            },{
                                time:configuredRPOtime._m,
                                unit:appUtils.getString("pg_details_minutes_label")
                            },{
                                time:configuredRPOtime._s,
                                unit:appUtils.getString("pg_details_seconds_label")
                            }];
                            var actualRPOString = _getTIme(rpoItem.actualRPO);
                            var actualRPOtime = {};
                            if(actualRPOString == "--") {
                                actualRPOtime._day = "--";
                                actualRPOtime._h = "--";
                                actualRPOtime._m = "--";
                                actualRPOtime._s = "--";
                            } else {
                                actualRPOtime._day = actualRPOString.day;
                                actualRPOtime._h = actualRPOString.h;
                                actualRPOtime._m = actualRPOString.m;
                                actualRPOtime._s = actualRPOString.s;
                            }
                            rpoItem.currentRPOtimes = [{
                                time:actualRPOtime._day,
                                unit:appUtils.getString("pg_details_day_label")
                            },{
                                time:actualRPOtime._h,
                                unit:appUtils.getString("pg_details_hours_label")
                            },{
                                time:actualRPOtime._m,
                                unit:appUtils.getString("pg_details_minutes_label")
                            },{
                                time:actualRPOtime._s,
                                unit:appUtils.getString("pg_details_seconds_label")
                            }];
                            if ((!_.isEmpty(rpoItem.protectedType) && rpoItem.protectedType != "--") && !_.isEmpty(rpoItem.siteId) && !_.isEmpty(rpoItem.productSiteId)) {
                                if (rpoItem.siteId != rpoItem.productSiteId) {
                                    rpoItem.siteName = rpoItem.productSiteName + " -> " + rpoItem.siteName;
                                }
                                switch (rpoItem.protectedType) {
                                    case "1":
                                        rpoItem.protectedType = appUtils.getStringWithColon("protection_HWVmware_task_createPG_para_type_value_rep_label");
                                        arr_copy.push(rpoItem);
                                        break
                                    case "2":
                                    case "100":
                                        rpoItem.protectedType = appUtils.getStringWithColon("pg_create_fastcloudback_label");
                                        arr_fastcloudback.push(rpoItem);
                                        break
                                    case "16":
                                        rpoItem.protectedType = appUtils.getStringWithColon("array.clone.name");
                                        arr_noType.push(rpoItem);
                                        break
                                    case "101":
                                        rpoItem.protectedType = appUtils.getStringWithColon("pg_create_cloudback_label");
                                        arr_cloudback.push(rpoItem);
                                        break
                                    default :
                                        rpoItem.protectedType = "";
                                        arr_noType.push(rpoItem);
                                };
                            } else if ((_.isEmpty(rpoItem.protectedType) || rpoItem.protectedType == "--") && !_.isEmpty(rpoItem.siteId) && !_.isEmpty(rpoItem.productSiteId)) {
                                rpoItem.protectedType = "";
                                if (rpoItem.siteId != rpoItem.productSiteId) {
                                    rpoItem.siteName = rpoItem.productSiteName + " -> " + rpoItem.siteName;
                                }
                                arr_noType.push(rpoItem);
                            }
                        });
                        $scope.RPOLists = arr_copy.concat(arr_fastcloudback).concat(arr_cloudback).concat(arr_noType);
                        arr_cloudback = null;
                        arr_fastcloudback = null;
                        arr_cloudback = null;
                    }
                    if( angular.isArray(rto) && rto.length != 0 ){
                        if(rto.length == 1){
                            if(_.contains([26,27],parseInt($scope.protectGroup.template.type,10))){
                                estimateRto = rto[0].productSiteName == rto[0].siteName ? "--" : rto[0].productSiteName + "->" + rto[0].siteName + "<span style='padding-left:25px'></span>" + appUtils.maxMsTimeUnit(rto[0].estimateRTO);
                            }else{
                                var site = rto[0].productSiteName == rto[0].siteName ? rto[0].siteName : rto[0].productSiteName + " -> " + rto[0].siteName;
                                estimateRto = site + "<span style='padding-left:25px'></span>" + appUtils.maxMsTimeUnit(rto[0].estimateRTO);
                            }
                        }else{
                            estimateRto = "";
                            rto.forEach(function(rtoItem){
                                estimateRto += rtoItem.productSiteName + " -> " + rtoItem.siteName + "<span style='padding-left:25px'></span>" + appUtils.maxMsTimeUnit(rtoItem.estimateRTO) + "<br>";
                            });
                            estimateRto = estimateRto.replace(/<br>$/,"");
                        }
                    }
                    table.find("tr:eq(4) td div").html(estimateRto);
                    $scope.$apply();
            }});

            Rest.getProtectGroupStatisticInfo({protectgroupId:pgId,range:"LAST_24_HOURS"},{
                mask: false,
                "success" : function(data){
                   var statistics = "--";
                   var table = $("#basicInfoTable");
                   statistics =  "<span class = 'icon-success' style='display: inline-block;width:16px;height:16px;position: relative;top:3px;margin-right:3px;'></span>"  +
                                data.successCount +
                                " <span class='statistics_failed' style='display: inline-block;width:16px;height:16px;position: relative;top:3px;margin:0px 3px 0px 10px;'></span> " +
                                data.failCount;
                   table.find("tr:eq(5) td div").html(statistics);
                   $("#countDiv").show();
                },
                "callback" : function(data){
                    $("#excuteStatusLoadDiv").hide();
                    $("#donaChartDiv").show();
                    statisticInfoDefer.resolve();
                }
            });

            $scope.maskHandle = $.Deferred();
            $scope.$apply();
            $.when(briefInfoDefer,statisticInfoDefer).then(function(){
                $scope.maskHandle.resolve();
                $scope.$apply();
            });
        }
        init(pgId);

        //监听保护组对象的改变
        $scope.$on(Consts.PG_SELECT_EVENT,function(evt,msg){
            init(msg.protectGroup.pgId);
        });

    }];
    var module = angular.module('recoverydirector.protection.config');
    module.tinyController('protection.pg.abstract.ctrl', ctrl);
    return module;
});
