define([], function() {
	"use strict";
	var ctrl = ["$scope", "message", "constsService", "appUtils",  "model", "statusEnumService", "restService", "$injector", "$compile",
			function($scope, message, Consts, appUtils, Model, Status, Rest, $injector, $compile) {

				 var resource = appUtils.resource();

				 var data = appUtils.getWinData();
				 var poLen = data.poLen;
				 var providerName = data.providerName;
				 var G_pg  = new Model.ProtectGroup(data.protectGroup);
				 var tableFixer = appUtils.tableFixer("addPoTable","moUuid");
				 var testStatus = [];

				 $scope.showSearch = G_pg.poType == 1 || G_pg.poType == 2 || G_pg.poType == 3;
				 $scope.clickActionType = 2;
				 $scope.Consts = Consts;

				 $scope.text = {
				    name : resource.getWithColon("ism.drm.drp.local.pg.name.label"),
					type : resource.getWithColon("pg_list_po_type_label"),
					providerName : resource.getWithColon("ism.drm.site.host"),
					avaliableObj : resource.getWithColon("ism.drm.protect.element.available")
				 };

				 $scope.model = {
					name    : G_pg.name ,
					providerName : providerName,
					type    : resource.get("protect_object")[G_pg.poType],
					searchSelect : {
						id : "searchSelect",
						values : [{selectId : "name", label : resource.get("ism.drm.proetct.group.appdb.dbname.column")},
						          {selectId : "instanceName", label : resource.get("ism.drm.proetct.group.appdb.instance.column")}],
						defaultSelectid : "name"
					},
					search : {
						id : "dbSearchBox",
						searchFn : function(query){
							query = appUtils.formatSearchVal(query);

							var  key    = $("#searchSelect").widget().getSelectedId(),
							     filter = "extFilter." + key + "=" + query;

							$scope.table.tableFixer.search = true;
							Rest.getAddAvailableProtectObject({pgId:G_pg.pgId,poType:G_pg.poType,_FILTER:filter},updateTable);
						}
					}
				 };

				 $scope.table = {
						id : "addPoTable",
						displayLength : Consts.TABLE_COUNT_PER_PAGE,
			            checkbox : true,
			            tableFixer : tableFixer,
						columns : [ {
							"mData" : "moUuid",
							"bVisible" : false
						},{
							"sTitle" : G_pg.poType == 16 ? resource.get("site_term_system_id_label") : resource.get("ism.drm.proetct.group.appdb.dbname.column"),
							"mData" : "name",
							"bVisible": G_pg.poType != 15
						},{
							"sTitle" : G_pg.poType == 16 ? resource.get("site_term_instance_number_label") : resource.get("ism.drm.proetct.group.appdb.instance.column"),
							"mData" : "props.INSTANCENAME",
							"bSortable" : false
						},{
							"sTitle" : resource.get("ism.drm.proetct.group.appdb.version.column"),
							"mData" : "props.VERSION",
							"bSortable" : false
						}],
					    cellClickActive : function(event, cell) {
							tableFixer.click(cell,function(){
								//数据库测试连接窗口
								if( $scope.clickActionType == 2 ){
									if (G_pg.poType == 15) {
									    tableFixer.click(cell, function() {
									        testDB(cell);
									    }, function() {
									        var testPo = appUtils.getItemFromArray(testStatus, "moUuid", cell.moUuid);
									        if (testPo) {
									            testPo.testOk = false;
									        }
									    })

									} else {
										openTestWin(cell,event);
									}
								}
								else if( $scope.clickActionType == 1 ){
									 var poModel = new Model.ProtectObject(cell);

									 var error =
		                             poModel.loadStorageInfo({
		                            	 success: function (result) {
		                            		 message.success(resource.get("common_term_operation_success_label"));
		                            	 },
		                            	 fail : function(){
		                        				tableFixer.cancelSelect(event,cell);
		                        		},
		                            	timeout: Consts.AJAX_TIMEOUT
		                             });

									 if( !Model.util.checkError(error) ){
	                                	message.error({
	                            			content:resource.get(Consts.ERROR_DESC[error],$.encoder.encodeForHTML(poModel.name)),
	                            			ok : function(){
	                            				tableFixer.cancelSelect(event,cell);
	                            			}
	                            		});
	                            		return;
		                            }
								}
							},function(){
								if( G_pg.poType == 1 || G_pg.poType == 2 || G_pg.poType == 3 ){
			                    	var testPo = appUtils.getItemFromArray(testStatus,"moUuid",cell.moUuid);
			                    	if(testPo){
			                    		testPo.testOk = false;
			                    	}
		                    	}
		                    });
					    },
					    tHeadCheckboxFn : function(){
							tableFixer.click();
						},
					    drawCallback : function(){
					    	tableFixer.selectRow();
					    	//oracle 12.2离线状态checkbox灰化并有tips
					    	if(G_pg.poType == 1 && !!_.size($("#addPoTable .table_checkbox_disable"))){
					    		_.each($("#addPoTable .table_checkbox_disable"), function(item){
					    			var tipsScope = $scope.$new();
					    			$(item).attr("tiny-tip", "disableTip");
					    			var dbName = $(item).parent("td").next("td").html();
					    			tipsScope.disableTip = {
					    				content: appUtils.getString("protection_create_oracle_disable_label", dbName),
					    				width: "250px",
					    				position: "top-right"
					    			};
					    			$compile($(item))(tipsScope);
					    		})
					    	}
					    },
					    renderRow : function(nRow, aData, iDataIndex){
					    	var instancename = aData.props && aData.props.INSTANCENAME;
					    	if (G_pg.poType == 15) {
					    		if(instancename){
					    			$('td:eq("1")', nRow).text(Model.util.formatIstName(instancename));
					    		}
					    	} else {
					    		if(instancename){
					    			$('td:eq("2")', nRow).text(Model.util.formatIstName(instancename));
					    		}
					    	}

					    	if( G_pg.poType == 1 || G_pg.poType == 2 || G_pg.poType == 3 ){
					    		//初始化验证状态
			    				updateTestStatus(aData.moUuid,$('td:last', nRow));
					    	}
					    }
				 };

				var updateTable = appUtils.newUpdateTable($scope.table,$scope, function(data){
					//oracle 12.2状态离线不允许选中，checkbox灰化
					if (G_pg.poType == 1 && !_.isEmpty(data)) {
					    try {
					        _.each(data, function(val) {
					            val.poStatus == 1 && val.props.VERSION.startsWith("12.2") && _.extend(val, {
					                tinyCheckDisabled: true
					            })
					        })
					    } catch (err) {}
					};
				});

				function openTestWin(po,event){

					var config = angular.copy(Consts.DB_TEST_WIN);
					var isOracle = G_pg.poType == "1";

					config.title  = resource.get(config.title);
					if( po.props.IS_ASM == "1" ){
						config.height = isOracle ? 400 : 370;
					}else{
						config.height = isOracle ? 300 : 265;
					}

					config.close  = function(){
						appUtils.getWinData() !== true && _cancelSelect(event,po.moUuid);
					};

					appUtils.openWin(config,{event:event,po:po,testStatus:testStatus,updateTestStatus:updateTestStatus});

					//取消选中
		        	function _cancelSelect(event,moUuid){
						tableFixer.cancelSelect(event,{moUuid:moUuid});
		        	}
				}

				function updateTestStatus(moUuid,td){
					var testPoStatus = appUtils.getItemFromArray(testStatus,"moUuid",moUuid);
					if( testPoStatus && testPoStatus.testStatusHtml ){
						if(!td){
							//通过moUuid找到td
							var aoData = $("#addPoTable").widget()._getoSettings().aoData;
							aoData.forEach(function(item){
								if( item._aData.moUuid == moUuid ){
									td = $("td:last",item.nTr);
								}
							});
						}
						td.html(testPoStatus.testStatusHtml);
					}
				}

				function testDB(cell) {
			        var testPoStatus = appUtils.getItemFromArray(testStatus, "moUuid", cell.moUuid);
			        if (!testPoStatus) {
			            testPoStatus = {
			                moUuid: cell.moUuid
			            };
			            testStatus.push(testPoStatus);
			        } else {
			            testPoStatus.testOk = false;
			        }
			        var iconHtml = '<span class="iconbutton-loading iconbutton"></span>' + resource.get("protection_app_db_status_check");
			        testPoStatus.testStatusHtml = iconHtml;
			        updateTestStatus(testPoStatus.moUuid);
			        var poModel = new Model.ProtectObject(cell);
			        poModel.validateAuthInfo({
			            "timeout": Consts.AJAX_TIMEOUT,
			            "mask": false,
			            "success": function() {

			                iconHtml = '<span class="iconbutton-loading iconbutton"></span>' + resource.get("protection_app_loadStorage");
			                testPoStatus.testStatusHtml = iconHtml;
			                updateTestStatus(testPoStatus.moUuid);

			                //测试连接通过以后加载存储信息
			                poModel.loadStorageInfo({
			                    "timeout": Consts.AJAX_TIMEOUT,
			                    "mask": false,
			                    "success": function() {
			                        iconHtml = '<span class="icon-success iconbutton"></span>' + resource.get("protection_app_loadStorage_success");
			                        testPoStatus.testStatusHtml = iconHtml;
			                        updateTestStatus(testPoStatus.moUuid);

			                        testPoStatus.testOk = true;
			                    },
			                    "fail": function(errObj, errDetail) {
			                        iconHtml = '<span class="icon-failed iconbutton"></span>' + resource.getWithColon("home.term.testStatusInLastThreeMonth.value.fail.label") + " " + errDetail;
			                        testPoStatus.testStatusHtml = iconHtml;
			                        updateTestStatus(testPoStatus.moUuid);
			                    },
			                    "isShowMsgBox": false
			                });
			            },
			            "fail": function(errObj, errDetail) {
			                iconHtml = '<span class="icon-failed iconbutton"></span>' + resource.getWithColon("home.term.testStatusInLastThreeMonth.value.fail.label") + " " + errDetail;
			                testPoStatus.testStatusHtml = iconHtml;
			                updateTestStatus(testPoStatus.moUuid);
			            },
			            "isShowMsgBox": false
			        });
			    }


                function confirmAction() {
                    G_pg.polist = Model.util.generatePoListFromTable(tableFixer);
                    G_pg.addProtectObject({
                    	"interceptor" : function(next){
                    		if(  G_pg.poType == 1 || G_pg.poType == 2 || G_pg.poType == 3 || G_pg.poType == 15 || G_pg.poType == 16){
			                    //检查选中的数据库是否全部验证成功
								var testOk = G_pg.polist.every(function(item){
									var poStatus = appUtils.getItemFromArray(testStatus,"moUuid",item.moUuid);
									return poStatus && poStatus.testOk;
								});
								if(!testOk){
									message.error(resource.get("protection_app_valid_error_msg"));
									return false;
								}
							}
                    		//快照和vis快照和双活+快照模板需要高危提示
                    		var msg = appUtils.getString("protection.VISSnapshot.task.addProtectedObject.danger.message1",$.encoder.encodeForHTML(G_pg.name)) + "<br>" + appUtils.getString("protection.VISSnapshot.task.addProtectedObject.danger.message2") + "<br>"
                			+ appUtils.getString("protection.VISSnapshot.task.addProtectedObject.danger.message3");

                    		if( G_pg.template.type == 9 || G_pg.template.type == 1){
                    			message.warn({
                    				content : msg,
                    				ok:function(){
                    					next();
                    				}
                    			});
                    		}else{
                    			next();
                    		}
                    	},
                        "success": function () {
                            message.prompt({
                                content: appUtils.getString(resource.get("site_term_refresh_message")),
                                ok: function () {
                                	appUtils.closeWin(true,"ADD_PO_WIN");
                                }
                            });
                        },
                        "poNum": poLen
                    });
                }

				 (function init(){

					 //解析配置
					 var config = G_APP.getPoAddConfig();
					 if( angular.isObject(config) ){
						 var table;
						 if( angular.isObject(table = config.table) ){

						 	//renderRow
							var renderRow = table.renderRow;
							//支持服务注入
							if( angular.isArray(renderRow) ){
								var fn = renderRow.pop(),deps = [];
								angular.forEach(renderRow,function(i){
									deps.push($injector.get(i));
								});
								table.renderRow = fn.apply(null,deps);
							}

                             appUtils.assign($scope.text,  "avaliableObj",    resource.getWithColon(table.desc));
                             appUtils.assign($scope,       "clickActionType", table.clickActionType);
                             appUtils.assign($scope.table, "columns",         table.columns);
                             appUtils.assign($scope.table, "renderRow",       table.renderRow);

							 $scope.table.columns.forEach(function(col){
								 appUtils.assign( col , "sTitle" , resource.get(col.sTitle) );
							 });
						 }
					 }

					if( G_pg.poType == 1 || G_pg.poType == 2 || G_pg.poType == 3 || G_pg.poType == 15 || G_pg.poType == 16){
						$scope.table.columns.push({
							"sTitle" : resource.get("protection_app_valid_title"),
							"mData" : "",
							"bSortable" : false
						});
					}

					 $("#"+Consts.ADD_PO_WIN.winId).widget().option("buttons",[{
	                     label : resource.get("common_term_confirm_button"),
	                     handler : confirmAction
					 }]);

                     Rest.getAddAvailableProtectObject({pgId: G_pg.pgId, poType: G_pg.poType}, function(data){
                    	    updateTable(data);
							if(G_pg.poType == 8){
								if( G_pg.props.dbVersion == 1 ){
									$("#addPoTable").find("table:eq(1) tr:eq(0) th:eq(1)").text(resource.get("ism.drm.proetct.group.appdb.storagegroup.column"));
								}else{
									$("#addPoTable").find("table:eq(1) tr:eq(0) th:eq(1)").text(resource.get("ism.drm.proetct.group.appdb.dbname.column"));
								}
							}
                     });

				 }());

			}];

	var module = angular.module("recoverydirector.protection.config");
	module.tinyController("addProtectObjectsCtrl", ctrl);
	return module;
});
