define(["tiny-common/UnifyValid"],
function(UnifyValid){
	var ctrl = ["$scope", "message", "appUtils", "model","constsService",
	     function($scope, message, appUtils, Model, Consts){

			var resource = appUtils.resource();
			$scope.Consts = Consts;

			var winData = appUtils.getWinData();
			var clickEvent = winData.event;
			$scope.testPo = winData.po;

			var testStatus = winData.testStatus;
			var testPoStatus = appUtils.getItemFromArray(testStatus,"moUuid",$scope.testPo.moUuid);
			var updateTestStatus = winData.updateTestStatus;



		    $scope.text = {
				dbName : resource.getWithColon("ism.drm.proetct.group.appdb.dbname.column"),
				dbInsName : resource.getWithColon("ism.drm.proetct.group.appdb.instance.column"),
				username : resource.getWithColon("common_term_username_label"),
				password : resource.getWithColon("common_term_password_label"),
				asmInsName : resource.getWithColon("ism.drm.protect.group.asm.asmInstanceName"),
				asmUsername : resource.getWithColon("ism.drm.protect.group.asm.usename"),
				asmPassword : resource.getWithColon("ism.drm.protect.group.asm.password"),
				valiType : resource.getWithColon("common_term_authenticationMode_label")
			};

			if($scope.testPo.poType == 16){
				$scope.text.dbName = resource.getWithColon("site_term_system_id_label");
				$scope.text.dbInsName = resource.getWithColon("site_term_instance_number_label");
			};

			$scope.model = {
				dbName : $scope.testPo.name,
				instanceName : Model.util.formatIstName($scope.testPo.props.INSTANCENAME),
				isAsm : $scope.testPo.props.IS_ASM == "1",
				isOracle : $scope.testPo.poType == "1",
				username : {
					id : "username",
					validate : $scope.testPo.poType == 16 ? "required;maxSize(128):" + appUtils.getString("validate_term_expr_length") : Consts.VALID.AUTH_NAME,
					disable : false
				},
				password : {
					id : "password",
					validate : $scope.testPo.poType == 16 ? "required;maxSize(128):" + appUtils.getString("validate_term_expr_length") : Consts.VALID.AUTH_PWD,
					type : "password",
					disable : false
				},
				asmInsName : {
					id : "asmInsName",
					validate :  Consts.VALID.AUTH_NAME,
					value : "+ASM",
					disable : false
				},
				asmUsername : {
					id : "asmUsername",
					validate : Consts.VALID.AUTH_NAME,
					disable : false
				},
				asmPassword : {
					id : "asmPassword",
					validate : Consts.VALID.AUTH_PWD,
					type : "password",
					disable : false
				},
				type : {
					id : "type",
					values : [{label:resource.get("common_term_authenticationMode_value_database_value"), selectId:"0"},{label:resource.get("common_term_authenticationMode_value_os_value"), selectId:"1"}],
					defaultSelectid : "0",
					message : appUtils.getString("pg_certification_mode_message"),
					change : function(p){
						var typeId = $("#type").widget().getSelectedId();
						if( typeId == "1" ){
							enableInput(false);
						}else{
							enableInput(true);
						}
					}
				}
			};

			function enableInput(enable){
				$scope.model.username.disable = !enable;
				$scope.model.password.disable = !enable;
				$scope.model.asmInsName.disable = !enable;
				$scope.model.asmUsername.disable = !enable;
				$scope.model.asmPassword.disable = !enable;

				$scope.model.asmInsName.disable = false;
			}


			$("#"+Consts.DB_TEST_WIN.winId).widget().option("buttons",[{
                    label : resource.get("common_term_yes_button"),
                    handler : function(event) {
                    	if( $scope.model.isOracle ){
                    		//操作系统认证
                    		if( $("#type").widget().getSelectedId() == "1" ){
                    			var ok = UnifyValid.FormValid($("#dbTestWinDiv"), {focusInvalid: true});
                            	if(!ok) return;

                            	$scope.testPo.props.AUTH_TYPE = "1";
                				if( $scope.testPo.props.IS_ASM == "1" ){
                					$scope.testPo.props.ASM_INSTANCENAME = $("#asmInsName").widget().getValue();
                				}

                				testDB();
                    			return;
                    		}
                    		else{
                    			$scope.testPo.props.AUTH_TYPE = "0";
                    		}
                    	}

                    	var ok = UnifyValid.FormValid($("#dbTestWinDiv"), {focusInvalid: true});
                    	if(!ok) return;

                    	var username = $("#username").widget().getValue();
                    	var password = $("#password").widget().getValue();

						$scope.testPo.props.USERNAME = username;
						$scope.testPo.props.PASSWD = password;

						if($scope.testPo.props.IS_ASM == "1"){
							  var asmInstanceName = $("#asmInsName").widget().getValue();
							  var asmname = $("#asmUsername").widget().getValue();
							  var asmpwd = $("#asmPassword").widget().getValue();

							  $scope.testPo.props.ASM_INSTANCENAME = asmInstanceName;
							  $scope.testPo.props.ASM_USERNAME = asmname;
							  $scope.testPo.props.ASM_PASSWD = asmpwd;
						}

						testDB();
                    }
			}]);

			function testDB(){
				if( !testPoStatus ){
					testPoStatus = {moUuid:$scope.testPo.moUuid};
					testStatus.push(testPoStatus);
				}
				else{
					testPoStatus.testOk = false;
				}

				var iconHtml = '<span class="iconbutton-loading iconbutton"></span>' + resource.get("protection_app_dbtest");
				testPoStatus.testStatusHtml = iconHtml;
				updateTestStatus(testPoStatus.moUuid);

				appUtils.closeWin(true);

				var poModel = new Model.ProtectObject($scope.testPo);
				poModel.validateAuthInfo({
					"timeout" : Consts.AJAX_TIMEOUT,
					"mask": false,
					"success" : function(){

						iconHtml = '<span class="iconbutton-loading iconbutton"></span>' + resource.get("protection_app_loadStorage");
						testPoStatus.testStatusHtml = iconHtml;
						updateTestStatus(testPoStatus.moUuid);

						//测试连接通过以后加载存储信息
						poModel.loadStorageInfo({
							"timeout" : Consts.AJAX_TIMEOUT,
							"mask": false,
							"success" : function(){
								iconHtml = '<span class="icon-success iconbutton"></span>' + resource.get("protection_app_loadStorage_success");
								testPoStatus.testStatusHtml = iconHtml;
								updateTestStatus(testPoStatus.moUuid);

								testPoStatus.testOk = true;
							},
							"fail": function(errObj,errDetail){
								iconHtml = '<span class="icon-failed iconbutton"></span>' + resource.getWithColon("home.term.testStatusInLastThreeMonth.value.fail.label") + " " + errDetail;
								testPoStatus.testStatusHtml = iconHtml;
								updateTestStatus(testPoStatus.moUuid);
							},
							"isShowMsgBox": false
						});
					},
					"fail": function(errObj,errDetail){
						iconHtml = '<span class="icon-failed iconbutton"></span>' + resource.getWithColon("home.term.testStatusInLastThreeMonth.value.fail.label") + " " + errDetail;
						testPoStatus.testStatusHtml = iconHtml;
						updateTestStatus(testPoStatus.moUuid);
					},
					"isShowMsgBox": false
				});
			}

	}];

	var dbTestWinModule = angular.module("recoverydirector.protection.config");
	dbTestWinModule.tinyController("dbTestWinCtrl", ctrl);
    return dbTestWinModule;
});
