define(["tiny-common/UnifyValid"], function(UnifyValid){
	var ctrl = ["$scope","appUtils","constsService","restService","statusEnumService","message",
	            function($scope,appUtils,Consts,Rest,Status,message){

		if(!$scope.$parent.tabShow) return;

		var resource = appUtils.resource();

		var isIntegration = $scope.protectGroup.template.type == 17,
			localSchedule = resource.get("protection_exebackup_storage_snapshot_des_localBackup_label"),
			remoteSchedule = resource.get("protection_exebackup_storage_snapshot_des_remoteBackup_label"),
			defaultColumns = [{
					"sTitle" : resource.get("ism.drm.proetct.group.appdb.status.column"),
					"mData" : "status"
				},{
					"sTitle" : resource.get("recovery.term.test.replica.colum.replicaTime"),
					"mData" : "timeStamp"
				},{
					"sTitle" : resource.get("site.term.resourceOwingSite.column"),
					"mData" : "recoverySite",
					"bSortable" : false
				}],
			integrationColumns = [{
					"sTitle" : resource.get("ism.drm.proetct.group.appdb.status.column"),
					"mData" : "status"
				},{
					"sTitle" : resource.get("recovery.term.test.replica.colum.replicaTime"),
					"mData" : "timeStamp"
				},{
					"sTitle" : resource.get("site.term.resourceOwingSite.column"),
					"mData" : "recoverySite",
					"bSortable" : false
				},{
					"sTitle" : resource.get("common_term_type_label"),
					"mData" : "protectLocation",
					"bSortable" : false
				}];
		$scope.maskFlag = false;
		$scope.dpTable = {
				id : "dpTable",
				displayLength : Consts.TABLE_COUNT_PER_PAGE,
				columns : isIntegration ? integrationColumns : defaultColumns,
				renderRow : function(nRow, aData, iDataIndex){
					Status.setRenderRowStatus(arguments,{
			    		0 : ["DUPLICA_STATUS" , "status"],
			    		1 : ["I18N" , aData.status == 0 || aData.timeStamp == "" || aData.timeStamp == null ? "--" : aData.timeStamp]
			    	});

					if (isIntegration) {
						$("td[tdtitle='" + appUtils.getString("common_term_type_label") +
					    "']", nRow).html(aData.protectLocation == 0 ? localSchedule : remoteSchedule);
					}
				}
		};
		//起始页
		var _startPage = 1;
		var _siteLocation = $scope.protectGroup.productSiteId;
		var _startTime = "";
		var _endTime = "";
		var _backupType = "3";
		var resetConditions = function(){
			_startPage = 1;
			_siteLocation = $scope.protectGroup.productSiteId;
			_startTime = "";
			_endTime = "";
			_backupType = "3";
		};
		//转换数据模式,后台分页
		var transformData = function(data){
			if(_.isEmpty(data)){
				return {
					records: [],
					totalCount: 0
				};
			};
			return {
				records: data.replicas,
				totalCount: data.totalCount
			};
		};
		$scope.sanDpTable = {
			id: "sanDpTable",
			displayLength : Consts.TABLE_COUNT_PER_PAGE,
			paginationStyle:"full_numbers",
			columns: [{
				"sTitle" : resource.get("common_term_name_label"),
				"mData" : "name"
			},{
				"sTitle" : resource.get("ism.drm.proetct.group.appdb.status.column"),
				"mData" : "status"
			},{
				"sTitle": appUtils.getString("datamount_create_resource_id_label"),
				"mData": "",
				"bSortable": false
			},{
				"sTitle" : resource.get("recovery.term.test.replica.colum.replicaTime"),
				"mData" : "timeStamp"
			}, {
				"sTitle" : resource.get("site.term.resourceOwingSite.column"),
				"mData" : ""
			}, {
				"sTitle" : resource.get("topo_term_quorumserverIp_label"),
				"mData" : "storageIp",
				"bSortable" : false
			}, {
				"sTitle" : resource.get("common_term_type_label"),
				"mData" : "type"
			}, {
				"sTitle" : resource.get("protection_object_column_level_label"),
				"mData" : "generation",
				"bSortable" : false
			}, {
				"sTitle" : $scope.protectGroup.poType == 10 ? resource.get("protection_object_column_cluster_label") : resource.get("protection_object_column_hosts_label"),
				"mData" : "mountHost",
				"bSortable" : false
			}],
			data: [],
			opAreaConfig: appUtils.flilterOperRight([{
			    id: "deleteDpBtn",
			    authKey: "ism.drm.protectgroup.auth.execute",
			    template: "<div class='iconbutton-delete' title='" + resource.get("protection_object_action_delete_dp_label") + "'></div>",
			    clickActive: function() {
			        if (!$("#deleteDpBtn div").hasClass("iconbutton-delete")) {
			            return;
			        };
			        var hoverData = _.first($("#sanDpTable").widget().getHoverData());
			        message.warn({
			            content: appUtils.getString("protection_object_delete_dp_warn_label"),
			            ok: function() {
			                Rest.sanHyperReplicaDelete([$scope.protectGroup.uuid, hoverData.id], function(result) {
			                    message.prompt({
			                        content: appUtils.getString("common_term_operationsyn_success_label"),
			                        ok: function() {
			                            init($scope.protectGroup.pgId);
			                        }
			                    })
			                })
			            }
			        })
			    }
			}]),
			hoverActive: function(e, param) {
				var optsConfig = appUtils.flilterOperRight([{
				    id: "deleteDpBtn",
				    authKey: "ism.drm.protectgroup.auth.execute",
				    template: "<div class='iconbutton-delete' title='" + resource.get("protection_object_action_delete_dp_label") + "'></div>",
				    clickActive: function() {
				        if (!$("#deleteDpBtn div").hasClass("iconbutton-delete")) {
				            return;
				        };
				        var hoverData = _.first($("#sanDpTable").widget().getHoverData());
				        message.warn({
				            content: appUtils.getString("protection_object_delete_dp_warn_label"),
				            ok: function() {
				                Rest.sanHyperReplicaDelete([$scope.protectGroup.uuid, hoverData.id], function(result) {
				                    message.prompt({
				                        content: appUtils.getString("common_term_operationsyn_success_label"),
				                        ok: function() {
				                            init($scope.protectGroup.pgId);
				                        }
				                    })
				                })
				            }
				        })
				    }
				}]);
				$scope.sanDpTable.opAreaConfig = param.generation != 2 ? [] : optsConfig;
				$scope.$apply();

				if (param.generation == 2 && !_.contains([0, 1, 3], param.mountStatus)) {
				    $("#deleteDpBtn div").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
				} else {
				    $("#deleteDpBtn div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
				}
			},
			renderRow: function(nRow, aData, iDataIndex){
				Status.setRenderRowStatus(arguments,{
		    		1 : ["DUPLICA_STATUS" , "status"],
		    		2 : ["I18N" , aData.status == 0 || aData.timeStamp == "" || aData.timeStamp == null ? "--" : aData.timeStamp]
		    	});
		    	$("td[tdtitle='" + appUtils.getString("common_term_type_label") + "']", nRow).html(Status.getStatus("REPLICA_TYPE", aData.type));
		    	$("td[tdtitle='" + appUtils.getString("datamount_create_resource_id_label") + "']", nRow).html(_.isEmpty(aData.props.StorageIds) ? "--" : aData.props.StorageIds);
				if (_.isEmpty(aData.mountHost)) {
			        $("td:eq(8)", nRow).html("--");
				};
				if (!_.isEmpty(aData.props.CLOUD_SITE_ID)) {
					Rest.getSiteDetails(aData.props.CLOUD_SITE_ID,function(data) {
						$("td[tdtitle='" + appUtils.getString("site.term.resourceOwingSite.column") + "']", nRow).html(data.name);
					})
				} else {
					$("td[tdtitle='" + appUtils.getString("site.term.resourceOwingSite.column") + "']", nRow).html(aData.recoverySite);
				}

			},
			callback: function(oPage){
				_startPage = oPage.currentPage;
				initByTime();
			}
		};
		//按时间查询副本信息
		function initByTime(){
			!_.isEmpty($("#startTime").widget()) && (_startTime = $("#startTime").widget().getDateTime());
			!_.isEmpty($("#endTime").widget()) && (_endTime = $("#endTime").widget().getDateTime());
			if(!_.isEmpty(_startTime) && _.isEmpty(_endTime)){
				_startTime = appUtils.newDate(_startTime).getTime();
				//未选择结束时间默认在2099年
				_endTime = new Date().setFullYear(2099);
			};
			if(!_.isEmpty(_endTime) && _.isEmpty(_startTime)){
				_endTime = appUtils.newDate(_endTime).getTime();
				_startTime = 0;
			};
			if(!_.isEmpty(_endTime) && !_.isEmpty(_startTime)){
				_startTime = appUtils.newDate(_startTime).getTime();
				_endTime = appUtils.newDate(_endTime).getTime();
			};
			$scope.maskFlag = false;
        	$scope.maskHandle = $.Deferred();
			$scope.$apply();
			var params = {
				protectGroupId: $scope.protectGroup.pgId,
				startTime: _startTime,
				endTime: _endTime,
				startPage: _startPage,
				siteId: _siteLocation,
				replicaType: _backupType
			};
			Rest.queryPageSizeReplicas(params, {
        		mask : false,
        		success : function(data){
        			data = transformData(data);
	        		updateSandpTable(data);
	        	},
	        	callback : function(){
	        		$scope.maskHandle.resolve();
	        		$scope.maskFlag = true;
	        		$scope.$apply();
	        	}
        	});
		};
		$scope.init = function(){
			if(!_.isEmpty($("#startTime").widget()) && !_.isEmpty($("#endTime").widget())){
				$("#startTime").widget().empty();
				$("#endTime").widget().empty();
			};
			$("#backupType").widget().opChecked("3");
			init($scope.protectGroup.pgId);
		};

		$scope.refresh = {
			title: appUtils.getString("common_term_refresh_button"),
			startTime: {
				id: "startTime",
				label: appUtils.getString("common_term_from_label"),
				type : "datetime",
				dateFormat : 'yy-mm-dd',
				timeFormat : "hh:mm:ss",
				onClose: function() {
					_startPage = 1;
					$scope.sanDpTable.curPage = {
						"pageIndex": 1
					};
					initByTime();
				}
			},
			endTime: {
				id: "endTime",
				label: appUtils.getString("common_term_to_label"),
				type : "datetime",
				dateFormat : 'yy-mm-dd',
				timeFormat : "hh:mm:ss",
				onClose: function() {
					_startPage = 1;
					$scope.sanDpTable.curPage = {
						"pageIndex": 1
					};
					initByTime();
				}
			},
			siteName: {
				id: "siteName",
				label: appUtils.getStringWithColon("common_term_remoteSite_label"),
				values: [{
					selectId: "-1",
					label: appUtils.getString("common_term_pleaseSelect_listbox")
				}],
				defaultSelectid: "-1",
				closeFn: function(){
					var siteId = $("#" + this.id).widget().getSelectedId();
					_siteLocation = siteId;
					_startPage = 1;
					$scope.sanDpTable.curPage = {
						"pageIndex": 1
					};
					initByTime();
				}
			},
			backupType: {
				id: "backupType",
				values: [{
					selectId: "3",
					label: appUtils.getString("pg_copybackuptype_snapshot_label")
				},{
					selectId: "4",
					label: appUtils.getString("pg_copybackuptype_hypercdp_label")
				},{
					selectId: "101",
					label: appUtils.getString("pg_copybackuptype_cloudbackup_label")
				},{
					selectId: "9",
					label: appUtils.getString("pg_copybackuptype_cloneduplica_label")
				}],
				defaultSelectid: "3",
				closeFn: function(){
					var backupTypeId = $("#" + this.id).widget().getSelectedId();
					_backupType = backupTypeId;
					_startPage = 1;
					$scope.sanDpTable.curPage = {
						"pageIndex": 1
					};
					initByTime();
				}
			}
		};


		var updatedpTable = appUtils.newUpdateTable($scope.dpTable , $scope);
		var updateSandpTable = appUtils.newUpdateTable($scope.sanDpTable , $scope);

		$scope.$on(Consts.PG_SELECT_EVENT,function(evt,msg){
			isIntegration = $scope.protectGroup.template.type == 17;
			if (isIntegration) {
				$scope.dpTable.columns = integrationColumns
			}else{
				$scope.dpTable.columns = defaultColumns
			}
			init(msg.protectGroup.pgId);
		});

        function init(pgId){
        	$scope.isSanHyperVault = _.contains([30,31,32,2,19],parseInt($scope.protectGroup.template.type, 10));
        	if ($scope.isSanHyperVault && !_.isEmpty($("#startTime").widget()) && !_.isEmpty($("#endTime").widget())) {
			    $("#startTime").widget().empty();
			    $("#endTime").widget().empty();
			};
			if($scope.isSanHyperVault){
				//获取站点列表
				Rest.queryLocalServer([], function(data) {
				    if (data) {
				        Rest.querySites([data.uuid],function(data){
				        	appUtils.updateSelectValues("siteName",data,"siteId","name");
				        	$scope.refresh.siteName.defaultSelectid = $scope.protectGroup.productSiteId;
				        });
				    }
				});
				//重置副本下拉框
				$("#backupType").length > 0 && $("#backupType").widget().opChecked("3");
			};
			//清空查询条件
			resetConditions();
        	$scope.maskFlag = false;
        	$scope.maskHandle = $.Deferred();
			$scope.$apply();

        	//快照类单独的接口
        	if($scope.isSanHyperVault){
	        	initByTime();
        	}else{
	        	Rest.queryProtectGroupReplicas([pgId],{
	        		mask : false,
	        		success : function(data){
		        		updatedpTable(data);
		        	},
		        	callback : function(){
		        		$scope.maskHandle.resolve();
		        		$scope.maskFlag = true;
		        		$scope.$apply();
		        	}
	        	});
        	}
		};

		init($scope.protectGroup.pgId);

	}];
	var module = angular.module('recoverydirector.protection.config');
	module.tinyController('protection.pg.duplica.ctrl', ctrl);
	return module;
});
