define(["tiny-common/UnifyValid"],
    function(UnifyValid) {
        var editStepCtrl = [
            "$scope",
            "message",
            "appUtils",
            "constsService",
            "restService",
            "model",
            "communicationService",
            "mask",
            "exception",
            function ($scope, message, appUtils, constsService, Rest, Model, communicationService, mask, exception) {

                $scope.Consts = constsService;
                var resource = appUtils.resource();
                var pg = appUtils.getWinData();

                $scope.allForm = false;
                $scope.defaultForm = false;

                $scope.hostScriptDesc = resource.get("protection_oracle_task_editStep_uninstallDuplicate_des_label");
                $scope.hostScriptDescShow = false;
                $scope.isCancleMount = false;
                //Lun快照
                $scope.isLunSnapshot = pg.poType == 11 && pg.template.type == 2;
                //公共参数
                var publicParamTemp;
                //步骤参数
                var stepsParamTemp = [];
                //步骤Props
                var scriptProps = {};
                //用户自定义步骤props
                var userScriptProps = {};
                //如果选择的系统脚本里面没有前置、后置脚本
                var disableSelect = function(currentNode){
                    if(!_.isEmpty(stepsParamTemp)){
                        var beforeStep = _.filter(stepsParamTemp, function(val){
                            return val.position == "protect-before"
                        });
                        var afterStep = _.filter(stepsParamTemp, function(val){
                            return val.position == "protect-after"
                        });
                        if(currentNode.config.name == "com.huawei.ism.drm.host.protection.action.PreProcessScriptAction"){
                            $("#snapShotScriptType").widget().option("disable", _.isEmpty(beforeStep));
                        };
                        if(currentNode.config.name == "com.huawei.ism.drm.host.protection.action.PostProcessScriptAction"){
                            $("#snapShotScriptType").widget().option("disable", _.isEmpty(afterStep));
                        };
                    };
                };
                //查询脚本方案按方案Id
                var querySchemeSteps = function(scriptSchemeId, selectFlag){
                    if(_.isEmpty(scriptSchemeId)){
                        return;
                    };
                    Rest.getPresetScrpitsBySchemeId([scriptSchemeId], function(result){
                        if(_.isEmpty(result)){
                            return;
                        };
                        var currentNode = _getCurrentNode();
                        publicParamTemp = angular.copy(result.publicParams);
                        stepsParamTemp = angular.copy(result.steps);
                        disableSelect(currentNode);
                        //设置界面显示的值
                        if(selectFlag){
                            //前置脚本
                            if(currentNode.config.name == "com.huawei.ism.drm.host.protection.action.PreProcessScriptAction"){
                                var beforeStep = _.filter(stepsParamTemp, function(value){
                                    return value.position == "protect-before"
                                });
                                !_.isEmpty(beforeStep) && ($scope.snapShotScript.schemeScript = _.first(beforeStep)["script"]);

                            }else{
                                //后置脚本
                                var afterStep = _.filter(stepsParamTemp, function(value){
                                    return value.position == "protect-after"
                                });
                                !_.isEmpty(afterStep) && ($scope.snapShotScript.schemeScript = _.first(afterStep)["script"]);
                            };
                            $scope.$apply();
                        }
                    });
                };
                //设置用户自己定义的脚本参数
                var setScriptParams = function(params){
                    var win = angular.copy(constsService.CONFIG_SCRIPT_PARAMS_WIN);
                    win.data = angular.copy(params);
                    win.title = appUtils.getString("protection_lun_script_config_label");
                    appUtils.showWindow(win, function(){
                        if (!UnifyValid.FormValid($("#config_script_params_win"), {focusInvalid: true})) {
                            return;
                        };
                        var configParams = {};
                        var tableData = $("#scrpitParamsTable").widget().getTableData();
                        var userKey = [];
                        !_.isEmpty(tableData) && _.each(tableData, function(item){
                            configParams[item.key] = item.value;
                            userKey.push(item.key);
                        });
                        //校验用户参数自定义输入的参数key是否相同
                        if(_.uniq(userKey).length != userKey.length){
                            message.error(appUtils.getString("protection_lun_script_same_key_validate_label"));
                            return;
                        };
                        if("before" == params.type){
                            _.extend(userScriptProps, {
                                userBeforeParam: configParams
                            });
                        }else{
                            _.extend(userScriptProps, {
                                userAfterParam: configParams
                            });
                        };
                        $scope.$apply();
                        $("#" + constsService.CONFIG_SCRIPT_PARAMS_WIN.winId).widget().destroy();
                    });
                };
                //设置公共脚本参数
                var setPublicScriptParams = function(params){
                    var win = angular.copy(constsService.CONFIG_SCRIPT_PARAMS_WIN);
                    _.extend(params, {
                        props: angular.copy(scriptProps)
                    });
                    win.data = angular.copy(params);
                    win.title = appUtils.getString("protection_lun_script_config_label");
                    win.content = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/configPublicScriptParamWin.html";
                    win.controller = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/configPublicScriptParamWinCtrl";
                    win.width = 550;
                    win.height = 410;
                    appUtils.showWindow(win, function(){
                        if (!UnifyValid.FormValid($("#config_script_params_win"), {focusInvalid: true})) {
                            return;
                        };
                        var tableData = $("#scrpitParamsTable").widget().getTableData();
                        //如果折叠框关闭，也需要校验
                        if(!!_.size($(".default_show_style "))){
                            $(".default_show_style ").click();
                            if (!UnifyValid.FormValid($("#config_script_params_win"), {focusInvalid: true})) {
                                return;
                            };
                        };
                        //预置参数
                        var configParams = {};
                        //公共参数
                        var publicData = {};
                        //自定义参数
                        var customData = {};
                        //保存用户自定义的参数key
                        var customDataKey = [];
                        _.each(tableData, function(val){
                            if(val.id == "publicUuid"){
                                _.each(val.childResources, function(item0){
                                    item0.changeFlag !== false && (publicData[item0.key] = item0.value);
                                });
                                _.extend(scriptProps, {
                                    publicParam: publicData
                                })
                            }else{
                                _.each(val.childResources, function(item3){
                                    (item3.isCustom != "true" && item3.changeFlag !== false) && (configParams[item3.key] = item3.value)
                                    if(item3.isCustom == "true"){
                                        customDataKey.push(item3.key);
                                        customData[item3.key] = item3.value
                                    };
                                });
                            }
                        });
                        //不允许用户添加已经存在的键
                        var publicKey = [];
                        if(!_.isEmpty(publicParamTemp)){
                            _.each(publicParamTemp, function(item){
                                publicKey.push(item.name);
                            })
                        };
                        var configKey = [];
                        if(!_.isEmpty(params["data"])){
                            _.each(params["data"], function(item){
                                configKey.push(item.name);
                            })
                        };
                        if(_.uniq(customDataKey).length != customDataKey.length || _.intersection(customDataKey, configKey).length != 0 || _.intersection(customDataKey, publicKey).length != 0){
                            message.error(appUtils.getString("protection_lun_script_same_key_validate_label"));
                            return;
                        };
                        if(params["type"] == "before"){
                            _.extend(scriptProps, {
                                beforeParam: configParams,
                                userBeforeParam: customData
                            })
                        }else{
                            _.extend(scriptProps, {
                                afterParam: configParams,
                                userAfterParam: customData
                            })
                        }
                        $scope.$apply();
                        $("#" + constsService.CONFIG_SCRIPT_PARAMS_WIN.winId).widget().destroy();
                    });
                };
                //前置后置脚本步骤描述
                var processScriptDescConf = {
                    //阵列复制
                    rep: {
                        pre:  resource.get("recovery_task_editstepByRep_executePreStep_des_label"),
                        post: resource.get("recovery_task_editstepByRep_executePostStep_des_label")
                    },
                    //快照
                    snapshot: {
                        pre:  resource.get("recovery_task_editstepBySnapshot_executePreStep_des_label"),
                        post: resource.get("recovery_task_editstepBySnapshot_executePostStep_des_label")
                    },
                    //克隆
                    clone: {
                        pre:  resource.get("recovery_task_editstepByClone_executePreStep_des_label"),
                        post: resource.get("recovery_task_editstepByClone_executePostStep_des_label")
                    },
                    get: function(tpType){
                        if(!tpType) return {};

                        if(tpType == 16){
                            return this.clone;
                        }
                        else if(tpType == 2 || tpType == 9 || tpType == 14){
                            return this.snapshot;
                        }
                        else{
                            return this.rep;
                        }
                    }
                };

                var processScriptDesc = processScriptDescConf.get(pg.template.type);

                //配置脚本步骤的配置
                var AgentScriptConf = {
                    "com.huawei.ism.drm.host.protection.action.PreProcessScriptAction" : {
                        desc: processScriptDesc.pre,
                        host: true,
                        hostLabel: resource.getWithColon("ism.drm.host"),
                        scriptLabel: resource.getWithColon("com.huawei.ism.drm.host.protection.action.PreProcessScriptAction"),
                        enableWarnMsg: ["protectionGroup_FusionSphere_task_enablePreScript_danger_msg1",{"key":"protectionGroup_FusionSphere_task_enablePreScript_danger_msg2",hasParameter:true},"protectionGroup_FusionSphere_task_enablePreScript_danger_msg3"],
                        modifyWarnMsg: ["protectionGroup_FusionSphere_task_modifyPreScript_danger_msg1",{"key":"protectionGroup_FusionSphere_task_modifyPreScript_danger_msg2",hasParameter:true},"protectionGroup_FusionSphere_task_modifyPreScript_danger_msg3"]
                    },
                    "com.huawei.ism.drm.host.protection.action.PostProcessScriptAction" : {
                        desc: processScriptDesc.post,
                        host: true,
                        hostLabel: resource.getWithColon("ism.drm.host"),
                        scriptLabel: resource.getWithColon("com.huawei.ism.drm.host.protection.action.PostProcessScriptAction"),
                        enableWarnMsg: ["protectionGroup_FusionSphere_task_enablePostScript_danger_msg1",{"key":"protectionGroup_FusionSphere_task_enablePostScript_danger_msg2",hasParameter:true},"protectionGroup_FusionSphere_task_enablePostScript_danger_msg3"],
                        modifyWarnMsg: ["protectionGroup_FusionSphere_task_modifyPostScript_danger_msg1",{"key":"protectionGroup_FusionSphere_task_modifyPostScript_danger_msg2",hasParameter:true},"protectionGroup_FusionSphere_task_modifyPostScript_danger_msg3"]
                    },
                    "com.huawei.ism.drm.host.protection.action.LoadReplicaAction": {
                        desc: resource.get("protection_oracle_task_editStep_installDuplicate_des_label"),
                        host: true,
                        hostLabel: resource.getWithColon("protection_oracle_task_editStep_para_installedDuplicate_label"),
                        scriptLabel: resource.getWithColon("protection_oracle_task_editStep_para_installedDuplicateScript_label"),
                        enableWarnMsg: ["protectionGroup_FusionSphere_task_enableInstallDuplicate_danger_msg1",{"key":"protectionGroup_FusionSphere_task_enableInstallDuplicate_danger_msg2",hasParameter:true},"protectionGroup_FusionSphere_task_enableInstallDuplicate_danger_msg3"],
                        modifyWarnMsg: ["protectionGroup_FusionSphere_task_modifyInstallDuplicate_danger_msg1",{"key":"protectionGroup_FusionSphere_task_modifyInstallDuplicate_danger_msg2",hasParameter:true},"protectionGroup_FusionSphere_task_modifyInstallDuplicate_danger_msg3"]
                    },
                    "com.huawei.ism.drm.host.protection.action.UnLoadReplicaAction": {
                        desc: resource.get("protection_oracle_task_editStep_uninstallDuplicate_des_label"),
                        host: true,
                        hostLabel: resource.getWithColon("protection_oracle_task_editStep_para_uninstalledDuplicate_label"),
                        scriptLabel: resource.getWithColon("protection_oracle_task_editStep_para_uninstalledDuplicateScript_label"),
                        enableWarnMsg: ["protectionGroup_FusionSphere_task_enableUnistallDuplicate_danger_msg1",{"key":"protectionGroup_FusionSphere_task_enableUnistallDuplicate_danger_msg2",hasParameter:true},"protectionGroup_FusionSphere_task_enableUnistallDuplicate_danger_msg3"],
                        modifyWarnMsg: ["protectionGroup_FusionSphere_task_modifyUnistallDuplicate_danger_msg1",{"key":"protectionGroup_FusionSphere_task_modifyUnistallDuplicate_danger_msg2",hasParameter:true},"protectionGroup_FusionSphere_task_modifyUnistallDuplicate_danger_msg3"]
                    }
                };
                //配置克隆副本
                var cloneDuplicateConf = {
                    "com.huawei.ism.drm.host.protection.action.UnLoadReplicaAction": {
                        "checkLabel": resource.get("protection_term_clone_edit_del_mapping_box"),
                        "tipLabel": resource.get("protection_term_clone_edit_del_mapping_box_label"),
                        "isMapping": true,
                        "mappingKey": "delMapping"
                    },
                    "com.huawei.ism.drm.host.protection.action.LoadReplicaAction": {
                        "checkLabel": resource.get("protection_term_clone_edit_add_mapping_box"),
                        "tipLabel": resource.get("protection_term_clone_edit_add_mapping_box_label"),
                        "isMapping": true,
                        "mappingKey": "addMapping"
                    }
                };
                var cloneDescConf = {
                    "com.huawei.ism.drm.storage.protection.action.SynchronizeHyperCloneAction": {
                        "editDesc": resource.get("protection_term_clone_split_policy_label"),
                        "stepLabel": resource.get("rotection_term_clone_edit_step_synchronizeHyper_label")
                    },
                    "com.huawei.ism.drm.storage.protection.action.SplitMultiHyperCloneAction": {
                        "editDesc": resource.get("rotection_term_clone_edit_step_splitMultiHyper_box"),
                        "stepLabel": resource.get("rotection_term_clone_edit_step_splitMultiHyper_label")
                    }
                };

                var disableMsgConf = [{"key":"protectionGroup_FusionSphere_task_disableProtectionStep_warm_msg1","hasParameter":true},"protectionGroup_FusionSphere_task_disableProtectionStep_warm_msg2","protectionGroup_FusionSphere_task_disableProtectionStep_warm_msg3"];

                var treeData = [];

                $scope.editStep = {
                    enableCheckBox: {
                        "id": "enableCheckBox",
                        "text": appUtils.getString("recovery.term.procedure.start.checkBox.label"),
                        "checked": true,
                        "disable": false,
                        "change": function (event) {
                            var startWidget = $("#enableCheckBox").widget(), checked = startWidget.option("checked");
                            if($scope.defaultForm){
                                $("#testHost").widget().option("disable", !checked);
                                $("#loadScript").widget().option("disable", !checked);
                                if($scope.isLunSnapshot && !_.isEmpty($("#snapShotScript").widget())){
                                    var currentNode = _getCurrentNode();
                                    $("#snapShotScript").widget().option("disable", !checked);
                                    $("#snapShotScriptType").widget().option("disable", !checked);
                                    //选择的脚本方案，但没有前置、后置脚本
                                    disableSelect(currentNode);
                                    //如果选择的是自定义脚本，不能切成系统脚本
                                    if(currentNode.config.params.isUserDefined == "1"){
                                        $("#snapShotScriptType").widget().option("disable", true);
                                    };
                                    //配置脚本参数按钮是否可用
                                    $scope.scriptParamSet.disableClick = !checked;
                                }
                            }
                            if($scope.isMappingSetting){
                                $scope.editStep.mappingCheck.disable = !checked
                            }
                            //clone LUN禁用解除映射增加提示
                            var checkNode = _getCurrentNode();
                            var isUnLoadReplicaStep = checkNode.config.name == "com.huawei.ism.drm.host.protection.action.UnLoadReplicaAction";
                            var isCheckecAddMapping = $.trim(checkNode.config.delMapping) == "true";
                            if(pg.poType == 11 && pg.template.type ==16 && !checked && isUnLoadReplicaStep && isCheckecAddMapping){
                                 $scope.isCancleMount = true;
                            };
                        }
                    },
                    btnApply: {
                        id: "btnStartApply",
                        disable: false,
                        text: appUtils.getString("common_term_apply_button"),
                        click: function () {
                            var isCheck = $("#enableCheckBox").widget().option("checked");

                            if ( $scope.defaultForm && !UnifyValid.FormValid($("#pgEditStepDiv"), {focusInvalid: true}) ) return;
                            var crtNodeConfig = _getCurrentNode().config;

                            if (isCheck) {
                                var key = crtNodeConfig.isEnabled ? "modifyWarnMsg" : "enableWarnMsg";
                                var msgConfig =  AgentScriptConf[crtNodeConfig.name][key];

                                var hostName   = $("#"+$scope.testHost.id).widget().getSelectedLabel();
                                var scriptName = $("#"+$scope.loadScript.id).widget().getValue();
                                //Lun快照
                                if($scope.defaultForm && $scope.isLunSnapshot && !_.isEmpty($("#snapShotScript").widget())){
                                    var scriptCheck = $("#snapShotScript").widget().getSelectedId();
                                    var typeCheck = $("#snapShotScriptType").widget().getSelectedId();
                                    if("-1" == scriptCheck && "1" == typeCheck){
                                        message.error(appUtils.getString("protection_lun_script_empty_validate_label"));
                                        return;
                                    };
                                    if(_.isEmpty($scope.snapShotScript.schemeScript) && "0" == typeCheck){
                                        message.error(appUtils.getString("protection_lun_script_empty_validate_label"));
                                        return;
                                    };
                                    scriptName = "1" == typeCheck ? scriptCheck : $scope.snapShotScript.schemeScript;
                                };
                                msgConfig[1].params = [$.encoder.encodeForHTML(hostName) , $.encoder.encodeForHTML(scriptName)];

                                var msg = appUtils.getDangerMsg(msgConfig);
                                message.warn({
                                    content: msg,
                                    ok: function () {
                                        _sendRequest();
                                    }
                                });
                            }
                            else {
                                var pgName = $.encoder.encodeForHTML(pg.name);
                                var stepName = crtNodeConfig.stepName;
                                disableMsgConf[0].params = [pgName,stepName];
                                var msg = appUtils.getDangerMsg(disableMsgConf);
                                message.warn({
                                    content: msg,
                                    ok: function () {
                                        _sendRequest();
                                    }
                                });
                            }
                        }
                    },
                    btnCancel: {
                        id: "btnStartCancel",
                        disable: false,
                        text: appUtils.getString("common_term_cancel_button"),
                        click: function () {
                            $scope.initSelectedNodeView();
                            UnifyValid.FormValid($("#pgEditStepDiv"), {focusInvalid: true});
                        }
                    },
                    stepTree: {
                        "id": "stepTree",
                        "width": "200px",
                        "height": "380px",
                        "setting": {
                            view: {
                                showLine: true,
                                showIcon: true,
                                selectedMulti: false
                            },
                            edit: {
                                enable: true,
                                editNameSelectAll: false,
                                showRemoveBtn: false,
                                showRenameBtn: false
                            },
                            data: {
                                simpleData: {
                                    enable: true
                                }
                            },
                            callback: {
                                onClick: function (event, id, node) {
                                    treeData.forEach(function(nodeData){
                                        nodeData.selected = node.id == nodeData.id;
                                    });

                                    $scope.initSelectedNodeView();
                                    $scope.$apply();
                                },
                                onExpand: function(event, id, node){
                                    var nodeData = appUtils.getItemFromArray(treeData,"id",node.id);
                                    nodeData && (nodeData.open = node.open);
                                },
                                onCollapse: function(event, id, node){
                                    var nodeData = appUtils.getItemFromArray(treeData,"id",node.id);
                                    nodeData && (nodeData.open = node.open);
                                }
                            }
                        },
                        "values": []
                    },
                    mappingCheck: {
                        id: "mappingSetting",
                        text: "",
                        label: "",
                        disable: true,
                        checked: false
                    },

                    title : appUtils.getString("common_term_step_label", appUtils.getString("com.huawei.ism.drm.protection.framework.engine.action.BasePrepareAction")),
                    desc: "",
                    helpTip: appUtils.getString("protection_term_clone_edit_cancle_mount_tips")
                }

                $scope.testHostLabel = resource.getWithColon("protection_oracle_task_editStep_para_installedDuplicate_label");

                //测试主机
                $scope.testHost = {
                    id : "testHost",
                    values : [{selectId : "-1", label : resource.get("common_term_pleaseSelect_listbox")}],
                    defaultSelectid : "-1",
                    disable: false,
                    change: function(){
                        //Lun快照
                        if($scope.isLunSnapshot && !_.isEmpty($("#snapShotScript").widget())){
                            var hostSn = $("#" + this.id).widget().getSelectedId();
                            var currentData = _getCurrentNode();
                            var isChangeHost = currentData.config.params.hostId != hostSn;
                            $("#snapShotScriptType").widget().option("defaultSelectid", "1");
                            $("#snapShotScriptType").widget().option("disable", isChangeHost);
                            if(!isChangeHost && currentData.config.params.isUserDefined == "0" && _.isEmpty(currentData.config.params.scriptName)){
                                $("#snapShotScriptType").widget().option("disable", true);
                            };
                            if(!isChangeHost && currentData.config.params.isUserDefined == "1"){
                                $("#snapShotScriptType").widget().option("disable", true);
                            };
                            appUtils.resetSelectValues("snapShotScript");
                            $scope.snapShotScript.defaultSelectid = "-1";
                        };
                    }
                };

                $scope.loadScriptLabel = resource.getWithColon("protection_oracle_task_editStep_para_installedDuplicateScript_label");
                $scope.scriptStateLabel = appUtils.getString("others_script_label");
                //装载脚本
                $scope.loadScript = {
                    id: "loadScript",
                    value: "",
                    disable: false,
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "minSize",
                        params: [4],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "maxSize",
                        params: [32],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "isScript",
                        errorDetail: appUtils.getString("validate_term_script")
                    }],
                    change: function(){
                        $scope.loadScript.value = $("#loadScript").widget().getValue();
                    }
                }
                //脚本方案选择
                $scope.snapShotScriptType = {
                    id: "snapShotScriptType",
                    values: [{
                        selectId : "0",
                        label : resource.get("protection_lun_use_system_script_label")
                    },{
                        selectId : "1",
                        label : resource.get("protection_lun_use_hosts_script_label")
                    }],
                    defaultSelectid : "1",
                    disable: false,
                    closeFn: function(){
                        var currentData = _getCurrentNode();
                        var hostSn = $("#testHost").widget().getSelectedId();
                        var schemeId = $("#" + this.id).widget().getSelectedId();
                        $scope.snapShotScript.show = schemeId == "1";
                        if(schemeId == "1"){
                            appUtils.resetSelectValues("snapShotScript");
                            $scope.snapShotScript.defaultSelectid = "-1";
                        };
                        //如果选择系统脚本需要查询脚本步骤哦
                        schemeId == "0" && querySchemeSteps(currentData.config.params.schemeId, true);
                        $scope.$apply();
                    }
                };
                //脚本参数配置
                $scope.scriptParamSet = {
                    disableClick: true,
                    scrpitParam: resource.get("protection_lun_script_config_label"),
                    click: function(){
                        var that = this;
                        if(that.disableClick){
                            return;
                        };
                        var isHostScript = $("#snapShotScriptType").widget().getSelectedId() == "1";
                        //获取当前节点数据
                        var nodeData = _getCurrentNodeRawData();
                        //如果选择的是系统脚本
                        if(!isHostScript){
                            //前置脚本
                            var params = {};
                            if(nodeData.config.name == "com.huawei.ism.drm.host.protection.action.PreProcessScriptAction"){
                                var beforeStep = _.filter(stepsParamTemp, function(value){
                                    return value.position == "protect-before"
                                });
                                if(!_.isEmpty(beforeStep)){
                                    beforeStep = beforeStep[0]
                                };
                                params = {
                                    type: "before",
                                    data: beforeStep["params"],
                                    publicData: publicParamTemp
                                };
                            };
                            //后置脚本
                            if(nodeData.config.name == "com.huawei.ism.drm.host.protection.action.PostProcessScriptAction"){
                                var afterStep = _.filter(stepsParamTemp, function(value){
                                    return value.position == "protect-after"
                                });
                                if(!_.isEmpty(afterStep)){
                                    afterStep = afterStep[0]
                                };
                                params = {
                                    type: "after",
                                    data: afterStep["params"],
                                    publicData: publicParamTemp
                                };
                            };
                            setPublicScriptParams(params);
                        }else{
                            //前置脚本
                            var params = {};
                            if(nodeData.config.name == "com.huawei.ism.drm.host.protection.action.PreProcessScriptAction"){
                                params = {
                                    type: "before",
                                    data: _.isString(userScriptProps["userBeforeParam"]) ? JSON.parse(userScriptProps["userBeforeParam"]) : userScriptProps["userBeforeParam"]
                                };
                            };
                            //后置脚本
                            if(nodeData.config.name == "com.huawei.ism.drm.host.protection.action.PostProcessScriptAction"){
                                params = {
                                    type: "after",
                                    data: _.isString(userScriptProps["userAfterParam"]) ? JSON.parse(userScriptProps["userAfterParam"]) : userScriptProps["userAfterParam"]
                                };
                            };
                            setScriptParams(params);
                        };
                    }
                };
                //Lun快照装载脚本
                $scope.snapShotScript = {
                    id: "snapShotScript",
                    values: [{
                        selectId : "-1",
                        label : resource.get("common_term_pleaseSelect_listbox")
                    }],
                    defaultSelectid : "-1",
                    disable: false,
                    show: true,
                    schemeScript: "",
                    openFn: function(object){
                        var hostSn = $("#testHost").widget().getSelectedId();
                        if("-1" == hostSn){
                            object.open();
                            return;
                        };
                        Rest.getCustomScrpits([hostSn], {
                            success: function(result){
                                if(!_.isEmpty(result)){
                                    var scrpitArray = [];
                                    _.each(result["scripts"], function(val, index){
                                        scrpitArray.push({
                                            selectId: val,
                                            label: val
                                        })
                                    });
                                    scrpitArray.unshift({
                                        selectId: "-1",
                                        label: appUtils.getString("common_term_pleaseSelect_listbox"),
                                        checked: true
                                    });
                                    $("#snapShotScript").widget().option("values", scrpitArray);
                                    $scope.$apply()
                                }
                                object.open();
                            }
                        })

                    }
                }

                //初始化右边面板
                $scope.initSelectedNodeView = function(node){
                    var node = node || _getCurrentNode();
                    if(!node) return;

                    if (node.isParent) {
                        $scope.allForm = false;
                        $scope.$apply();
                        return;
                    }

                    var selectedNodeConfig = node.config;
                    $scope.editStep.title = appUtils.getString("common_term_step_label", selectedNodeConfig.stepName);
                    $("#enableCheckBox").widget().option("checked",selectedNodeConfig.isEnabled);

                    $("#enableCheckBox").widget().option("disable", !selectedNodeConfig.isEditable);
                    $("#btnStartApply").widget().option("disable", !selectedNodeConfig.isEditable);
                    $("#btnStartCancel").widget().option("disable", !selectedNodeConfig.isEditable);

                    //显示右边面板
                    $scope.allForm = true;
                    $scope.defaultForm = selectedNodeConfig.actionType == "AgentScript";
                    $scope.isCancleMount = false;

                    //副本相关配置
                    var isMappingConf = cloneDuplicateConf[selectedNodeConfig.name];
                    $scope.isMappingSetting = !_.isUndefined(isMappingConf) && pg.poType == 11 && pg.template.type ==16;
                    var stepDesc = cloneDescConf[selectedNodeConfig.name];
                    $scope.cloneStepDescShow = !_.isUndefined(stepDesc) && pg.poType == 11 && pg.template.type ==16;

                    $scope.hostScriptDescShow = $scope.defaultForm;
                    //若步骤可配置副本脚本,需要查询主机列表
                    if( $scope.defaultForm ){
                        var conf = AgentScriptConf[selectedNodeConfig.name];
                        $scope.hostScriptDesc = conf.desc;
                        $scope.showHost = conf.host;

                        var check = $("#enableCheckBox").widget().option("checked");
                        $("#loadScript").widget().option("disable", !check);
                        //Lun快照
                        if($scope.isLunSnapshot && !_.isEmpty($("#snapShotScript").widget())){
                            $("#snapShotScriptType").widget().option("disable", !check);
                            $("#snapShotScript").widget().option("disable", !check);
                            //配置脚本参数按钮是否可用
                            $scope.scriptParamSet.disableClick = !check;
                            //是否是自定义或者是系统脚本
                            //保存公共参数
                            scriptProps.publicParam = selectedNodeConfig["params"]["publicParam"];
                            if(check){
                                //用户自定义的脚本
                                if(selectedNodeConfig.params.isUserDefined == "1"){
                                    $scope.snapShotScriptType.defaultSelectid == "1";
                                    $("#snapShotScriptType").widget().option("disable", true);
                                    $scope.snapShotScript.show = true;
                                    if(!_.isEmpty(selectedNodeConfig.params.scriptName)){
                                        $("#snapShotScript").widget().option("values", [{
                                            selectId : selectedNodeConfig.params.scriptName,
                                            label : selectedNodeConfig.params.scriptName
                                        }]);
                                        $scope.snapShotScript.defaultSelectid = selectedNodeConfig.params.scriptName;
                                    };
                                    userScriptProps["userBeforeParam"] = selectedNodeConfig["params"]["userBeforeParam"];
                                    userScriptProps["userAfterParam"] = selectedNodeConfig["params"]["userAfterParam"];
                                }else{
                                    //选择的是系统脚本、前置脚本
                                    //如果没有前置、后置脚本
                                    if(selectedNodeConfig.name == "com.huawei.ism.drm.host.protection.action.PreProcessScriptAction"){
                                        $scope.snapShotScriptType.defaultSelectid = selectedNodeConfig["params"]["beforeParam"]["isUserDefined"];
                                        $scope.snapShotScript.show = selectedNodeConfig["params"]["beforeParam"]["isUserDefined"] == "1";
                                        if($scope.snapShotScript.show){
                                            if(!_.isEmpty(selectedNodeConfig.params.scriptName)){
                                                $("#snapShotScript").widget().option("values", [{
                                                    selectId : selectedNodeConfig.params.scriptName,
                                                    label : selectedNodeConfig.params.scriptName
                                                }]);
                                                $scope.snapShotScript.defaultSelectid = selectedNodeConfig.params.scriptName;
                                            };
                                            userScriptProps["userBeforeParam"] = selectedNodeConfig["params"]["userBeforeParam"];
                                        }else{
                                            $scope.snapShotScript.schemeScript = selectedNodeConfig.params.scriptName || "";
                                            scriptProps.beforeParam = _.omit(selectedNodeConfig["params"]["beforeParam"], "isUserDefined");
                                            scriptProps.userBeforeParam = selectedNodeConfig["params"]["userBeforeParam"];
                                        }
                                    }else{
                                        $scope.snapShotScriptType.defaultSelectid = selectedNodeConfig["params"]["afterParam"]["isUserDefined"];
                                        $scope.snapShotScript.show = selectedNodeConfig["params"]["afterParam"]["isUserDefined"] == "1";
                                        if($scope.snapShotScript.show){
                                            if(!_.isEmpty(selectedNodeConfig.params.scriptName)){
                                                $("#snapShotScript").widget().option("values", [{
                                                    selectId : selectedNodeConfig.params.scriptName,
                                                    label : selectedNodeConfig.params.scriptName
                                                }]);
                                                $scope.snapShotScript.defaultSelectid = selectedNodeConfig.params.scriptName;
                                            };
                                            userScriptProps["userAfterParam"] = selectedNodeConfig["params"]["userAfterParam"];
                                        }else{
                                            $scope.snapShotScript.schemeScript = selectedNodeConfig.params.scriptName || "";
                                            scriptProps.afterParam = _.omit(selectedNodeConfig["params"]["afterParam"], "isUserDefined");
                                            scriptProps.userAfterParam = selectedNodeConfig["params"]["userAfterParam"];
                                        }
                                    };
                                };
                            }else{
                                $scope.snapShotScript.show = true;
                                $scope.snapShotScriptType.defaultSelectid = "1";
                            }
                        };

                        $("#defaultForm table:first tr:eq(1) td:eq(1) label").text(conf.scriptLabel);

                        //主机配置
                        if($scope.showHost){
                            $("#testHost").widget().option("disable", !check);
                            $("#defaultForm table:first tr:eq(0) td:eq(1) label").text(conf.hostLabel);

                            var siteId = pg.productSiteId;
                            Rest.queryHostBySite([siteId,0],function(data){
                                var hosts = Model.util.formatHosts(data);
                                appUtils.updateSelectValues("testHost",hosts,"deviceSn","name",resource.get("common_term_pleaseSelect_listbox"));
                                //配置了脚本则选中
                                if( selectedNodeConfig.hostName || selectedNodeConfig.hostId || selectedNodeConfig.scriptName ){
                                    $scope.testHost.defaultSelectid = selectedNodeConfig.hostId;
                                    $scope.loadScript.value = selectedNodeConfig.scriptName;
                                    //Lun快照
                                    if($scope.isLunSnapshot && !_.isEmpty($("#snapShotScript").widget())){
                                        //自定义脚本
                                        if(selectedNodeConfig["params"]["isUserDefined"] == "1"){
                                            $("#snapShotScript").widget().option("values", [{
                                                selectId : selectedNodeConfig.scriptName,
                                                label : selectedNodeConfig.scriptName
                                            }]);
                                            $scope.snapShotScript.defaultSelectid = selectedNodeConfig.scriptName;
                                        }else{
                                            //方案脚本
                                            querySchemeSteps(selectedNodeConfig["params"]["schemeId"]);
                                        }
                                    }
                                }
                                else{
                                    $scope.testHost.defaultSelectid = "-1";
                                    $scope.loadScript.value = "";
                                    //Lun快照
                                    if($scope.isLunSnapshot && !_.isEmpty($("#snapShotScript").widget())){
                                        $("#snapShotScript").widget().option("values", [{
                                            selectId : "-1",
                                            label : resource.get("common_term_pleaseSelect_listbox")
                                        }]);
                                        $scope.snapShotScript.defaultSelectid = "-1";
                                    }
                                }
                                $scope.$digest();
                            });
                        }
                        else{
                            $scope.loadScript.value = selectedNodeConfig.scriptName || "";
                            $scope.$digest();
                        }
                        //副本配置
                        if($scope.isMappingSetting){
                            $scope.editStep.mappingCheck.text = isMappingConf["checkLabel"];
                            $scope.editStep.mappingCheck.label = isMappingConf["tipLabel"];
                            $scope.editStep.mappingCheck.disable = !selectedNodeConfig["isEnabled"];
                            $scope.editStep.mappingCheck.checked = $.trim(selectedNodeConfig[isMappingConf['mappingKey']]) == "true";
                            $scope.$apply();
                        }
                    }
                    if($scope.cloneStepDescShow){
                        $scope.editStep.desc = stepDesc["editDesc"];
                        $scope.cloneEditDesc = stepDesc["stepLabel"];
                        $scope.$apply();
                    }
                }


                //发送请求
                function _sendRequest() {
                    var check = $("#enableCheckBox").widget().option("checked");
                    var nodeData = _getCurrentNodeRawData();

                    var params = [pg.pgId,nodeData.id];

                    if ( $scope.defaultForm && check ) {
                        var conf = AgentScriptConf[nodeData.config.name];
                        //映射关系
                        var mappingConf = cloneDuplicateConf[nodeData.config.name] || {};
                        if(conf.host){
                            //主机选择
                            var hostId = $("#testHost").widget().getSelectedId();
                            if(!hostId || hostId==-1){
                                return message.error(appUtils.getString("recovery.term.recovery.hostGroup.message.least"));
                            }
                        }

                        function modifyStep(){
                            var q = {
                                data: {
                                    scriptName: $scope.loadScript.value
                                },
                                success: function(){
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok: function(){
                                            var extend = {
                                                scriptName: $scope.loadScript.value,
                                                isEnabled: true
                                            };
                                            //Lun快照
                                            if($scope.isLunSnapshot && !_.isEmpty($("#snapShotScript").widget())){
                                                extend.scriptName = $("#snapShotScript").widget().getSelectedId();
                                                //替换节点数据
                                                var paramTemp = angular.copy(nodeData.config.params);
                                            };

                                            if(conf.host){
                                                extend.hostId = $("#testHost").widget().getSelectedId();
                                                extend.hostName = $("#testHost").widget().getSelectedLabel();
                                            }
                                            if(mappingConf.isMapping){
                                                extend[mappingConf.mappingKey] = $("#mappingSetting").widget().option("checked");
                                            }
                                            _updateCurrentNodeData(extend);
                                        }
                                    });
                                }
                            }

                            if(conf.host){
                                q.data.hostId = $("#testHost").widget().getSelectedId();
                            }
                            //Lun快照
                            if($scope.isLunSnapshot && !_.isEmpty($("#snapShotScript").widget())){
                                var scriptCheck = $("#snapShotScript").widget().getSelectedId();
                                q.data.scriptName = scriptCheck;
                                var isUserChecked = $("#snapShotScriptType").widget().getSelectedId();
                                //修改前置脚本还是后置脚本
                                if("com.huawei.ism.drm.host.protection.action.PreProcessScriptAction" == nodeData.config.name){
                                    q.data.userBeforeParam = _.isString(userScriptProps["userBeforeParam"]) ? userScriptProps["userBeforeParam"] : angular.toJson(userScriptProps["userBeforeParam"]);
                                    q.data.beforeParam = angular.toJson({
                                        isUserDefined: "1"
                                    });
                                    if("0" == isUserChecked){
                                        var beforeParamTemp = angular.copy(scriptProps["beforeParam"]);
                                        _.isString(beforeParamTemp) && (beforeParamTemp = JSON.parse(beforeParamTemp));
                                        _.extend(beforeParamTemp, {
                                            isUserDefined: "0"
                                        });
                                        _.extend(q.data, {
                                            scriptName: $scope.snapShotScript.schemeScript,
                                            userBeforeParam: _.isString(scriptProps["userBeforeParam"]) ? scriptProps["userBeforeParam"] : angular.toJson(scriptProps["userBeforeParam"]),
                                            beforeParam: angular.toJson(beforeParamTemp),
                                            publicParam: _.isString(scriptProps["publicParam"]) ? scriptProps["publicParam"] : angular.toJson(scriptProps["publicParam"])
                                        })
                                    };
                                }else{
                                    q.data.userAfterParam = _.isString(userScriptProps["userAfterParam"]) ? userScriptProps["userAfterParam"] : angular.toJson(userScriptProps["userAfterParam"]);
                                    q.data.afterParam = angular.toJson({
                                        isUserDefined: "1"
                                    });
                                    if("0" == isUserChecked){
                                        var afterParamTemp = angular.copy(scriptProps["afterParam"]);
                                        _.isString(afterParamTemp) && (afterParamTemp = JSON.parse(afterParamTemp));
                                        _.extend(afterParamTemp, {
                                            isUserDefined: "0"
                                        });
                                        _.extend(q.data, {
                                            scriptName: $scope.snapShotScript.schemeScript,
                                            userAfterParam: _.isString(scriptProps["userAfterParam"]) ? scriptProps["userAfterParam"] : angular.toJson(scriptProps["userAfterParam"]),
                                            afterParam: angular.toJson(afterParamTemp),
                                            publicParam: _.isString(scriptProps["publicParam"]) ? scriptProps["publicParam"] : angular.toJson(scriptProps["publicParam"])
                                        })
                                    }
                                };
                            }

                            if(mappingConf.isMapping){
                               q.data[mappingConf.mappingKey] = $("#mappingSetting").widget().option("checked");
                            }

                            Rest.modifyPgStepAction(params,q);
                        }

                        //禁用变为启用,需要先下发启用命令
                        if( !nodeData.config.isEnabled ){
                            Rest.enablePgStepAction(params,function(){
                                modifyStep();
                            });
                        }
                        else{
                            modifyStep();
                        }
                    }
                    else {
                        //启用
                        if(check){
                            Rest.enablePgStepAction(params,function(){
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function(){
                                        _updateCurrentNodeData({isEnabled: check});
                                    }
                                });
                            });
                        }
                        //禁用
                        else{
                            Rest.disablePgStepAction(params,function(){
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function(){
                                        _updateCurrentNodeData({isEnabled: check});
                                    }
                                });
                            });
                        }
                    }
                };

                //更新节点状态
                function _updateCurrentNodeData(data) {
                    var nodeData = _getCurrentNodeRawData();
                    _.extend(nodeData.config,data);
                    nodeData.icon = nodeData.config.isEnabled ? constsService.EDIT_SETP_TREE_STATUS_ICON.enable : constsService.EDIT_SETP_TREE_STATUS_ICON.disabled;

                    if( nodeData.pId ){
                        var parentNodeData = appUtils.getItemFromArray(treeData,"id",nodeData.pId);
                        parentNodeData && (parentNodeData.open = true);
                    }

                    initTree();
                }

                //获取当前选中节点
                function _getCurrentNode(){
                    return $("#stepTree").widget().getZTreeObj().getSelectedNodes()[0] || {};
                }

                //获取当前节点的配置数据
                function _getCurrentNodeRawData(){
                    var node = _getCurrentNode();
                    return appUtils.getItemFromArray(treeData,"id",node.id);
                }

                function successCb(data){
                    var icon = "" , nodes = [];
                    if (_.contains([2, 19, 30, 31, 32], parseInt(pg.template.type, 10))) {
                        _.each(data, function(item, index){
                            var protectType = _.first(item.actions).protectedType;
                            var name = protectType == 101 ? appUtils.getString("pg_create_cloudback_label") + "(" + item.protectedSiteName + ")" : protectType == 1 ? item.protectedSiteName + "-->" +  item.recoverySiteName : appUtils.getString("pg_create_fastcloudback_label") + "(" + item.protectedSiteName + ")";
                            var p = {
                                config: {},
                                id: name,
                                pId: 0,
                                name: resource.get(name),
                                selected: false,
                                open: true,
                                icon: ""
                            };
                            nodes.push(p);
                            nodes = nodes.concat(initNodes(item.actions, name));
                        });
                    } else {
                        //3dc异步+异步
                        if (data.length == 2) {
                            var name = appUtils.addDirectArrow(data[0].protectedSiteName, data[0].recoverySiteName);
                            //san一体化备份
                            if (_.contains([30, 31, 32], parseInt(pg.template.type, 10))) {
                                name = appUtils.getString("protection_VM_task_manualExecute_para_localBackup_label");
                            };
                            var p1 = {
                                config: {},
                                id: name,
                                pId: 0,
                                name: resource.get(name),
                                selected: false,
                                open: true,
                                icon: ""
                            };
                            nodes.push(p1);
                            nodes = nodes.concat(initNodes(data[0].actions, name));

                            name = appUtils.addDirectArrow(data[1].protectedSiteName, data[1].recoverySiteName);
                            //san一体化备份
                            if (_.contains([30, 31, 32], parseInt(pg.template.type, 10))) {
                                name = appUtils.getString("protection_VM_task_manualExecute_para_remotelBackup_label");
                            };
                            var p2 = {
                                config: {},
                                id: name,
                                pId: 0,
                                name: resource.get(name),
                                open: true,
                                icon: ""
                            };

                            nodes.push(p2);
                            nodes = nodes.concat(initNodes(data[1].actions, name));

                        } else if (data.length == 1) {
                            var type = pg.template.type;
                            //3dc同步+异步
                            if (type == 3 || type == 5) {
                                var name = data[0].protectedSiteName + " -> " + data[0].recoverySiteName;
                                var p1 = {
                                    config: {},
                                    id: name,
                                    pId: 0,
                                    name: resource.get(name),
                                    selected: false,
                                    open: true,
                                    icon: ""
                                };
                                nodes.push(p1);
                                nodes = nodes.concat(initNodes(data[0].actions, name));
                            } else {
                                var p1 = {
                                    config: {},
                                    id: "rootScope",
                                    pId: 0,
                                    name: resource.get("recovery.term.procedureTitle.tab"),
                                    selected: false,
                                    open: true,
                                    icon: ""
                                };
                                nodes.push(p1);
                                nodes = nodes.concat(initNodes(data[0].actions, "rootScope"));
                            }
                        }
                    };
                    nodes[1].selected = true;
                    treeData = nodes;
                    initTree();
                    $scope.initSelectedNodeView();
                    $scope.$apply();
                }

                function failCb(){
                   appUtils.closeWin();
                }

                mask.show();
                var url = "/ws/protectgroups/"+pg.pgId+"/actions";
                communicationService.get(url).always(function(result) {
                    mask.hide();
                    if (exception.check(result,true,failCb)) {
                        successCb(result);
                    }
                });

                //初始化左树
                function initTree(){
                    $scope.editStep.stepTree.values = angular.copy(treeData);
                    $scope.$apply();
                }

                function initNodes(data,pid){
                    if( !angular.isArray(data) || !pid ) return [];
                    var confNodes = [];
                    var icon = "";
                    var params;
                    var nameParams;

                    _.each(data, function (node, index) {
                        icon = node.enable ? constsService.EDIT_SETP_TREE_STATUS_ICON.enable : constsService.EDIT_SETP_TREE_STATUS_ICON.disabled;
                        params = node.params || {};
                        if(node.nameParams){
                            nameParams = node.nameParams.split(";");
                        }

                        var _node = {
                            config: {
                                "id" : node.uuid,
                                "name": node.name,
                                "stepName": $.encoder.encodeForHTML(appUtils.getString(node.name,nameParams)),
                                "scriptName": params.scriptName,
                                "hostId":  params.hostId,
                                "hostName": params.hostName,
                                "isEnabled": node.enable,
                                "isEditable": node.isEditable,
                                // 步骤类型：Ordinary (普通的) AgentScript（主机脚本）
                                "actionType": node.actionType,
                                "delMapping": params.delMapping,
                                "addMapping": params.addMapping
                            },
                            id: node.uuid,
                            pId: pid,
                            name: appUtils.getString(node.name,nameParams),
                            icon: icon,
                            selected: node.selected,
                            open: node.open
                        };
                        //快照保护组需要把params传入，方便后面使用
                        if($scope.isLunSnapshot){
                            _.extend(_node["config"],{
                                "params": params
                            })
                        };
                        confNodes.push(_node);
                    });

                    return confNodes;
                }
            }
        ]

        var editStepApp = angular.module("recoverydirector.protection.config");
        editStepApp.tinyController("app.pg.edit.step.ctrl", editStepCtrl);
        return editStepApp;
    })
;
