define([], function(){

	var ctrl = ["$scope","$compile","appUtils","constsService","restService","statusEnumService",
	            function($scope,$compile,appUtils,Consts,Rest,Status){

		if(!$scope.$parent.tabShow) return;
		$scope.maskFlag = false;
		$scope.checkRight = appUtils.checkRight;
		var pgId = $scope.protectGroup.pgId;
		var resource = appUtils.resource();
		var page=1, orderBy, orderType;

		$scope.ehTable = {
				id : "ehTable",
				paginationStyle:"full_numbers",
				displayLength : Consts.TABLE_COUNT_PER_PAGE,
	            totalRecords : 0,
	            lengthMenu: Consts.TABLE_LENGTH_AUTO_MENU,
				columns : [{
					"bVisible" : false,
					"mData" : "historyLogId"
				},{
					"sTitle" : resource.get("syslog_term_result_label"),
					"mData" : "result"
				},{
					"sTitle" : resource.get("task_term_begintime_label"),
					"mData" : "startTime"
				},{
					"sTitle" : resource.get("task_term_endtime_label"),
					"mData" : "endTime"
				},{
					"sTitle" : resource.get("task_term_executeTime_label"),
					"mData" : "executeTime",
					"bSortable" : false
				},{
					"sTitle" : resource.get("task_term_exec_detail_label"),
					"bSortable" : false
				}],
				renderRow : function(nRow, aData, iDataIndex){
					Status.setRenderRowStatus(arguments,{
			    		0 : ["PG_HISTORY_RESULT" , "result"]
			    	});

					appUtils.createLink($('td:eq(4)', nRow),resource.get("common_term_view_button") + "  ",function(){
						openDetailWin(aData.historyLogId);
					});
					var exportClass = $scope.protectGroup.template.type == 25 ? "btn-link-disable" : "btn-link"
					var exportDetails = "<a href='javascript:void(0)' class='"+ exportClass +"' ng-click='exportDetails()' ng-if=\"checkRight('ism.drm.protectgroup.auth.export')\">" + "&nbsp;&nbsp;" + appUtils.getString("common_term_export_button") + "</a>"
					var optLink = $compile($(exportDetails));
                    var optScope = $scope.$new();
                    optScope.data = aData;
                    optScope.exportDetails = function () {
                    	//云双活屏蔽导出
                    	if (aData.historyLogId == -1 || $scope.protectGroup.template.type == 25) {
                    		return;
                    	}
                        appUtils.export("/protectgroups/" + pgId + "/logs/" + aData.historyLogId + "/action/export");
                    };
                    var optNode = optLink(optScope);
					$('td:eq(4)', nRow).append(optNode)
				},
				callback:function(oPage){
					page = oPage.currentPage;
	        		pageQuery();
				},
				sortCallback: function (nNode, sortArr) {
					orderBy = $scope.ehTable.columns[sortArr[0][0]].mData;
	                orderType = sortArr[0][1];
	                page = 1;
	                pageQuery();
                },
                exporte:{
                	"id":"ehTableExoprte",
                	"text":appUtils.getString("common_term_exportall_button"),
                	disable:false,
                	click: function() {
                        appUtils.export("/protectgroups/" + pgId + "/logs/action/export");
                    }
                }
		};

		function pageQuery(){
			$scope.maskHandle = $.Deferred();
			$scope.maskFlag = false;
			$scope.$apply();

			Rest.queryProtectGroupLogs({
				protectgroupId  : pgId,
				_PAGE :  appUtils.queryFilter(page-1,10,orderBy,orderType)
			},{
				mask : false,
				success : updateEhTable,
				callback : function(){
					$scope.maskHandle.resolve();
					$scope.maskFlag = true;

					if ($scope.ehTable.data.totalCount == 0) {
						$scope.ehTable.exporte.disable = true;
					} else {
						$scope.ehTable.exporte.disable = false;
					}

					//云双活禁用导出按钮
					if($scope.protectGroup.template.type == 25){
						$scope.ehTable.exporte.disable = true;
					}
					$scope.$apply();
				}
			});
		}

		//查看详情
		function openDetailWin(logId){
			var winConfig = angular.copy(Consts.PG_EXEC_DETAIL);
			winConfig.title  = resource.get(winConfig.title);
			winConfig.buttons = [{
                label : resource.get("common_term_close_button"),
                handler : function(){
                	$("#"+Consts.PG_EXEC_DETAIL.winId).widget().destroy();
                }
            }];

        	appUtils.openWin(winConfig,{
				pgId : pgId,
				logId : logId
			});
		}

		var updateEhTable = appUtils.newUpdateTable($scope.ehTable , $scope);

		$scope.$on(Consts.PG_SELECT_EVENT,function(evt,msg){
			pgId = msg.protectGroup.pgId;
			init();
		});

        function init(){
        	page = 1;
        	orderBy = undefined;
        	orderType = undefined;
        	$scope.ehTable.curPage = {"pageIndex": 1};
        	pageQuery();
		};
		init();

	}];
	var module = angular.module('recoverydirector.protection.config');
	module.tinyController('protection.pg.executionhistory.ctrl', ctrl);
	return module;
});
