define([], function() {

        var ctrl = ["$scope", "appUtils", "exception", "constsService", "restService", "statusEnumService", "treeTableRenderService","$timeout","$state",
            function($scope, appUtils, exception, Consts, Rest, Status, treeTableRenderService, $timeout, $state) {

                if (!$scope.$parent.tabShow) return;

                var resource = appUtils.resource();
                var pgId = $scope.protectGroup.pgId;
                var pg = $scope.protectGroup;
                var pgExecFlag = false;
                var hasExecDataFlag = false;
                var execEndFlag = false;
                var promise;

                $scope.edit = {
                    isActive: true,
                    hasRight: appUtils.checkRight("ism.drm.protectgroup.auth.modify"),
                    cls: {
                        span: "btn-link",
                        icon: "iconbutton-edit"
                    },
                    text: appUtils.getString("recovery.term.procedure.editStepLabel"),
                    click: function() {
                        if(!$scope.editEnable) return;

                        var winConfig = angular.copy(Consts.PG_EDIT_STEP);
                        winConfig.title = resource.get(winConfig.title);
                        winConfig.buttons = [{
                            label: resource.get("common_term_close_button"),
                            handler: function() {
                                $("#" + Consts.PG_EDIT_STEP.winId).widget().destroy();
                            }
                        }];

                        appUtils.openWin(winConfig,$scope.protectGroup);
                    }
                }

                $scope.tipContainer = {
                    display: false,
                    text: "",
                    icon: "",
                    cls: "tip-container-success"
                }

                $scope.hideTip = function(){
                    delete $scope.executeStepTip[$scope.protectGroup.uuid];
                    $scope.tipContainer.display = false;
                    $scope.$apply();
                }

                $scope.$on(Consts.PG_SELECT_EVENT, function(evt, msg) {
                    pgId = msg.protectGroup.pgId;
                    pg = msg.protectGroup;
                    init();
                });

                init();

                function init() {
                    pgExecFlag = $scope.$parent.exec;
                    execEndFlag = false;
                    hasExecDataFlag = false;

                    //tipContainer初始化
                    if( pgExecFlag || $scope.protectGroup.status == 5 ){
                        delete $scope.executeStepTip[$scope.protectGroup.uuid];
                    };

                    initTipContainer();

                    //编辑步骤是否可用判断
                    var statusTypes = Consts.PROTECT_GROUP_STATUS;
                    var appType = pg.poType;
                    var status = pg.status;

                    //编辑
                    $scope.editEnable = pg.poType == 10 ? false
                        : pg.poType == 12 ? false
                        : status == statusTypes.DISABLED ? false //禁用不能修改
                        : status == statusTypes.INVALID ? false //失效不能修改
                        : status == statusTypes.LOCKED ? false //锁定不能修改
                        : status == statusTypes.RUNNING ? false //正在执行不能修改
                        : pg.primary; //远端不能修改

                    //同步复制和双活,vis镜像,vis复制需要灰化,vis复制
                    if( [0,8,10,12,15,23,24,28].indexOf( parseInt(pg.template.type,10) ) != -1 ){
                        $scope.editEnable = false;
                    }


                    if($scope.editEnable){
                        $scope.edit.cls.span = "btn-link";
                        $scope.edit.cls.icon = "iconbutton-edit";
                    }
                    else{
                        $scope.edit.cls.span = "btn-link-disable";
                        $scope.edit.cls.icon = "iconbutton-edit-disabled";
                    }

                    if(promise){
                        $timeout.cancel(promise);
                    }

                    $scope.maskHandle = $.Deferred();
                    $scope.$apply();
                    //初始化时需要遮罩层
                    Rest.getPgActionLogs(pgId,{
                        mask : false,
                        "success": function(data){
                            var treeData = initTree(data);
                            hasExecDataFlag = hasExecData(treeData);
                            autoRefresh();
                        },
                        "fail" : function(rep){
                            clearTable();

                            exception.checkSessionTimeout(rep,function(){
                                $timeout.cancel(promise);
                            });
                            autoRefresh();
                        },
                        callback: function() {
                            $scope.maskHandle.resolve();
                        }
                    });


                    //定时刷新 3s
                    function autoRefresh(){
                        if( !$state.includes("protection.pg.list.executionStep") || $scope.$$destroyed){
                            $timeout.cancel(promise);
                        }
                        else{
                            if( $scope.protectGroup.status == 5 ){
                                !execEndFlag && (pgExecFlag = true);
                            }

                            pgExecFlag && Rest.getPgActionLogs(pgId,{
                                "mask" : false,
                                "success": function(data){
                                    var treeData = initTree(data);
                                    if(!hasExecDataFlag){
                                        hasExecDataFlag = hasExecData(treeData);
                                    };

                                    //判断是否执行完毕:
                                    //所有步骤状态都由执行变为--或者成功
                                    var resultSuccess = true;
                                    if( hasExecDataFlag ){
                                        execEndFlag =
                                            treeData.every(function(item){
                                                return item.processStatus == "--";
                                            }) ||
                                            treeData.every(function(item){
                                                return item.processStatus == "0";
                                            });
                                    }
                                    //有一个步骤为失败
                                    else{
                                        execEndFlag = !!appUtils.getItemFromArray(treeData,"processStatus","1");
                                        resultSuccess = false;
                                    }

                                    //保护组执行完毕后,显示结果并通知父页面更新
                                    if( execEndFlag ){
                                        pgExecFlag = false;
                                        //通知父页面更新
                                        $scope.$emit(Consts.TOPIC.PG_STATUS_CHANGE,{execOverCb:showResultTip,pgUuId:$scope.protectGroup.uuid});
                                    }
                                },
                                "fail" : function(rep){
                                    clearTable();

                                    exception.checkSessionTimeout(rep,function(){
                                        $timeout.cancel(promise);
                                    });
                                }
                            });

                            promise = $timeout(autoRefresh, 3E3);
                        }
                    }
                }

                //初始化tipContainer
                function initTipContainer(){
                    var tipContainerCopy = $scope.executeStepTip[$scope.protectGroup.uuid];
                    if(tipContainerCopy){
                        _.extend($scope.tipContainer,tipContainerCopy);
                    }
                    else{
                        $scope.tipContainer.display = false;
                    }
                }


                //判断是否有正在执行
                function hasExecData(data){
                    if(!data || data.length == 0) return false;
                    var ret = !!appUtils.getItemFromArray(data,"processStatus","3");
                    if(ret){
                        //通知pg页面刷新
                        $scope.$emit(Consts.TOPIC.PG_STATUS_CHANGE);
                    }
                    return ret;
                };

                //显示本次执行结果 0失败 1成功
                function showResultTip(success){

                    $scope.tipContainer.icon = success  ? "icon-success" : "icon-failed";
                    $scope.tipContainer.text = success  ? resource.get("protection_object_task_execute_success_message") : resource.get("protection_object_task_execute_fail_message");
                    $scope.tipContainer.cls  = success  ? "tip-container-success" : "tip-container-failed";
                    $scope.tipContainer.display = true;
                    $scope.$apply();

                    //保存tipContainer
                    $scope.executeStepTip[$scope.protectGroup.uuid] = angular.copy($scope.tipContainer);
                }

                function clearTable(){
                    treeTableRenderService.treeTableBuf = "";
                    treeTableRenderService.initTreeTabelHead();
                    treeTableRenderService.initEmptyTr();
                    treeTableRenderService.initTableFinalTag();
                }

                function initTree(r) {
                    if (!angular.isArray(r) || r.length == 0) {
                        clearTable();
                    } else {
                        var treeData;
                        var type = $scope.protectGroup.template.type;

                        //3dc异步+异步
                        if (type == 4 || type == 6 || type == 17 || type == 35 || type == 36) {
                            var processNameA;
                            var processNameB;
                            if (type == 17) {
                                var title = {
                                    0: appUtils.getString("protection_VM_task_manualExecute_para_localBackup_label"),
                                    4: appUtils.getString("protection_VM_task_manualExecute_para_remotelBackup_label"),
                                    1: appUtils.getString("protection_VM_task_manualExecute_para_remotelBackup_label")
                                };
                                processNameA = title[r[0].protectLocation]
                                processNameB = title[r[1].protectLocation]
                            } else {
                                processNameA = appUtils.addDirectArrow(r[0].protectedSiteName, r[0].recoverySiteName);
                                processNameB = appUtils.addDirectArrow(r[1].protectedSiteName, r[1].recoverySiteName);
                            }

                            var childA = formatTreeDate(r[0].protectGroupLogDetails, processNameA);
                            var parentA = {
                                processName: processNameA,
                                detailId: processNameA,
                                children: childA
                            };

                            var childB = formatTreeDate(r[1].protectGroupLogDetails, processNameB);
                            var parentB = {
                                processName: processNameB,
                                detailId: processNameB,
                                children: childB
                            };

                            treeData = [parentA, parentB];
                        }
                        //CDM
                        else if (type == 30 || type == 31 || type == 32 || type == 2 || type == 19){
                            treeData = [];
                            var processSnap = _.filter(r, function(item){
                                return _.first(item.protectGroupLogDetails).protectedType == "2" || _.first(item.protectGroupLogDetails).protectedType == "100"
                            });
                            var processCloud = _.filter(r, function(item){
                                return _.first(item.protectGroupLogDetails).protectedType == "101"
                            });
                            var processCopy = _.filter(r, function(item){
                                return _.first(item.protectGroupLogDetails).protectedType == "1"
                            });
                            var snapStep, cloudStep, copyStep;
                            if(!_.isEmpty(processSnap)){
                                _.each(processSnap, function(val){
                                    var processNameA = appUtils.getString("pg_create_fastcloudback_label") + "(" + val.protectedSiteName + ")";
                                    var childA = formatTreeDate(val.protectGroupLogDetails, processNameA);
                                    var step = {
                                        processName: processNameA,
                                        detailId: processNameA,
                                        children: childA
                                    };
                                    treeData.push(step)
                                })
                            };
                            if(!_.isEmpty(processCloud)){
                                _.each(processCloud, function(val){
                                    var processNameB = appUtils.getString("pg_create_cloudback_label") + "(" + val.protectedSiteName + ")";
                                    var childB = formatTreeDate(val.protectGroupLogDetails, processNameB);
                                    var step = {
                                        processName: processNameB,
                                        detailId: processNameB,
                                        children: childB
                                    };
                                    treeData.push(step)
                                })
                            };
                            if(!_.isEmpty(processCopy)){
                                _.each(processCopy, function(val){
                                    var processNameC = appUtils.getString("pg_execute_copybackup_label") + "(" + val.protectedSiteName + "-->" +  val.recoverySiteName + ")";
                                    var childC = formatTreeDate(val.protectGroupLogDetails, processNameC);
                                    var step = {
                                        processName: processNameC,
                                        detailId: processNameC,
                                        children: childC
                                    };
                                    treeData.push(step)
                                })
                            };
                        }
                        //3dc同步+异步
                        else if (type == 3 || type == 5) {
                            //环形3DC
                            if (r[0].protectLocation == 5) {
                                treeData = formatTreeDate(r[0].protectGroupLogDetails);
                            } else {
                                var processNameA = r[0].protectedSiteName + " -> " + r[0].recoverySiteName;
                                var childA = formatTreeDate(r[0].protectGroupLogDetails, processNameA);
                                var parentA = {
                                    processName: processNameA,
                                    detailId: processNameA,
                                    children: childA
                                };
                                treeData = [parentA];
                            }
                        }
                        else{
                            treeData = formatTreeDate(r[0].protectGroupLogDetails);
                        }

                        treeTableRenderService.treeTableBuf = "";
                        treeTableRenderService.initTreeTabelHead();
                        treeTableRenderService.initTreeTabContent(treeData);
                        treeTableRenderService.initTableFinalTag();
                        treeTableRenderService.bindListenEvent();

                        var steps = [];
                        if(treeData){
                            treeData.forEach(function(item){
                                if( angular.isArray(item.children) && item.children != 0 ){
                                    steps = steps.concat(item.children);
                                }
                                else{
                                    steps = steps.concat(item);
                                }
                            });
                        }
                        return steps;
                    }
                }

                function formatTreeDate(data, parentDetailId) {
                    var keyMap = {
                        "title": "processName",
                        "result": "processStatus",
                        "protectGroupLogDetails": "children",
                        "titleParams": "processNameParams",
                        "infoParams": "processDetailParams",
                        "info": "processDetail"
                    };

                    var statusMap = {
                        "1": "0", //成功
                        "0": "1", //失败
                        "2": "3", //执行中
                        "3": "--" //--
                    };

                    if (angular.isArray(data) && data.length > 0) {
                        data.forEach(function(item) {
                            if (parentDetailId) {
                                item.parentDetailId = parentDetailId;
                            }

                            item.result = statusMap[item.result + ""];

                            angular.forEach(keyMap, function(v, k) {
                                //这两个参数需要转换为数组
                                if( k == "titleParams" || k == "infoParams" ){
                                    item[k] && (item[v] = item[k].split(";"));
                                }
                                else{
                                    item[v] = item[k];
                                }

                                delete item[k];
                            });

                            if (angular.isArray(item.children) && item.children.length > 0) {
                                formatTreeDate(item.children, item.detailId);
                            }
                        });
                    }

                    return data;
                }

            }
        ];
        var module = angular.module('recoverydirector.protection.config');
        module.tinyController('protection.pg.executionStep.ctrl', ctrl);
        return module;
    });
